from pywps.Process import WPSProcess
class HelloWorldProcess(WPSProcess):
    def __init__(self):
        WPSProcess.__init__(
            self,
            version='0.1.0',
            identifier='hello-world',
            title='Hello World',
            abstract='Sample process',
            storeSupported=False,
            statusSupported=False)

        self.data = self.addLiteralInput(identifier='name',
                                         type=type('string'),
                                         title='Name')

        self.out = self.addLiteralOutput(identifier='output',
                                         title='Output')

    def execute(self):
        value = self.data.getValue()
        self.out.setValue('Hello World from %s' % value)
        return
