# -*- coding: ISO-8859-1 -*-

# Copyright (C) 2002, 2003 Jrg Lehmann <joerg@luga.de>
#
# Ogg Vorbis interface by Byron Ellacott <bje@apnic.net>.
#
# This file is part of PyTone (http://www.luga.de/pytone/)
#
# PyTone is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# as published by the Free Software Foundation.
#
# PyTone is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with PyX; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import events, hub

def initsongdb(id, config):
    """ initialize player with id defined by config
    return id (or None if player is turned off)
    """
    type = config.type
    if type=="off":
        return None
    
    if type=="local":
        import songdbs.local
        songdb = songdbs.local.songdb(id,
                                      config.basename,
                                      config.dbfile,
                                      config.musicbasedir,
                                      config.playingstatslength,
                                      config.cachesize)
    elif type=="remote":
        import songdbs.remote
        songdb = songdbs.remote.songdb(id, config.server, config.port)

    songdb.setName("song database thread (id=%s)" % id)
    songdb.start()
    if config.autoregisterer:
        hub.hub.notify(events.autoregistersongs(id))
            
        
    return id
