#!/usr/bin/python

"""
__version__ = "$Revision: 1.165 $"
__date__ = "$Date: 2004/03/27 22:23:54 $"
"""

# TODO: Start using exceptions!

from PythonCardPrototype import clipboard, config, dialog, graphic, log, model, res, util
from wxPython import wx
import os, sys, pprint

from modules.backgroundInfoDialog import BackgroundInfoDialog
from modules.stackInfoDialog import StackInfoDialog
from modules import menuDialog
from modules import stringDialog
from modules.dialogInfoDialog import DialogInfoDialog
from modules.runOptionsDialog import RunOptionsDialog
#from modules.positionSize import PositionSize
from modules.propertyEditor import PropertyEditor
from modules import resourceOutput
import webbrowser

SIZING_HANDLE_SIZE = 7
NUM_SIZING_HANDLES = 8
RESOURCE_TEMPLATE = 'template.rsrc.py'
RESOURCE_DIALOG_TEMPLATE = 'dialogTemplate.rsrc.py'
USERCONFIG = 'user.config.txt'

# KEA doc handling adapted from python_docs 
# method in IDLE EditorWindow.py

pythoncard_url = util.documentationURL("documentation.html")
resourceeditor_url = util.documentationURL("resource_editor_overview.html")

class DummyDialog(model.CustomDialog):
    def __init__(self, aBg, path):
        # load the resource
        aDialogRsrc = res.ResourceFile(path).getResource()
        model.CustomDialog.__init__(self, aBg, aDialogRsrc)

    def on_mouseClick(self, event):
        event.Skip()


class ResourceEditor(model.Background):
    
    def on_openBackground(self, event):
        # KEA 2002-06-27
        # copied from codeEditor.py
        # wxFileHistory isn't wrapped, so use raw wxPython
        # also the file list gets appended to the File menu
        # rather than going in front of the Exit menu
        # I suspect I have to add the Exit menu after the file history
        # which means changing how the menus in resources are loaded
        # so I'll do that later
        self.fileHistory = wx.wxFileHistory()
        fileMenu = self.GetMenuBar().GetMenu(0)
        self.fileHistory.UseMenu(fileMenu)
        wx.EVT_MENU_RANGE(self, wx.wxID_FILE1, wx.wxID_FILE9, self.OnFileHistory)

        self.cursors = {}
        self.cursors['topRight'] = wx.wxStockCursor(wx.wxCURSOR_SIZENESW)
        self.cursors['bottomLeft'] = self.cursors['topRight']
        self.cursors['topMiddle'] = wx.wxStockCursor(wx.wxCURSOR_SIZENS)
        self.cursors['bottomMiddle'] = self.cursors['topMiddle']
        self.cursors['topLeft'] = wx.wxStockCursor(wx.wxCURSOR_SIZENWSE)
        self.cursors['bottomRight'] = self.cursors['topLeft']
        self.cursors['middleLeft'] = wx.wxStockCursor(wx.wxCURSOR_SIZEWE)
        self.cursors['middleRight'] = self.cursors['middleLeft']
        self.cursors['general'] = wx.wxStockCursor(wx.wxCURSOR_SIZING)
        self.cursors['null'] = wx.wxNullCursor
 
        self.sizingHandleNames = ['topLeft', 'topMiddle', 'topRight',
                         'middleLeft', 'middleRight',
                         'bottomLeft', 'bottomMiddle', 'bottomRight']

        if wx.wxPlatform == '__WXMSW__':
            path = os.path.join(self.stack.app.applicationDirectory, 'images', 'sizingHandle.bmp')
            sizingHandleTemplate = {'type':'ImageButton',
                                    'name':'topLeft',
                                    'position':(3, 3),
                                    'size':(SIZING_HANDLE_SIZE, SIZING_HANDLE_SIZE),
                                    'file':path,
                                    'border':'none',
                                    'visible':0}
        elif wx.wxPlatform == '__WXMAC__':
            #self.resizingHandleColor = (0,0,128)
            path = os.path.join(self.stack.app.applicationDirectory, 'images', 'sizingHandle.bmp')
            sizingHandleTemplate = {'type':'Image',
                                    'name':'topLeft',
                                    'position':(3, 3),
                                    'size':(SIZING_HANDLE_SIZE, SIZING_HANDLE_SIZE),
                                    'file':path,
                                    #'backgroundColor':self.resizingHandleColor,
                                    'border':'none',
                                    'visible':0}
        else:
            self.resizingHandleColor = (0,0,128)
            sizingHandleTemplate = {'type':'ImageButton',
                                    'name':'topLeft',
                                    'position':(3, 3),
                                    'size':(SIZING_HANDLE_SIZE, SIZING_HANDLE_SIZE),
                                    'file':'',
                                    'backgroundColor':self.resizingHandleColor,
                                    'visible':0}
            
        
        for sizingHandle in self.sizingHandleNames:
            sizingHandleTemplate['name'] = sizingHandle
            self.components[sizingHandle] = sizingHandleTemplate

        self.lastCaptured = None
        self.startName = ''
        self.startPosition = (0, 0)
        self.startSize = (0, 0)
        self.offset = (0, 0)
        self.startToolTip = ''
        self.createDC()

        #self.positionSizeWindow = model.childWindow(self, PositionSize)
        self.propertyEditorWindow = model.childWindow(self, PropertyEditor)

        self.xGridSize = 5
        self.yGridSize = 5
        self.alignToGrid = self.menuBar.getChecked('menuOptionsAlignToGrid')

        path = os.path.join(self.stack.app.applicationDirectory, 'templates', \
                            RESOURCE_TEMPLATE)
        self.rsrc = res.ResourceFile(path).getResource()
        
        #self.updateStack(self.rsrc)
        self.updatePanel(self.rsrc)
        
        self.filename = None
        self.documentChanged = 0
        self.cmdLineArgs = {'debugmenu':0, 'logging':0, 'messagewatcher':0,
                            'namespaceviewer':0, 'propertyeditor':0,
                            'shell':0}

        self.configPath = os.path.join(config.homedir, 'resourceeditor')
        self.loadConfig()

        try:
            self.readme = open('readme.txt').read()
        except:
            self.readme = ''

        """
        # KEA 2002-03-03
        # this doesn't appear to work, some additional accelerator table modification
        # must be messing up the bindings
        # setup acceleratortable for background
        acctbl = wx.wxAcceleratorTable([
            (wx.wxACCEL_CTRL, ord('C'), self.menuBar.getMenuId('menuEditCopy')),
            (wx.wxACCEL_CTRL, ord('X'), self.menuBar.getMenuId('menuEditCut')),
		    (wx.wxACCEL_CTRL, ord('V'), self.menuBar.getMenuId('menuEditPaste'))
        ])
        self.SetAcceleratorTable(acctbl)
        """

        # KEA 2001-12-24
        # once we can do dynamic menus we should load the component list dynamically
        # to build the first part of the Component menu
        # Add BitmapCanvas
        # Add Button
        # ...
        # perhaps there should be a framework function to return the list of files in
        # the components directory or list of components and then a method in the
        # resourceEditor can load each component module as it builds the menu
        
        # MRV 2002-08-08
        # copied and changed from codeEditor to allow commandline argument for resource file
        # then can use from windows explorer rightclick...
        if len(sys.argv) > 1:
            # accept a file argument on the command-line
            filename = os.path.abspath(sys.argv[1])
            log.info('resourceEditor filename: ' + filename)
            if not os.path.exists(filename):
                filename = os.path.abspath(os.path.join(self.stack.app.startingDirectory, sys.argv[1]))
            if os.path.isfile(filename):
                if filename.endswith('rsrc.py'):
                    self.filename = filename
                    self.openFile(filename)

        self.resizingHandler = {
            'topLeft':self.on_topLeft_mouseDrag,
            'topMiddle':self.on_topMiddle_mouseDrag,
            'topRight':self.on_topRight_mouseDrag,
            'middleLeft':self.on_middleLeft_mouseDrag,
            'middleRight':self.on_middleRight_mouseDrag,
            'bottomLeft':self.on_bottomLeft_mouseDrag,
            'bottomMiddle':self.on_bottomMiddle_mouseDrag,
            'bottomRight':self.on_bottomRight_mouseDrag
        }


    def OnFileHistory(self, event):
        fileNum = event.GetId() - wx.wxID_FILE1
        path = self.fileHistory.GetHistoryFile(fileNum)
        if self.documentChanged:
            save = self.saveChanges()
            if save == "Cancel":
                # don't do anything, just go back to editing
                return
            elif save == "No":
                # any changes will be lost
                pass
            else:
                if self.documentPath is None:
                    # if the user cancels out of the Save As then go back to editing
                    if not self.on_menuFileSaveAs_select(None):
                        return
                else:
                    self.saveFile(self.documentPath)
        self.openFile(path)

    def clearWidgets(self):
        for w in self.components.keys():
            if w not in self.sizingHandleNames:
                del self.components[w]

    def positionSizingHandles(self, position, size):
        x, y = position
        width, height = size
        halfHandleSize = SIZING_HANDLE_SIZE / 2
        log.debug('positionSizingHandles position:' + str(position) + ", size:" + str(size))
        
        self.components['topLeft'].position = (x - SIZING_HANDLE_SIZE, y - SIZING_HANDLE_SIZE)
        self.components['topMiddle'].position = (x + (width / 2) - halfHandleSize, y - SIZING_HANDLE_SIZE)
        self.components['topRight'].position = (x + width, y - SIZING_HANDLE_SIZE)

        self.components['middleLeft'].position = (x - SIZING_HANDLE_SIZE, y + (height / 2) - halfHandleSize)
        self.components['middleRight'].position = (x + width, y + (height / 2) - halfHandleSize)

        self.components['bottomLeft'].position = (x - SIZING_HANDLE_SIZE, y + height)
        self.components['bottomMiddle'].position = (x + (width / 2) - halfHandleSize, y + height)
        self.components['bottomRight'].position = (x + width, y + height)

    def showSizingHandles(self, name):
        self.startName = name
        self.positionSizingHandles(self.components[name].position, self.components[name].size)
        for sizingHandle in self.sizingHandleNames:
            self.components[sizingHandle].visible = 1
            if wx.wxPlatform == '__WXMAC__':
                pass
                #self.components[sizingHandle].backgroundColor = self.resizingHandleColor
            elif wx.wxPlatform == '__WXGTK__':
                self.components[sizingHandle].backgroundColor = self.resizingHandleColor
        # overly conservative, but effective
        self.documentChanged = 1

    def hideSizingHandles(self):
        if self.components.topLeft.visible:
            for sizingHandle in self.sizingHandleNames:
                self.components[sizingHandle].visible = 0

    def gtkHideSizingHandles(self, name):
        for sizingHandle in self.sizingHandleNames:
            if sizingHandle == name:
                self.components[sizingHandle].backgroundColor = self.getBackgroundColor()
            else:
                self.components[sizingHandle].visible = 0
                

    def setToolTip(self, target):
        # in case the user closed the window
        #self.positionSizeWindow.Show()
        ##self.positionSizeWindow.components.fldName.text = str(target.name)
        ##self.positionSizeWindow.components.fldPosition.text = str(target.position)
        ##self.positionSizeWindow.components.fldSize.text = str(target.size)
        self.propertyEditorWindow.statusBar.text = "Component: %s  Pos: %s  Size: %s" % (str(target.name), 
            str(target.position),
            str(target.size))
        """
        x, y = target.position
        width, height = target.size
        tip = "name: " + target.name + "  \n" + \
              "position: " + str(x) + ", " + str(y) + "  \n" + \
              "size: " + str(width) + ", " + str(height)
        if tip != target.toolTip:
            target.toolTip = tip
        """

    def setToolTipDrag(self, name, position, size):
        self.propertyEditorWindow.statusBar.text = "Component: %s  Pos: %s  Size: %s" % (name, 
            str(position),
            str(size))

    def on_mouseEnter(self, event):
        name = event.target.name
        if name in self.sizingHandleNames:
            try:
                self.SetCursor(self.cursors[name])
            except:
                # not all platforms have all cursors, but hopefully
                # the general sizing cursor is always available
                self.SetCursor(self.cursors['general'])
        else:
            # KEA 2003-05-05
            # get rid of cursor change on wxTextCtrl
            self.SetCursor(wx.wxStockCursor(wx.wxCURSOR_ARROW))
            self.setToolTip(event.target)

    def on_mouseLeave(self, event):
        if event.target.name in self.sizingHandleNames:
            self.SetCursor(self.cursors['null'])

    def pointInControl(self, position):
        #print 'pointInControl:'
        #position = self.panel.ClientToScreen( position )
        #print '    position=', position
        globalPosition = self.panel.ScreenToClient(wx.wxGetMousePosition())
        #print '    globalPosition=', globalPosition
        result = None
        for name in self.components.order:
            if name in self.sizingHandleNames:
                continue
            control = self.components[name]
            r = control.GetRect()
            #print '    ', control, r
            if (r.Inside(globalPosition)):
                #print '    ', control
                result = control
                break
        #print "pointInControl", result
        return result

    # KEA 2004-03-27
    # the DC and lastPosition handling are basically a bunch
    # of hacks for event bugs in WXMAC and I'm sure I'm going to regret them
    def createDC(self):
        dc = wx.wxClientDC(self.panel)
        dc.SetPen(wx.wxPen('black', 1, wx.wxDOT))
        dc.SetBrush(wx.wxTRANSPARENT_BRUSH)
        dc.SetLogicalFunction(wx.wxINVERT)
        self.dc = dc

    def drawTheRect(self):
        position = [self.startGlobalPosition[0], self.startGlobalPosition[1]]
        position[0] = position[0] - self.startGlobalOffset[0]
        position[1] = position[1] - self.startGlobalOffset[1]

        ##rect = [self.startGlobalPosition[0], self.startGlobalPosition[1], self.startSize[0], self.startSize[1]]
        ##rect[0] = rect[0] - self.startGlobalOffset[0]
        ##rect[1] = rect[1] - self.startGlobalOffset[1]
        ##print "drawTheRect", rect
        ##dc.DrawRectangle(rect[0], rect[1], rect[2], rect[3])
        self.dc.DrawRectangle(position[0], position[1], self.startSize[0], self.startSize[1])
        ##self.rect = rect
        self.lastPosition = position
        #print "    self.lastPosition", self.lastPosition

    def on_mouseDown(self, event):
        # KEA 2003-03-23
        # protect against panel events
        #print "on_mouseDown"
        globalPosition = wx.wxGetMousePosition()

        control = event.GetEventObject()
        if control is self.panel:
            control = self.pointInControl(event.GetPosition())
            if control is None:
                self.startName = None
                return

        #target = event.target
        target = control
        if target.name not in self.sizingHandleNames:
            self.startName = target.name
            if self.stack.app.pw is not None:
                self.stack.app.pw.selectComponentsList(target.name, target.__class__.__name__)
            # KEA 2002-02-23
            self.propertyEditorWindow.selectComponentList(target.name, target.__class__.__name__)
            
            # KEA 2003-03-23
            # new drag code
            self.startGlobalPosition = self.panel.ScreenToClient(globalPosition)
            self.startGlobalOffset = target.ScreenToClient(globalPosition)
            # KEA 2003-05-05
            # workaround for 3D border on Windows
            t = target.__class__.__name__
            if wx.wxPlatform == "__WXMSW__":
                if ['List', 'PasswordField', 'TextField', 'TextArea'].count(t):
                    self.startGlobalOffset = [self.startGlobalOffset[0] + 3, self.startGlobalOffset[1] + 3]
                elif ['Gauge', 'StaticLine'].count(t):
                    self.startGlobalOffset = [self.startGlobalOffset[0] + 1, self.startGlobalOffset[1] + 1]

            #print "globalPosition", globalPosition
            #print "self.startGlobalPosition", self.startGlobalPosition
            #print "self.startGlobalOffset", self.startGlobalOffset
            ##self.startGlobalPosition[0] =- self.startGlobalOffset[0]
            ##self.startGlobalPosition[1] =- self.startGlobalOffset[1]
            self.hideSizingHandles()
        else:
            if not self.startName:
                return

            #print "res4 sizing handles", self.startName
            self.resizingHandleTarget = target.name
            if wx.wxPlatform == '__WXMSW__':
                self.hideSizingHandles()
            elif wx.wxPlatform == '__WXMAC__':
                self.hideSizingHandles()
                ##if self.lastCaptured is not None:
                ##    self.lastCaptured.ReleaseMouse()
                ##target.CaptureMouse()
                ##self.lastCaptured = target
            else:
                #print "capturing mouse"
                #if self.lastCaptured is not None:
                #    self.lastCaptured.ReleaseMouse()
                #self.gtkHideSizingHandles(target.name)
                self.hideSizingHandles()
                #target.CaptureMouse()
                #self.lastCaptured = target

        self.startPosition = self.components[self.startName].position
        self.startSize = self.components[self.startName].size
        self.offset = target.ScreenToClient(globalPosition)

        if target.name not in self.sizingHandleNames:
            self.drawTheRect()
            self.movingComponent = True
        #self.startToolTip = self.components[self.startName].toolTip

        ###print "capturing mouse"
        ###if self.lastCaptured is not None:
        ###    self.lastCaptured.ReleaseMouse()
        #self.gtkHideSizingHandles(target.name)
        ###target.CaptureMouse()
        ###self.lastCaptured = targe
        
        ##event.Skip()
            
    def on_mouseDrag(self, event):
        ##print "on_mouseDrag", event.Dragging()
        # protect against double-clicks in the open file dialog
        # when switching rsrc.py files
        #if event.target.name not in self.sizingHandleNames and self.startName in self.components:
        if not event.Dragging():
            return

        #print "on_mouseDrag"
        if wx.wxPlatform == '__WXMAC__' and not hasattr(self, 'lastPosition'):
            self.on_mouseDown(event)
        
        if self.startName in self.components:
            if not self.movingComponent and self.resizingHandleTarget:
                self.resizingHandler[self.resizingHandleTarget](event)
                return
                
            self.hideSizingHandles()
            
            # erase the last rect
            self.dc.DrawRectangle(self.lastPosition[0], self.lastPosition[1], 
                self.startSize[0], self.startSize[1])
            # use the global mouse position and the initial offset and start
            # to figure out where to draw a rect in global coordinates
            x, y = self.panel.ScreenToClient(wx.wxGetMousePosition())
            xOffset = x - self.startGlobalOffset[0]
            yOffset = y - self.startGlobalOffset[1]
            if self.alignToGrid:
                xOffset = xOffset / self.xGridSize * self.xGridSize
                yOffset = yOffset / self.yGridSize * self.yGridSize
            self.lastPosition[0] = xOffset
            self.lastPosition[1] = yOffset           
            self.dc.DrawRectangle(self.lastPosition[0], self.lastPosition[1], 
                self.startSize[0], self.startSize[1])

            # doesn't do anything if just drawing rects
            self.setToolTipDrag(self.startName, self.lastPosition, self.startSize)
        ##event.Skip()

    def on_mouseUp(self, event):
        # protect against double-clicks in the open file dialog
        # when switching rsrc.py files
        ####print "on_mouseUp BEFORE", self.rect
        if self.startName in self.components:
            if self.movingComponent:
                self.dc.DrawRectangle(self.lastPosition[0], self.lastPosition[1], 
                    self.startSize[0], self.startSize[1])
                self.components[self.startName].position = (self.lastPosition[0], self.lastPosition[1])
                #print "on_mouseUp", self.lastPosition
                self.panel.Refresh()
                self.movingComponent = False

            if wx.wxPlatform == '__WXMAC__':
                ##if self.lastCaptured is not None:
                ##    self.lastCaptured.ReleaseMouse()
                ##    self.lastCaptured = None
                #event.target.ReleaseMouse()
                # clear up drag artifacts
                self.Refresh()
            if wx.wxPlatform == '__WXGTK__':
                ##if self.lastCaptured is not None:
                ##    self.lastCaptured.ReleaseMouse()
                ##    self.lastCaptured = None
                #event.target.ReleaseMouse()
                self.Refresh()
            self.showSizingHandles(self.startName)
            self.resizingHandleTarget = None
            #self.setToolTip(self.components[self.startName])
            #self.components[self.startName].toolTip = self.startToolTip


# KEA 2003-05-13
# these should no longer be needed
##    # KEA 2002-04-30
##    # workaround for WXMAC
##    def on_mouseClick(self, event):
##        print "on_mouseClick"
##        if wx.wxPlatform == '__WXMAC__':
##            self.on_mouseUp(event)
##
##    # KEA 2002-04-30
##    # workaround for WXMAC
##    def on_select(self, event):
##        print "on_select"
##        if wx.wxPlatform == '__WXMAC__':
##            self.on_mouseUp(event)


    # KEA 2001-12-24
    # I need to refactor the common elements of the resizing handle code
    # I also want to add a Component info window to show the component
    # name, position, size as the component is moved and resized
    # THe 2002-08-29
    # Refactored the common elements of resizing handle code.
    
    def doResize(self, event, (n, w, s, e)):
        if not self.startName:
            return

        try:
            # Windows
            xOffset = event.x - self.offset[0]
            yOffset = event.y - self.offset[1]
        except:
            # Mac OS X and Linux/GTK
            #x, y = event.GetPosition()
            globalPosition = wx.wxGetMousePosition()
            x, y = self.components[self.resizingHandleTarget].ScreenToClient(globalPosition)
            xOffset = x - self.offset[0]
            yOffset = y - self.offset[1]
            
        xStartOffset = self.startPosition[0] + e * xOffset
        yStartOffset = self.startPosition[1] + n * yOffset
        if self.alignToGrid:
            xOffset = xOffset / self.xGridSize * self.xGridSize
            yOffset = yOffset / self.yGridSize * self.yGridSize
            xStartOffset = xStartOffset / self.xGridSize * self.xGridSize
            yStartOffset = yStartOffset / self.yGridSize * self.yGridSize

        width = self.startSize[0] + (w - e) * xOffset
        height = self.startSize[1] + (s - n) * yOffset
        self.components[self.startName].position = (xStartOffset, yStartOffset)
        self.components[self.startName].size = (width, height)
        self.setToolTip(self.components[self.startName])

    def on_topLeft_mouseDrag(self, event):
        self.doResize(event, (1, 0, 0, 1))
        
    def on_topMiddle_mouseDrag(self, event):
        self.doResize(event, (1, 0, 0, 0))

    def on_topRight_mouseDrag(self, event):
        self.doResize(event, (1, 1, 0, 0))

    def on_middleLeft_mouseDrag(self, event):
        self.doResize(event, (0, 0, 0, 1))

    def on_middleRight_mouseDrag(self, event):
        self.doResize(event, (0, 1, 0, 0))
        
    def on_bottomLeft_mouseDrag(self, event):
        self.doResize(event, (0, 0, 1, 1))
    
    def on_bottomMiddle_mouseDrag(self, event):
        self.doResize(event, (0, 0, 1, 0))
        
    def on_bottomRight_mouseDrag(self, event):
        self.doResize(event, (0, 1, 1, 0))

    def saveChanges(self):
        if self.filename is None:
            filename = "Untitled"
        else:
            filename = self.filename
        msg = "The data in the %s file has changed.\n\nDo you want to save the changes?" % filename
        result = dialog.messageDialog(self, msg, 'resourceEditor',
                                   dialog.ICON_EXCLAMATION,
                                   dialog.BUTTON_YES_NO | dialog.BUTTON_CANCEL)
        return result['returned']

    def newFile(self, fullTemplatePath):
        """
        KEA 2003-07-31
        the logic of where templates come from,
        the user selecting a template,
        prompting to save, etc. should be refactored
        especially if we are going to support a 
        pythoncard_config/resourceEditor/templates
        directory for user-specific resource/code templates
        for now we'll assume a single templates dir
        and put the save logic here
        
        also need to decide if resourceEditor should startup differently
        like not showing a new layout to begin with
        maybe have an option to start with a new project prompt,
        open resource dialog, or none so user can select from the
        history (always lots of UI decisions ;-)
        """
        # prompt to save
        # user will probably end up creating a new dir
        # and changing the filename
        templatePath, templateFilename = os.path.split(fullTemplatePath)
        #print path, filename
        # have the user save the source or resource?!
        wildcard = "Python files (*.py)|*.py"
        # don't set the starting dir, let user navigate
        result = dialog.saveFileDialog(None, "Save As", "", templateFilename[:-8] + ".py", wildcard)
        if result['accepted']:
            path = result['paths'][0]
            
            if path.endswith('.rsrc.py'):
                basepath = os.path.splitext(os.path.splitext(path)[0])[0]
            elif path.endswith('.py'):
                basepath = os.path.splitext(path)[0]
            else:
                # user didn't use a .py extension?
                # should this be an error?
                basepath = path

            #print basepath

            # now we need to copy and rename the
            # template files to the user chosen location
            import shutil

            destPath, destFilename = os.path.split(basepath)
            # copy the .py file
            fname = os.path.join(templatePath, templateFilename[:-8] + ".py")
            tname = os.path.join(destPath, destFilename + ".py")
            #print "copying", tname
            shutil.copy(fname, tname)
            # copy the .rsrc.py file
            fname = os.path.join(templatePath, templateFilename)
            tname = os.path.join(destPath, destFilename + ".rsrc.py")
            #print "copying", tname
            shutil.copy(fname, tname)
            
            self.filename = tname
            #print self.filename
        else:
            # present a dialog instead?!
            return
        
        self.resetAndClearWidgets()
        path = os.path.join(self.filename)
        self.rsrc = res.ResourceFile(path).getResource()
        ##self.filename = None
        self.updatePanel(self.rsrc)
        if self.editingDialog: 
            comp = self.rsrc.components
        else:
            comp = self.rsrc.stack.backgrounds[0].components
        for w in comp:
            self.components[w.name] = w
        self.rebindEventsForDragging()
        self.documentChanged = 0
        # could change the resource and title bar
        # here to give the user more feedback

    def saveFile(self):
        if self.filename is None:
            return self.on_menuFileSaveAs_select(None)
        else:
            ##desc = self.resourceAttributes()
            desc = resourceOutput.resourceAttributes(self)
            try:
                f = open(self.filename, 'w')
                f.write(desc)
                f.close()
                self.documentChanged = 0
                self.fileHistory.AddFileToHistory(self.filename)
                return True
            except Exception, e:
                message = 'The resource file could not be saved.\n' + str( e )
                dialog.messageDialog(self, message, 'ResourceEditor Error',
                                     dialog.ICON_EXCLAMATION,dialog.BUTTON_OK)
                return False

    def revertFile(self):
        self.resetAndClearWidgets()
        if self.filename is None:
            path = os.path.join(self.stack.app.applicationDirectory, 'templates', \
                            RESOURCE_TEMPLATE)
            self.rsrc = res.ResourceFile(path).getResource()
        else:
            self.rsrc = res.ResourceFile(self.filename).getResource()
        self.updatePanel(self.rsrc)
        # KEA 2002-03-24
        # either we're editing a Background or a Dialog
        if self.editingDialog: 
            comp = self.rsrc.components
        else:
            comp = self.rsrc.stack.backgrounds[0].components
        for w in comp:
            self.components[w.name] = w
        self.rebindEventsForDragging()
        self.documentChanged = 0

    def getNewFileTemplates(self):
        templatesDir = os.path.join(self.stack.app.applicationDirectory, 'templates')
        fileList = os.listdir(templatesDir)
        #fileList.sort()
        templates = []
        for filename in fileList:
            # get 'title'
            path = os.path.join(templatesDir, filename)
            if os.path.isfile(path):
                try:
                    rsrc = res.ResourceFile(path).getResource()
                    try:
                        templates.append((rsrc.stack.backgrounds[0].title, path, 'background'))
                    except:
                        templates.append((rsrc.title, path, 'dialog'))
                except:
                    # not a resource file
                    pass
        templates.sort()
        return templates

    def doNewFile(self):
        templates = self.getNewFileTemplates()
        listX = []
        for t in templates:
            #print t[0], t[2], t[1]
            listX.append(t[0])
        result = dialog.singleChoiceDialog(self, "Templates", "Choose a resource template", listX)
        if result['accepted']:
            name = result['selection']
            for t in templates:
                if t[0] == name:
                    filename = t[1]
            self.newFile(filename)

    def on_menuFileNew_select(self, event):
        if self.documentChanged:
            save = self.saveChanges()
            if save == "Cancel":
                # don't do anything, just go back to editing
                pass
            elif save == "No":
                # any changes will be lost
                #self.newFile(RESOURCE_TEMPLATE)
                self.doNewFile()
            else:
                if self.filename is None:
                    if self.on_menuFileSaveAs_select(None):
                        #self.newFile(RESOURCE_TEMPLATE)
                        self.doNewFile()
                else:
                    self.saveFile()
                    #self.newFile(RESOURCE_TEMPLATE)
                    self.doNewFile()
        else:
            #self.newFile(RESOURCE_TEMPLATE)
            self.doNewFile()

    def on_menuFileNewDialog_select(self, event):
        if self.documentChanged:
            save = self.saveChanges()
            if save == "Cancel":
                # don't do anything, just go back to editing
                pass
            elif save == "No":
                # any changes will be lost
                self.newFile(RESOURCE_DIALOG_TEMPLATE)
            else:
                if self.filename is None:
                    if self.on_menuFileSaveAs_select(None):
                        self.newFile(RESOURCE_DIALOG_TEMPLATE)
                else:
                    self.saveFile()
                    self.newFile(RESOURCE_DIALOG_TEMPLATE)
        else:
            self.newFile(RESOURCE_DIALOG_TEMPLATE)

    def on_menuFileSave_select(self, event):
        self.saveFile()

    def on_menuFileSaveAs_select(self, event):
        if self.filename is None:
            path = ''
            filename = ''
        else:
            path, filename = os.path.split(self.filename)
        wildcard = "resource files (*.rsrc.py)|*.rsrc.py"
        result = dialog.saveFileDialog(None, "Save As", path, filename, wildcard)
        if result['accepted']:
            path = result['paths'][0]
            # KEA 2002-06-01
            # force .rsrc.py extension
            # the one problem with this is that
            # the user won't be prompted for an overwrite
            # of a .rsrc.py file if they didn't enter that
            # in the save as dialog
            if not path.endswith('.rsrc.py'):
                path = os.path.splitext(path)[0] + '.rsrc.py'
            ##desc = self.resourceAttributes()
            desc = resourceOutput.resourceAttributes(self)
            try:
                f = open(path, 'w')
                f.write(desc)
                f.close()
                self.filename = path
                self.documentChanged = 0
                return True
            except:
                return False
        else:
            return False

    def on_menuFileRevert_select(self, event):
        if self.documentChanged:
            if self.filename is None:
                filename = "Untitled"
            else:
                filename = self.filename
            msg = "You will lose any changes you've made to %s.\n\nAre you sure you want to revert to the last saved version?" % filename
            result = dialog.messageDialog(self, msg, 'resourceEditor',
                                       dialog.ICON_EXCLAMATION,
                                       dialog.BUTTON_YES_NO | dialog.BUTTON_CANCEL)
            save = result['returned']
            if save == "Cancel" or save == "No":
                # don't do anything, just go back to editing
                pass
            else:
                # any changes will be lost
                self.revertFile()
        else:
            self.revertFile()


    def resetAndClearWidgets(self):
        self.startName = ''
        self.startPosition = (0, 0)
        self.startSize = (0, 0)
        self.offset = (0, 0)
        if self.stack.app.pw is not None:
            self.stack.app.pw.selectComponentsList('topLeft', 'ImageButton')
        # KEA 2002-02-23
        self.propertyEditorWindow.clearComponentList()
        self.propertyEditorWindow.clearPropertyList()
        self.hideSizingHandles()
        self.clearWidgets()

    def openFile(self, path):
        self.resetAndClearWidgets()

        os.chdir(os.path.dirname(path))
        self.filename = path
        resource = res.ResourceFile(path).getResource()
        self.rsrc = resource
        
        self.updatePanel(self.rsrc)
        #self.updateStack(self.rsrc)

        # KEA 2002-03-24
        # either we're editing a Background or a Dialog
        if self.editingDialog: 
            comp = self.rsrc.components
        else:
            comp = self.rsrc.stack.backgrounds[0].components
        for w in comp:
            self.components[w.name] = w
        self.rebindEventsForDragging()

        self.documentChanged = 0
        self.fileHistory.AddFileToHistory(self.filename)

    def doOpenFile(self):
        wildcard = "resource files (*.rsrc.py)|*.rsrc.py"
        result = dialog.openFileDialog(None, "Import which resource file?", '', '', wildcard)
        if result['accepted']:
            self.openFile(result['paths'][0])

    def on_menuFileOpen_select(self, event):
        if self.documentChanged:
            save = self.saveChanges()
            if save == "Cancel":
                # don't do anything, just go back to editing
                pass
            elif save == "No":
                # any changes will be lost
                self.doOpenFile()
            else:
                if self.filename is None:
                    if self.on_menuFileSaveAs_select(None):
                        self.doOpenFile()
                else:
                    self.saveFile()
                    self.doOpenFile()
        else:
            self.doOpenFile()


    def on_menuFileExit_select(self, event):
        self.Close()

    def on_menuHelpAbout_select(self, event):
        dialog.scrolledMessageDialog(self, self.readme, 'About resourceEditor...')


    def fixComponentOrder(self, name):
        reverseOrder = self.components.order[:]
        reverseOrder.reverse()
        for c in reverseOrder:
            self.components[c].Raise()
        
        if self.stack.app.pw is not None:
            self.stack.app.pw.clearComponentsList()
            self.stack.app.pw.displayComponents(self.components)
            self.stack.app.pw.selectComponentsList(name, self.components[name].__class__.__name__)
        # KEA 2002-02-23
        ##self.propertyEditorWindow.Freeze()
        self.propertyEditorWindow.clearComponentList()
        self.propertyEditorWindow.displayComponents(self.components)
        self.propertyEditorWindow.selectComponentList(name, self.components[name].__class__.__name__)
        ##self.propertyEditorWindow.Thaw()

    def on_componentDuplicate_command(self, event):
        if self.startName in self.components:
            aWidget = self.components[self.startName]
            result = dialog.textEntryDialog(self, 'Duplicate ' + self.startName,
                                         'Name for copy:',
                                         self.startName + 'Copy')
            if result['accepted']:
                name = result['text']
                if name in self.components:
                    dialog.alertDialog(self, name + " already exists", 'Error: Unable to duplicate widget')
                else:
                    # now loop through the original widget and build a dictionary suitable
                    # for making a copy
                    d = {}
                    d['type'] = aWidget.__class__.__name__
                    #for key in aWidget._getAttributeNames():
                    attributes = aWidget._spec.attributes.keys()
                    attributes.sort()
                    for key in attributes:
                        # I'm not exactly sure why I have to special-case these tuples
                        if key == 'bitmap':
                            # this should get recreated from the file attribute
                            pass
                        elif key in ['position', 'size']:
                            d[key] = getattr(aWidget, key)
                        elif getattr(aWidget, key) is not None:
                            d[key] = getattr(aWidget, key)
                    d['name'] = name
                    #d['toolTip'] = ''
                    #print d
                    
                    # a lot of this is common to add widget below
                    # so refactor so the common code is in a method
                    self.components[name] = d
                    # offset the widget so that it isn't underneath
                    # the original
                    x, y = self.components[name].position
                    x += 10
                    y += 10
                    self.components[name].position = (x, y)
                    
                    self.components.order.remove(name)
                    self.components.order.insert(NUM_SIZING_HANDLES, name)
                    self.fixComponentOrder(name)

                    self.startName = name
                    self.startPosition = self.components[self.startName].position
                    self.startSize = self.components[self.startName].size
                    self.offset = (0, 0)
                    self.showSizingHandles(name)
                    self.documentChanged = 1

                    c = self.components[name]
                    wx.EVT_LEFT_DOWN(c, self.on_mouseDown)
                    wx.EVT_LEFT_UP(c, self.on_mouseUp)
                    wx.EVT_MOTION(c, self.on_mouseDrag)


    def on_componentDelete_command(self, event):
        if self.startName in self.components:
            aWidget = self.components[self.startName]
            msg = "Are you sure you want to delete %s %s?" % (aWidget.__class__.__name__, aWidget.name)
            result = dialog.messageDialog(self, msg, 'Delete Component',
                                       dialog.ICON_INFORMATION)
            if result['accepted']:
                self.hideSizingHandles()
                del self.components[aWidget.name]
                self.documentChanged = 1

    def on_componentAdd_command(self, event):
        className = event.target.name[16:]
        #baseDesc = "{'type':'" + className + "', 'name':'genericName', 'position':(10, 10), 'size':(-1, -1), "
        # KEA 2002-02-23
        #dBgC = self.components.topLeft.backgroundColor.asTuple()
        #defaultBgColor = "'backgroundColor':" + str(dBgC) + ", "
        #print defaultBgColor
        baseDesc = "'position':(10, 10), 'size':(-1, -1), "
        if className == 'BitmapCanvas':
            desc = baseDesc + "}"
        elif className == 'Button':
            desc = baseDesc + "'label':'Button n'}"
            #desc = baseDesc + defaultBgColor + "'label':'Button n'}"
        elif className == 'Calendar':
            desc = baseDesc + "}"
        elif className == 'CheckBox':
            desc = baseDesc + "'label':'CheckBox n', 'checked':0}"
        elif className == 'Choice':
            desc = baseDesc + "'items':[], 'selected':''}"
        elif className == 'CodeEditor':
            desc = baseDesc + "}"
        elif className == 'ComboBox':
            desc = baseDesc + "'items':[], 'selected':''}"
        elif className == 'Gauge':
            desc = baseDesc + "'max':100, 'value':0, 'layout':'horizontal'}"
        elif className == 'Grid':
            desc = baseDesc + "}"
        elif className == 'HtmlWindow':
            desc = baseDesc + "'text':''}"
        elif className == 'IEHtmlWindow':
            desc = baseDesc + "'text':''}"
        elif className == 'Image':
            desc = baseDesc + "'file':''}"
        elif className == 'ImageButton':
            desc = baseDesc + "'file':''}"
        elif className == 'List':
            desc = baseDesc + "'items':[], 'selected':''}"
        elif className == 'MultiColumnList':
            desc = baseDesc + "'columns':2}"
        elif className == 'PasswordField':
            desc = baseDesc + "'text':''}"
        elif className == 'RadioGroup':
            desc = baseDesc + "'label':'RadioBox n', 'items':['one'], 'selected':'', 'layout':'vertical'}"
        elif className == 'Slider':
            desc = baseDesc + "'min':1, 'max':100, 'value':1, 'layout':'horizontal'}"
        elif className == 'Spinner':
            desc = baseDesc + "'min':1, 'max':100, 'value':1}"
        elif className == 'StaticBox':
            desc = baseDesc + "}"
        elif className == 'StaticLine':
            desc = baseDesc + "'layout':'horizontal'}"
        elif className == 'StaticText':
            desc = baseDesc + "'text':''}"
        elif className == 'TextArea':
            desc = baseDesc + "'text':''}"
        elif className == 'TextField':
            desc = baseDesc + "'text':''}"
        elif className == 'Tree':
            desc = baseDesc + "}"
        else:
            return

        # KEA 2002-02-23
        # find a unique name
        i = 1
        while 1:
            if className + str(i) not in self.components:
                desc = "{'type':'" + className + "', 'name':'" + className + str(i) + "', " + desc
                break
            i += 1

        # KEA 2002-02-23
        # just create the widget and update via the propertyEditorWindow
        # to streamline the editing process
        d = eval(desc)
        name = d['name']
        if name in self.components:
            # this shouldn't ever happen given the while loop above, but leave it in for now
            dialog.alertDialog(self, name + " already exists", 'Error: Unable to add widget')
        else:
            if className == 'BitmapCanvas':
                d['size'] = (50, 50)
            elif className == 'Button':
                d['label'] = d['name']
            elif className == 'Calendar':
                pass
            elif className == 'CheckBox':
                d['label'] = d['name']
            elif className == 'Choice':
                pass
            elif className == 'CodeEditor':
                d['size'] = (50, 50)
            elif className == 'ComboBox':
                pass
            elif className == 'Gauge':
                pass
            elif className == 'Grid':
                d['size'] = (50, 50)
            elif className == 'HtmlWindow':
                d['size'] = (50, 50)
            elif className == 'IEHtmlWindow':
                d['size'] = (50, 50)
            elif className == 'Image':
                d['size'] = (50, 50)
                d['backgroundColor']='white'
            elif className == 'ImageButton':
                d['size'] = (50, 50)
                d['backgroundColor']='white'
            elif className == 'List':
                pass
            elif className == 'MultiColumnList':
                d['size'] = (50, 50)
            elif className == 'PasswordField':
                pass
            elif className == 'RadioGroup':
                d['label'] = d['name']
            elif className == 'Slider':
                pass
            elif className == 'Spinner':
                pass
            elif className == 'StaticBox':
                pass#d['size'] = (50, -1)
            elif className == 'StaticLine':
                d['size'] = (50, -1)
            elif className == 'StaticText':
                d['text'] = d['name']
            elif className == 'TextArea':
                d['size'] = (50, 50)
            elif className == 'TextField':
                pass
            elif className == 'Tree':
                d['size'] = (50, 50)
                
            self.components[name] = d

            # KEA 2001-12-20
            # hack to insert component so that it is the first one
            # in the list
            # a similar trick will be needed for re-ordering widgets
            self.components.order.remove(name)
            self.components.order.insert(NUM_SIZING_HANDLES, name)
            self.fixComponentOrder(name)

            self.startName = name
            self.startPosition = self.components[self.startName].position
            self.startSize = self.components[self.startName].size
            self.offset = (0, 0)
            self.showSizingHandles(name)
            self.documentChanged = 1

            c = self.components[self.startName]
            wx.EVT_LEFT_DOWN(c, self.on_mouseDown)
            wx.EVT_LEFT_UP(c, self.on_mouseUp)
            wx.EVT_MOTION(c, self.on_mouseDrag)
        
    def on_componentSendBack_command(self, event):
        if self.startName in self.components and \
           self.components.order.index(self.startName) != len(self.components.order) - 1:
            self.components.order.remove(self.startName)
            self.components.order.append(self.startName)
            self.fixComponentOrder(self.startName)

    def on_componentMoveBack_command(self, event):
        if self.startName in self.components:
            i = self.components.order.index(self.startName)
            ln = len(self.components.order) - 1
            if i >= NUM_SIZING_HANDLES and i < ln:
                self.components.order.remove(self.startName)
                if i == ln - 1:
                    self.components.order.append(self.startName)
                else:
                    self.components.order.insert(i + 1, self.startName)
                self.fixComponentOrder(self.startName)

    def on_componentMoveForward_command(self, event):
        if self.startName in self.components:
            i = self.components.order.index(self.startName)
            if i > NUM_SIZING_HANDLES:
                self.components.order.remove(self.startName)
                self.components.order.insert(i - 1, self.startName)
                self.fixComponentOrder(self.startName)

    def on_componentBringFront_command(self, event):
        if self.startName in self.components and \
           self.components.order.index(self.startName) != NUM_SIZING_HANDLES:
            self.components.order.remove(self.startName)
            self.components.order.insert(NUM_SIZING_HANDLES, self.startName)
            self.fixComponentOrder(self.startName)
        


    def on_displayAttributes_command(self, event):
        ##desc = self.resourceAttributes()
        desc = resourceOutput.resourceAttributes(self)
        dialog.scrolledMessageDialog(self, desc, 'Resource')

    #def on_menuViewPositionSize_select(self, event):
    #    self.positionSizeWindow.Show(not self.positionSizeWindow.IsShown())

    def on_menuViewPropertyEditor_select(self, event):
        self.propertyEditorWindow.Show(not self.propertyEditorWindow.IsShown())

    def updateStack(self, resource):
        pass

    def updatePanel(self, resource):
        # KEA 2002-03-24
        # this will need to update different parameters
        # depending on whether we're editing a background or dialog
        self.editingDialog = 0
        try: 
            background = resource.stack.backgrounds[0]
        except:
            dlg = self.rsrc
            self.editingDialog = 1

        if self.editingDialog:
            self.menuBar.setEnabled('menuFileRun', 0)
            self.menuBar.setEnabled('menuFileRunWithInterpreter', 0)
            self.menuBar.setEnabled('menuFilePreviewDialog', 1)
            self.menuBar.setEnabled('menuEditBackgroundInfo', 0)
            self.menuBar.setEnabled('menuEditMenubar', 0)
            self.menuBar.setEnabled('menuEditDialogInfo', 1)
            
            self.SetTitle(dlg.title)
            self._createStatusBar(dlg)
            self.setPosition(dlg.position)
            #self.setSize((dlg.size[0], dlg.size[1] + 20))
            self.setSize(dlg.size)
            self.setImage('')
            self.setTiled(0)
            self.panel._imageFile = self.image
            self.panel._backgroundTiling = self.tiled

            defaultBgColor = wx.wxSystemSettings_GetSystemColour(wx.wxSYS_COLOUR_3DFACE)
            self.setBackgroundColor(defaultBgColor)
            self.panel.Disconnect(-1, -1, wx.wxEVT_ERASE_BACKGROUND)
            self.panel._bitmap = None
        else:
            self.menuBar.setEnabled('menuFileRun', 1)
            self.menuBar.setEnabled('menuFileRunWithInterpreter', 1)
            self.menuBar.setEnabled('menuFilePreviewDialog', 0)
            self.menuBar.setEnabled('menuEditBackgroundInfo', 1)
            self.menuBar.setEnabled('menuEditMenubar', 1)
            self.menuBar.setEnabled('menuEditDialogInfo', 0)

            self.SetTitle(background.title)
            self._createStatusBar(background)
            self.setPosition(background.position)
            if background.menubar is None:
                #self.setSize((background.size[0], background.size[1] + 20))
                self.setSize(background.size)
            else:
                self.setSize(background.size)
            self.setImage(background.image)
            self.setTiled(background.tiled)
            self.panel._imageFile = self.image
            self.panel._backgroundTiling = self.tiled

            defaultBgColor = wx.wxSystemSettings_GetSystemColour(wx.wxSYS_COLOUR_3DFACE)
            self.setBackgroundColor(defaultBgColor)
            self.setForegroundColor(background.foregroundColor)
            self.setBackgroundColor(background.backgroundColor)
            if self.image is not None :
                self.panel._bitmap = graphic.Bitmap(self.image)
                wx.EVT_ERASE_BACKGROUND( self.panel, self.panel.onEraseBackground )
            else:
                self.panel.Disconnect(-1, -1, wx.wxEVT_ERASE_BACKGROUND)
                self.panel._bitmap = None
        # KEA 2001-12-26
        # can the icon for the titlebar be updated dynamically?
        self.documentChanged = 1

        # KEA link up events for new dragging code
        wx.EVT_LEFT_DOWN(self.panel, self.on_mouseDown)
        wx.EVT_LEFT_UP(self.panel, self.on_mouseUp)
        wx.EVT_MOTION(self.panel, self.on_mouseDrag)
        self.movingComponent = False
        self.resizingHandleTarget = None

    def rebindEventsForDragging(self):
        for name in self.components.order:
            if name not in self.sizingHandleNames:
                #print name
                c = self.components[name]
                wx.EVT_LEFT_DOWN(c, self.on_mouseDown)
                wx.EVT_LEFT_UP(c, self.on_mouseUp)
                wx.EVT_MOTION(c, self.on_mouseDrag)

    def on_fileRunOptions_command(self, event):
        dlg = RunOptionsDialog(self, self.cmdLineArgs)
        dlg.showModal()
        if dlg.accepted():
            self.cmdLineArgs['debugmenu'] = dlg.components.chkDebugMenu.checked
            self.cmdLineArgs['logging'] = dlg.components.chkLogging.checked
            self.cmdLineArgs['messagewatcher'] = dlg.components.chkMessageWatcher.checked
            self.cmdLineArgs['namespaceviewer'] = dlg.components.chkNamespaceViewer.checked
            self.cmdLineArgs['propertyeditor'] = dlg.components.chkPropertyEditor.checked
            self.cmdLineArgs['shell'] = dlg.components.chkShell.checked
        dlg.destroy()

    def on_editStackInfo_command(self, event):
        dlg = StackInfoDialog(self, self.rsrc)
        dlg.showModal()
        if dlg.accepted():
            self.rsrc.stack.name = dlg.components.fldName.text
            #self.updateStack(self.rsrc)
            self.documentChanged = 1
        dlg.destroy()

    # need to change the logic so that self.rsrc
    # and the current window are updated
    def on_editBackgroundInfo_command(self, event):
        background = self.rsrc.stack.backgrounds[0]
        background.position = self.GetPositionTuple()
        background.size = self.GetSizeTuple()
        dlg = BackgroundInfoDialog(self, background)
        dlg.showModal()
        if dlg.accepted():
            background.name = dlg.components.fldName.text
            background.title = dlg.components.fldTitle.text
            background.position = eval(dlg.components.fldPosition.text)
            background.size = eval(dlg.components.fldSize.text)
            background.statusBar = dlg.components.chkStatusBar.checked
            # use same color/eval algorithm as onSelectUpdate of PropertyEditor in debug.py
            if dlg.components.fldForegroundColor.text != '':
                value = dlg.components.fldForegroundColor.text
                try:
                    background.foregroundColor = eval(value)
                except:
                    background.foregroundColor = value
            else:
                background.foregroundColor = None
            if dlg.components.fldBackgroundColor.text != '':
                value = dlg.components.fldBackgroundColor.text
                try:
                    background.backgroundColor = eval(value)
                except:
                    background.backgroundColor = value
            else:
                background.backgroundColor = None
            if dlg.components.fldImage.text != '':
                background.image = dlg.components.fldImage.text
            else:
                background.image = None
            background.tiled = dlg.components.chkTiled.checked
            background.visible = dlg.components.chkVisible.checked
            if dlg.components.chkResizeable.checked:
                background.style = ['resizeable']
            else:
                background.style = []
            if dlg.components.fldIcon.text != '':
                background.icon = dlg.components.fldIcon.text
            else:
                background.icon = None
            self.updatePanel(self.rsrc)
        dlg.destroy()

    # need to change the logic so that self.rsrc
    # and the current window are updated
    def on_editDialogInfo_command(self, event):
        background = self.rsrc
        background.position = self.GetPositionTuple()
        background.size = self.GetSizeTuple()
        dlg = DialogInfoDialog(self, background)
        dlg.showModal()
        if dlg.accepted():
            background.name = dlg.components.fldName.text
            background.title = dlg.components.fldTitle.text
            background.position = eval(dlg.components.fldPosition.text)
            background.size = eval(dlg.components.fldSize.text)
            self.updatePanel(self.rsrc)
        dlg.destroy()
        

    def on_editMenubar_command(self, event):
        try:
            menubar = self.rsrc.stack.backgrounds[0].menubar
        except:
            menubar = None
        dlg = menuDialog.MenuDialog(self, menubar)
        dlg.showModal()
        if dlg.accepted():
            if len(dlg.menuList) == 0:
                self.rsrc.stack.backgrounds[0].menubar = None
            else:
                self.rsrc.stack.backgrounds[0].menubar = menuDialog.menuResourceFromList(dlg.menuList)
            self.documentChanged = 1
        dlg.destroy()

    def on_editStrings_command(self, event):
        stringList = {}
        try:
            if self.editingDialog: 
                strings = self.rsrc.strings
            else:
                strings = self.rsrc.stack.backgrounds[0].strings
            for s in strings.__dict__:
                stringList[s] = strings.__dict__[s]
        except:
            stringList = {}
        dlg = stringDialog.StringDialog(self, stringList)
        dlg.showModal()
        if dlg.accepted():
            if self.editingDialog:
                self.rsrc.strings = stringDialog.stringResourceFromList(dlg.stringList)
            else:
                self.rsrc.stack.backgrounds[0].strings = stringDialog.stringResourceFromList(dlg.stringList)
            self.documentChanged = 1
        dlg.destroy()


    def on_optionGridSize_command(self, event):
        result = dialog.textEntryDialog(self, 
                                    'Grid Size', 
                                    'Enter the preferred grid size (e.g. 5):',
                                    str(self.xGridSize))
        if result['accepted']:
            try:
                size = int(result['text'])
                self.xGridSize = size
                self.yGridSize = size
            except:
                # should probably do an alert dialog here
                pass

    def on_menuOptionsAlignToGrid_select(self, event):
        self.alignToGrid = self.menuBar.getChecked('menuOptionsAlignToGrid')

    def getCommandLineArgs(self):
        args = ' '
        if self.cmdLineArgs['debugmenu']:
            args += '-d '
        if self.cmdLineArgs['logging']:
            args += '-l '
        if self.cmdLineArgs['messagewatcher']:
            args += '-m '
        if self.cmdLineArgs['namespaceviewer']:
            args += '-n '
        if self.cmdLineArgs['propertyeditor']:
            args += '-p '
        if self.cmdLineArgs['shell']:
            args += '-s '
        """
        if self.menuBar.getChecked('menuOptionsLogging'):
            args += '-l '
        if self.menuBar.getChecked('menuOptionsMessageWatcher'):
            args += '-m '
        if self.menuBar.getChecked('menuOptionsNamespaceViewer'):
            args += '-n '
        if self.menuBar.getChecked('menuOptionsPropertyEditor'):
            args += '-p '
        if self.menuBar.getChecked('menuOptionsShell'):
            args += '-s '
        """
        return args

    def previewDialog(self):
        if self.filename is None:
            # KEA 2002-03-25
            # should probably present an error dialog here
            return

        dlg = DummyDialog(self, self.filename)
        dlg.showModal()
        dlg.destroy()

    def on_filePreviewDialog_command(self, event):
        # we should prompt to save the .rsrc.py file if needed
        # or in the case of a new file, do a save as before attempting
        # to do a preview
        self.previewDialog()

    def runScript(self, useInterpreter):
        if self.filename is None:
            # KEA 2002-03-25
            # should probably present an error dialog here
            return

        # this algorithm, taken from samples.py assumes the rsrc.py file and the main
        # program file have the same basename
        # if that isn't the case then this doesn't work and we need a different solution
        path, filename = os.path.split(self.filename)
        name = filename.split('.')[0]
        if os.path.exists(os.path.join(path, name + ".pyw")):
            filename = '"' + os.path.join(path, name + ".pyw") + '"'
        else:
            filename = '"' + os.path.join(path, name + ".py") + '"'
        # the args should come from a dialog or menu items that are checked/unchecked
        args = self.getCommandLineArgs()

        if useInterpreter:
            interp = ' -i '
        else:
            interp = ' '
            
        if sys.platform.startswith('win'):
            # KEA 2002-03-06
            # always launch with console in the resourceEditor for debugging purposes
            python = os.path.join(os.path.dirname(sys.executable), 'python.exe')
            if ' ' in python:
                pythonQuoted = '"' + python + '"'
            else:
                pythonQuoted = python
            if useInterpreter and os.name != 'nt':
                os.spawnv(os.P_NOWAIT, python, [pythonQuoted, interp, filename, args])
            else:
                os.spawnv(os.P_NOWAIT, python, [pythonQuoted, interp, filename, args])
        else:
            if ' ' in sys.executable:
                python = '"' + sys.executable + '"'
            else:
                python = sys.executable
            os.system(python + interp + filename + args + ' &')

    def on_fileRun_command(self, event):
        # KEA 2001-12-14
        # we should prompt to save the .rsrc.py file if needed
        # or in the case of a new file, do a save as before attempting
        # to do a run
        self.runScript(0)

    def on_fileRunWithInterpreter_command(self, event):
        # KEA 2001-12-14
        # we should prompt to save the .rsrc.py file if needed
        # or in the case of a new file, do a save as before attempting
        # to do a run
        self.runScript(1)

    def copyWidgetDescriptionToClipboard(self, name):
        widget = self.components[name]
        desc = resourceOutput.widgetAttributes(self, widget)
        if desc.endswith(',\n'):
            desc = desc[:-2]
        clipboard.setClipboard(desc)

    def on_menuEditCut_select(self, event):
        if self.components.topLeft.visible and self.startName in self.components:
            aWidget = self.components[self.startName]
            msg = "Are you sure you want to Cut %s %s?" % (aWidget.__class__.__name__, aWidget.name)
            result = dialog.messageDialog(self, msg, 'Cut Component',
                                       dialog.ICON_INFORMATION)
            if result['accepted']:
                self.copyWidgetDescriptionToClipboard(self.startName)
                self.hideSizingHandles()
                del self.components[aWidget.name]
                self.documentChanged = 1

    def on_menuEditCopy_select(self, event):
        if self.components.topLeft.visible and self.startName in self.components:
            self.copyWidgetDescriptionToClipboard(self.startName)

    def on_menuEditPaste_select(self, event):
        # need to figure out the logic of checking the contents
        # of the clipboard to see if it is something we can use
        # then checking whether the component already exists
        # if it exists, prompt for a new name
        # create the widget
        desc = clipboard.getClipboard()
        if not isinstance(desc, str):
            return
        # this is dangerous so we need a better way of converting
        # the text in the clipboard to a dictionary safely
        if desc[0] == '{' and desc[-1] == '}':
            desc = eval(desc)
            name = desc['name']
            if name in self.components:
                aWidget = self.components[name]
                result = dialog.textEntryDialog(self, 'New name',
                                             name + ' component already exists\nEnter a new name:',
                                             name + 'Copy')
                if result['accepted']:
                    name = result['text']
                    if name in self.components:
                        dialog.alertDialog(self, name + " already exists", 'Error: Unable to duplicate component')
                        return
                else:
                    return
            #print name, desc
            desc['name'] = name
            self.components[name] = desc

            # this is common to duplicate, need to refactor
            self.components.order.remove(name)
            self.components.order.insert(NUM_SIZING_HANDLES, name)
            self.fixComponentOrder(name)

            self.startName = name
            self.startPosition = self.components[self.startName].position
            self.startSize = self.components[self.startName].size
            self.offset = (0, 0)
            self.showSizingHandles(name)
            self.documentChanged = 1


    def loadConfig(self):
        try:
            if not os.path.exists(self.configPath):
                os.mkdir(self.configPath)
            path = os.path.join(self.configPath, USERCONFIG)
            self.config = util.readAndEvalFile(path)
            if self.config != {}:
                #if 'positionSizeWindow.position' in self.config:
                #    self.positionSizeWindow.SetPosition(self.config['positionSizeWindow.position'])
                if 'propertyEditorWindow.position' in self.config:
                    self.propertyEditorWindow.SetPosition(self.config['propertyEditorWindow.position'])
                if 'history' in self.config:
                    history = self.config['history']
                    history.reverse()
                    for h in history:
                        self.fileHistory.AddFileToHistory(h)
        except:
            self.config = {}

    def saveConfig(self):
        #self.config['positionSizeWindow.position'] = self.positionSizeWindow.GetRestoredPosition()
        #self.config['positionSizeWindow.size'] = self.positionSizeWindow.GetRestoredSize()
        self.config['propertyEditorWindow.position'] = self.propertyEditorWindow.GetRestoredPosition()
        self.config['propertyEditorWindow.size'] = self.propertyEditorWindow.GetRestoredSize()
        history = []
        if wx.wxVERSION > (2, 5):
            for i in range(self.fileHistory.GetCount()):
                history.append(self.fileHistory.GetHistoryFile(i))
        else:
            for i in range(self.fileHistory.GetNoHistoryFiles()):
                history.append(self.fileHistory.GetHistoryFile(i))
        self.config['history'] = history
        try:
            path = os.path.join(self.configPath, USERCONFIG)
            f = open(path, "w")
            pprint.pprint(self.config, f)
            f.close()
        except:
            pass    # argh

    def doExit(self):
        if self.documentChanged:
            save = self.saveChanges()
            if save == "Cancel":
                return 0
            elif save == "No":
                return 1
            else:
                if self.filename is None:
                    return self.on_menuFileSaveAs_select(None)
                else:
                    return self.saveFile()
        else:
            return 1

    def doCleanup(self):
        # memory leak cleanup
        for k in self.cursors:
            self.cursors[k] = None

    def on_close(self, event):
        if self.doExit():
            self.saveConfig()
            self.doCleanup()
            event.Skip()

    def on_showPythonCardDocumentation_command(self, event):
        global pythoncard_url
        webbrowser.open(pythoncard_url)

    def on_showResourceEditorDocumentation_command(self, event):
        global resourceeditor_url
        webbrowser.open(resourceeditor_url)


if __name__ == '__main__':
    # now force the property editor to be enabled
    #config.setOption('showPropertyEditor', 1)
    #config.setOption('showShell', 1)

    app = model.PythonCardApp(ResourceEditor)
    app.MainLoop()
