from wxPython import wx

class trURLDropTarget(wx.wxPyDropTarget):
    def __init__(self, trWindow):
        wx.wxPyDropTarget.__init__(self)
        self.trWin = trWindow

        self.data = wx.wxURLDataObject();
        self.SetDataObject(self.data)

    def OnDragOver(self, x, y, d):
        return wx.wxDragLink

    def OnData(self, x, y, d):
        if not self.GetData():
            return wx.wxDragNone

        text  = self.data.GetURL()
        
        if text.count("\n") == 0 and text.find("://") != -1:
            text = "<a href=\"" + text + "\"></a>"
        
        self.trWin.updateTextBox(text, "insert")

        return d


class trTextDropTarget(wx.wxPyDropTarget):
    def __init__(self, trWindow):
        wx.wxPyDropTarget.__init__(self)
        self.do = wx.wxTextDataObject()
        self.SetDataObject(self.do)
        self.trWin = trWindow

    def OnEnter(self, x, y, d):
        #print "OnEnter: %d, %d, %d" % (x, y, d)
        return wx.wxDragCopy

    #def OnLeave(self):
        #print "OnLeave"

    def OnDrop(self, x, y):
        #print "OnDrop: %d %d" % (x, y)
        return true

    def OnData(self, x, y, d):
        #print "OnData: %d, %d, %d" % (x, y, d)
        self.GetData()
        #print "%s" % self.do.GetText()
        self.trWin.updateTextBox(self.do.GetText())
        return d
