#!/usr/bin/python

"""
__version__ = "$Revision: 1.47 $"
__date__ = "$Date: 2004/04/02 20:14:36 $"
"""

from PythonCardPrototype import dialog, model
import os, sys
import webbrowser
from wxPython import wx

class Launcher(model.Background):

    def setupSizers(self):
        sizer1 = wx.wxBoxSizer(wx.wxVERTICAL)
        sizer2 = wx.wxBoxSizer(wx.wxHORIZONTAL)
        sizer3 = wx.wxBoxSizer(wx.wxVERTICAL)
        sizer4 = wx.wxBoxSizer(wx.wxHORIZONTAL)
        comp = self.components
        
        btnFlags = wx.wxLEFT | wx.wxALIGN_BOTTOM
        vertFlags = wx.wxLEFT | wx.wxTOP | wx.wxALIGN_LEFT

        sizer4.Add(comp.btnLaunch, 1, btnFlags, 5)
        sizer4.Add(comp.btnDescription, 1, btnFlags, 5)
        sizer4.Add(comp.btnSource, 1, btnFlags, 5)
        sizer4.Add(comp.btnResource, 1, btnFlags, 5)

        sizer3.Add(comp.stcCmdLineArgs, 0, wx.wxLEFT | wx.wxBOTTOM | wx.wxALIGN_TOP, 5)
        sizer3.Add(comp.chkDebugMenu, 0, vertFlags, 5)
        sizer3.Add(comp.chkLogging, 0, vertFlags, 5)
        sizer3.Add(comp.chkMessageWatcher, 0, vertFlags, 5)
        sizer3.Add(comp.chkNamespaceViewer, 0, vertFlags, 5)
        sizer3.Add(comp.chkPropertyEditor, 0, vertFlags, 5)
        sizer3.Add(comp.chkShell, 0, vertFlags, 5)
        sizer3.Add((5, 5), 1)  # spacer
        sizer3.Add(sizer4, 1, wx.wxALIGN_BOTTOM | wx.wxEXPAND)

        sizer2.Add(comp.listSamples, 0, wx.wxRIGHT | wx.wxALIGN_TOP, 5)
        sizer2.Add(sizer3, 1, wx.wxEXPAND)

        sizer1.Add(sizer2, 0, vertFlags)
        sizer1.Add((5, 5), 0)  # spacer
        sizer1.Add(comp.stcDescription, 0, wx.wxLEFT | wx.wxTOP | wx.wxBOTTOM | wx.wxALIGN_LEFT | wx.wxEXPAND, 5)
        sizer1.Add(comp.fldDescription, 1, wx.wxEXPAND)
        self.sizer1 = sizer1
        
        sizer1.Fit(self)
        sizer1.SetSizeHints(self)
        self.panel.SetSizer(sizer1)
        self.panel.SetAutoLayout(1)
        self.panel.Layout()
        # KEA 2004-04-02
        # won't work until wxPython 2.5
        # self.visible = True
        self.Show()

    def on_openBackground(self, event):
        self.setupSizers()
        
        self.showDescription()
        try:
            self.readme = open('readme.txt').read()
        except:
            self.readme = ''

    def on_menuFileExit_select(self, event):
        self.Close()

    def getCommandLineArgs(self):
        args = []
        if self.components.chkDebugMenu.checked:
            args.append('-d')
        if self.components.chkLogging.checked:
            args.append('-l')
        if self.components.chkMessageWatcher.checked:
            args.append('-m')
        if self.components.chkNamespaceViewer.checked:
            args.append('-n')
        if self.components.chkPropertyEditor.checked:
            args.append('-p')
        if self.components.chkShell.checked:
            args.append('-s')
        return args

    def on_launch_command(self, event):
        name = self.components.listSamples.selected
        if name == "samples":
            path = self.stack.app.applicationDirectory
        else:
            path = os.path.join(self.stack.app.applicationDirectory, name)
        if os.path.exists(os.path.join(path, name + ".pyw")):
            filename =  os.path.join(path, name + ".pyw")
        else:
            filename = os.path.join(path, name + ".py")
        args = self.getCommandLineArgs()
        # KEA 2002-04-28
        # os.spawnv probably works on all platforms
        # and regardless of the quoting needs for paths with
        # and without spaces, but each platform is separate
        # below until that is confirmed
        if ' ' in filename:
            filename = '"' + filename + '"'
        python = sys.executable
        if ' ' in python:
            pythonQuoted = '"' + python + '"'
        else:
            pythonQuoted = python
        if sys.platform.startswith('win'):
            os.spawnv(os.P_NOWAIT, python, [pythonQuoted, filename] + args)
        elif wx.wxPlatform == '__WXMAC__':
            # this is a bad hack to deal with the user starting
            # samples.py from the Finder
            if sys.executable == '/':
                python = '/Applications/Python.app/Contents/MacOS/python'
            os.spawnv(os.P_NOWAIT, python, [pythonQuoted, filename] + args)
        else:
            os.spawnv(os.P_NOWAIT, python, [pythonQuoted, filename] + args)

    def showDescription(self):
        path = self.components.listSamples.selected
        if path == "samples":
            path = ""
        name = 'readme.txt'
        try:
            path = os.path.join(path, name)
            desc = open(path).read()
            self.components.fldDescription.text = desc
            self.components.stcDescription.text = 'Description: ' + path
        except:
            pass

        if self.components.fldSource.visible:
            self.components.fldSource.visible = 0
            self.sizer1.Remove(self.components.fldSource)
            self.sizer1.Add(self.components.fldDescription, 1, wx.wxEXPAND)
            self.components.fldDescription.visible = 1
            self.sizer1.Layout()

    def on_showDescription_command(self, event):
        self.showDescription()

    def showSource(self, source):
        name = self.components.listSamples.selected
        if name == "samples":
            path = ""
        else:
            path = name
        try:
            if source == 'source':
                p = os.path.join(path, name + '.py')
                if os.path.exists(p):
                    path = p
                else:
                    path = os.path.join(path, name + '.pyw')
                self.components.stcDescription.text = 'Source code: ' + path
            else:
                path = os.path.join(path, name + '.rsrc.py')
                self.components.stcDescription.text = 'Resource: ' + path
            src = open(path).read()
            # KEA 2002-06-21
            # you can't change the text of a CodeEditor
            # component if it isn't editable
            # should we change that?
            self.components.fldSource.editable = 1
            self.components.fldSource.text = src            
            self.components.fldSource.editable = 0
        except:
            pass

        if self.components.fldDescription.visible:
            self.components.fldDescription.visible = 0
            self.sizer1.Remove(self.components.fldDescription)
            self.sizer1.Add(self.components.fldSource, 1, wx.wxEXPAND)
            self.components.fldSource.visible = 1
            self.sizer1.Layout()

    def on_showSource_command(self, event):
        self.showSource('source')

    def on_showResource_command(self, event):
        self.showSource('resource')

    def on_listSamples_select(self, event):
        if self.components.stcDescription.text.startswith('Description'):
            self.showDescription()
        elif self.components.stcDescription.text.startswith('Source code'):
            self.showSource('source')
        else:
            self.showSource('resource')

    def on_listSamples_mouseDoubleClick(self, event):
        self.on_launch_command(None)

    def on_menuHelpPythonCardHomePage_select(self, event):
        webbrowser.open('http://pythoncard.sourceforge.net/', 1, 1) 

    def on_menuHelpOnlineDocumentation_select(self, event):
        webbrowser.open('http://pythoncard.sourceforge.net/documentation.html', 1, 1) 

    def on_menuHelpAbout_select(self, event):
        dialog.scrolledMessageDialog(self, self.readme, 'About samples...')

if __name__ == '__main__':
    app = model.PythonCardApp(Launcher)
    app.MainLoop()
