#!/usr/bin/python

"""
__version__ = "$Revision: 1.9 $"
__date__ = "$Date: 2004/04/02 20:16:25 $"
"""

from PythonCardPrototype import model, util
from wxPython import wx

import os

from util import readLifeFile, translateClipboardPattern

"""
:101: (p5)  Found by Achim Flammenkamp in August 1994.  The name was
   suggested by Bill Gosper, noting that the phase shown below displays
   the period in binary.
	....**......**....
	...*.*......*.*...
	...*..........*...
	**.*..........*.**
	**.*.*..**..*.*.**
	...*.*.*..*.*.*...
	...*.*.*..*.*.*...
	**.*.*..**..*.*.**
	**.*..........*.**
	...*..........*...
	...*.*......*.*...
	....**......**....

"""

def readLexiconFile():
    try:
        fp = open('lexicon.txt')
        data = fp.readlines()
        fp.close()
    
        lexicon = {}
        # first collect the header
        # up to the first row of
        # ------
        # then collect the definitions and patterns
        # and finally the bibliography after
        # the second row of
        # -----
        inIntroduction = 1
        inBibliography = 0
        bibliography = ''
        introduction = ''
        term = ''
        for line in data:
            stripped = line.strip()
            if inIntroduction:
                if line.startswith('-----'):
                    inIntroduction = 0
                else:
                    introduction += line
            elif inBibliography:
                bibliography += line
            else:
                if line.startswith('-----'):
                    inBibliography = 1
                else:
                    # collecting an entry
                    if stripped == '':
                        continue
                    elif stripped.startswith(':'):
                        # start of new term
                        if term != '':
                            lexicon[term] = (description, pattern)
                        offset = stripped.find(':', 1)
                        term = stripped[1:offset]
                        description = stripped[offset + 1:].lstrip()
                        #crud, term, description = stripped.split(':')
                        pattern = ''
                    elif stripped.startswith('.') or stripped.startswith('*'):
                        pattern += stripped + '\n'
                    else:
                        if line.startswith('    '):
                            description += '\n\n' + stripped
                        else:
                            description += '\n' + stripped
                        
        if term != '':
            lexicon[term] = (description, pattern)
        lexicon['INTRODUCTION'] = (introduction, '')
        lexicon['BIBLIOGRAPHY'] = (bibliography, '')
        #print len(lexicon)
        return lexicon
    except:
        return None

class Lexicon(model.Background):

    def on_openBackground(self, event):
        #self.initSizers()
        self.components.fldDescription.lineNumbersVisible = 0
        self.components.fldDescription.setEditorStyle('text')
        self.populatePatternsList()

    def populatePatternsList(self):
        self.lexicon = readLexiconFile()
        if self.lexicon is None:
            self.getParent().menuBar.setEnabled('menuAutomataLexicon', 0)
            # KEA 2004-04-02
            # won't work until wxPython 2.5
            # self.visible = False
            self.Hide()
        else:
            items = self.lexicon.keys()
            items = util.caseinsensitive_sort(items)
            self.components.lstPatterns.items = items
            self.components.lstPatterns.selection = 0
            # now simulate the user doing a selection
            self.on_lstPatterns_select(None)

    def loadPattern(self, name):
        #filename = name + '.lif'
        #path = os.path.join(self.stack.app.applicationDirectory, 'patterns', filename)
        try:
            description, patternString = self.lexicon[name]
            if patternString != '':
                crud, patterns, topLeft, size = translateClipboardPattern(patternString)
                #print "topLeft:", topLeft, "size", size
                self.getParent().initAndPlacePatterns(patterns, topLeft, size)
        except:
            pass

    def on_lstPatterns_select(self, event):
        #name = event.target.selected
        #filename = name + '.lif'
        #path = os.path.join(self.stack.app.applicationDirectory, 'patterns', filename)
        #path = self.files[event.target.selection]
        name = self.components.lstPatterns.selected
        try:
            description, patternString = self.lexicon[name]
            if patternString == '':
                self.components.fldDescription.text = description
                self.components.stcSize.text = ""
            else:
                crud, patterns, topLeft, size = translateClipboardPattern(patternString)
                self.components.fldDescription.text = description + "\n\n" + patternString
                self.components.stcSize.text = "Size: (%d, %d)" % size
        except:
            pass

    def on_btnLoad_mouseClick(self, event):
        self.loadPattern(self.components.lstPatterns.selected)

    def on_lstPatterns_mouseDoubleClick(self, event):
        self.loadPattern(self.components.lstPatterns.selected)

    def on_close(self, event):
        # KEA 2004-04-02
        # won't work until wxPython 2.5
        # self.visible = False
        self.Hide()
