
"""
__version__ = "$Revision: 1.1 $"
__date__ = "$Date: 2002/12/25 23:31:21 $"
"""

from PythonCardPrototype import model, res
import os

class ConferenceDialog(model.CustomDialog):
    def __init__(self, parent, room='', server=None, nickname=''):
        model.CustomDialog.__init__(self, parent)
        
        # if some special setup is necessary, do it here
        self.components.fldRoomName.text = room
        if server:
            self.components.cmbRoomServer.selection = server
        self.components.fldNickname.text = nickname

def conferenceDialog(parent, room='', server=None, nickname=''):
    dlg = ConferenceDialog(parent, room, server, nickname)
    dlg.showModal()
    result = {'accepted':dlg.accepted()}
    result['room'] = dlg.components.fldRoomName.text
    result['server'] = dlg.components.cmbRoomServer.selection
    result['nickname'] = dlg.components.fldNickname.text
    dlg.destroy()
    return result
