
"""
__version__ = "$Revision: 1.3 $"
__date__ = "$Date: 2002/12/27 08:56:04 $"
"""

from PythonCardPrototype import dialog, model, res
import os, sys
from wxPython import wx

class FindDialog(model.CustomDialog):
    def __init__(self, aBg, searchText='', wholeWordsOnly=0, caseSensitive=0, 
                    searchField=None, searchableFields=None):
        model.CustomDialog.__init__(self, aBg)
        
        self.parent = aBg
        
        # if some special setup is necessary, do it here
        self.components.fldFind.text = searchText
        self.components.chkMatchWholeWordOnly.checked = wholeWordsOnly
        self.components.chkMatchCase.checked = caseSensitive
        if searchableFields is None:
            self.components.popSearchField.visible = 0
        else:
            searchableFields.insert(0, 'All')
            self.components.popSearchField.items = searchableFields
            if searchField is None:
                self.components.popSearchField.selection = 'All'
            else:
                self.components.popSearchField.selection = searchField
        self.components.fldFind.setSelection(0, len(self.components.fldFind.text))
        #self.components.fldFind.SetMark(-1, -1)
        self.components.fldFind.setFocus()

    # these shouldn't be necessary
    # but I haven't taken the time to figure out what is messed up in
    # the event dispatch that keeps event.Skip from being called automatically
    # there might be a problem specific to wxDialog
    def on_btnFindNext_mouseClick(self, event):
        event.Skip()

    def on_btnCancel_mouseClick(self, event):
        event.Skip()


def findDialog(parent, searchText='', wholeWordsOnly=0, caseSensitive=0, 
                searchField=None, searchableFields=None):
    dlg = FindDialog(parent, searchText, wholeWordsOnly, caseSensitive, 
                        searchField, searchableFields)
    dlg.showModal()
    result = {'accepted':dlg.accepted()}
    result['searchText'] = dlg.components.fldFind.text
    result['wholeWordsOnly'] = dlg.components.chkMatchWholeWordOnly.checked
    result['caseSensitive'] = dlg.components.chkMatchCase.checked
    sel = dlg.components.popSearchField.selection
    if searchableFields is None or sel == 'All':
        result['searchField'] = None
    else:
        result['searchField'] = sel
    dlg.destroy()
    return result

