"""
__version__ = "$Revision: 1.8 $"
__date__ = "$Date: 2003/01/10 07:19:39 $"
"""

# POM - Python Object Model

import event, dispatch, registry

class AttributeSpec :

    def __init__(self, name, properties):
        self.name = name
        self.presence = properties['presence']
        self.default = None
        if self.presence is 'optional':
            self.default = properties['default']
        if 'values' in properties:
            self.values = properties['values']
        else:
            self.values = None

    # PUBLIC METHODS

    def getName( self ) :
        return self.name

    def isRequired( self ) :
        return self.presence is 'mandatory'

    def isOptional( self ) :
        return self.presence is 'optional'

    def getDefaultValue( self ) :
        return self.default      

    def hasDefaultValueList( self ) :
        return self.values is not None

    def getDefaultValueList( self ) :
        return self.values

class BaseSpec :

    def __init__( self, aDictionary ) :
        # PRIVATE MEMBERS
        self.name = aDictionary[ 'name' ]
        self.parentName = aDictionary[ 'info' ][ 'parent' ]
        self.parent = None
        self.events = aDictionary[ 'info' ][ 'events' ]
        self.attributes = self.parseAttributes( aDictionary[ 'info' ][ 'attributes' ] )
        self.requiredAttributes = self.parseRequiredAttributes()
        self.optionalAttributes = self.parseOptionalAttributes()

    # PUBLIC METHODS

    def getName( self ) :
        return self.name

    def getParentName( self ) :
        return self.parentName

    def getParent( self ) :
        return self.parent

    def getEvents( self ) :
        return self.events

    # KEA 2002-07-01
    def getEventNames(self):
        eventNames = [e.name for e in self.events]
        eventNames.sort()
        return eventNames

    def getAttributes( self ) :
        return self.attributes

    def getRequiredAttributes( self ) :
        return self.requiredAttributes

    def getOptionalAttributes( self ) :
        return self.optionalAttributes

    # PRIVATE METHODS

    def parseAttributes(self, aDictionary):
        attributes = {}
        for key in aDictionary:
            value = aDictionary[key]
            attribute = AttributeSpec(key, value)
            attributes[attribute.getName()] = attribute
        return attributes

    def parseRequiredAttributes(self):
        required = {}
        for key in self.attributes:
            attribute = self.attributes[key]
            if attribute.isRequired():
                required[key] = attribute
        return required

    def parseOptionalAttributes(self):
        optional = {}
        for key in self.attributes:
            attribute = self.attributes[key]
            if attribute.isOptional():
                optional[key] = attribute
        return optional

    def __repr__( self ) :
        return str( self.__dict__ )

class ComponentSpec(BaseSpec):
    def __init__(self):
        self.name = 'Component'
        self.parent = None
        self.parentName = self.parent
        self.events = []
        self._attributes = {
            'name' : { 'presence' : 'mandatory' },
            'command' : { 'presence' : 'optional', 'default' : None }
        }
        
        self.attributes = self.parseAttributes(self._attributes)
        self.requiredAttributes = self.parseRequiredAttributes()
        self.optionalAttributes = self.parseOptionalAttributes()


class Component( event.EventSource ) :
    """
    The superclass of all PythonCard components.

    Components can be visual ( extend Widget ) or
    non-visual ( extend Component ).
    """

    _spec = ComponentSpec()
    
    def __init__( self ) :
        event.EventSource.__init__( self )

class ComponentInspector :
    """
    Provides an api for introspection on
    Component instances.
    """
    def __init__( self, component ) :
        self.componentClass = component.__class__ 

    def getAttributes( self ) :
        return self.componentClass._spec.getAttributes()

    def getEvents( self ) :
        return self.componentClass._spec.getEvents()

class ComponentClassInspector :
    """
    Provides an api for introspection on
    Component classes.
    """
    def __init__( self, componentClass ) :
        self.componentClass = componentClass 

    def getAttributes( self ) :
        return self.componentClass._spec.getAttributes()

    def getEvents( self ) :
        return self.componentClass._spec.getEvents()

class ComponentFactory :
    """
    An abstract factory for creating Widgets from a Resource description.
    """
        
    def createComponent( self, aScriptable, aParent, aResource ) :
    
            # Find the class object based on a component's Resource definition.
            
        # KEA 2001-08-05 is there a better way of coming up with 
        # the module name for model as the package name changes?
        #aPackage, aModule = __name__.split('.')
        #clazz = sys.modules[ aPackage + '.model' ].__dict__[ aResource.__dict__[ 'type' ] ]
        
        reggie = registry.getRegistry()
    
        #clazz = sys.modules[__name__].__dict__[ aResource.__dict__[ 'type' ] ]
        clazz = reggie.getComponentClass( aResource.__dict__['type'] )
        
        #clazz = sys.modules[ 'model' ].__dict__[ aResource.__dict__[ 'type' ] ]
        
            # Construct a new Component.
    
        component = clazz( aParent, aResource )
    
            # Bind the Component to an EventDispatch that will translate
            # events generated by Component into calls to handlers that
            # are defined in a Scriptable object.
    
        dispatch.EventDispatch( component, aScriptable )
    
            # Return the newly created Component

        return component

