
"""
__version__ = "$Revision: 1.17 $"
__date__ = "$Date: 2004/03/17 17:58:16 $"
"""

import inspect
from wxPython import wx
import res

# these should be in some common place
# since they are used in widget.py as well
MAGIC_GET_PREFIX = '_get'
MAGIC_SET_PREFIX = '_set'

# Construct a Python list from a CSS style font-family list which
# is comma delimited and uses quotes for multi-word items.
# Unquoted multi-word items have starting and ending whitespace stripped
# and all whitespace reduced to single space characters.
def FixWhiteSpace(s):
    s = s.strip()
    s = s.replace('\t', ' ')
    s = s.replace('\n', ' ')
    s = s.replace('\r', ' ')
    while s.find('  ') >= 0:
        s = s.replace('  ', ' ')
    return s

def ListFromCSSFonts(s):
    l = []
    # The starting position of the current item
    start = 0
    # The character that started the current item, empty if outside item
    startChar = ""    
    for i in range(len(s)):
        if startChar:
            if startChar in "\'\"":
                if s[i] == startChar:
                    l.append(s[start+1:i])
                    startChar = ""
            elif s[i] in ",":
                l.append(FixWhiteSpace(s[start:i]))
                startChar = ""
        elif s[i] not in " \t,":
                start = i
                startChar = s[i]
    if startChar:
        l.append(FixWhiteSpace(s[start:]))
    return l

def fontDescription(font):
    desc = {}
    family = font.GetFamily()
    faceName = font.GetFaceName()
    size = font.GetPointSize()
    style = font.GetStyle()
    weight = font.GetWeight()
    #print "wx.wxDEFAULT, wx.wxMODERN", wx.wxDEFAULT, wx.wxMODERN
    #print family, faceName, size, style, weight
    #print font.GetNativeFontInfo()
    if family >= wx.wxDEFAULT and family <= wx.wxMODERN:
        # ['wxDEFAULT', 'wxDECORATIVE', 'wxROMAN', 'wxSCRIPT', 'wxSWISS', 'wxMODERN']
        names = ['default', 'decorative', 'serif', 'script', 'sansSerif', 'monospace']
        desc['family'] = names[family - wx.wxDEFAULT]
    if faceName != '':
        desc['faceName'] = faceName
    if size != 0:
        desc['size'] = size
    if style == wx.wxITALIC and weight == wx.wxBOLD:
        desc['style'] = 'boldItalic'
    elif style == wx.wxITALIC:
        desc['style'] = 'italic'
    elif weight == wx.wxBOLD:
        desc['style'] = 'bold'
    else:
        desc['style'] = 'regular'
    return desc

def familyId(name):
    if name == 'serif':
        return wx.wxROMAN
    elif name == 'sansSerif':
        return wx.wxSWISS
    elif name == 'monospace':
        return wx.wxMODERN
    else:
        return wx.wxDEFAULT

def styleId(name):
    if name.endswith('italic'):
        return wx.wxITALIC
    else:
        return wx.wxNORMAL

def weightId(name):
    if name.startswith('bold'):
        return wx.wxBOLD
    else:
        return wx.wxNORMAL

def fontFromDescription(fontDescription):
    return wx.wxFont(fontDescription.get('size', wx.wxNORMAL_FONT.GetPointSize()),
                  familyId(fontDescription.get('family', '')),
                  styleId(fontDescription.get('style', 'regular')),
                  weightId(fontDescription.get('style', 'regular')),
                  0,
                  fontDescription.get('faceName', ''))


class Font :

    def __init__( self, fontDescription, aParent=None ) :
        attributes = ['_family', '_faceName', '_style', '_size',
                      '_weight', '_font', '_id', '_underline',
                      '_name', '_parent']
        self._createAttributes(attributes)

        #self._name = name
        # _family: 'serif', 'sansSerif', 'monospace'
        # _style: 'regular', 'bold', 'italic', 'boldItalic'

        self._parent = aParent
        self._family = ''
        self._faceName = ''
        self._size = wx.wxNORMAL_FONT.GetPointSize()
        self._style = 'regular'
        self._underline = 0
        if fontDescription is not None:
            if isinstance(fontDescription, dict):
                fontDescription = res.Resource(fontDescription)
            try:
                self._family = fontDescription.family
            except:
                pass
            try:
                self._faceName = fontDescription.faceName
            except:
                pass
            try:
                self._size = fontDescription.size
            except:
                pass
            try:
                self._style = fontDescription.style
            except:
                pass

    def _getAttributeNames(self):
        """Return list of magic attributes to extend introspection.
        
        Returns only attributes having both "get" and "set" methods."""
        listX = []
        methods = inspect.getmembers(self, inspect.ismethod)
        for m in methods:
            if m[0].startswith(MAGIC_GET_PREFIX):
                name = m[0][len(MAGIC_GET_PREFIX):]
                if name and hasattr(self, MAGIC_SET_PREFIX + name):
                    listX.append(name[0].lower() + name[1:])
        return listX

    def __getattr__(self, name):
        if not name.startswith(MAGIC_GET_PREFIX) and name[0].islower():
            callName = MAGIC_GET_PREFIX + name[0].upper() + name[1:]
            return getattr(self, callName)()
        else:
            raise AttributeError, name

    def __setattr__(self, name, value):
        if name in self.__dict__:
            self.__dict__[name] = value
        elif not name.startswith(MAGIC_SET_PREFIX) and name[0].islower():
            callName = MAGIC_SET_PREFIX + name[0].upper() + name[1:]
            try:
                method = getattr(self, callName)
            except:
                raise AttributeError, name
            if self._parent:
                # The font is bound to a widget.
                method(value)
                return self._parent._setFont(self)
            else:
                # The font is not bound to any widget.
                return method(value)
        else:
            raise AttributeError, name
        
    def _createAttributes(self, attrList):
        for attr in attrList:
            if attr not in self.__dict__:
                self.__dict__[attr] = None

    def _familyId(self, name):
        if name == 'serif':
            return wx.wxROMAN
        elif name == 'sansSerif':
            return wx.wxSWISS
        elif name == 'monospace':
            return wx.wxMODERN
        else:
            return wx.wxDEFAULT

    def _styleId(self, name):
        if name.endswith('italic'):
            return wx.wxITALIC
        else:
            return wx.wxNORMAL

    def _weightId(self, name):
        if name.startswith('bold'):
            return wx.wxBOLD
        else:
            return wx.wxNORMAL

    def _getFont(self):
        return wx.wxFont(self._size,
                      self._familyId(self._family),
                      self._styleId(self._style),
                      self._weightId(self._style),
                      self._underline,
                      self._faceName)

    def _setFont(self, aFont):
        raise AttributeError, "font attribute is read-only"

    def _getSize(self):
        return self._size

    def _setSize(self, size):
        #self._font = self._newFont()
        #self._font.SetPointSize(size)
        self._size = size

    def _getStyle(self):
        return self._style

    def _setStyle(self, style):
        self._style = style

    def _getFaceName(self):
        return self._faceName

    def _setFaceName(self, faceName):
        self._faceName = faceName

    def _getFamily(self):
        return self._family

    def _setFamily(self, family):
        self._family = family

    def description(self):
        desc = {}
        if self._family != '':
            desc['family'] = self._family
        if self._faceName != '':
            desc['faceName'] = self._faceName
        desc['size'] = self._size
        if self._style != 'regular':
            desc['style'] = self._style
        return desc

    def __repr__(self):
        return str(self.description())
