
"""
__version__ = "$Revision: 1.106 $"
__date__ = "$Date: 2004/03/31 01:36:12 $"
"""

from wxPython import wx, stc
import wxPython
import STCStyleEditor
import event
import dialog
import font
import registry
import __version__
import pprint
import config
import os, sys
import webbrowser

try:
    from wx import py as PyCrust
    from wx.py.shell import Shell
    from wx.py.shell import ShellFacade
    from wx.py.filling import Filling
    from wx.py import introspect
    PYCRUST_FOUND = True
except ImportError:
    PYCRUST_FOUND = False

if PYCRUST_FOUND:
    class PythonCardShellFacade(ShellFacade):
        def _getAttributeNames(self):
            names = ShellFacade._getAttributeNames(self)
            names.append('autoCompleteWxMethods')
            names.sort()
            return names


    class PythonCardShell(Shell):
        def setLocalShell(self):
            """Add 'shell' to locals as reference to ShellFacade instance."""
            self.interp.locals['shell'] = PythonCardShellFacade(other=self)
            self.autoCompleteWxMethods = True

        def autoCompleteShow(self, command):
            """Display auto-completion popup list."""
            names = self.interp.getAutoCompleteList(command,
                        includeMagic=self.autoCompleteIncludeMagic,
                        includeSingle=self.autoCompleteIncludeSingle,
                        includeDouble=self.autoCompleteIncludeDouble)
            if not self.autoCompleteWxMethods:
                root = introspect.getRoot(command, terminator='.')
                try:
                    # we have to use locals, right?
                    #print root
                    object = eval(root, self.interp.locals)
                    #print object
                    # only filter attribute names of wxPython objects
                    if isinstance(object, (wx.wxObjectPtr, wx.wxObject)):
                        names.remove('this')
                        names.remove('thisown')
                        names = [name for name in names if name[0] not in 'ABCDEFGHIJKLMNOPQRSTUVWXYZ']
                except:
                    # what is the proper thing to do here?
                    pass
            if names:
                options = ' '.join(names)
                offset = 0
                self.AutoCompShow(offset, options)

        
PYTHONCARD_DEBUG_MENU_RESOURCE_FILE = 'debugmenu.rsrc.py'

DEBUG_MENU_REDIRECT = 'Redirect stdout to Shell'
DEBUG_MENU_ONLINE_HOME = 'PythonCard Home Page'
DEBUG_MENU_ONLINE_HELP = 'Online Documentation'

# MyMiniFrame allows us to use wxMiniFrame on Windows where it
# works correctly, but still use wxFrame under GTK while we wait
# for the wxMiniFrame bug to be fixed (still broken as of 2.3.2.1
if wx.wxPlatform == '__WXMSW__':
    class MyMiniFrame(wx.wxMiniFrame):
        def __init__(self, parent, ID, title, pos, size):
            wx.wxMiniFrame.__init__(self, parent, ID, title, pos,
                                 style = wx.wxDEFAULT_FRAME_STYLE | wx.wxTINY_CAPTION_HORIZ)
else:
    class MyMiniFrame(wx.wxFrame):
        def __init__(self, parent, ID, title, pos, size):
            wx.wxFrame.__init__(self, parent, ID, title, pos, size,
                                wx.wxDEFAULT_FRAME_STYLE | wx.wxFRAME_NO_TASKBAR)

class MessageWatcher(MyMiniFrame, event.EventListener):
    def __init__(self, parent, ID, title, pos, size, parentApp):
        MyMiniFrame.__init__(self, parent, ID, title, pos, size)
        
        panel = wx.wxPanel(self, -1)

        self.parentApp = parentApp

        wx.EVT_CLOSE(self, self.onCloseMe)

        sizer1 = wx.wxBoxSizer(wx.wxVERTICAL)
        sizer2 = wx.wxBoxSizer(wx.wxHORIZONTAL)

        self.hideTimers = wx.wxCheckBox(panel, -1, 'Hide timers',
                                   wx.wxDefaultPosition, wx.wxDefaultSize,
                                   wx.wxNO_BORDER)
        #self.hideTimers.SetValue(1)

        sizer2.Add(self.hideTimers, 0, wx.wxLEFT | wx.wxRIGHT | wx.wxBOTTOM, 5)
        # KEA 2004-01-18
        # deal with (w,h) wxPython 2.5 changes
        #if wx.__version__ >= "2.5":
        # if wx.wxVERSION > (2, 5):
        sizer2.Add((5, 5), 1)  # spacer
        #else:
        #    sizer2.Add(5, 5, 1)  # spacer

        self.hideUnused = wx.wxCheckBox(panel, -1, 'Hide unused',
                                     wx.wxDefaultPosition, wx.wxDefaultSize,
                                     wx.wxNO_BORDER)
        self.hideUnused.SetValue(1)

        sizer2.Add(self.hideUnused, 0, wx.wxLEFT | wx.wxBOTTOM, 5)
        sizer1.Add(sizer2, 0, wx.wxEXPAND)

        self.maxSizeMsgHistory = 29000
        #self.maxSizeMsgHistory = 0	# Turn off

        # eventually, the font size should be settable in the user config
        if wx.wxPlatform == '__WXMAC__KEA_FIXED':
            # don't use wxStyledTextCtrl

            self.msgHistory = wx.wxTextCtrl(panel, -1, '',
                                            wx.wxDefaultPosition,
                                            (100, 60),
                                            style=wx.wxTE_MULTILINE | wx.wxTE_READONLY)
        else:
            self.msgHistory = stc.wxStyledTextCtrl(panel, -1,
                    size=(100, 60),                      
                    style=wx.wxCLIP_CHILDREN)
            self.msgHistory.SetReadOnly(1)
            if wx.wxPlatform == '__WXMSW__':
                self.msgHistory.StyleSetSpec(stc.wxSTC_STYLE_DEFAULT, "face:Arial,size:9")
            else:
                self.msgHistory.StyleSetSize(stc.wxSTC_STYLE_DEFAULT, wx.wxNORMAL_FONT.GetPointSize())
            self.msgHistory.SetUseHorizontalScrollBar(0)
            self.msgHistory.SetMarginWidth(1,0)
            self.msgHistory.SetUndoCollection(0)

        sizer1.Add(self.msgHistory, 1, wx.wxEXPAND)
        sizer1.Fit(panel)
        sizer1.SetSizeHints(self)
        panel.SetSizer(sizer1)
        panel.SetAutoLayout(1)
        panel.Layout()

        # and now for a hack-fest
        if wx.wxPlatform == '__WXMSW__':
            self.SetSize(size)

        event.EventQueue().addListener( self )

    def eventOccurred(self, aDispatchEvent):

        evt = aDispatchEvent.getDispatchedEvent()

        eventName = evt.getName()
        sourceName = evt.getSource().name
        
        # KEA 2002-06-10
        # displaying idle is a losing proposition
        # the act of displaying the idle event ends up
        # causing another idle event as the queue empties
        # with the wxSTC or at least that is what I think was
        # happening
        if eventName == event.IdleEvent.name:
            # print aDispatchEvent.getEventWasUsed(), eventName, sourceName
            return

        used = aDispatchEvent.getEventWasUsed()

        if used:
            eventText = eventName + ' : '  + sourceName
        else:
            eventText = '(' + eventName + ' : '  + sourceName + ')'

        # show timer events?
        if (eventName == 'timer' and self.hideTimers.GetValue()):
            return

        if used or (not self.hideUnused.GetValue()):
            if wx.wxPlatform == '__WXMAC__KEA_FIXED':
                print eventText
                while self.msgHistory.GetLastPosition() > self.maxSizeMsgHistory:
                    # delete first line of history
                    #print self.msgHistory.GetLineLength(0), self.msgHistory.XYToPosition(0, 1)
                    self.msgHistory.Remove(0, self.msgHistory.XYToPosition(0, 1))
                self.msgHistory.AppendText(eventText + '\r')
                # KEA 2002-04-25
                # it doesn't appear we can get the control to auto-scroll
                #self.msgHistory.SetInsertionPointEnd()
                #e = self.msgHistory.GetLastPosition()
                #self.msgHistory.SetSelection(e, e)
                #print self.msgHistory.GetLastPosition()
            else:
                self.msgHistory.SetReadOnly(0)
                if self.maxSizeMsgHistory and self.msgHistory.GetLength() > self.maxSizeMsgHistory:
                    # delete many lines at once to reduce overhead
                    text = self.msgHistory.GetText()
                    endDel = text.index('\n', self.maxSizeMsgHistory / 10) + 1
                    self.msgHistory.SetTargetStart(0)
                    self.msgHistory.SetTargetEnd(endDel)
                    self.msgHistory.ReplaceTarget("")
                self.msgHistory.GotoPos(self.msgHistory.GetLength())
                self.msgHistory.AddText(eventText + '\n')
                self.msgHistory.GotoPos(self.msgHistory.GetLength())
                self.msgHistory.SetReadOnly(1)

    def onCloseMe(self, evt):
        # KEA if the menu item exists, then uncheck it
        #id = self.parentApp.frame.GetMenuBar().FindMenuItem("Script", "Message Watcher")
        #self.parentApp.frame.GetMenuBar().Check(id, false)
        
        # Really close the window, otherwise the app hangs -rds
        #self.Destroy()
        # KEA fixed showMessageWatcher in model.py
        # however, the fix probably needs more work
        self.Show(0)


# KEA this is a load of dingos' kidneys and needs to be rewritten
class PropertyEditor(MyMiniFrame, event.ChangeListener):
    def __init__(self, parent, ID, title, pos, size, parentApp ):
        MyMiniFrame.__init__(self, parent, ID, title, pos, size)
        
        panel = wx.wxPanel(self, -1)

        self.parentApp = parentApp
        bg = self.parentApp.getCurrentBackground()
        bg.components.addChangeEventListener(self)

        wx.EVT_CLOSE(self, self.onCloseMe)

        wx.wxStaticText(panel, -1, 'Name  :  Class', wx.wxPoint(3, 3))
        wx.wxStaticText(panel, -1, 'Properties', wx.wxPoint(228, 3))
        self.wComponentList = wx.wxListBox(panel, -1, wx.wxPoint(0, 20), wx.wxSize(200, 100))
        self.wPropertyList = wx.wxListBox(panel, -1, wx.wxPoint(225, 20), wx.wxSize(125, 100))
        #self.wPropertyList.InsertItems(self.propList, 0)
        self.wName = wx.wxStaticText(panel, -1, 'name:', wx.wxPoint(3, 135), wx.wxSize(90, -1), style = wx.wxALIGN_RIGHT | wx.wxST_NO_AUTORESIZE)
        self.wField = wx.wxTextCtrl(panel, -1, '', wx.wxPoint(100, 130), wx.wxSize(180, -1))
        self.wColor = wx.wxButton(panel, -1, 'Color...', wx.wxPoint(290, 130), wx.wxSize(50, -1))
        self.wColor.Show(0)
        self.wFont = wx.wxButton(panel, -1, 'Font...', wx.wxPoint(290, 130), wx.wxSize(50, -1))
        self.wFont.Show(0)
        self.wTextArea = wx.wxTextCtrl(panel, -1, '', wx.wxPoint(100, 130), wx.wxSize(250, 50), style = wx.wxTE_MULTILINE)
        self.wTextArea.Show(0)
        self.wChecked = wx.wxCheckBox(panel, -1, '', wx.wxPoint(100, 132), wx.wxDefaultSize, wx.wxNO_BORDER)
        self.wChecked.Show(0)
        self.wPop = wx.wxChoice(panel, -1, wx.wxPoint(100, 130), wx.wxDefaultSize, [])
        self.wPop.Show(0)

        self.wCopy = wx.wxButton(panel, -1, 'Copy resource to clipboard', wx.wxPoint(5, 185), wx.wxSize(150, -1))
        self.wCopy.Show(0)
        
        self.wUpdate = wx.wxButton(panel, -1, 'Update', wx.wxPoint(265, 185))
        self.wUpdate.Show(0)

        self.editItems = [self.wField, self.wColor, self.wFont, self.wTextArea, self.wChecked, self.wPop]        

        #self.wSep = wxButton(panel, -1, '', wxPoint(5, 5), wxSize(150, 3))
        #self.wSep.Enable(0)

        # KEA 2001-08-14
        # this was causing an assertion error with the hybrid wxPython
        #self.wComponentList.SetSelection(0)
        if self.wComponentList.GetStringSelection() == "":
            wClass = ""
        else:
            wName, wClass = self.wComponentList.GetStringSelection().split("  :  ")
        self.setValidProps(wClass)

        wx.EVT_LISTBOX(self, self.wComponentList.GetId(), self.onSelectComponentListEvent)
        wx.EVT_LISTBOX(self, self.wPropertyList.GetId(), self.onSelectPropertyListEvent)
        wx.EVT_BUTTON(self, self.wColor.GetId(), self.onSelectColor)
        wx.EVT_BUTTON(self, self.wFont.GetId(), self.onSelectFont)
        wx.EVT_BUTTON(self, self.wCopy.GetId(), self.onSelectCopy)
        wx.EVT_BUTTON(self, self.wUpdate.GetId(), self.onSelectUpdate)

        #event.EventQueue().addListener( self )

        # and now for a hack-fest
        if wx.wxPlatform == '__WXMSW__':
            self.SetSize(size)

    def addWidgetToComponentsList(self, widget):
        wName = widget.name
        wClass = widget.__class__.__name__
        self.wComponentList.Append(wName + "  :  " + wClass)

    def deleteWidgetFromComponentsList(self, wName, wClass):
        i = self.wComponentList.GetSelection()
        j = self.wComponentList.FindString(wName + "  :  " + wClass)
        if i == -1 or i != j:
            if j != -1: 
                self.wComponentList.Delete(j)
        else:
            if j > 0:
                self.wComponentList.SetSelection(j - 1)
            if j != -1:
                self.wComponentList.Delete(j)
            if self.wComponentList.GetSelection() == -1:
                self.setValidProps("")
                self.hideAllBut(self.wField)
                self.wUpdate.Show(0)
                self.wCopy.Show(0)
            else:
                wName, wClass = self.wComponentList.GetStringSelection().split("  :  ")
                # deselect the name from properties list
                self.setValidProps(wClass)
                propName = self.wPropertyList.GetStringSelection()
                if propName == "":
                    propName = "name"
                    self.wPropertyList.SetStringSelection("name")
                self.displayProperty(wName, wClass, propName)

    def selectComponentsList(self, wName, wClass):
        self.wComponentList.SetStringSelection(wName + "  :  " + wClass)
        self.setValidProps(wClass)
        propName = self.wPropertyList.GetStringSelection()
        #print propName
        if propName == "":
            propName = "name"
            self.wPropertyList.SetStringSelection("name")
        self.displayProperty(wName, wClass, propName)

    def changed(self, evt):
        comp = self.parentApp.getCurrentBackground().components
        wName, wClass = evt.getOldValue().split(",")
        if wName in comp:
            # new item added
            self.addWidgetToComponentsList(comp[wName])
        else:
            # item deleted
            self.deleteWidgetFromComponentsList(wName, wClass)

    def onSelectCopy(self, evt):
        wName, wClass = self.wComponentList.GetStringSelection().split("  :  ")
        # what needs to happen here is to have a method for the Widget class that
        # will provide a valid resource description, each subclass of widget would
        # override the method to deal with their specific resource attributes
        # the Widget class should provide some ordering so that 'type',
        # 'position', 'size' comes before less commonly used items, the actual
        # ordering could just be defined in a list, so it is easy to change
        # also, if the current values match the defaults for a widget attribute
        # then that attribute should not be provided as part of the output
        print "this is just a placeholder method right now,"
        print "the resource is not actually copied to the clipboard yet"
        pprint.pprint(self.parentApp.getCurrentBackground().components[wName])

    # KEA 2002-08-22
    # this should be updated to match the resourceEditor Property Editor
    # or the Property Editor code should be changed so that the same module
    # could be used at runtime?
    def onSelectUpdate(self, evt):
        # make these attributes of self, since they are duplicated below in displayProperty
        checkItems = ['enabled', 'visible', 'editable', 'checked', 'default']
        popItems = ['layout', 'border', 'style', 'alignment']
        cantmodify = ['id', 'name', 'alignment', 'layout', 'style', 'border' ]

        wName, wClass = self.wComponentList.GetStringSelection().split("  :  ")
        propName = self.wPropertyList.GetStringSelection()

        if propName not in cantmodify:
            #print "updating", wName
            if propName in checkItems:
                value = self.wChecked.GetValue()
            elif propName in popItems:
                value = self.wPop.GetStringSelection()
            elif wClass == 'TextArea' and propName == 'text':
                value = self.wTextArea.GetValue()
            else:
                value = self.wField.GetValue()

        if propName not in ['label', 'text', 'toolTip']:
            try:
                value = eval(value)
            except:
                pass

        widget = self.parentApp.getCurrentBackground().components[wName]

        if propName == 'size':
            width, height = value
            if wClass not in ['BitmapCanvas', 'HtmlWindow']:
                bestWidth, bestHeight = widget.GetBestSize()
                if width == -1:
                    width = bestWidth
                if height == -1:
                    height = bestHeight
                #setattr(widget, propName, (width, height))
            widget.size = (width, height)
        else:
            setattr(widget, propName, value)

    def onSelectColor(self, evt):
        result = dialog.colorDialog(self)
        if result['accepted']:
            self.wField.SetValue(str(result['color']))

    def onSelectFont(self, evt):
        wName, wClass = self.wComponentList.GetStringSelection().split("  :  ")
        widget = self.parentApp.getCurrentBackground().components[wName]
        f = widget.font
        if f is None:
            desc = font.fontDescription(widget.GetFont())
            f = font.Font(desc)
        result = dialog.fontDialog(self, f)
        if result['accepted']:
            #color = dlg.getColor()
            f = result['font']
            #self.wField.SetValue("%s;%s" % (f, color))
            self.wField.SetValue("%s" % f)

    def setValidProps(self, wClass):
        #print "setValidProps", wClass
        oldProp = self.wPropertyList.GetStringSelection()
        if wClass == "":
            self.wPropertyList.Clear()
        else:
            klass = registry.getRegistry().getComponentClass(wClass)
            props = klass._spec.attributes.keys()
            props.sort()
            self.wPropertyList.Clear()
            self.wPropertyList.InsertItems(props, 0)
            if oldProp in props:
                self.wPropertyList.SetStringSelection(oldProp)

    def hideAllBut(self, widget):
        for w in self.editItems:
            if widget.GetId() != w.GetId():
                w.Show(0)

    def displayProperty(self, wName, wClass, propName):
        checkItems = ['enabled', 'visible', 'editable', 'checked', 'default', 'rules']
        popItems = ['layout', 'border', 'style', 'alignment', 'selected']
        cantmodify = ['id', 'name', 'alignment', 'layout', 'style', 'border' ]

        self.wName.SetLabel(propName + ":")
        widget = self.parentApp.getCurrentBackground().components[wName]
        if propName in ['label', 'text', 'toolTip'] or propName in checkItems:
            value = getattr(widget, propName)
        else:
            value = str(getattr(widget, propName))
        
        if propName in checkItems:
            self.hideAllBut(self.wChecked)
            self.wChecked.Show(1)
            self.wChecked.SetValue(int(value))
        elif propName in popItems:
            self.hideAllBut(self.wPop)
            self.wPop.Show(1)
            self.wPop.Clear()
            for v in widget._spec.attributes[propName].values:
                self.wPop.Append(v)
            self.wPop.SetStringSelection(value)
        elif wClass == 'TextArea' and propName == 'text':
            #print 'displaying TextArea'
            self.hideAllBut(self.wTextArea)
            self.wTextArea.Show(1)
            self.wTextArea.SetValue(value)
        else:
            self.hideAllBut(self.wField)
            self.wField.Show(1)
            if propName == 'foregroundColor' or propName == 'backgroundColor':
                self.wColor.Show(1)
            elif propName == 'font':
                self.wFont.Show(1)
            self.wName.SetLabel(propName + ":")

            if propName == 'size':
                width, height = getattr(widget, propName)
                if wClass not in ['BitmapCanvas', 'HtmlWindow']:
                    bestWidth, bestHeight = widget.GetBestSize()
                    if width == bestWidth:
                        width = -1
                    if height == bestHeight:
                        height = -1
                size = (width, height)
                value = str(size)

            self.wField.SetValue(value)
        # this should only display if the attribute is settable
        # so name, alignment, and others are read-only
        self.wUpdate.Show((propName not in cantmodify) and not (propName == 'items' and wClass == 'RadioGroup'))

    def onSelectComponentListEvent(self, evt):
        #print 'selectComponentListEvent: %s\n' % evt.GetString()
        wName, wClass = evt.GetString().split("  :  ")
        # change the wPropertiesList to only show relevant properties
        # either display the name by default or try and preserve the
        # wPropertiesList selection and display that item, so for example
        # you could look at size for all widgets, simply by going up and down
        # the components list
        self.setValidProps(wClass)
        propName = self.wPropertyList.GetStringSelection()
        #print propName
        if propName == "":
            propName = "name"
            self.wPropertyList.SetStringSelection("name")
        self.displayProperty(wName, wClass, propName)
        #self.wCopy.Show(1)  # probably only need to do this once, but what the hey

    def onSelectPropertyListEvent(self, evt):
        propName = evt.GetString()
        wName, wClass = self.wComponentList.GetStringSelection().split("  :  ")
        if wName != "":
            self.displayProperty(wName, wClass, propName)

    def clearComponentsList(self):
        self.wComponentList.Clear()

    def displayComponents(self, components):
        for c in components.order:
            self.addWidgetToComponentsList(components[c])

    def onCloseMe(self, evt):
        self.Show(0)


class PyCrustFrame(MyMiniFrame):
    def __init__(self, parent, ID, title, pos, size, parentApp):
        MyMiniFrame.__init__(self, parent, ID, title, pos, size)
        
        #parentApp.shell = Shell(editorParent=self)
        ###parentApp.shell = PyCrust.shell.Shell(self, -1)
        parentApp.shell = PythonCardShell(self, -1)
        #print __file__
        if wx.wxPlatform != '__WXMAC__KEA_FIXED':
            # KEA 2002-05-28
            # STCStyleEditor doesn't work yet on OS X
            configfile = os.path.join(config.homedir, 'stc-styles.rc.cfg')
            if not os.path.exists(configfile):
                configfile = os.path.join(config.default_homedir, 'stc-styles.rc.cfg')
            if os.path.exists(configfile):
                STCStyleEditor.initSTC(parentApp.shell, configfile, 'python')

        # KEA this is temporary until we decide what reference
        # we want here
        parentApp.shell.interp.locals['pcapp'] = parentApp
        self.parentApp = parentApp

        wx.EVT_CLOSE(self, self.onCloseMe)

        # and now for a hack-fest
        if wx.wxPlatform == '__WXMSW__':
            self.SetSize(size)

    def onCloseMe(self, evt):
        self.Show(0)

class PyCrustNamespaceFrame(MyMiniFrame):
    def __init__(self, parent, ID, title, pos, size, parentApp):
        MyMiniFrame.__init__(self, parent, ID, title, pos, size)

        parentApp.namespace = PyCrust.filling.Filling(parent = self, \
                                      rootObject = parentApp.shell.interp.locals, \
                                      rootLabel = 'Shell Namespace',
                                      rootIsNamespace = 1)

        self.parentApp = parentApp

        wx.EVT_CLOSE(self, self.onCloseMe)

        # and now for a hack-fest
        if wx.wxPlatform == '__WXMSW__':
            self.SetSize(size)

    def onCloseMe(self, evt):
        self.Show(0)


class DebugMenu:

    def __init__(self, parentApp):
        self.parentApp = parentApp
        self.menuIds = {DEBUG_MENU_REDIRECT:wx.wxNewId(),
                        DEBUG_MENU_ONLINE_HELP:wx.wxNewId(), 
                        DEBUG_MENU_ONLINE_HOME:wx.wxNewId()}
        # decided not to use a resource in order to avoid getting the Debug
        # menu caught up in the PythonCard event model
        #basePath = os.path.dirname(os.path.abspath( __file__))
        #path = os.path.join(basePath, PYTHONCARD_DEBUG_MENU_RESOURCE_FILE)
        #self._resource = ResourceFile(path).getResource()

    def createMenu(self, bg):
        menu = wx.wxMenu()
        menu.Append(wx.wxNewId(), '&Message Watcher')
        menu.Append(wx.wxNewId(), '&Namespace Viewer')
        menu.Append(wx.wxNewId(), '&Property Editor')
        if PYCRUST_FOUND:
            menu.Append(wx.wxNewId(), '&Shell')
            menu.AppendSeparator()
            id = self.menuIds[DEBUG_MENU_REDIRECT]
            #menu.Append(id, "&" + DEBUG_MENU_REDIRECT, checkable = 1)
            menu.Append(id, "&" + DEBUG_MENU_REDIRECT, "", 1)
            # if we want to have a config option set redirect, this is the
            # place to do it
            #menu.Check(id, 1)
        menu.Append(wx.wxNewId(), 'Save &Configuration')
        menu.AppendSeparator()
        id = self.menuIds[DEBUG_MENU_ONLINE_HOME]
        menu.Append(wx.wxNewId(), DEBUG_MENU_ONLINE_HOME)
        id = self.menuIds[DEBUG_MENU_ONLINE_HELP]
        menu.Append(wx.wxNewId(), DEBUG_MENU_ONLINE_HELP)
        menu.AppendSeparator()
        menu.Append(wx.wxNewId(), '&About PythonCard...')
        
        menubar = bg.GetMenuBar()
        if menubar is None:
            menubar = wx.wxMenuBar()
            bg.SetMenuBar(menubar)
        menubar.Append(menu, 'Debug')

    def bindMenuEvents(self, bg):
        # it appears that at the time bindMenuEvent and createMenu are
        # called from Background, the _iterator doesn't exist yet?!
        # so I had to pass in the current background
        #bg = self.parentApp._iterator.getCurrentBackground()
        menubar = bg.GetMenuBar()
        id = menubar.FindMenuItem('Debug', 'About PythonCard...')
        wx.EVT_MENU(bg, id, self.doAboutPythonCard)
        id = menubar.FindMenuItem('Debug', 'Message Watcher')
        wx.EVT_MENU(bg, id, self.toggleMessageWatcher)
        id = menubar.FindMenuItem('Debug', 'Namespace Viewer')
        wx.EVT_MENU(bg, id, self.toggleNamespaceViewer)
        id = menubar.FindMenuItem('Debug', 'Property Editor')
        wx.EVT_MENU(bg, id, self.togglePropertyEditor)
        if PYCRUST_FOUND:
            id = menubar.FindMenuItem('Debug', 'Shell')
            wx.EVT_MENU(bg, id, self.toggleShell)
            id = menubar.FindMenuItem('Debug', DEBUG_MENU_REDIRECT)
            wx.EVT_MENU(bg, id, self.toggleShellRedirect)
        else:
            menubar.Enable(id, 0)
        id = menubar.FindMenuItem('Debug', 'Save Configuration')
        wx.EVT_MENU(bg, id, self.doSaveUserConfiguration)
        id = menubar.FindMenuItem('Debug', DEBUG_MENU_ONLINE_HOME)
        wx.EVT_MENU(bg, id, self.onlineHomePage)
        id = menubar.FindMenuItem('Debug', DEBUG_MENU_ONLINE_HELP)
        wx.EVT_MENU(bg, id, self.onlineDocumentation)

    def toggleMessageWatcher(self, evt):
        self.parentApp.mw.Show(not self.parentApp.mw.IsShown())

    def toggleNamespaceViewer(self, evt):
        self.parentApp.namespaceFrame.Show(not self.parentApp.namespaceFrame.IsShown())

    def togglePropertyEditor(self, evt):
        self.parentApp.pw.Show(not self.parentApp.pw.IsShown())

    def toggleShell(self, evt):
        self.parentApp.shellFrame.Show(not self.parentApp.shellFrame.IsShown())

    def toggleShellRedirect(self, evt):
        menubar = self.parentApp.getCurrentBackground().GetMenuBar()
        #id = menubar.FindMenuItem('Debug', 'Redirect stdout to Shell')
        id = self.menuIds[DEBUG_MENU_REDIRECT]
        # I don't know why, but this appears to be returning the opposite
        # of what it should return, so if IsChecked returns 1 (true) the
        # menu item isn't really checked
        checked = menubar.IsChecked(id)
        #print id, menubar.GetLabel(id), checked
        menubar.Check(id, checked)
        self.parentApp.shell.redirectStdout(checked)

    def doSaveUserConfiguration(self, evt):
        if self.parentApp.mw is not None:
            config.setOption('messageWatcherPosition', self.parentApp.mw.GetPositionTuple())
            config.setOption('messageWatcherSize', self.parentApp.mw.GetSizeTuple())
            #config.setOption('showMessageWatcher', self.parentApp.mw.IsShown())
            config.setOption('showMessageWatcher', 0)
        if self.parentApp.namespaceFrame is not None:
            config.setOption('namespacePosition', self.parentApp.namespaceFrame.GetPositionTuple())
            config.setOption('namespaceSize', self.parentApp.namespaceFrame.GetSizeTuple())
            #config.setOption('showNamespace', self.parentApp.namespaceFrame.IsShown())
            config.setOption('showNamespace', 0)
        if self.parentApp.pw is not None:
            config.setOption('propertyEditorPosition', self.parentApp.pw.GetPositionTuple())
            config.setOption('propertyEditorSize', self.parentApp.pw.GetSizeTuple())
            #config.setOption('showPropertyEditor', self.parentApp.pw.IsShown())
            config.setOption('showPropertyEditor', 0)
        if self.parentApp.shellFrame is not None:
            config.setOption('shellPosition', self.parentApp.shellFrame.GetPositionTuple())
            config.setOption('shellSize', self.parentApp.shellFrame.GetSizeTuple())
            #config.setOption('showShell', self.parentApp.shellFrame.IsShown())
            config.setOption('showShell', 0)
        config.saveConfig()

    def onlineHomePage(self, evt):
        url = 'http://pythoncard.sourceforge.net/'
        webbrowser.open(url, 1, 1) 

    def onlineDocumentation(self, evt):
        url = 'http://pythoncard.sourceforge.net/documentation.html'
        webbrowser.open(url, 1, 1) 

    # the references to self will have to be modified depending on where this
    # method ends up going. we do need a parent for the dialog
    def doAboutPythonCard(self, evt):
        """Displays a ScrolledMessageDialog containing info about PythonCard and version numbers"""

        aboutTitle = "About PythonCard"
        txt = """PythonCard prototype
        
PythonCard is a software construction kit (in the spirit of Apple's HyperCard) written in Python.

"""
        txt += "PythonCard version: %s\n" % __version__.ver
        txt += "wxPython version: %s\n" % wx.__version__
        try:
            txt += "PyCrust version: %s\n" % PyCrust.version.VERSION
            #parentApp.shell.version
            #self.stack.app.shell.version
        except:
            pass
        txt += "Python version: %s\n" % sys.version
        txt += "Platform: %s\n" % os.sys.platform
        txt += """
        
For more information see the docs directory included with this distribution.

Latest release files:
http://sourceforge.net/project/showfiles.php?group_id=19015

PythonCard home page
http://pythoncard.sourceforge.net/

SourceForge summary page
http://sourceforge.net/projects/pythoncard/

Mailing list
http://lists.sourceforge.net/lists/listinfo/pythoncard-users

PythonCard requires Python 2.1 or later and wxPython 2.3.2. wxPython is available at http://www.wxpython.org/
PythonCard relies on wxPython, so it will support the Macintosh once wxPython has been ported to the Mac.
"""
        dialog.scrolledMessageDialog(self.parentApp.getCurrentBackground(), txt, aboutTitle)
