
"""
__version__ = "$Revision: 1.5 $"
__date__ = "$Date: 2004/03/17 23:26:10 $"
"""

from wxPython import wx

import sys
from PythonCardPrototype import binding, event, registry, widget

class TreeSpec(widget.WidgetSpec):
    def __init__(self):
        widget.WidgetSpec.__init__(self)
        
        self.name = 'Tree'
        self.parent = 'Widget'
        self.parentName = self.parent
        self.events.extend([event.SelectEvent, 
                            event.ItemActivatedEvent,
                            event.ItemExpandedEvent,
                            event.ItemExpandingEvent,
                            event.SelectionChangedEvent,
                            event.SelectionChangingEvent,
                            event.KeyDownEvent
                           ])
        self._attributes.update({ 
            #'items' : { 'presence' : 'optional', 'default' : [] },
            #'style' : { 'presence' : 'optional', 'default' : [], 'values' : [ 'horizontal', 'vertical' ] },
        })
        
        self.attributes = self.parseAttributes(self._attributes)
        self.requiredAttributes = self.parseRequiredAttributes()
        self.optionalAttributes = self.parseOptionalAttributes()


class Tree(widget.Widget, wx.wxTreeCtrl):
    """
    A tree.
    """
    
    _spec = TreeSpec()

    def __init__(self, aParent, aResource) :
        #attributes = []
        #self._createAttributes(attributes)
        widget.Widget.__init__(self, aParent, aResource)

        wx.wxTreeCtrl.__init__(
            self,
            aParent, 
            self.getId(), 
            wx.wxPoint(aResource.position[ 0 ], aResource.position[ 1 ]), 
            wx.wxSize(aResource.size[ 0 ], aResource.size[ 1 ]), 
            #aResource.items,
            #style = border | wx.wxLC_REPORT | wx.wxCLIP_SIBLINGS,
            name = aResource.name)

        # then call Widget._postInit which were the initialization
        # steps done after the _delegate was created
        widget.Widget._postInit(self, aParent, aResource)

    def _bindEvents(self):
        adapter = TreeEventBinding(self)
        adapter.bindEvents()


class TreeEventBinding(binding.wxPython_EventBinding) :
    """
    Bind the Events supported by Tree to wxPython.
    """
    def __init__(self, aComponent) :
        binding.wxPython_EventBinding.__init__(self, aComponent)

    """
    Bind an Event class that is supported by this objects peer Widget.
    """
    def bindEvent(self, aEventClass) :
        parent = self._component._parent
        id = self._component.getId()

        if aEventClass is event.ItemActivatedEvent:
            wx.EVT_TREE_ITEM_ACTIVATED(parent, id, self._dispatch)
        elif aEventClass is event.ItemExpandedEvent:
            wx.EVT_TREE_ITEM_EXPANDED(parent, id, self._dispatch)
        elif aEventClass is event.ItemExpandingEvent:
            wx.EVT_TREE_ITEM_EXPANDING(parent, id, self._dispatch)
        elif aEventClass is event.SelectionChangedEvent:
            wx.EVT_TREE_SEL_CHANGED(parent, id, self._dispatch)
        elif aEventClass is event.SelectionChangingEvent:
            wx.EVT_TREE_SEL_CHANGING(parent, id, self._dispatch)
        elif aEventClass is event.KeyDownEvent:
            wx.EVT_TREE_KEY_DOWN(parent, id, self._dispatch)

    """
    Intercept all wxPyton events, convert them to PythonCard events, and
    post them to the EventQueue.
    """
    def _dispatch(self, aWxEvent) :
        # Call our superclass to dispatch the standard mouse
        # events that every widget should get.
        if binding.wxPython_EventBinding._dispatch(self, aWxEvent) :
            return

        evt = None 

        if aWxEvent.GetEventType() == wx.wxEVT_COMMAND_TREE_ITEM_ACTIVATED:
            evt = self._createEvent(event.ItemActivatedEvent, aWxEvent)
        elif aWxEvent.GetEventType() == wx.wxEVT_COMMAND_TREE_ITEM_EXPANDED:
            evt = self._createEvent(event.ItemExpandedEvent, aWxEvent)
        elif aWxEvent.GetEventType() == wx.wxEVT_COMMAND_TREE_ITEM_EXPANDING:
            evt = self._createEvent(event.ItemExpandingEvent, aWxEvent)
        elif aWxEvent.GetEventType() == wx.wxEVT_COMMAND_TREE_SEL_CHANGED:
            evt = self._createEvent(event.SelectionChangedEvent, aWxEvent)
        elif aWxEvent.GetEventType() == wx.wxEVT_COMMAND_TREE_SEL_CHANGING:
            evt = self._createEvent(event.SelectionChangingEvent, aWxEvent)
        elif aWxEvent.GetEventType() == wx.wxEVT_COMMAND_TREE_KEY_DOWN:
            evt = self._createEvent(event.KeyDownEvent, aWxEvent)

        if evt is not None :
            self._component._notifyEventListeners(evt)


registry.getRegistry().register(sys.modules[__name__].Tree)

