
"""
__version__ = "$Revision: 1.8 $"
__date__ = "$Date: 2002/04/18 01:51:09 $"
"""

from wxPython import wx

import sys
from PythonCardPrototype import event, graphic, registry, widget
import button, image

class ImageButtonSpec(image.ImageSpec):
    def __init__(self):
        image.ImageSpec.__init__(self)
        
        self.name = 'ImageButton'
        self.parent = 'Image'
        self.parentName = self.parent
        self.events.extend([event.MouseClickEvent])
        self._attributes.update({
            # KEA since 3d is Windows specific, make transparent the default
            'border' : { 'presence' : 'optional', 'default' : 'transparent', 'values' : [ '3d', 'transparent', 'none' ] }
        })
        
        self.attributes = self.parseAttributes(self._attributes)
        self.requiredAttributes = self.parseRequiredAttributes()
        self.optionalAttributes = self.parseOptionalAttributes()

class ImageButton(image.Image, wx.wxBitmapButton):
    """
    An image that plays the role of a button.
    """

    _spec = ImageButtonSpec()

    def __init__( self, aParent, aResource ) :
        attributes = ['_bitmap', '_border', '_file']
        self._createAttributes(attributes)
        self._border = aResource.border
        ##image.Image.__init__(self, aParent, aResource )
        self._bitmap = graphic.Bitmap(aResource.file, aResource.size)
        self._file = aResource.file
        widget.Widget.__init__( self, aParent, aResource )

        # KEA
        # should we modify aResource instead?
        # is aResource used again later?
        #print aResource.size
        x = aResource.size[0]
        if x == -2:
            x = self._bitmap.getWidth()
        y = aResource.size[1]
        if y == -2:
            y = self._bitmap.getHeight()
        size = wx.wxSize( x, y )

        # KEA need to check all possible variations on Win32 and Linux
        if aResource.border == '3d':
            style = wx.wxBU_AUTODRAW   # Windows specific ?!
        else:
            style = 0

        wx.wxBitmapButton.__init__(
            self,
            aParent, 
            self.getId(), 
            self._bitmap.getBits(), 
            aResource.position, 
            size,
            style | wx.wxCLIP_SIBLINGS,
            name = aResource.name 
        )

        wx.EVT_WINDOW_DESTROY(self, self._OnDestroy)

        # KEA 2001-07-27
        # we should only be binding this if the button
        # is supposed to be transparent
        # so maybe a setTransparent method with true/false parameter?
        # keep track of _transparent attribute and if _transparent
        # then unbind EVT_ERASE_BACKGROUND
        # before changing _transparent to false
        # same kind of thing for setTransparent
        # don't rebind events if not needed
        # getTransparent as well
        # setBorder/getBorder
        #print aResource.border
        if aResource.border == 'transparent':
            #print aResource.border
            wx.EVT_ERASE_BACKGROUND( self, lambda evt: None)

        # then call Widget._postInit which were the initialization
        # steps done after the _delegate was created
        widget.Widget._postInit(self, aParent, aResource)

    def _OnDestroy(self, event):
        # memory leak cleanup
        self._bitmap = None

    def _bindEvents(self):
        # KEA 2001-12-09
        # the class for the binding should probably come
        # from the registry
        # also the classname could always just be EventBinding
        # since the EventBinding class in each widget module would be
        # unique, so the reference below would just be button.EventBinding
        adapter = button.ButtonEventBinding(self)
        adapter.bindEvents()

    #def _setHelpText( self, aString ) :
    #    pass

    # KEA added getBitmap, setBitmap
    # KEA wxWindows uses a different set for wxStaticBitmap
    # so we have to override
    def _getBitmap( self ) :
        return self._bitmap

    # KEA
    # should something other than Refresh be used to force
    # a screen update?
    def _setBitmap( self, aValue ) :
        self._bitmap = aValue
        bmp = aValue.getBits()
        self.SetBitmapLabel(bmp)
        if wx.wxPlatform != "__WXMSW__":
            self.SetBitmapDisabled(bmp)
            self.SetBitmapFocus(bmp)
            self.SetBitmapSelected(bmp)
        self.Refresh()

    def _getBorder( self ) :
        return self._border

    def _setBorder( self, aString ) :
        raise AttributeError, "border attribute is read-only"

    """
    # KEA do we query the Bitmap to find the actual dimensions
    # _size can contain -1, and -2
    # or provide a special getBitmapSize method?
    # this getSize is actually the same as its parent
    def _getSize( self ) :
        return self.GetSizeTuple()   # get the actual size, not (-1, -1)

    # KEA special handling for -2 size option
    def _setSize( self, aSize ):
        x = aSize[0]
        if x == -2:
            x = self._bitmap.getWidth()
        y = aSize[1]
        if y == -2:
            y = self._bitmap.getHeight()
        self.SetSize( ( x, y ) )
    """


    # KEA 2001-08-02
    # right now the image is loaded from a filename
    # during initialization
    # but later these might not make any sense
    # if setBitmap is used directly in user code
    def _getFile( self ) :
        return self._file

    # KEA 2001-08-14
    # if we're going to support setting the file
    # after initialization, then this will need to handle the bitmap loading
    # overhead
    def _setFile( self, aFile ) :
        self._file = aFile
        self._setBitmap(graphic.Bitmap(aFile))

    def _setBackgroundColor( self, aColor ) :
        aColor = self._getDefaultColor( aColor )
        if self._file == '':
            bmp = self._bitmap.getBits()
            dc = wx.wxMemoryDC()
            dc.SelectObject(bmp)
            dc.SetBackground(wx.wxBrush(aColor))
            dc.Clear()
            dc.SelectObject(wx.wxNullBitmap)
        self.SetBackgroundColour( aColor )
        self.Refresh()   # KEA wxPython bug?


registry.getRegistry().register( sys.modules[__name__].ImageButton )

