"""
__version__ = "$Revision: 1.4 $"
__date__ = "$Date: 2003/01/08 08:08:21 $"
"""

from wxPython import wx

def getClipboard():
    data = None
    try:
        if wx.wxTheClipboard.Open():
            if wx.wxTheClipboard.IsSupported(wx.wxDataFormat(wx.wxDF_TEXT)):
                do = wx.wxTextDataObject()
                wx.wxTheClipboard.GetData(do)
                data = do.GetText()
            elif wx.wxTheClipboard.IsSupported(wx.wxDataFormat(wx.wxDF_BITMAP)):
                do = wx.wxBitmapDataObject()
                wx.wxTheClipboard.GetData(do)
                data = do.GetBitmap()
            wx.wxTheClipboard.Close()
    except:
        data = None
    return data

def setClipboard(data):
    try:
        if wx.wxTheClipboard.Open():
            if isinstance(data, (str, unicode)):
                do = wx.wxTextDataObject()
                do.SetText(data)
                wx.wxTheClipboard.SetData(do)
            elif isinstance(data, (wx.wxBitmap, wx.wxBitmapPtr)):
                do = wx.wxBitmapDataObject()
                do.SetBitmap(data)
                wx.wxTheClipboard.SetData(do)
            wx.wxTheClipboard.Close()
    except:
        pass
