"""
__version__ = "$Revision: 1.21 $"
__date__ = "$Date: 2004/03/17 23:25:39 $"
"""

import imp, sys
#import config
#import log
import error
import pom
import event
import dispatch
from wxPython import wx
import wxPython


class EventBindingAdapter :    
    """
    Defines an interface that must be implemented by GUI-specific
    classes that bind GUI events to PythonCard Events.
    """
    def __init__( self, aComponent ) :
        assert issubclass( aComponent.__class__, pom.Component ), 'parameter must extend pom.Component'
        self._component = aComponent

    def bindEvents( self ) :
        raise error.AbstractMethodException


class wxPython_EventBinding ( EventBindingAdapter ) :
    """
    A superclass specific to the wxPython cross-platform GUI toolkit.
    """
    def __init__( self, aComponent ) :
        EventBindingAdapter.__init__( self, aComponent )
        """
        There are a number of mouse specific events that are
        supported by most Widgets, so we bind them here instead
        of requiring any subclasses to do the work.
        """
        self.wxRegistry = { event.TimerEvent : ( wx.EVT_TIMER, wx.wxEVT_TIMER ),
                            event.GainFocusEvent : ( wx.EVT_SET_FOCUS, wx.wxEVT_SET_FOCUS ),
                            event.LoseFocusEvent : ( wx.EVT_KILL_FOCUS, wx.wxEVT_KILL_FOCUS ),
                            event.MouseDownEvent : ( wx.EVT_LEFT_DOWN, wx.wxEVT_LEFT_DOWN ),
                            event.MouseUpEvent : ( wx.EVT_LEFT_UP, wx.wxEVT_LEFT_UP ),      
                            event.MouseDoubleClickEvent : ( wx.EVT_LEFT_DCLICK, wx.wxEVT_LEFT_DCLICK ),   
                            event.MouseMiddleDownEvent : ( wx.EVT_MIDDLE_DOWN, wx.wxEVT_MIDDLE_DOWN ),
                            event.MouseMiddleUpEvent : ( wx.EVT_MIDDLE_UP, wx.wxEVT_MIDDLE_UP ),
                            event.MouseContextDownEvent : ( wx.EVT_RIGHT_DOWN, wx.wxEVT_RIGHT_DOWN ),
                            event.MouseContextUpEvent : ( wx.EVT_RIGHT_UP, wx.wxEVT_RIGHT_UP ),
                            event.MouseMoveEvent : ( wx.EVT_MOTION, wx.wxEVT_MOTION ),
                            event.MouseMiddleDoubleClickEvent : ( wx.EVT_MIDDLE_DCLICK, wx.wxEVT_MIDDLE_DCLICK ), 
                            event.MouseContextDoubleClickEvent : ( wx.EVT_RIGHT_DCLICK, wx.wxEVT_RIGHT_DCLICK ),  
                            event.MouseLeaveEvent : ( wx.EVT_LEAVE_WINDOW, wx.wxEVT_LEAVE_WINDOW ),  
                            event.MouseEnterEvent : ( wx.EVT_ENTER_WINDOW, wx.wxEVT_ENTER_WINDOW ) }

        self.wxEventIdMap = {}

        for key in self.wxRegistry:
            value = self.wxRegistry[key]
            self.wxEventIdMap[value[1]] = key

    def bindEvents( self ) :
        classes = pom.ComponentClassInspector( self._component.__class__ ).getEvents()

        # The _bindMouseEvents method makes a copy of the classes list,
        # removes each mouse event that is found in the copy then returns 
        # the copy.  We use the returned copy that is stripped of mouse
        # events as they are all handled in this class and subclasses
        # don't need to see them.

        remainingClasses = self._bindMouseEvents( classes )
        
        # Bind all of the Events supported by the component.

        for eventClass in remainingClasses :
            self.bindEvent( eventClass )

    def bindEvent( self, aEventClass ) :
        raise AbstractMethodError

    def _bindMouseEvents( self, aEventClassList ) :
                
        # Make a copy of the event class list so we can
        # strip out the mouse event classes.

        widgetClasses = []
        widgetClasses = widgetClasses + aEventClassList

        parent = self._component._parent

        id = self._component.getId()

        otherClasses = []

        for widgetClass in widgetClasses :
            index = self._findEventClass( widgetClass, event.MOUSE_EVENTS ) 
            if index >= 0 :
                wxFunction = self.wxRegistry[widgetClass][0]
                if widgetClass == event.TimerEvent:
                    wxFunction(self._component, -1, self._dispatch)
                else:
                    wxFunction(self._component, self._dispatch)
            else :
                otherClasses.append(widgetClass)

        return otherClasses

    def _findEventClass( self, aClass, aArray ) :
        i = 0
        for e in aArray :
            if e == aClass :
                return i
            i += 1
        return -1

    """
    Subclasses MUST call wxPython_EventBinding._dispatch( self, aWxEvent )
    in order for the generic mouse events to get processed.

    The _dispatch method must return true if it handled the
     event and false if it didn't.
    """
    def _dispatch( self, aWxEvent ) :

        eventType = aWxEvent.GetEventType()

        # KEA 2002-03-07
        # change to (self, event) event handler dispatch
        try:
            # all events should have GetEventObject()
            aWxEvent.target = aWxEvent.GetEventObject()
            aWxEvent.eventObject = aWxEvent.target
        except:
            pass
        # wxPython.controls2.wxListEvent wxPython.controls2.wxTreeEvent
        #if aWxEvent.__class__ == wxPython.controls2.wxListEventPtr or \
        #    aWxEvent.__class__ == wxPython.controls2.wxTreeEventPtr:
        eventType = aWxEvent.GetEventType()
        if eventType in [wx.wxEVT_COMMAND_LIST_KEY_DOWN, 
                         wx.wxEVT_COMMAND_TREE_KEY_DOWN]:
            try:
                # key events are different for wxTreeCtrl and wxListCtrl
                aWxEvent.keyCode = aWxEvent.GetCode()
            except:
                pass
            try:
                # wxListEvent doesn't have GetKeyEvent for some reason
                keyEvent = aWxEvent.GetKeyEvent()
                #print aWxEvent.keyCode, keyEvent.GetKeyCode()
                aWxEvent.altDown = keyEvent.AltDown()
                aWxEvent.controlDown = keyEvent.ControlDown()
                aWxEvent.shiftDown = keyEvent.ShiftDown()
                #print aWxEvent.keyCode, aWxEvent.altDown, aWxEvent.controlDown, aWxEvent.shiftDown
            except:
                pass
        elif eventType in [wx.wxEVT_COMMAND_TREE_BEGIN_DRAG, \
                           wx.wxEVT_COMMAND_TREE_BEGIN_RDRAG, \
                           wx.wxEVT_COMMAND_TREE_END_DRAG, \
                           wx.wxEVT_COMMAND_LIST_BEGIN_DRAG, \
                           wx.wxEVT_COMMAND_LIST_BEGIN_RDRAG, \
                           wx.wxEVT_COMMAND_LIST_COL_BEGIN_DRAG, \
                           wx.wxEVT_COMMAND_LIST_COL_DRAGGING, \
                           wx.wxEVT_COMMAND_LIST_COL_END_DRAG]:
            try:
                # the mouse position during a drag event
                # there doesn't appear to be a way of getting the
                # state of the shift, alt, and control keys
                # during a mouse drag
                aWxEvent.position = aWxEvent.GetPoint()
                aWxEvent.x = aWxEvent.position[0]
                aWxEvent.y = aWxEvent.position[1]
            except:
                pass
        else:
            # each of these could check the event class like
            # wxListEventPtr and wxTreeEventPtr above
            try:
                # mouse and key events
                aWxEvent.position = aWxEvent.GetPosition()
                aWxEvent.x = aWxEvent.GetX()
                aWxEvent.y = aWxEvent.GetY()
                aWxEvent.altDown = aWxEvent.AltDown()
                aWxEvent.controlDown = aWxEvent.ControlDown()
                aWxEvent.shiftDown = aWxEvent.ShiftDown()
            except:
                pass
            try:
                # key events
                aWxEvent.keyCode = aWxEvent.GetKeyCode()
            except:
                pass
            try:
                # timer events
                aWxEvent.interval = aWxEvent.GetInterval()
            except:
                pass

        if eventType in self.wxEventIdMap:
            evt = self.wxEventIdMap[ eventType ]( self._component )
            if evt.__class__ is event.MouseMoveEvent :
                if aWxEvent.Dragging() :
                    evt = event.MouseDragEvent( self._component )
            evt._nativeEvent = aWxEvent
            self._component._notifyEventListeners( evt )
            aWxEvent.Skip()
            return 1
        else :
            return 0
        

    def _createEvent( self, aEventClass, aWxEvent ) :
        evt = aEventClass( self._component )
        evt.setNativeEvent( aWxEvent )
        return evt



class SystemEvent( wx.wxPyCommandEvent ) :
    
    def __init__(self, evtType, id):
        wx.wxPyCommandEvent.__init__(self, evtType, id)
        self.myVal = None

    #def __del__(self):
    #    print '__del__'
    #    wxPyCommandEvent.__del__(self)

    def SetMyVal(self, val):
        self.myVal = val

    def GetMyVal(self):
        return self.myVal


class wxPython_SystemEventBinding( event.EventSource ) :
    """
    """

    EVT_OPEN_BACKGROUND_TYPE = wx.wxNewEventType()

    def __init__( self, scriptable ) :
        event.EventSource.__init__( self )
        # KEA 2002-06-10
        # don't need this dispatch since dispatch is already
        # bound in the background
        ##self.dispatch = dispatch.EventDispatch( self, scriptable )
        #print 'binding system events'
        self.id = wx.wxNewId()
        self.scriptable = scriptable
        scriptable.Connect( scriptable.GetId(), -1, 
                     self.EVT_OPEN_BACKGROUND_TYPE, 
                     self.dispatchOpenBackground )

    def postOpenBackgroundEvent( self ) :

        evt = SystemEvent ( self.EVT_OPEN_BACKGROUND_TYPE, 
                              self.scriptable.GetId() )

        wx.wxPostEvent( self.scriptable, evt )

    def dispatchOpenBackground( self, evt ) :
        #print 'received evt from wxPython:', evt
        # KEA 2002-06-10
        # don't need this dispatch since dispatch is already
        # bound in the background
        ##self.dispatch.eventOccurred( event.OpenBackgroundEvent( self.scriptable ) )
        self.scriptable.dispatch.eventOccurred( event.OpenBackgroundEvent( self.scriptable ) )

class BackgroundEventBindingAdapter:
    def __init__(self, background):
        self._background = background
        self._closing = 0

        #self.wxRegistry = {event.IdleEvent:(wx.EVT_IDLE, wx.wxEVT_IDLE)}
        self.wxRegistry = {event.IdleEvent:(wx.EVT_IDLE, wx.wxEVT_IDLE),
                           event.MoveEvent:(wx.EVT_MOVE, wx.wxEVT_MOVE),
                           event.SizeEvent:(wx.EVT_SIZE, wx.wxEVT_SIZE),
                           event.MinimizeEvent:(wx.EVT_ICONIZE, wx.wxEVT_ICONIZE),
                           event.MaximizeEvent:(wx.EVT_MAXIMIZE, wx.wxEVT_MAXIMIZE),
                           event.ActivateEvent:(wx.EVT_ACTIVATE, wx.wxEVT_ACTIVATE),
                           event.CloseEvent:(wx.EVT_CLOSE, wx.wxEVT_CLOSE_WINDOW)}
                           # can't have ActivatEvent or CloseEvent
                           # since during a close the event listeners are destroyed
                           #event.ActivateEvent:(wx.EVT_ACTIVATE, wx.wxEVT_ACTIVATE),
        self.wxEventIdMap = {}

        for key in self.wxRegistry:
            value = self.wxRegistry[key]
            self.wxEventIdMap[value[1]] = key
        #print self.wxEventIdMap

    def bindEvents(self):
        # event.IdleEvent
        #wx.EVT_IDLE(self._background, self._dispatch)
        #wx.EVT_MOVE(self._background, self._dispatch)
        #wx.EVT_SIZE(self._background, self._dispatch)
        #wx.EVT_CLOSE(self._background, self._dispatch)
        for eventClass in self.wxRegistry:
            wxFunction = self.wxRegistry[eventClass][0]
            wxFunction(self._background, self._dispatch)

    def _dispatch(self, aWxEvent):
        eventType = aWxEvent.GetEventType()

        try:
            # all events should have GetEventObject()
            aWxEvent.target = aWxEvent.GetEventObject()
            aWxEvent.eventObject = aWxEvent.target
        except:
            pass
        if eventType == wx.wxEVT_MOVE:
            aWxEvent.position = aWxEvent.GetPosition()
        elif eventType == wx.wxEVT_SIZE:
            aWxEvent.size = aWxEvent.GetSize()
        elif eventType == wx.wxEVT_ICONIZE:
            aWxEvent.minimized = aWxEvent.Iconized()
        elif eventType == wx.wxEVT_MAXIMIZE:
            aWxEvent.maximized = aWxEvent.target.IsMaximized()
        elif eventType == wx.wxEVT_ACTIVATE:
            aWxEvent.activated = aWxEvent.GetActive()

        """
        try:
            aWxEvent.size = aWxEvent.GetSize()
        except:
            pass
        """

        evt = None
        #if aWxEvent in [wx.wxEVT_IDLE]:
        if eventType in self.wxEventIdMap:
            evt = self.wxEventIdMap[eventType](self._background)
            evt._nativeEvent = aWxEvent
            #self._background._notifyEventListeners(evt)

        if evt is not None:
            #if eventType != wx.wxEVT_IDLE:
            #    print evt, self._closing
            if self._closing:
                # don't display messages when quitting the app
                # the Message Watcher may no longer exist
                # and will cause Python to crash
                return
            self._background._notifyEventListeners(evt)
            if not evt.getUsed():
                aWxEvent.Skip()
            # KEA 2002-07-01
            # if we have a close event and the user code called
            # Skip() then we really are closing
            if eventType == wx.wxEVT_CLOSE_WINDOW and aWxEvent.GetSkipped():
                self._closing = 1

