#!/usr/bin/env python
#
# $Id: setup.py,v 1.2 2000/10/09 05:42:57 mrnolta Exp $
#
# distutils setup file for libplot contributed Berthold Hllmann
# <bhoel@starship.python.net>
#

from distutils.core import setup, Extension

setup (# Distribution meta-data
    name = "libplot",
    version = "1.0.2",
    author = "Mike Nolta",
    author_email = "mrnolta@users.sourceforge.net",
    url = "http://biggles.sourceforge.net/",
    description = "GNU plotutils/libplot interface for Python",

    # Description of the modules and packages in the distribution
    py_modules = ["libplot"],
    ext_modules = [Extension("_libplot", ["_libplot.i"],
                             libraries=["plot", "Xaw", "Xmu", "Xt", "SM",
                                        "ICE", "Xext", "X11"])],
    # use extra directory for libplot
    extra_path = "libplot"
    )

