.\" Automatically generated by Pod::Man v1.37, Pod::Parser v1.32
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sh \" Subsection heading
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  | will give a
.\" real vertical bar.  \*(C+ will give a nicer C++.  Capital omega is used to
.\" do unbreakable dashes and therefore won't be available.  \*(C` and \*(C'
.\" expand to `' in nroff, nothing in troff, for use with C<>.
.tr \(*W-|\(bv\*(Tr
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.Sh), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.if \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.\"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.hy 0
.if n .na
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "xpaenv n"
.TH xpaenv n "April 14, 2011" "version 2.1.13" "SAORD Documentation"
.SH "NAME"
\&\fBXPAEnv: Environment Variables for XPA Messaging\fR
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
Describes the environment variables which can be used to tailor the overall
\&\s-1XPA\s0 environment.
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
The following environment variables are supported by \s-1XPA:\s0
.IP "\(bu" 4
\&\fB\s-1XPA_ACL\s0\fR
.Sp
If \fI\s-1XPA_ACL\s0\fR is \fItrue\fR, then 
host-based \s-1XPA\s0 Access Control
is turned on and only specified machines can access specified access
points.  If \fIfalse\fR, then access control is turned off and any
machine can access point. The default is turn turn access control on.
.IP "\(bu" 4
\&\fB\s-1XPA_ACLFILE\s0\fR
.Sp
If
\&\s-1XPA\s0 Access Control
is turned on, this variable specifies the name of the file containing
access control information for all access points started by this user.
The default file name is: \fI$HOME/acls.xpa\fR.
.IP "\(bu" 4
\&\fB\s-1XPA_CONNECT_TIMEOUT\s0\fR
.Sp
When an \s-1XPA\s0 server first starts up, it immediately tries to
connect to the \s-1XPA\s0 name server program (xpans) on the host specified by
the \fI\s-1XPA_NSINET\s0\fR variable. (If this connection fails on the
local host, and if xpans can be found in the path, then the name
server is started automatically.)  Unfortunately, a mis-configured
network can cause this connect attempt to hang for many seconds while
the \fIconnect()\fR system call times out. Therefore, an alarm is started
to interrupt the \fIconnect()\fR call and prevent a long hang.  The initial
value of the alarm timeout is 10 seconds, but can be changed by setting
this environment variable. If you want to disable the alarm and allow
the initial \fIconnect()\fR to time out, set the value of this variable to
0. Normally, users would not change this variable at all.
.IP "\(bu" 4
\&\fB\s-1XPA_CLIENT_DOXPA\s0\fR
.Sp
Normally, an \s-1XPA\s0 client (xpaget, xpaset, etc.) will process incoming
\&\s-1XPA\s0 server requests while awaiting the completion of the client request.
Setting this variable to \*(L"false\*(R" will prevent \s-1XPA\s0 server requests from
being processed by the client.
.IP "\(bu" 4
\&\fB\s-1XPA_DEFACL\s0\fR
.Sp
If
\&\s-1XPA\s0 Access Control
is turned on, this variable specifies the default access control
condition for all access points, if the \fI\s-1XPA_ACLFILE\s0\fR file does
not exist.  The default acl is: \fI$host:* \f(CI$host\fI +\fR, meaning that
all processes on the host machine have full access to all access points.
.IP "\(bu" 4
\&\fB\s-1XPA_HOST\s0\fR
.Sp
For the \s-1INET\s0 socket method, \s-1XPA\s0 utilizes the canonical hostname (as
returned by the \fIgethostname()\fR routine) to construct the \s-1IP\s0 part of the
method id. Under some circumstances, this might not be a correct choice
of name and \s-1IP\s0. For example, if an \s-1XPA\s0 server is started on a machine
running \s-1VPN\s0, you might want to use the \s-1VPN\s0 name and \s-1IP\s0 instead of the
canonical host name, so that other machines in the \s-1VPN\s0 network can
access the server. In this case, you can set the \s-1XPA_HOST\s0 to be
the \s-1VPN\s0 name (if resolvable) or, more easily, the \s-1VPN\s0 \s-1IP\s0.
.IP "\(bu" 4
\&\fB\s-1XPA_IOCALLSXPA\s0\fR
.Sp
Setting this variable causes all \s-1XPA\s0 socket \s-1IO\s0 calls to process
outstanding \s-1XPA\s0 requests whenever the primary socket is not ready for
\&\s-1IO\s0. This means that a server making a client call will (recursively)
process incoming server requests while waiting for client completion.
This inter-IO \s-1XPA\s0 processing avoids a rare
\&\s-1XPA\s0 Race Condition: two or more
\&\s-1XPA\s0 servers sending messages to one another using an \s-1XPA\s0 client
routine such as \fIXPASet()\fR can deadlock while each waits for the other
server to respond. This can happen, for example, if the servers call
\&\fIXPAPoll()\fR with a time limit, and send messages in between the polling call.
.Sp
By default, this option is turned off, because we judge that the added
code complication and overhead involved will not be justified by the
amount of its use.  Moreover, processing \s-1XPA\s0 requests within socket \s-1IO\s0
can lead to non-intuitive results, since incoming server requests will
not necessarily be processed to completion in the order in which they
are received.
.IP "\(bu" 4
\&\fB\s-1XPA_LOGNAME\s0\fR
.Sp
\&\s-1XPA\s0 preferentially uses the de facto standard environment variable
\&\s-1LOGNAME\s0 to determine the username when registering an access point in
the name server. If this environment variable has been used for
something other than the actual user name (such as a log file name),
unexpected results can ensue. In such cases, use the \s-1XPA_LOGNAME\s0
variable to set the user name. (If neither exists, then getpwuid(\fIgeteuid()\fR)
is used as a last resort).
.IP "\(bu" 4
\&\fB\s-1XPA_LONG_TIMEOUT\s0\fR
.Sp
\&\s-1XPA\s0 is designed to allow data to be sent from one process to
another over a long period of time (i.e., a program that generates
image data sends that data to an image display, but slowly) but it
also seeks to prevent hangs. This is done by supporting 2 timeout
periods: a \fIshort\fR timeout for protocol communication
and a \fIlong\fR for data communication.
.Sp
The \fI\s-1XPA_LONG_TIMEOUT\s0\fR variable controls the \fIlong\fR
timeout and is used to prevent hangs in cases where communication
between the client and server that is \fInot\fR controlled by the
\&\s-1XPA\s0 interface itself. Transfer of data between client and server, or a
client's wait for a status message after completion of the server
callback, are two examples of this sort of communication. By default,
the \fIlong\fR timeout is set to 180 seconds.
Setting the value to \-1 will disable \fIlong\fR timeouts and allow
an infinite amount of time.
.IP "\(bu" 4
\&\fB\s-1XPA_MAXHOSTS\s0\fR
.Sp
The maximum number of access points that the programs 
\&\fIxpaset\fR, \fIxpaget\fR, and \fIxpainfo\fR will
communicate with at one time. The default is 64, meaning, for
example, that the \fIxpaset\fR program will not send a message
to more than 100 access points at one time and \fIxpaget\fR will
not retrieve from more than 100 access points at one time.
.IP "\(bu" 4
\&\fB\s-1XPA_METHOD\s0\fR
.Sp
Determines the socket connection method used by this session of \s-1XPA\s0.
The choices are: \fIinet\fR (to use \s-1INET\s0 or Internet-based
sockets), \fIlocalhost\fR (to use the machines localhost inet
socket), or \fIlocal (unix)\fR (to use \s-1UNIX\s0 sockets). The default
is \fI\s-1INET\s0\fR.  Using the \fIinet\fR method will allow access
from other machines (subject to access controls) but using
\&\fIlocalhost\fR or \fIlocal\fR will not. Localhost is most useful
for private access and when the machine in question is not connected
to the Internet. The unix method also can be used for private access
and non-Internet connections (Unix platforms only).
.Sp
Once defined, the first registration of an \s-1XPA\s0 access point will
ensure that an instance of the
\&\s-1XPA\s0 Name Server (xpans)
is running that handles that connection method. All new access points
will use the new connection method but existing access points will use
the original method.
.IP "\(bu" 4
\&\fB\s-1XPA_NSINET\s0\fR
.Sp
For the \fIinet\fR method of socket connection, this variable
specifies the host and port on which the 
\&\s-1XPA\s0 Name Server (xpans)
is listens for new access points. The default is \fI$host:$port\fR,
meaning that the default \s-1XPA\s0 port (14285) on the current machine
(as returned by \fIgethostname()\fR) is used. If several machines were all
accessing the same \s-1XPA\s0 access points, you would use this variable to
specify that they all use the same name server to find out about these
access points.  For example, a value of \fImyhost:$port\fR would
mean that the xpans name server is running on myhost and uses the
default port 12345.  All machines would then get the \s-1XPA\s0 access points
registered with that name server, subject to access controls.
.Sp
The port used by xpans to register its \s-1XPA\s0 access point normally is
taken to be one greater than the port on which it receives new access
points from \s-1XPA\s0 servers. You can specify a specific access point port
using the syntax machine:port1,port2, i.e., the access point port is
specified after the comma.  For example, \f(CW$host:12345\fR,23456 will listen
for new access ports on 12345 and will accept \s-1XPA\s0 commands on 23456.
.IP "\(bu" 4
\&\fB\s-1XPA_NSREGISTER\s0\fR
.Sp
This boolean variable specifies whether a server registers its \s-1XPA\s0
access point with the specified xpans name server. The default is
\&\fItrue\fR.  If set to \fIfalse\fR, the access point still is
set up but it is not registered with xpans and therefore cannot be
accessed by name. (It can be accessed by method, if the latter is
known.) Note that an access point can be registered later on (using
\&\-remote or \-proxy, for example). This variable mainly is useful in
cases where the Internet configuration is broken (so that registration
causes a \s-1DNS\s0 hang) but you still wish to and can use the server with a
remote xpans (e.g., ds9's Virtual Observatory capability).
.IP "\(bu" 4
\&\fB\s-1XPA_NSUNIX\s0\fR
.Sp
For the \fIlocal\fR method of socket connection, this variable
specifies the name of the Unix file that will be used to access the
\&\s-1XPA\s0 Name Server (xpans). The default is
\&\fIxpans_unix\fR. This variable is not usually needed. Note that
is the \fIlocal\fR socket method is used, then remote machines will
not be able to access the xpans name server or the registered \s-1XPA\s0 access
points.
.IP "\(bu" 4
\&\fB\s-1XPA_NSUSERS\s0\fR
.Sp
This variable specifies whether other users' access points will be
returned by the
\&\s-1XPA\s0 Name Server (xpans) for use by
\&\fIxpaget\fR, \fIxpaset\fR, etc.
Generally speaking, it is sufficient to run one xpans name server per
machine and register the access points for all users with that xpans.
This means, for example, that if you request information from
ds9 by running:
.Sp
.Vb 1
\&  xpaget ds9 colormap
.Ve
.Sp
you might get information from your own ds9 as well as
from another user running ds9 on the same machine.  The
\&\fI\s-1XPA_NSUSERS\s0\fR variable controls whether you want such access 
to the access points of other users.
By default, only your own access points are returned, so
that, in the example above, you would only get the colormap information
from the ds9 you registered. If, however, you had set the value of the
\&\fI\s-1XPA_NSUSERS\s0\fR variable to \fIeric,fred\fR, then you would be
able to communicate with both eric and fred's access points. Note that
this variable can be overridden using the \fI\-u\fR switch on the
\&\fIxpaget\fR, \fIxpaset\fR, and \fIxpainfo\fR programs.
.IP "\(bu" 4
\&\fB\s-1XPA_PORT\s0\fR
.Sp
A semi-colon delimited list of user specified ports to use for specific
\&\s-1XPA\s0 access points. The format is each specification is:
.Sp
class:template port1[ port2]
.Sp
where \fBport1\fR is the main (command) port for the access point and
\&\fBport2\fR is the (secondary) data port. If port2 is not specified,
it defaults to a value of 0 (meaning the system assigns the port).
.Sp
Specification of specific ports is useful, for example, when a machine
outside a firewall needs to communicate with a machine inside a
firewall. In such a case, the firewall should be configured to allow
socket connections to both the command and data port from the outside
machine, and the inside \s-1XPA\s0 program should be started up with the
outside machine in its \s-1ACL\s0 list. Then, when the inside program is
started with specified ports, outside \s-1XPA\s0 programs can use
\&\*(L"machine:port\*(R" to contact the inside access points, instead of the
access point names. That is, the machine outside the firewall does not
need access to the \s-1XPA\s0 name server:
.Sp
export XPA_PORT=\*(L"DS9:ds9 12345 12346\*(R"   # on machine \*(L"inside\*(R"
cat foo.fits | xpaset inside:12345 fits # on machine \*(L"outside\*(R"
.Sp
Note that 2 ports are required for full \s-1XPA\s0 communication and
therefore 2 ports should be specified to go through a firewall.  The
second port assignment is not important if you simply are assigning
the command port in order to communicate commands with a known
port (e.g., to bypass the xpans name server). If only one (command)
port is specified, the system will negotiate a random data port and
everything will work properly.
.Sp
This support is somewhat experimental. If you run into problems, please
let us know.
.IP "\(bu" 4
\&\fB\s-1XPA_PORTFILE\s0\fR
.Sp
A list of user-specified port to use for specific xpa access points.
The format of the file is:
.Sp
class:template port1 [port2]
.Sp
where \fBport1\fR is the main port for the access point and
\&\fBport2\fR is the data port. If port2 is not specified, it defaults
to a value of 0 (meaning the system assigns the port).  See
\&\fB\s-1XPA_PORT\s0\fR above for an explanation of user-specified ports.
.IP "\(bu" 4
\&\fB\s-1XPA_SHORT_TIMEOUT\s0\fR
.Sp
\&\s-1XPA\s0 is designed to allow data to be sent from one process to
another over a long period of time (i.e., a program that generates
image data sends that data to an image display, but slowly) but it
also seeks to prevent hangs. This is done by supporting 2 timeout
periods: a \fIshort\fR timeout for protocol communication
and a \fIlong\fR for data communication.
.Sp
The \fI\s-1XPA_SHORT_TIMEOUT\s0\fR variable
controls the \fIshort\fR timeout and is used to prevent hangs
in cases where the \s-1XPA\s0 protocol requires internal communication between
the client and server that is controlled by the \s-1XPA\s0 interface
itself. Authentication is an example of this sort of communication,
as is the establishment of a data channel between the two processes.
The default value for the \fIshort\fR is 30 seconds (which is
a pretty long time, actually). Setting the value to \-1 will disable
\&\fIshort\fR timeouts and allow an infinite amount of time.
.IP "\(bu" 4
\&\fB\s-1XPA_SIGUSR1\s0\fR
.Sp
If the value of this variable is \fItrue\fR, then \s-1XPA\s0 will
catch \s-1SIGUSR1\s0 signals when performing an I/O operation in order to
curtail that operation. This facility allows users to send a \s-1SIGUSR1\s0
signal to an \s-1XPA\s0 server if a client is hanging up the server by
sending or receiving data too slowly (timeouts also can be used \*(-- see
above). When enabled in this way, the \s-1SIGUSR1\s0 signal is ignored at all other
times, so that its safe to send the signal at any time.  If the
variable is set to \fIfalse\fR, then \s-1SIGUSR1\s0 is not used at
all. Turning off \s-1SIGUSR1\s0 would be desired in cases there the program
uses \s-1SIGUSR1\s0 for some other reason and does not want \s-1XPA\s0 interfering.
The default is to use the signal.
.IP "\(bu" 4
\&\fB\s-1XPA_TIMESTAMP_ERRORS\s0\fR
.Sp
If \fI\s-1XPA_TIMESTAMP_ERRORS\s0\fR is \fItrue\fR, then error
messages will include a date/time string.  This can be useful when
\&\s-1XPA\s0 errors are being saved in an error log (e.g. Web/CGI use). The
default is false.
.RE
.IP "\(bu"
\&\fB\s-1XPA_TMPDIR\s0\fR
.PP
This variable specifies the directory into which \s-1XPA\s0 logs, Unix
socket files (when \fI\s-1XPA_METHOD\s0\fR is \fIlocal\fR), etc. are
stored. The default is \fI/tmp/.xpa\fR.
.RE
.IP "\(bu"
\&\fB\s-1XPA_VERBOSITY\s0\fR
.PP
Specify the verbosity level of error messages. If the value is
set to \fI0\fR, \fIfalse\fR, or \fIoff\fR, then no error
messages are printed to stderr.  If the value is \fI1\fR, then
important \s-1XPA\s0 error messages will be output.  If the value is
set to \fI2\fR, \s-1XPA\s0 warnings about out-of-sync messages will also
be output.  These latter almost always can be ignored.
.RE
.IP "\(bu"
\&\fB\s-1XPA_VERSIONCHECK\s0\fR
.PP
Specify whether a new access point should check its major and minor \s-1XPA\s0
version number against the version used by the xpans name server at
registration time. The default is \fItrue\fR. When checking is
performed, a warning is issued if the server major version is found to
be greater than the xpans version. Note that the check is performed
both by the \s-1XPA\s0 server and by the xpans process and warnings will be
issued by each.  Also, instead of the values of \fItrue\fR or
\&\fIfalse\fR, you can give this variable an integer value n. In this
case, each version checking process (i.e., the XPA-enabled server or
xpans) will print out a maximum of n warning messages (after which
version warnings are silently swallowed).
.PP
In general, it is a bad idea to run an XPA-enabled server program
using a version of \s-1XPA\s0 newer than the basic xpaset, xpaget, xpaaccess,
xpans programs. This sort of mismatch usually will not work due to
protocol changes.
.SH "SEE ALSO"
.IX Header "SEE ALSO"
See xpa(n) for a list of \s-1XPA\s0 help pages
