#!/usr/bin/env python

from lpltoolkit import LaunchpadService

lp   = LaunchpadService()
d    = lp.load_project("ubuntu")

next_milestone = None
for series in d.series:
    print "%-10s %-20s %-25s" % (series.name,
                                 series.status,
                                 series.date_created)
    if series.status == "Active Development" or series.status == "Pre-release Freeze":
        for milestone in series.active_milestones:
            print "%10s %-20s %-25s" % ("-->", milestone.name, milestone.date_targeted)
            if milestone.date_targeted and not next_milestone:
                next_milestone = milestone
            elif next_milestone and milestone.date_targeted < next_milestone.date_targeted:
                next_milestone = milestone

print
print "The next milestone is ", next_milestone.name
