# pylint: disable=too-many-lines,too-many-statements
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from io import IOBase
import json
import sys
from typing import (
    Any,
    AsyncIterable,
    AsyncIterator,
    Callable,
    Dict,
    IO,
    List,
    Optional,
    Type,
    TypeVar,
    Union,
    cast,
    overload,
)
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    StreamClosedError,
    StreamConsumedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.polling import AsyncLROPoller, AsyncNoPolling, AsyncPollingMethod
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict
from azure.mgmt.core.exceptions import ARMErrorFormat
from azure.mgmt.core.polling.async_arm_polling import AsyncARMPolling

from ... import models as _models
from ..._model_base import SdkJSONEncoder, _deserialize
from ...operations._operations import (
    build_fleets_create_or_update_request,
    build_fleets_delete_request,
    build_fleets_get_request,
    build_fleets_list_by_resource_group_request,
    build_fleets_list_by_subscription_request,
    build_fleets_list_virtual_machine_scale_sets_request,
    build_fleets_update_request,
    build_operations_list_request,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class Operations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.computefleet.aio.ComputeFleetMgmtClient`'s
        :attr:`operations` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace
    def list(self, **kwargs: Any) -> AsyncIterable["_models.Operation"]:
        """List the operations for the provider.

        :return: An iterator like instance of Operation
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.computefleet.models.Operation]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "actionType": "str",
                    "display": {
                        "description": "str",
                        "operation": "str",
                        "provider": "str",
                        "resource": "str"
                    },
                    "isDataAction": bool,
                    "name": "str",
                    "origin": "str"
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.Operation]] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_operations_list_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.Operation], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.ErrorResponse, response.json())
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class FleetsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.mgmt.computefleet.aio.ComputeFleetMgmtClient`'s
        :attr:`fleets` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @distributed_trace_async
    async def get(self, resource_group_name: str, fleet_name: str, **kwargs: Any) -> _models.Fleet:
        """Get a Fleet.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param fleet_name: The name of the Compute Fleet. Required.
        :type fleet_name: str
        :return: Fleet. The Fleet is compatible with MutableMapping
        :rtype: ~azure.mgmt.computefleet.models.Fleet
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "location": "str",
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",
                                "principalId": "str"
                            }
                        }
                    },
                    "name": "str",
                    "plan": {
                        "name": "str",
                        "product": "str",
                        "publisher": "str",
                        "promotionCode": "str",
                        "version": "str"
                    },
                    "properties": {
                        "computeProfile": {
                            "baseVirtualMachineProfile": {
                                "applicationProfile": {
                                    "galleryApplications": [
                                        {
                                            "packageReferenceId": "str",
                                            "configurationReference":
                                              "str",
                                            "enableAutomaticUpgrade":
                                              bool,
                                            "order": 0,
                                            "tags": "str",
                "treatFailureAsDeploymentFailure": bool
                                        }
                                    ]
                                },
                                "capacityReservation": {
                                    "capacityReservationGroup": {
                                        "id": "str"
                                    }
                                },
                                "diagnosticsProfile": {
                                    "bootDiagnostics": {
                                        "enabled": bool,
                                        "storageUri": "str"
                                    }
                                },
                                "extensionProfile": {
                                    "extensions": [
                                        {
                                            "id": "str",
                                            "name": "str",
                                            "properties": {
                "autoUpgradeMinorVersion": bool,
                "enableAutomaticUpgrade": bool,
                                                "forceUpdateTag":
                                                  "str",
                                                "protectedSettings":
                                                  {
                                                    "str": {}
                                                },
                "protectedSettingsFromKeyVault": {
                                                    "secretUrl":
                                                      "str",
                "sourceVault": {
                                                        "id":
                                                          "str"
                                                    }
                                                },
                "provisionAfterExtensions": [
                                                    "str"
                                                ],
                                                "provisioningState":
                                                  "str",
                                                "publisher": "str",
                                                "settings": {
                                                    "str": {}
                                                },
                                                "suppressFailures":
                                                  bool,
                                                "type": "str",
                                                "typeHandlerVersion":
                                                  "str"
                                            },
                                            "type": "str"
                                        }
                                    ],
                                    "extensionsTimeBudget": "str"
                                },
                                "hardwareProfile": {
                                    "vmSizeProperties": {
                                        "vCPUsAvailable": 0,
                                        "vCPUsPerCore": 0
                                    }
                                },
                                "licenseType": "str",
                                "networkProfile": {
                                    "healthProbe": {
                                        "id": "str"
                                    },
                                    "networkApiVersion": "str",
                                    "networkInterfaceConfigurations": [
                                        {
                                            "name": "str",
                                            "properties": {
                                                "ipConfigurations": [
                                                    {
                "name": "str",
                "properties": {
                "applicationGatewayBackendAddressPools":
                                                              [
                {
                "id": "str"
                }
                ],
                "applicationSecurityGroups": [
                {
                "id": "str"
                }
                ],
                "loadBalancerBackendAddressPools": [
                {
                "id": "str"
                }
                ],
                "loadBalancerInboundNatPools": [
                {
                "id": "str"
                }
                ],
                "primary": bool,
                "privateIPAddressVersion": "str",
                "publicIPAddressConfiguration": {
                "name": "str",
                "properties": {
                "deleteOption": "str",
                "dnsSettings": {
                "domainNameLabel": "str",
                "domainNameLabelScope": "str"
                },
                "idleTimeoutInMinutes": 0,
                "ipTags": [
                {
                "ipTagType": "str",
                "tag": "str"
                }
                ],
                "publicIPAddressVersion": "str",
                "publicIPPrefix": {
                "id": "str"
                }
                },
                "sku": {
                "name": "str",
                "tier": "str"
                }
                },
                "subnet": {
                "id": "str"
                }
                                                        }
                                                    }
                                                ],
                                                "auxiliaryMode":
                                                  "str",
                                                "auxiliarySku":
                                                  "str",
                                                "deleteOption":
                                                  "str",
                "disableTcpStateTracking": bool,
                                                "dnsSettings": {
                                                    "dnsServers":
                                                      [
                                                        "str"
                                                    ]
                                                },
                "enableAcceleratedNetworking": bool,
                                                "enableFpga": bool,
                                                "enableIPForwarding":
                                                  bool,
                "networkSecurityGroup": {
                                                    "id": "str"
                                                },
                                                "primary": bool
                                            }
                                        }
                                    ]
                                },
                                "osProfile": {
                                    "adminPassword": "str",
                                    "adminUsername": "str",
                                    "allowExtensionOperations": bool,
                                    "computerNamePrefix": "str",
                                    "customData": "str",
                                    "linuxConfiguration": {
                                        "disablePasswordAuthentication":
                                          bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "ssh": {
                                            "publicKeys": [
                                                {
                                                    "keyData":
                                                      "str",
                                                    "path": "str"
                                                }
                                            ]
                                        }
                                    },
                                    "requireGuestProvisionSignal": bool,
                                    "secrets": [
                                        {
                                            "sourceVault": {
                                                "id": "str"
                                            },
                                            "vaultCertificates": [
                                                {
                "certificateStore": "str",
                "certificateUrl": "str"
                                                }
                                            ]
                                        }
                                    ],
                                    "windowsConfiguration": {
                                        "additionalUnattendContent": [
                                            {
                                                "componentName":
                                                  "Microsoft-Windows-Shell-Setup",
                                                "content": "str",
                                                "passName":
                                                  "OobeSystem",
                                                "settingName": "str"
                                            }
                                        ],
                                        "enableAutomaticUpdates": bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "enableHotpatching": bool,
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "timeZone": "str",
                                        "winRM": {
                                            "listeners": [
                                                {
                "certificateUrl": "str",
                                                    "protocol":
                                                      "str"
                                                }
                                            ]
                                        }
                                    }
                                },
                                "scheduledEventsProfile": {
                                    "osImageNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    },
                                    "terminateNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    }
                                },
                                "securityPostureReference": {
                                    "excludeExtensions": [
                                        "str"
                                    ],
                                    "id": "str",
                                    "isOverridable": bool
                                },
                                "securityProfile": {
                                    "encryptionAtHost": bool,
                                    "encryptionIdentity": {
                                        "userAssignedIdentityResourceId":
                                          "str"
                                    },
                                    "proxyAgentSettings": {
                                        "enabled": bool,
                                        "keyIncarnationId": 0,
                                        "mode": "str"
                                    },
                                    "securityType": "str",
                                    "uefiSettings": {
                                        "secureBootEnabled": bool,
                                        "vTpmEnabled": bool
                                    }
                                },
                                "serviceArtifactReference": {
                                    "id": "str"
                                },
                                "storageProfile": {
                                    "dataDisks": [
                                        {
                                            "createOption": "str",
                                            "lun": 0,
                                            "caching": "str",
                                            "deleteOption": "str",
                                            "diskIOPSReadWrite": 0,
                                            "diskMBpsReadWrite": 0,
                                            "diskSizeGB": 0,
                                            "managedDisk": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                                                "securityProfile": {
                "diskEncryptionSet": {
                                                        "id":
                                                          "str"
                                                    },
                "securityEncryptionType": "str"
                                                },
                                                "storageAccountType":
                                                  "str"
                                            },
                                            "name": "str",
                                            "writeAcceleratorEnabled":
                                              bool
                                        }
                                    ],
                                    "diskControllerType": "str",
                                    "imageReference": {
                                        "communityGalleryImageId": "str",
                                        "exactVersion": "str",
                                        "id": "str",
                                        "offer": "str",
                                        "publisher": "str",
                                        "sharedGalleryImageId": "str",
                                        "sku": "str",
                                        "version": "str"
                                    },
                                    "osDisk": {
                                        "createOption": "str",
                                        "caching": "str",
                                        "deleteOption": "str",
                                        "diffDiskSettings": {
                                            "option": "str",
                                            "placement": "str"
                                        },
                                        "diskSizeGB": 0,
                                        "image": {
                                            "uri": "str"
                                        },
                                        "managedDisk": {
                                            "diskEncryptionSet": {
                                                "id": "str"
                                            },
                                            "securityProfile": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                "securityEncryptionType": "str"
                                            },
                                            "storageAccountType": "str"
                                        },
                                        "name": "str",
                                        "osType": "str",
                                        "vhdContainers": [
                                            "str"
                                        ],
                                        "writeAcceleratorEnabled": bool
                                    }
                                },
                                "timeCreated": "2020-02-20 00:00:00",
                                "userData": "str"
                            },
                            "computeApiVersion": "str",
                            "platformFaultDomainCount": 0
                        },
                        "vmSizesProfile": [
                            {
                                "name": "str",
                                "rank": 0
                            }
                        ],
                        "provisioningState": "str",
                        "regularPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "minCapacity": 0
                        },
                        "spotPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "evictionPolicy": "str",
                            "maintain": bool,
                            "maxPricePerVM": 0.0,
                            "minCapacity": 0
                        },
                        "timeCreated": "2020-02-20 00:00:00",
                        "uniqueId": "str"
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str"
                    },
                    "tags": {
                        "str": "str"
                    },
                    "type": "str",
                    "zones": [
                        "str"
                    ]
                }
        """
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[_models.Fleet] = kwargs.pop("cls", None)

        _request = build_fleets_get_request(
            resource_group_name=resource_group_name,
            fleet_name=fleet_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = kwargs.pop("stream", False)
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            if _stream:
                try:
                    await response.read()  # Load the body in memory and close the socket
                except (StreamConsumedError, StreamClosedError):
                    pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        if _stream:
            deserialized = response.iter_bytes()
        else:
            deserialized = _deserialize(_models.Fleet, response.json())

        if cls:
            return cls(pipeline_response, deserialized, {})  # type: ignore

        return deserialized  # type: ignore

    async def _create_or_update_initial(
        self, resource_group_name: str, fleet_name: str, resource: Union[_models.Fleet, JSON, IO[bytes]], **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(resource, (IOBase, bytes)):
            _content = resource
        else:
            _content = json.dumps(resource, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_fleets_create_or_update_request(
            resource_group_name=resource_group_name,
            fleet_name=fleet_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 200:
            deserialized = response.iter_bytes()

        if response.status_code == 201:
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

            deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        fleet_name: str,
        resource: _models.Fleet,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Fleet]:
        """Create a Fleet.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param fleet_name: The name of the Compute Fleet. Required.
        :type fleet_name: str
        :param resource: Resource create parameters. Required.
        :type resource: ~azure.mgmt.computefleet.models.Fleet
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns Fleet. The Fleet is compatible with
         MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.computefleet.models.Fleet]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                resource = {
                    "location": "str",
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",
                                "principalId": "str"
                            }
                        }
                    },
                    "name": "str",
                    "plan": {
                        "name": "str",
                        "product": "str",
                        "publisher": "str",
                        "promotionCode": "str",
                        "version": "str"
                    },
                    "properties": {
                        "computeProfile": {
                            "baseVirtualMachineProfile": {
                                "applicationProfile": {
                                    "galleryApplications": [
                                        {
                                            "packageReferenceId": "str",
                                            "configurationReference":
                                              "str",
                                            "enableAutomaticUpgrade":
                                              bool,
                                            "order": 0,
                                            "tags": "str",
                "treatFailureAsDeploymentFailure": bool
                                        }
                                    ]
                                },
                                "capacityReservation": {
                                    "capacityReservationGroup": {
                                        "id": "str"
                                    }
                                },
                                "diagnosticsProfile": {
                                    "bootDiagnostics": {
                                        "enabled": bool,
                                        "storageUri": "str"
                                    }
                                },
                                "extensionProfile": {
                                    "extensions": [
                                        {
                                            "id": "str",
                                            "name": "str",
                                            "properties": {
                "autoUpgradeMinorVersion": bool,
                "enableAutomaticUpgrade": bool,
                                                "forceUpdateTag":
                                                  "str",
                                                "protectedSettings":
                                                  {
                                                    "str": {}
                                                },
                "protectedSettingsFromKeyVault": {
                                                    "secretUrl":
                                                      "str",
                "sourceVault": {
                                                        "id":
                                                          "str"
                                                    }
                                                },
                "provisionAfterExtensions": [
                                                    "str"
                                                ],
                                                "provisioningState":
                                                  "str",
                                                "publisher": "str",
                                                "settings": {
                                                    "str": {}
                                                },
                                                "suppressFailures":
                                                  bool,
                                                "type": "str",
                                                "typeHandlerVersion":
                                                  "str"
                                            },
                                            "type": "str"
                                        }
                                    ],
                                    "extensionsTimeBudget": "str"
                                },
                                "hardwareProfile": {
                                    "vmSizeProperties": {
                                        "vCPUsAvailable": 0,
                                        "vCPUsPerCore": 0
                                    }
                                },
                                "licenseType": "str",
                                "networkProfile": {
                                    "healthProbe": {
                                        "id": "str"
                                    },
                                    "networkApiVersion": "str",
                                    "networkInterfaceConfigurations": [
                                        {
                                            "name": "str",
                                            "properties": {
                                                "ipConfigurations": [
                                                    {
                "name": "str",
                "properties": {
                "applicationGatewayBackendAddressPools":
                                                              [
                {
                "id": "str"
                }
                ],
                "applicationSecurityGroups": [
                {
                "id": "str"
                }
                ],
                "loadBalancerBackendAddressPools": [
                {
                "id": "str"
                }
                ],
                "loadBalancerInboundNatPools": [
                {
                "id": "str"
                }
                ],
                "primary": bool,
                "privateIPAddressVersion": "str",
                "publicIPAddressConfiguration": {
                "name": "str",
                "properties": {
                "deleteOption": "str",
                "dnsSettings": {
                "domainNameLabel": "str",
                "domainNameLabelScope": "str"
                },
                "idleTimeoutInMinutes": 0,
                "ipTags": [
                {
                "ipTagType": "str",
                "tag": "str"
                }
                ],
                "publicIPAddressVersion": "str",
                "publicIPPrefix": {
                "id": "str"
                }
                },
                "sku": {
                "name": "str",
                "tier": "str"
                }
                },
                "subnet": {
                "id": "str"
                }
                                                        }
                                                    }
                                                ],
                                                "auxiliaryMode":
                                                  "str",
                                                "auxiliarySku":
                                                  "str",
                                                "deleteOption":
                                                  "str",
                "disableTcpStateTracking": bool,
                                                "dnsSettings": {
                                                    "dnsServers":
                                                      [
                                                        "str"
                                                    ]
                                                },
                "enableAcceleratedNetworking": bool,
                                                "enableFpga": bool,
                                                "enableIPForwarding":
                                                  bool,
                "networkSecurityGroup": {
                                                    "id": "str"
                                                },
                                                "primary": bool
                                            }
                                        }
                                    ]
                                },
                                "osProfile": {
                                    "adminPassword": "str",
                                    "adminUsername": "str",
                                    "allowExtensionOperations": bool,
                                    "computerNamePrefix": "str",
                                    "customData": "str",
                                    "linuxConfiguration": {
                                        "disablePasswordAuthentication":
                                          bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "ssh": {
                                            "publicKeys": [
                                                {
                                                    "keyData":
                                                      "str",
                                                    "path": "str"
                                                }
                                            ]
                                        }
                                    },
                                    "requireGuestProvisionSignal": bool,
                                    "secrets": [
                                        {
                                            "sourceVault": {
                                                "id": "str"
                                            },
                                            "vaultCertificates": [
                                                {
                "certificateStore": "str",
                "certificateUrl": "str"
                                                }
                                            ]
                                        }
                                    ],
                                    "windowsConfiguration": {
                                        "additionalUnattendContent": [
                                            {
                                                "componentName":
                                                  "Microsoft-Windows-Shell-Setup",
                                                "content": "str",
                                                "passName":
                                                  "OobeSystem",
                                                "settingName": "str"
                                            }
                                        ],
                                        "enableAutomaticUpdates": bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "enableHotpatching": bool,
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "timeZone": "str",
                                        "winRM": {
                                            "listeners": [
                                                {
                "certificateUrl": "str",
                                                    "protocol":
                                                      "str"
                                                }
                                            ]
                                        }
                                    }
                                },
                                "scheduledEventsProfile": {
                                    "osImageNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    },
                                    "terminateNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    }
                                },
                                "securityPostureReference": {
                                    "excludeExtensions": [
                                        "str"
                                    ],
                                    "id": "str",
                                    "isOverridable": bool
                                },
                                "securityProfile": {
                                    "encryptionAtHost": bool,
                                    "encryptionIdentity": {
                                        "userAssignedIdentityResourceId":
                                          "str"
                                    },
                                    "proxyAgentSettings": {
                                        "enabled": bool,
                                        "keyIncarnationId": 0,
                                        "mode": "str"
                                    },
                                    "securityType": "str",
                                    "uefiSettings": {
                                        "secureBootEnabled": bool,
                                        "vTpmEnabled": bool
                                    }
                                },
                                "serviceArtifactReference": {
                                    "id": "str"
                                },
                                "storageProfile": {
                                    "dataDisks": [
                                        {
                                            "createOption": "str",
                                            "lun": 0,
                                            "caching": "str",
                                            "deleteOption": "str",
                                            "diskIOPSReadWrite": 0,
                                            "diskMBpsReadWrite": 0,
                                            "diskSizeGB": 0,
                                            "managedDisk": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                                                "securityProfile": {
                "diskEncryptionSet": {
                                                        "id":
                                                          "str"
                                                    },
                "securityEncryptionType": "str"
                                                },
                                                "storageAccountType":
                                                  "str"
                                            },
                                            "name": "str",
                                            "writeAcceleratorEnabled":
                                              bool
                                        }
                                    ],
                                    "diskControllerType": "str",
                                    "imageReference": {
                                        "communityGalleryImageId": "str",
                                        "exactVersion": "str",
                                        "id": "str",
                                        "offer": "str",
                                        "publisher": "str",
                                        "sharedGalleryImageId": "str",
                                        "sku": "str",
                                        "version": "str"
                                    },
                                    "osDisk": {
                                        "createOption": "str",
                                        "caching": "str",
                                        "deleteOption": "str",
                                        "diffDiskSettings": {
                                            "option": "str",
                                            "placement": "str"
                                        },
                                        "diskSizeGB": 0,
                                        "image": {
                                            "uri": "str"
                                        },
                                        "managedDisk": {
                                            "diskEncryptionSet": {
                                                "id": "str"
                                            },
                                            "securityProfile": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                "securityEncryptionType": "str"
                                            },
                                            "storageAccountType": "str"
                                        },
                                        "name": "str",
                                        "osType": "str",
                                        "vhdContainers": [
                                            "str"
                                        ],
                                        "writeAcceleratorEnabled": bool
                                    }
                                },
                                "timeCreated": "2020-02-20 00:00:00",
                                "userData": "str"
                            },
                            "computeApiVersion": "str",
                            "platformFaultDomainCount": 0
                        },
                        "vmSizesProfile": [
                            {
                                "name": "str",
                                "rank": 0
                            }
                        ],
                        "provisioningState": "str",
                        "regularPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "minCapacity": 0
                        },
                        "spotPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "evictionPolicy": "str",
                            "maintain": bool,
                            "maxPricePerVM": 0.0,
                            "minCapacity": 0
                        },
                        "timeCreated": "2020-02-20 00:00:00",
                        "uniqueId": "str"
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str"
                    },
                    "tags": {
                        "str": "str"
                    },
                    "type": "str",
                    "zones": [
                        "str"
                    ]
                }

                # response body for status code(s): 200, 201
                response == {
                    "location": "str",
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",
                                "principalId": "str"
                            }
                        }
                    },
                    "name": "str",
                    "plan": {
                        "name": "str",
                        "product": "str",
                        "publisher": "str",
                        "promotionCode": "str",
                        "version": "str"
                    },
                    "properties": {
                        "computeProfile": {
                            "baseVirtualMachineProfile": {
                                "applicationProfile": {
                                    "galleryApplications": [
                                        {
                                            "packageReferenceId": "str",
                                            "configurationReference":
                                              "str",
                                            "enableAutomaticUpgrade":
                                              bool,
                                            "order": 0,
                                            "tags": "str",
                "treatFailureAsDeploymentFailure": bool
                                        }
                                    ]
                                },
                                "capacityReservation": {
                                    "capacityReservationGroup": {
                                        "id": "str"
                                    }
                                },
                                "diagnosticsProfile": {
                                    "bootDiagnostics": {
                                        "enabled": bool,
                                        "storageUri": "str"
                                    }
                                },
                                "extensionProfile": {
                                    "extensions": [
                                        {
                                            "id": "str",
                                            "name": "str",
                                            "properties": {
                "autoUpgradeMinorVersion": bool,
                "enableAutomaticUpgrade": bool,
                                                "forceUpdateTag":
                                                  "str",
                                                "protectedSettings":
                                                  {
                                                    "str": {}
                                                },
                "protectedSettingsFromKeyVault": {
                                                    "secretUrl":
                                                      "str",
                "sourceVault": {
                                                        "id":
                                                          "str"
                                                    }
                                                },
                "provisionAfterExtensions": [
                                                    "str"
                                                ],
                                                "provisioningState":
                                                  "str",
                                                "publisher": "str",
                                                "settings": {
                                                    "str": {}
                                                },
                                                "suppressFailures":
                                                  bool,
                                                "type": "str",
                                                "typeHandlerVersion":
                                                  "str"
                                            },
                                            "type": "str"
                                        }
                                    ],
                                    "extensionsTimeBudget": "str"
                                },
                                "hardwareProfile": {
                                    "vmSizeProperties": {
                                        "vCPUsAvailable": 0,
                                        "vCPUsPerCore": 0
                                    }
                                },
                                "licenseType": "str",
                                "networkProfile": {
                                    "healthProbe": {
                                        "id": "str"
                                    },
                                    "networkApiVersion": "str",
                                    "networkInterfaceConfigurations": [
                                        {
                                            "name": "str",
                                            "properties": {
                                                "ipConfigurations": [
                                                    {
                "name": "str",
                "properties": {
                "applicationGatewayBackendAddressPools":
                                                              [
                {
                "id": "str"
                }
                ],
                "applicationSecurityGroups": [
                {
                "id": "str"
                }
                ],
                "loadBalancerBackendAddressPools": [
                {
                "id": "str"
                }
                ],
                "loadBalancerInboundNatPools": [
                {
                "id": "str"
                }
                ],
                "primary": bool,
                "privateIPAddressVersion": "str",
                "publicIPAddressConfiguration": {
                "name": "str",
                "properties": {
                "deleteOption": "str",
                "dnsSettings": {
                "domainNameLabel": "str",
                "domainNameLabelScope": "str"
                },
                "idleTimeoutInMinutes": 0,
                "ipTags": [
                {
                "ipTagType": "str",
                "tag": "str"
                }
                ],
                "publicIPAddressVersion": "str",
                "publicIPPrefix": {
                "id": "str"
                }
                },
                "sku": {
                "name": "str",
                "tier": "str"
                }
                },
                "subnet": {
                "id": "str"
                }
                                                        }
                                                    }
                                                ],
                                                "auxiliaryMode":
                                                  "str",
                                                "auxiliarySku":
                                                  "str",
                                                "deleteOption":
                                                  "str",
                "disableTcpStateTracking": bool,
                                                "dnsSettings": {
                                                    "dnsServers":
                                                      [
                                                        "str"
                                                    ]
                                                },
                "enableAcceleratedNetworking": bool,
                                                "enableFpga": bool,
                                                "enableIPForwarding":
                                                  bool,
                "networkSecurityGroup": {
                                                    "id": "str"
                                                },
                                                "primary": bool
                                            }
                                        }
                                    ]
                                },
                                "osProfile": {
                                    "adminPassword": "str",
                                    "adminUsername": "str",
                                    "allowExtensionOperations": bool,
                                    "computerNamePrefix": "str",
                                    "customData": "str",
                                    "linuxConfiguration": {
                                        "disablePasswordAuthentication":
                                          bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "ssh": {
                                            "publicKeys": [
                                                {
                                                    "keyData":
                                                      "str",
                                                    "path": "str"
                                                }
                                            ]
                                        }
                                    },
                                    "requireGuestProvisionSignal": bool,
                                    "secrets": [
                                        {
                                            "sourceVault": {
                                                "id": "str"
                                            },
                                            "vaultCertificates": [
                                                {
                "certificateStore": "str",
                "certificateUrl": "str"
                                                }
                                            ]
                                        }
                                    ],
                                    "windowsConfiguration": {
                                        "additionalUnattendContent": [
                                            {
                                                "componentName":
                                                  "Microsoft-Windows-Shell-Setup",
                                                "content": "str",
                                                "passName":
                                                  "OobeSystem",
                                                "settingName": "str"
                                            }
                                        ],
                                        "enableAutomaticUpdates": bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "enableHotpatching": bool,
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "timeZone": "str",
                                        "winRM": {
                                            "listeners": [
                                                {
                "certificateUrl": "str",
                                                    "protocol":
                                                      "str"
                                                }
                                            ]
                                        }
                                    }
                                },
                                "scheduledEventsProfile": {
                                    "osImageNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    },
                                    "terminateNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    }
                                },
                                "securityPostureReference": {
                                    "excludeExtensions": [
                                        "str"
                                    ],
                                    "id": "str",
                                    "isOverridable": bool
                                },
                                "securityProfile": {
                                    "encryptionAtHost": bool,
                                    "encryptionIdentity": {
                                        "userAssignedIdentityResourceId":
                                          "str"
                                    },
                                    "proxyAgentSettings": {
                                        "enabled": bool,
                                        "keyIncarnationId": 0,
                                        "mode": "str"
                                    },
                                    "securityType": "str",
                                    "uefiSettings": {
                                        "secureBootEnabled": bool,
                                        "vTpmEnabled": bool
                                    }
                                },
                                "serviceArtifactReference": {
                                    "id": "str"
                                },
                                "storageProfile": {
                                    "dataDisks": [
                                        {
                                            "createOption": "str",
                                            "lun": 0,
                                            "caching": "str",
                                            "deleteOption": "str",
                                            "diskIOPSReadWrite": 0,
                                            "diskMBpsReadWrite": 0,
                                            "diskSizeGB": 0,
                                            "managedDisk": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                                                "securityProfile": {
                "diskEncryptionSet": {
                                                        "id":
                                                          "str"
                                                    },
                "securityEncryptionType": "str"
                                                },
                                                "storageAccountType":
                                                  "str"
                                            },
                                            "name": "str",
                                            "writeAcceleratorEnabled":
                                              bool
                                        }
                                    ],
                                    "diskControllerType": "str",
                                    "imageReference": {
                                        "communityGalleryImageId": "str",
                                        "exactVersion": "str",
                                        "id": "str",
                                        "offer": "str",
                                        "publisher": "str",
                                        "sharedGalleryImageId": "str",
                                        "sku": "str",
                                        "version": "str"
                                    },
                                    "osDisk": {
                                        "createOption": "str",
                                        "caching": "str",
                                        "deleteOption": "str",
                                        "diffDiskSettings": {
                                            "option": "str",
                                            "placement": "str"
                                        },
                                        "diskSizeGB": 0,
                                        "image": {
                                            "uri": "str"
                                        },
                                        "managedDisk": {
                                            "diskEncryptionSet": {
                                                "id": "str"
                                            },
                                            "securityProfile": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                "securityEncryptionType": "str"
                                            },
                                            "storageAccountType": "str"
                                        },
                                        "name": "str",
                                        "osType": "str",
                                        "vhdContainers": [
                                            "str"
                                        ],
                                        "writeAcceleratorEnabled": bool
                                    }
                                },
                                "timeCreated": "2020-02-20 00:00:00",
                                "userData": "str"
                            },
                            "computeApiVersion": "str",
                            "platformFaultDomainCount": 0
                        },
                        "vmSizesProfile": [
                            {
                                "name": "str",
                                "rank": 0
                            }
                        ],
                        "provisioningState": "str",
                        "regularPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "minCapacity": 0
                        },
                        "spotPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "evictionPolicy": "str",
                            "maintain": bool,
                            "maxPricePerVM": 0.0,
                            "minCapacity": 0
                        },
                        "timeCreated": "2020-02-20 00:00:00",
                        "uniqueId": "str"
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str"
                    },
                    "tags": {
                        "str": "str"
                    },
                    "type": "str",
                    "zones": [
                        "str"
                    ]
                }
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        fleet_name: str,
        resource: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Fleet]:
        """Create a Fleet.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param fleet_name: The name of the Compute Fleet. Required.
        :type fleet_name: str
        :param resource: Resource create parameters. Required.
        :type resource: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns Fleet. The Fleet is compatible with
         MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.computefleet.models.Fleet]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "location": "str",
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",
                                "principalId": "str"
                            }
                        }
                    },
                    "name": "str",
                    "plan": {
                        "name": "str",
                        "product": "str",
                        "publisher": "str",
                        "promotionCode": "str",
                        "version": "str"
                    },
                    "properties": {
                        "computeProfile": {
                            "baseVirtualMachineProfile": {
                                "applicationProfile": {
                                    "galleryApplications": [
                                        {
                                            "packageReferenceId": "str",
                                            "configurationReference":
                                              "str",
                                            "enableAutomaticUpgrade":
                                              bool,
                                            "order": 0,
                                            "tags": "str",
                "treatFailureAsDeploymentFailure": bool
                                        }
                                    ]
                                },
                                "capacityReservation": {
                                    "capacityReservationGroup": {
                                        "id": "str"
                                    }
                                },
                                "diagnosticsProfile": {
                                    "bootDiagnostics": {
                                        "enabled": bool,
                                        "storageUri": "str"
                                    }
                                },
                                "extensionProfile": {
                                    "extensions": [
                                        {
                                            "id": "str",
                                            "name": "str",
                                            "properties": {
                "autoUpgradeMinorVersion": bool,
                "enableAutomaticUpgrade": bool,
                                                "forceUpdateTag":
                                                  "str",
                                                "protectedSettings":
                                                  {
                                                    "str": {}
                                                },
                "protectedSettingsFromKeyVault": {
                                                    "secretUrl":
                                                      "str",
                "sourceVault": {
                                                        "id":
                                                          "str"
                                                    }
                                                },
                "provisionAfterExtensions": [
                                                    "str"
                                                ],
                                                "provisioningState":
                                                  "str",
                                                "publisher": "str",
                                                "settings": {
                                                    "str": {}
                                                },
                                                "suppressFailures":
                                                  bool,
                                                "type": "str",
                                                "typeHandlerVersion":
                                                  "str"
                                            },
                                            "type": "str"
                                        }
                                    ],
                                    "extensionsTimeBudget": "str"
                                },
                                "hardwareProfile": {
                                    "vmSizeProperties": {
                                        "vCPUsAvailable": 0,
                                        "vCPUsPerCore": 0
                                    }
                                },
                                "licenseType": "str",
                                "networkProfile": {
                                    "healthProbe": {
                                        "id": "str"
                                    },
                                    "networkApiVersion": "str",
                                    "networkInterfaceConfigurations": [
                                        {
                                            "name": "str",
                                            "properties": {
                                                "ipConfigurations": [
                                                    {
                "name": "str",
                "properties": {
                "applicationGatewayBackendAddressPools":
                                                              [
                {
                "id": "str"
                }
                ],
                "applicationSecurityGroups": [
                {
                "id": "str"
                }
                ],
                "loadBalancerBackendAddressPools": [
                {
                "id": "str"
                }
                ],
                "loadBalancerInboundNatPools": [
                {
                "id": "str"
                }
                ],
                "primary": bool,
                "privateIPAddressVersion": "str",
                "publicIPAddressConfiguration": {
                "name": "str",
                "properties": {
                "deleteOption": "str",
                "dnsSettings": {
                "domainNameLabel": "str",
                "domainNameLabelScope": "str"
                },
                "idleTimeoutInMinutes": 0,
                "ipTags": [
                {
                "ipTagType": "str",
                "tag": "str"
                }
                ],
                "publicIPAddressVersion": "str",
                "publicIPPrefix": {
                "id": "str"
                }
                },
                "sku": {
                "name": "str",
                "tier": "str"
                }
                },
                "subnet": {
                "id": "str"
                }
                                                        }
                                                    }
                                                ],
                                                "auxiliaryMode":
                                                  "str",
                                                "auxiliarySku":
                                                  "str",
                                                "deleteOption":
                                                  "str",
                "disableTcpStateTracking": bool,
                                                "dnsSettings": {
                                                    "dnsServers":
                                                      [
                                                        "str"
                                                    ]
                                                },
                "enableAcceleratedNetworking": bool,
                                                "enableFpga": bool,
                                                "enableIPForwarding":
                                                  bool,
                "networkSecurityGroup": {
                                                    "id": "str"
                                                },
                                                "primary": bool
                                            }
                                        }
                                    ]
                                },
                                "osProfile": {
                                    "adminPassword": "str",
                                    "adminUsername": "str",
                                    "allowExtensionOperations": bool,
                                    "computerNamePrefix": "str",
                                    "customData": "str",
                                    "linuxConfiguration": {
                                        "disablePasswordAuthentication":
                                          bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "ssh": {
                                            "publicKeys": [
                                                {
                                                    "keyData":
                                                      "str",
                                                    "path": "str"
                                                }
                                            ]
                                        }
                                    },
                                    "requireGuestProvisionSignal": bool,
                                    "secrets": [
                                        {
                                            "sourceVault": {
                                                "id": "str"
                                            },
                                            "vaultCertificates": [
                                                {
                "certificateStore": "str",
                "certificateUrl": "str"
                                                }
                                            ]
                                        }
                                    ],
                                    "windowsConfiguration": {
                                        "additionalUnattendContent": [
                                            {
                                                "componentName":
                                                  "Microsoft-Windows-Shell-Setup",
                                                "content": "str",
                                                "passName":
                                                  "OobeSystem",
                                                "settingName": "str"
                                            }
                                        ],
                                        "enableAutomaticUpdates": bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "enableHotpatching": bool,
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "timeZone": "str",
                                        "winRM": {
                                            "listeners": [
                                                {
                "certificateUrl": "str",
                                                    "protocol":
                                                      "str"
                                                }
                                            ]
                                        }
                                    }
                                },
                                "scheduledEventsProfile": {
                                    "osImageNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    },
                                    "terminateNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    }
                                },
                                "securityPostureReference": {
                                    "excludeExtensions": [
                                        "str"
                                    ],
                                    "id": "str",
                                    "isOverridable": bool
                                },
                                "securityProfile": {
                                    "encryptionAtHost": bool,
                                    "encryptionIdentity": {
                                        "userAssignedIdentityResourceId":
                                          "str"
                                    },
                                    "proxyAgentSettings": {
                                        "enabled": bool,
                                        "keyIncarnationId": 0,
                                        "mode": "str"
                                    },
                                    "securityType": "str",
                                    "uefiSettings": {
                                        "secureBootEnabled": bool,
                                        "vTpmEnabled": bool
                                    }
                                },
                                "serviceArtifactReference": {
                                    "id": "str"
                                },
                                "storageProfile": {
                                    "dataDisks": [
                                        {
                                            "createOption": "str",
                                            "lun": 0,
                                            "caching": "str",
                                            "deleteOption": "str",
                                            "diskIOPSReadWrite": 0,
                                            "diskMBpsReadWrite": 0,
                                            "diskSizeGB": 0,
                                            "managedDisk": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                                                "securityProfile": {
                "diskEncryptionSet": {
                                                        "id":
                                                          "str"
                                                    },
                "securityEncryptionType": "str"
                                                },
                                                "storageAccountType":
                                                  "str"
                                            },
                                            "name": "str",
                                            "writeAcceleratorEnabled":
                                              bool
                                        }
                                    ],
                                    "diskControllerType": "str",
                                    "imageReference": {
                                        "communityGalleryImageId": "str",
                                        "exactVersion": "str",
                                        "id": "str",
                                        "offer": "str",
                                        "publisher": "str",
                                        "sharedGalleryImageId": "str",
                                        "sku": "str",
                                        "version": "str"
                                    },
                                    "osDisk": {
                                        "createOption": "str",
                                        "caching": "str",
                                        "deleteOption": "str",
                                        "diffDiskSettings": {
                                            "option": "str",
                                            "placement": "str"
                                        },
                                        "diskSizeGB": 0,
                                        "image": {
                                            "uri": "str"
                                        },
                                        "managedDisk": {
                                            "diskEncryptionSet": {
                                                "id": "str"
                                            },
                                            "securityProfile": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                "securityEncryptionType": "str"
                                            },
                                            "storageAccountType": "str"
                                        },
                                        "name": "str",
                                        "osType": "str",
                                        "vhdContainers": [
                                            "str"
                                        ],
                                        "writeAcceleratorEnabled": bool
                                    }
                                },
                                "timeCreated": "2020-02-20 00:00:00",
                                "userData": "str"
                            },
                            "computeApiVersion": "str",
                            "platformFaultDomainCount": 0
                        },
                        "vmSizesProfile": [
                            {
                                "name": "str",
                                "rank": 0
                            }
                        ],
                        "provisioningState": "str",
                        "regularPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "minCapacity": 0
                        },
                        "spotPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "evictionPolicy": "str",
                            "maintain": bool,
                            "maxPricePerVM": 0.0,
                            "minCapacity": 0
                        },
                        "timeCreated": "2020-02-20 00:00:00",
                        "uniqueId": "str"
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str"
                    },
                    "tags": {
                        "str": "str"
                    },
                    "type": "str",
                    "zones": [
                        "str"
                    ]
                }
        """

    @overload
    async def begin_create_or_update(
        self,
        resource_group_name: str,
        fleet_name: str,
        resource: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Fleet]:
        """Create a Fleet.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param fleet_name: The name of the Compute Fleet. Required.
        :type fleet_name: str
        :param resource: Resource create parameters. Required.
        :type resource: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns Fleet. The Fleet is compatible with
         MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.computefleet.models.Fleet]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "location": "str",
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",
                                "principalId": "str"
                            }
                        }
                    },
                    "name": "str",
                    "plan": {
                        "name": "str",
                        "product": "str",
                        "publisher": "str",
                        "promotionCode": "str",
                        "version": "str"
                    },
                    "properties": {
                        "computeProfile": {
                            "baseVirtualMachineProfile": {
                                "applicationProfile": {
                                    "galleryApplications": [
                                        {
                                            "packageReferenceId": "str",
                                            "configurationReference":
                                              "str",
                                            "enableAutomaticUpgrade":
                                              bool,
                                            "order": 0,
                                            "tags": "str",
                "treatFailureAsDeploymentFailure": bool
                                        }
                                    ]
                                },
                                "capacityReservation": {
                                    "capacityReservationGroup": {
                                        "id": "str"
                                    }
                                },
                                "diagnosticsProfile": {
                                    "bootDiagnostics": {
                                        "enabled": bool,
                                        "storageUri": "str"
                                    }
                                },
                                "extensionProfile": {
                                    "extensions": [
                                        {
                                            "id": "str",
                                            "name": "str",
                                            "properties": {
                "autoUpgradeMinorVersion": bool,
                "enableAutomaticUpgrade": bool,
                                                "forceUpdateTag":
                                                  "str",
                                                "protectedSettings":
                                                  {
                                                    "str": {}
                                                },
                "protectedSettingsFromKeyVault": {
                                                    "secretUrl":
                                                      "str",
                "sourceVault": {
                                                        "id":
                                                          "str"
                                                    }
                                                },
                "provisionAfterExtensions": [
                                                    "str"
                                                ],
                                                "provisioningState":
                                                  "str",
                                                "publisher": "str",
                                                "settings": {
                                                    "str": {}
                                                },
                                                "suppressFailures":
                                                  bool,
                                                "type": "str",
                                                "typeHandlerVersion":
                                                  "str"
                                            },
                                            "type": "str"
                                        }
                                    ],
                                    "extensionsTimeBudget": "str"
                                },
                                "hardwareProfile": {
                                    "vmSizeProperties": {
                                        "vCPUsAvailable": 0,
                                        "vCPUsPerCore": 0
                                    }
                                },
                                "licenseType": "str",
                                "networkProfile": {
                                    "healthProbe": {
                                        "id": "str"
                                    },
                                    "networkApiVersion": "str",
                                    "networkInterfaceConfigurations": [
                                        {
                                            "name": "str",
                                            "properties": {
                                                "ipConfigurations": [
                                                    {
                "name": "str",
                "properties": {
                "applicationGatewayBackendAddressPools":
                                                              [
                {
                "id": "str"
                }
                ],
                "applicationSecurityGroups": [
                {
                "id": "str"
                }
                ],
                "loadBalancerBackendAddressPools": [
                {
                "id": "str"
                }
                ],
                "loadBalancerInboundNatPools": [
                {
                "id": "str"
                }
                ],
                "primary": bool,
                "privateIPAddressVersion": "str",
                "publicIPAddressConfiguration": {
                "name": "str",
                "properties": {
                "deleteOption": "str",
                "dnsSettings": {
                "domainNameLabel": "str",
                "domainNameLabelScope": "str"
                },
                "idleTimeoutInMinutes": 0,
                "ipTags": [
                {
                "ipTagType": "str",
                "tag": "str"
                }
                ],
                "publicIPAddressVersion": "str",
                "publicIPPrefix": {
                "id": "str"
                }
                },
                "sku": {
                "name": "str",
                "tier": "str"
                }
                },
                "subnet": {
                "id": "str"
                }
                                                        }
                                                    }
                                                ],
                                                "auxiliaryMode":
                                                  "str",
                                                "auxiliarySku":
                                                  "str",
                                                "deleteOption":
                                                  "str",
                "disableTcpStateTracking": bool,
                                                "dnsSettings": {
                                                    "dnsServers":
                                                      [
                                                        "str"
                                                    ]
                                                },
                "enableAcceleratedNetworking": bool,
                                                "enableFpga": bool,
                                                "enableIPForwarding":
                                                  bool,
                "networkSecurityGroup": {
                                                    "id": "str"
                                                },
                                                "primary": bool
                                            }
                                        }
                                    ]
                                },
                                "osProfile": {
                                    "adminPassword": "str",
                                    "adminUsername": "str",
                                    "allowExtensionOperations": bool,
                                    "computerNamePrefix": "str",
                                    "customData": "str",
                                    "linuxConfiguration": {
                                        "disablePasswordAuthentication":
                                          bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "ssh": {
                                            "publicKeys": [
                                                {
                                                    "keyData":
                                                      "str",
                                                    "path": "str"
                                                }
                                            ]
                                        }
                                    },
                                    "requireGuestProvisionSignal": bool,
                                    "secrets": [
                                        {
                                            "sourceVault": {
                                                "id": "str"
                                            },
                                            "vaultCertificates": [
                                                {
                "certificateStore": "str",
                "certificateUrl": "str"
                                                }
                                            ]
                                        }
                                    ],
                                    "windowsConfiguration": {
                                        "additionalUnattendContent": [
                                            {
                                                "componentName":
                                                  "Microsoft-Windows-Shell-Setup",
                                                "content": "str",
                                                "passName":
                                                  "OobeSystem",
                                                "settingName": "str"
                                            }
                                        ],
                                        "enableAutomaticUpdates": bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "enableHotpatching": bool,
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "timeZone": "str",
                                        "winRM": {
                                            "listeners": [
                                                {
                "certificateUrl": "str",
                                                    "protocol":
                                                      "str"
                                                }
                                            ]
                                        }
                                    }
                                },
                                "scheduledEventsProfile": {
                                    "osImageNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    },
                                    "terminateNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    }
                                },
                                "securityPostureReference": {
                                    "excludeExtensions": [
                                        "str"
                                    ],
                                    "id": "str",
                                    "isOverridable": bool
                                },
                                "securityProfile": {
                                    "encryptionAtHost": bool,
                                    "encryptionIdentity": {
                                        "userAssignedIdentityResourceId":
                                          "str"
                                    },
                                    "proxyAgentSettings": {
                                        "enabled": bool,
                                        "keyIncarnationId": 0,
                                        "mode": "str"
                                    },
                                    "securityType": "str",
                                    "uefiSettings": {
                                        "secureBootEnabled": bool,
                                        "vTpmEnabled": bool
                                    }
                                },
                                "serviceArtifactReference": {
                                    "id": "str"
                                },
                                "storageProfile": {
                                    "dataDisks": [
                                        {
                                            "createOption": "str",
                                            "lun": 0,
                                            "caching": "str",
                                            "deleteOption": "str",
                                            "diskIOPSReadWrite": 0,
                                            "diskMBpsReadWrite": 0,
                                            "diskSizeGB": 0,
                                            "managedDisk": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                                                "securityProfile": {
                "diskEncryptionSet": {
                                                        "id":
                                                          "str"
                                                    },
                "securityEncryptionType": "str"
                                                },
                                                "storageAccountType":
                                                  "str"
                                            },
                                            "name": "str",
                                            "writeAcceleratorEnabled":
                                              bool
                                        }
                                    ],
                                    "diskControllerType": "str",
                                    "imageReference": {
                                        "communityGalleryImageId": "str",
                                        "exactVersion": "str",
                                        "id": "str",
                                        "offer": "str",
                                        "publisher": "str",
                                        "sharedGalleryImageId": "str",
                                        "sku": "str",
                                        "version": "str"
                                    },
                                    "osDisk": {
                                        "createOption": "str",
                                        "caching": "str",
                                        "deleteOption": "str",
                                        "diffDiskSettings": {
                                            "option": "str",
                                            "placement": "str"
                                        },
                                        "diskSizeGB": 0,
                                        "image": {
                                            "uri": "str"
                                        },
                                        "managedDisk": {
                                            "diskEncryptionSet": {
                                                "id": "str"
                                            },
                                            "securityProfile": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                "securityEncryptionType": "str"
                                            },
                                            "storageAccountType": "str"
                                        },
                                        "name": "str",
                                        "osType": "str",
                                        "vhdContainers": [
                                            "str"
                                        ],
                                        "writeAcceleratorEnabled": bool
                                    }
                                },
                                "timeCreated": "2020-02-20 00:00:00",
                                "userData": "str"
                            },
                            "computeApiVersion": "str",
                            "platformFaultDomainCount": 0
                        },
                        "vmSizesProfile": [
                            {
                                "name": "str",
                                "rank": 0
                            }
                        ],
                        "provisioningState": "str",
                        "regularPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "minCapacity": 0
                        },
                        "spotPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "evictionPolicy": "str",
                            "maintain": bool,
                            "maxPricePerVM": 0.0,
                            "minCapacity": 0
                        },
                        "timeCreated": "2020-02-20 00:00:00",
                        "uniqueId": "str"
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str"
                    },
                    "tags": {
                        "str": "str"
                    },
                    "type": "str",
                    "zones": [
                        "str"
                    ]
                }
        """

    @distributed_trace_async
    async def begin_create_or_update(
        self, resource_group_name: str, fleet_name: str, resource: Union[_models.Fleet, JSON, IO[bytes]], **kwargs: Any
    ) -> AsyncLROPoller[_models.Fleet]:
        """Create a Fleet.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param fleet_name: The name of the Compute Fleet. Required.
        :type fleet_name: str
        :param resource: Resource create parameters. Is one of the following types: Fleet, JSON,
         IO[bytes] Required.
        :type resource: ~azure.mgmt.computefleet.models.Fleet or JSON or IO[bytes]
        :return: An instance of AsyncLROPoller that returns Fleet. The Fleet is compatible with
         MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.computefleet.models.Fleet]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                resource = {
                    "location": "str",
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",
                                "principalId": "str"
                            }
                        }
                    },
                    "name": "str",
                    "plan": {
                        "name": "str",
                        "product": "str",
                        "publisher": "str",
                        "promotionCode": "str",
                        "version": "str"
                    },
                    "properties": {
                        "computeProfile": {
                            "baseVirtualMachineProfile": {
                                "applicationProfile": {
                                    "galleryApplications": [
                                        {
                                            "packageReferenceId": "str",
                                            "configurationReference":
                                              "str",
                                            "enableAutomaticUpgrade":
                                              bool,
                                            "order": 0,
                                            "tags": "str",
                "treatFailureAsDeploymentFailure": bool
                                        }
                                    ]
                                },
                                "capacityReservation": {
                                    "capacityReservationGroup": {
                                        "id": "str"
                                    }
                                },
                                "diagnosticsProfile": {
                                    "bootDiagnostics": {
                                        "enabled": bool,
                                        "storageUri": "str"
                                    }
                                },
                                "extensionProfile": {
                                    "extensions": [
                                        {
                                            "id": "str",
                                            "name": "str",
                                            "properties": {
                "autoUpgradeMinorVersion": bool,
                "enableAutomaticUpgrade": bool,
                                                "forceUpdateTag":
                                                  "str",
                                                "protectedSettings":
                                                  {
                                                    "str": {}
                                                },
                "protectedSettingsFromKeyVault": {
                                                    "secretUrl":
                                                      "str",
                "sourceVault": {
                                                        "id":
                                                          "str"
                                                    }
                                                },
                "provisionAfterExtensions": [
                                                    "str"
                                                ],
                                                "provisioningState":
                                                  "str",
                                                "publisher": "str",
                                                "settings": {
                                                    "str": {}
                                                },
                                                "suppressFailures":
                                                  bool,
                                                "type": "str",
                                                "typeHandlerVersion":
                                                  "str"
                                            },
                                            "type": "str"
                                        }
                                    ],
                                    "extensionsTimeBudget": "str"
                                },
                                "hardwareProfile": {
                                    "vmSizeProperties": {
                                        "vCPUsAvailable": 0,
                                        "vCPUsPerCore": 0
                                    }
                                },
                                "licenseType": "str",
                                "networkProfile": {
                                    "healthProbe": {
                                        "id": "str"
                                    },
                                    "networkApiVersion": "str",
                                    "networkInterfaceConfigurations": [
                                        {
                                            "name": "str",
                                            "properties": {
                                                "ipConfigurations": [
                                                    {
                "name": "str",
                "properties": {
                "applicationGatewayBackendAddressPools":
                                                              [
                {
                "id": "str"
                }
                ],
                "applicationSecurityGroups": [
                {
                "id": "str"
                }
                ],
                "loadBalancerBackendAddressPools": [
                {
                "id": "str"
                }
                ],
                "loadBalancerInboundNatPools": [
                {
                "id": "str"
                }
                ],
                "primary": bool,
                "privateIPAddressVersion": "str",
                "publicIPAddressConfiguration": {
                "name": "str",
                "properties": {
                "deleteOption": "str",
                "dnsSettings": {
                "domainNameLabel": "str",
                "domainNameLabelScope": "str"
                },
                "idleTimeoutInMinutes": 0,
                "ipTags": [
                {
                "ipTagType": "str",
                "tag": "str"
                }
                ],
                "publicIPAddressVersion": "str",
                "publicIPPrefix": {
                "id": "str"
                }
                },
                "sku": {
                "name": "str",
                "tier": "str"
                }
                },
                "subnet": {
                "id": "str"
                }
                                                        }
                                                    }
                                                ],
                                                "auxiliaryMode":
                                                  "str",
                                                "auxiliarySku":
                                                  "str",
                                                "deleteOption":
                                                  "str",
                "disableTcpStateTracking": bool,
                                                "dnsSettings": {
                                                    "dnsServers":
                                                      [
                                                        "str"
                                                    ]
                                                },
                "enableAcceleratedNetworking": bool,
                                                "enableFpga": bool,
                                                "enableIPForwarding":
                                                  bool,
                "networkSecurityGroup": {
                                                    "id": "str"
                                                },
                                                "primary": bool
                                            }
                                        }
                                    ]
                                },
                                "osProfile": {
                                    "adminPassword": "str",
                                    "adminUsername": "str",
                                    "allowExtensionOperations": bool,
                                    "computerNamePrefix": "str",
                                    "customData": "str",
                                    "linuxConfiguration": {
                                        "disablePasswordAuthentication":
                                          bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "ssh": {
                                            "publicKeys": [
                                                {
                                                    "keyData":
                                                      "str",
                                                    "path": "str"
                                                }
                                            ]
                                        }
                                    },
                                    "requireGuestProvisionSignal": bool,
                                    "secrets": [
                                        {
                                            "sourceVault": {
                                                "id": "str"
                                            },
                                            "vaultCertificates": [
                                                {
                "certificateStore": "str",
                "certificateUrl": "str"
                                                }
                                            ]
                                        }
                                    ],
                                    "windowsConfiguration": {
                                        "additionalUnattendContent": [
                                            {
                                                "componentName":
                                                  "Microsoft-Windows-Shell-Setup",
                                                "content": "str",
                                                "passName":
                                                  "OobeSystem",
                                                "settingName": "str"
                                            }
                                        ],
                                        "enableAutomaticUpdates": bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "enableHotpatching": bool,
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "timeZone": "str",
                                        "winRM": {
                                            "listeners": [
                                                {
                "certificateUrl": "str",
                                                    "protocol":
                                                      "str"
                                                }
                                            ]
                                        }
                                    }
                                },
                                "scheduledEventsProfile": {
                                    "osImageNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    },
                                    "terminateNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    }
                                },
                                "securityPostureReference": {
                                    "excludeExtensions": [
                                        "str"
                                    ],
                                    "id": "str",
                                    "isOverridable": bool
                                },
                                "securityProfile": {
                                    "encryptionAtHost": bool,
                                    "encryptionIdentity": {
                                        "userAssignedIdentityResourceId":
                                          "str"
                                    },
                                    "proxyAgentSettings": {
                                        "enabled": bool,
                                        "keyIncarnationId": 0,
                                        "mode": "str"
                                    },
                                    "securityType": "str",
                                    "uefiSettings": {
                                        "secureBootEnabled": bool,
                                        "vTpmEnabled": bool
                                    }
                                },
                                "serviceArtifactReference": {
                                    "id": "str"
                                },
                                "storageProfile": {
                                    "dataDisks": [
                                        {
                                            "createOption": "str",
                                            "lun": 0,
                                            "caching": "str",
                                            "deleteOption": "str",
                                            "diskIOPSReadWrite": 0,
                                            "diskMBpsReadWrite": 0,
                                            "diskSizeGB": 0,
                                            "managedDisk": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                                                "securityProfile": {
                "diskEncryptionSet": {
                                                        "id":
                                                          "str"
                                                    },
                "securityEncryptionType": "str"
                                                },
                                                "storageAccountType":
                                                  "str"
                                            },
                                            "name": "str",
                                            "writeAcceleratorEnabled":
                                              bool
                                        }
                                    ],
                                    "diskControllerType": "str",
                                    "imageReference": {
                                        "communityGalleryImageId": "str",
                                        "exactVersion": "str",
                                        "id": "str",
                                        "offer": "str",
                                        "publisher": "str",
                                        "sharedGalleryImageId": "str",
                                        "sku": "str",
                                        "version": "str"
                                    },
                                    "osDisk": {
                                        "createOption": "str",
                                        "caching": "str",
                                        "deleteOption": "str",
                                        "diffDiskSettings": {
                                            "option": "str",
                                            "placement": "str"
                                        },
                                        "diskSizeGB": 0,
                                        "image": {
                                            "uri": "str"
                                        },
                                        "managedDisk": {
                                            "diskEncryptionSet": {
                                                "id": "str"
                                            },
                                            "securityProfile": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                "securityEncryptionType": "str"
                                            },
                                            "storageAccountType": "str"
                                        },
                                        "name": "str",
                                        "osType": "str",
                                        "vhdContainers": [
                                            "str"
                                        ],
                                        "writeAcceleratorEnabled": bool
                                    }
                                },
                                "timeCreated": "2020-02-20 00:00:00",
                                "userData": "str"
                            },
                            "computeApiVersion": "str",
                            "platformFaultDomainCount": 0
                        },
                        "vmSizesProfile": [
                            {
                                "name": "str",
                                "rank": 0
                            }
                        ],
                        "provisioningState": "str",
                        "regularPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "minCapacity": 0
                        },
                        "spotPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "evictionPolicy": "str",
                            "maintain": bool,
                            "maxPricePerVM": 0.0,
                            "minCapacity": 0
                        },
                        "timeCreated": "2020-02-20 00:00:00",
                        "uniqueId": "str"
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str"
                    },
                    "tags": {
                        "str": "str"
                    },
                    "type": "str",
                    "zones": [
                        "str"
                    ]
                }

                # response body for status code(s): 200, 201
                response == {
                    "location": "str",
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",
                                "principalId": "str"
                            }
                        }
                    },
                    "name": "str",
                    "plan": {
                        "name": "str",
                        "product": "str",
                        "publisher": "str",
                        "promotionCode": "str",
                        "version": "str"
                    },
                    "properties": {
                        "computeProfile": {
                            "baseVirtualMachineProfile": {
                                "applicationProfile": {
                                    "galleryApplications": [
                                        {
                                            "packageReferenceId": "str",
                                            "configurationReference":
                                              "str",
                                            "enableAutomaticUpgrade":
                                              bool,
                                            "order": 0,
                                            "tags": "str",
                "treatFailureAsDeploymentFailure": bool
                                        }
                                    ]
                                },
                                "capacityReservation": {
                                    "capacityReservationGroup": {
                                        "id": "str"
                                    }
                                },
                                "diagnosticsProfile": {
                                    "bootDiagnostics": {
                                        "enabled": bool,
                                        "storageUri": "str"
                                    }
                                },
                                "extensionProfile": {
                                    "extensions": [
                                        {
                                            "id": "str",
                                            "name": "str",
                                            "properties": {
                "autoUpgradeMinorVersion": bool,
                "enableAutomaticUpgrade": bool,
                                                "forceUpdateTag":
                                                  "str",
                                                "protectedSettings":
                                                  {
                                                    "str": {}
                                                },
                "protectedSettingsFromKeyVault": {
                                                    "secretUrl":
                                                      "str",
                "sourceVault": {
                                                        "id":
                                                          "str"
                                                    }
                                                },
                "provisionAfterExtensions": [
                                                    "str"
                                                ],
                                                "provisioningState":
                                                  "str",
                                                "publisher": "str",
                                                "settings": {
                                                    "str": {}
                                                },
                                                "suppressFailures":
                                                  bool,
                                                "type": "str",
                                                "typeHandlerVersion":
                                                  "str"
                                            },
                                            "type": "str"
                                        }
                                    ],
                                    "extensionsTimeBudget": "str"
                                },
                                "hardwareProfile": {
                                    "vmSizeProperties": {
                                        "vCPUsAvailable": 0,
                                        "vCPUsPerCore": 0
                                    }
                                },
                                "licenseType": "str",
                                "networkProfile": {
                                    "healthProbe": {
                                        "id": "str"
                                    },
                                    "networkApiVersion": "str",
                                    "networkInterfaceConfigurations": [
                                        {
                                            "name": "str",
                                            "properties": {
                                                "ipConfigurations": [
                                                    {
                "name": "str",
                "properties": {
                "applicationGatewayBackendAddressPools":
                                                              [
                {
                "id": "str"
                }
                ],
                "applicationSecurityGroups": [
                {
                "id": "str"
                }
                ],
                "loadBalancerBackendAddressPools": [
                {
                "id": "str"
                }
                ],
                "loadBalancerInboundNatPools": [
                {
                "id": "str"
                }
                ],
                "primary": bool,
                "privateIPAddressVersion": "str",
                "publicIPAddressConfiguration": {
                "name": "str",
                "properties": {
                "deleteOption": "str",
                "dnsSettings": {
                "domainNameLabel": "str",
                "domainNameLabelScope": "str"
                },
                "idleTimeoutInMinutes": 0,
                "ipTags": [
                {
                "ipTagType": "str",
                "tag": "str"
                }
                ],
                "publicIPAddressVersion": "str",
                "publicIPPrefix": {
                "id": "str"
                }
                },
                "sku": {
                "name": "str",
                "tier": "str"
                }
                },
                "subnet": {
                "id": "str"
                }
                                                        }
                                                    }
                                                ],
                                                "auxiliaryMode":
                                                  "str",
                                                "auxiliarySku":
                                                  "str",
                                                "deleteOption":
                                                  "str",
                "disableTcpStateTracking": bool,
                                                "dnsSettings": {
                                                    "dnsServers":
                                                      [
                                                        "str"
                                                    ]
                                                },
                "enableAcceleratedNetworking": bool,
                                                "enableFpga": bool,
                                                "enableIPForwarding":
                                                  bool,
                "networkSecurityGroup": {
                                                    "id": "str"
                                                },
                                                "primary": bool
                                            }
                                        }
                                    ]
                                },
                                "osProfile": {
                                    "adminPassword": "str",
                                    "adminUsername": "str",
                                    "allowExtensionOperations": bool,
                                    "computerNamePrefix": "str",
                                    "customData": "str",
                                    "linuxConfiguration": {
                                        "disablePasswordAuthentication":
                                          bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "ssh": {
                                            "publicKeys": [
                                                {
                                                    "keyData":
                                                      "str",
                                                    "path": "str"
                                                }
                                            ]
                                        }
                                    },
                                    "requireGuestProvisionSignal": bool,
                                    "secrets": [
                                        {
                                            "sourceVault": {
                                                "id": "str"
                                            },
                                            "vaultCertificates": [
                                                {
                "certificateStore": "str",
                "certificateUrl": "str"
                                                }
                                            ]
                                        }
                                    ],
                                    "windowsConfiguration": {
                                        "additionalUnattendContent": [
                                            {
                                                "componentName":
                                                  "Microsoft-Windows-Shell-Setup",
                                                "content": "str",
                                                "passName":
                                                  "OobeSystem",
                                                "settingName": "str"
                                            }
                                        ],
                                        "enableAutomaticUpdates": bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "enableHotpatching": bool,
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "timeZone": "str",
                                        "winRM": {
                                            "listeners": [
                                                {
                "certificateUrl": "str",
                                                    "protocol":
                                                      "str"
                                                }
                                            ]
                                        }
                                    }
                                },
                                "scheduledEventsProfile": {
                                    "osImageNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    },
                                    "terminateNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    }
                                },
                                "securityPostureReference": {
                                    "excludeExtensions": [
                                        "str"
                                    ],
                                    "id": "str",
                                    "isOverridable": bool
                                },
                                "securityProfile": {
                                    "encryptionAtHost": bool,
                                    "encryptionIdentity": {
                                        "userAssignedIdentityResourceId":
                                          "str"
                                    },
                                    "proxyAgentSettings": {
                                        "enabled": bool,
                                        "keyIncarnationId": 0,
                                        "mode": "str"
                                    },
                                    "securityType": "str",
                                    "uefiSettings": {
                                        "secureBootEnabled": bool,
                                        "vTpmEnabled": bool
                                    }
                                },
                                "serviceArtifactReference": {
                                    "id": "str"
                                },
                                "storageProfile": {
                                    "dataDisks": [
                                        {
                                            "createOption": "str",
                                            "lun": 0,
                                            "caching": "str",
                                            "deleteOption": "str",
                                            "diskIOPSReadWrite": 0,
                                            "diskMBpsReadWrite": 0,
                                            "diskSizeGB": 0,
                                            "managedDisk": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                                                "securityProfile": {
                "diskEncryptionSet": {
                                                        "id":
                                                          "str"
                                                    },
                "securityEncryptionType": "str"
                                                },
                                                "storageAccountType":
                                                  "str"
                                            },
                                            "name": "str",
                                            "writeAcceleratorEnabled":
                                              bool
                                        }
                                    ],
                                    "diskControllerType": "str",
                                    "imageReference": {
                                        "communityGalleryImageId": "str",
                                        "exactVersion": "str",
                                        "id": "str",
                                        "offer": "str",
                                        "publisher": "str",
                                        "sharedGalleryImageId": "str",
                                        "sku": "str",
                                        "version": "str"
                                    },
                                    "osDisk": {
                                        "createOption": "str",
                                        "caching": "str",
                                        "deleteOption": "str",
                                        "diffDiskSettings": {
                                            "option": "str",
                                            "placement": "str"
                                        },
                                        "diskSizeGB": 0,
                                        "image": {
                                            "uri": "str"
                                        },
                                        "managedDisk": {
                                            "diskEncryptionSet": {
                                                "id": "str"
                                            },
                                            "securityProfile": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                "securityEncryptionType": "str"
                                            },
                                            "storageAccountType": "str"
                                        },
                                        "name": "str",
                                        "osType": "str",
                                        "vhdContainers": [
                                            "str"
                                        ],
                                        "writeAcceleratorEnabled": bool
                                    }
                                },
                                "timeCreated": "2020-02-20 00:00:00",
                                "userData": "str"
                            },
                            "computeApiVersion": "str",
                            "platformFaultDomainCount": 0
                        },
                        "vmSizesProfile": [
                            {
                                "name": "str",
                                "rank": 0
                            }
                        ],
                        "provisioningState": "str",
                        "regularPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "minCapacity": 0
                        },
                        "spotPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "evictionPolicy": "str",
                            "maintain": bool,
                            "maxPricePerVM": 0.0,
                            "minCapacity": 0
                        },
                        "timeCreated": "2020-02-20 00:00:00",
                        "uniqueId": "str"
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str"
                    },
                    "tags": {
                        "str": "str"
                    },
                    "type": "str",
                    "zones": [
                        "str"
                    ]
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Fleet] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._create_or_update_initial(
                resource_group_name=resource_group_name,
                fleet_name=fleet_name,
                resource=resource,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = _deserialize(_models.Fleet, response.json())
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.Fleet].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.Fleet](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _update_initial(
        self,
        resource_group_name: str,
        fleet_name: str,
        properties: Union[_models.FleetUpdate, JSON, IO[bytes]],
        **kwargs: Any
    ) -> AsyncIterator[bytes]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _content = None
        if isinstance(properties, (IOBase, bytes)):
            _content = properties
        else:
            _content = json.dumps(properties, cls=SdkJSONEncoder, exclude_readonly=True)  # type: ignore

        _request = build_fleets_update_request(
            resource_group_name=resource_group_name,
            fleet_name=fleet_name,
            subscription_id=self._config.subscription_id,
            content_type=content_type,
            api_version=self._config.api_version,
            content=_content,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 200:
            deserialized = response.iter_bytes()

        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

            deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @overload
    async def begin_update(
        self,
        resource_group_name: str,
        fleet_name: str,
        properties: _models.FleetUpdate,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Fleet]:
        """Update a Fleet.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param fleet_name: The name of the Compute Fleet. Required.
        :type fleet_name: str
        :param properties: The resource properties to be updated. Required.
        :type properties: ~azure.mgmt.computefleet.models.FleetUpdate
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns Fleet. The Fleet is compatible with
         MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.computefleet.models.Fleet]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                properties = {
                    "identity": {
                        "type": "str",
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",
                                "principalId": "str"
                            }
                        }
                    },
                    "plan": {
                        "name": "str",
                        "product": "str",
                        "promotionCode": "str",
                        "publisher": "str",
                        "version": "str"
                    },
                    "properties": {
                        "computeProfile": {
                            "baseVirtualMachineProfile": {
                                "applicationProfile": {
                                    "galleryApplications": [
                                        {
                                            "packageReferenceId": "str",
                                            "configurationReference":
                                              "str",
                                            "enableAutomaticUpgrade":
                                              bool,
                                            "order": 0,
                                            "tags": "str",
                "treatFailureAsDeploymentFailure": bool
                                        }
                                    ]
                                },
                                "capacityReservation": {
                                    "capacityReservationGroup": {
                                        "id": "str"
                                    }
                                },
                                "diagnosticsProfile": {
                                    "bootDiagnostics": {
                                        "enabled": bool,
                                        "storageUri": "str"
                                    }
                                },
                                "extensionProfile": {
                                    "extensions": [
                                        {
                                            "id": "str",
                                            "name": "str",
                                            "properties": {
                "autoUpgradeMinorVersion": bool,
                "enableAutomaticUpgrade": bool,
                                                "forceUpdateTag":
                                                  "str",
                                                "protectedSettings":
                                                  {
                                                    "str": {}
                                                },
                "protectedSettingsFromKeyVault": {
                                                    "secretUrl":
                                                      "str",
                "sourceVault": {
                                                        "id":
                                                          "str"
                                                    }
                                                },
                "provisionAfterExtensions": [
                                                    "str"
                                                ],
                                                "provisioningState":
                                                  "str",
                                                "publisher": "str",
                                                "settings": {
                                                    "str": {}
                                                },
                                                "suppressFailures":
                                                  bool,
                                                "type": "str",
                                                "typeHandlerVersion":
                                                  "str"
                                            },
                                            "type": "str"
                                        }
                                    ],
                                    "extensionsTimeBudget": "str"
                                },
                                "hardwareProfile": {
                                    "vmSizeProperties": {
                                        "vCPUsAvailable": 0,
                                        "vCPUsPerCore": 0
                                    }
                                },
                                "licenseType": "str",
                                "networkProfile": {
                                    "healthProbe": {
                                        "id": "str"
                                    },
                                    "networkApiVersion": "str",
                                    "networkInterfaceConfigurations": [
                                        {
                                            "name": "str",
                                            "properties": {
                                                "ipConfigurations": [
                                                    {
                "name": "str",
                "properties": {
                "applicationGatewayBackendAddressPools":
                                                              [
                {
                "id": "str"
                }
                ],
                "applicationSecurityGroups": [
                {
                "id": "str"
                }
                ],
                "loadBalancerBackendAddressPools": [
                {
                "id": "str"
                }
                ],
                "loadBalancerInboundNatPools": [
                {
                "id": "str"
                }
                ],
                "primary": bool,
                "privateIPAddressVersion": "str",
                "publicIPAddressConfiguration": {
                "name": "str",
                "properties": {
                "deleteOption": "str",
                "dnsSettings": {
                "domainNameLabel": "str",
                "domainNameLabelScope": "str"
                },
                "idleTimeoutInMinutes": 0,
                "ipTags": [
                {
                "ipTagType": "str",
                "tag": "str"
                }
                ],
                "publicIPAddressVersion": "str",
                "publicIPPrefix": {
                "id": "str"
                }
                },
                "sku": {
                "name": "str",
                "tier": "str"
                }
                },
                "subnet": {
                "id": "str"
                }
                                                        }
                                                    }
                                                ],
                                                "auxiliaryMode":
                                                  "str",
                                                "auxiliarySku":
                                                  "str",
                                                "deleteOption":
                                                  "str",
                "disableTcpStateTracking": bool,
                                                "dnsSettings": {
                                                    "dnsServers":
                                                      [
                                                        "str"
                                                    ]
                                                },
                "enableAcceleratedNetworking": bool,
                                                "enableFpga": bool,
                                                "enableIPForwarding":
                                                  bool,
                "networkSecurityGroup": {
                                                    "id": "str"
                                                },
                                                "primary": bool
                                            }
                                        }
                                    ]
                                },
                                "osProfile": {
                                    "adminPassword": "str",
                                    "adminUsername": "str",
                                    "allowExtensionOperations": bool,
                                    "computerNamePrefix": "str",
                                    "customData": "str",
                                    "linuxConfiguration": {
                                        "disablePasswordAuthentication":
                                          bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "ssh": {
                                            "publicKeys": [
                                                {
                                                    "keyData":
                                                      "str",
                                                    "path": "str"
                                                }
                                            ]
                                        }
                                    },
                                    "requireGuestProvisionSignal": bool,
                                    "secrets": [
                                        {
                                            "sourceVault": {
                                                "id": "str"
                                            },
                                            "vaultCertificates": [
                                                {
                "certificateStore": "str",
                "certificateUrl": "str"
                                                }
                                            ]
                                        }
                                    ],
                                    "windowsConfiguration": {
                                        "additionalUnattendContent": [
                                            {
                                                "componentName":
                                                  "Microsoft-Windows-Shell-Setup",
                                                "content": "str",
                                                "passName":
                                                  "OobeSystem",
                                                "settingName": "str"
                                            }
                                        ],
                                        "enableAutomaticUpdates": bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "enableHotpatching": bool,
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "timeZone": "str",
                                        "winRM": {
                                            "listeners": [
                                                {
                "certificateUrl": "str",
                                                    "protocol":
                                                      "str"
                                                }
                                            ]
                                        }
                                    }
                                },
                                "scheduledEventsProfile": {
                                    "osImageNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    },
                                    "terminateNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    }
                                },
                                "securityPostureReference": {
                                    "excludeExtensions": [
                                        "str"
                                    ],
                                    "id": "str",
                                    "isOverridable": bool
                                },
                                "securityProfile": {
                                    "encryptionAtHost": bool,
                                    "encryptionIdentity": {
                                        "userAssignedIdentityResourceId":
                                          "str"
                                    },
                                    "proxyAgentSettings": {
                                        "enabled": bool,
                                        "keyIncarnationId": 0,
                                        "mode": "str"
                                    },
                                    "securityType": "str",
                                    "uefiSettings": {
                                        "secureBootEnabled": bool,
                                        "vTpmEnabled": bool
                                    }
                                },
                                "serviceArtifactReference": {
                                    "id": "str"
                                },
                                "storageProfile": {
                                    "dataDisks": [
                                        {
                                            "createOption": "str",
                                            "lun": 0,
                                            "caching": "str",
                                            "deleteOption": "str",
                                            "diskIOPSReadWrite": 0,
                                            "diskMBpsReadWrite": 0,
                                            "diskSizeGB": 0,
                                            "managedDisk": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                                                "securityProfile": {
                "diskEncryptionSet": {
                                                        "id":
                                                          "str"
                                                    },
                "securityEncryptionType": "str"
                                                },
                                                "storageAccountType":
                                                  "str"
                                            },
                                            "name": "str",
                                            "writeAcceleratorEnabled":
                                              bool
                                        }
                                    ],
                                    "diskControllerType": "str",
                                    "imageReference": {
                                        "communityGalleryImageId": "str",
                                        "exactVersion": "str",
                                        "id": "str",
                                        "offer": "str",
                                        "publisher": "str",
                                        "sharedGalleryImageId": "str",
                                        "sku": "str",
                                        "version": "str"
                                    },
                                    "osDisk": {
                                        "createOption": "str",
                                        "caching": "str",
                                        "deleteOption": "str",
                                        "diffDiskSettings": {
                                            "option": "str",
                                            "placement": "str"
                                        },
                                        "diskSizeGB": 0,
                                        "image": {
                                            "uri": "str"
                                        },
                                        "managedDisk": {
                                            "diskEncryptionSet": {
                                                "id": "str"
                                            },
                                            "securityProfile": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                "securityEncryptionType": "str"
                                            },
                                            "storageAccountType": "str"
                                        },
                                        "name": "str",
                                        "osType": "str",
                                        "vhdContainers": [
                                            "str"
                                        ],
                                        "writeAcceleratorEnabled": bool
                                    }
                                },
                                "timeCreated": "2020-02-20 00:00:00",
                                "userData": "str"
                            },
                            "computeApiVersion": "str",
                            "platformFaultDomainCount": 0
                        },
                        "vmSizesProfile": [
                            {
                                "name": "str",
                                "rank": 0
                            }
                        ],
                        "provisioningState": "str",
                        "regularPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "minCapacity": 0
                        },
                        "spotPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "evictionPolicy": "str",
                            "maintain": bool,
                            "maxPricePerVM": 0.0,
                            "minCapacity": 0
                        },
                        "timeCreated": "2020-02-20 00:00:00",
                        "uniqueId": "str"
                    },
                    "tags": {
                        "str": "str"
                    }
                }

                # response body for status code(s): 200, 202
                response == {
                    "location": "str",
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",
                                "principalId": "str"
                            }
                        }
                    },
                    "name": "str",
                    "plan": {
                        "name": "str",
                        "product": "str",
                        "publisher": "str",
                        "promotionCode": "str",
                        "version": "str"
                    },
                    "properties": {
                        "computeProfile": {
                            "baseVirtualMachineProfile": {
                                "applicationProfile": {
                                    "galleryApplications": [
                                        {
                                            "packageReferenceId": "str",
                                            "configurationReference":
                                              "str",
                                            "enableAutomaticUpgrade":
                                              bool,
                                            "order": 0,
                                            "tags": "str",
                "treatFailureAsDeploymentFailure": bool
                                        }
                                    ]
                                },
                                "capacityReservation": {
                                    "capacityReservationGroup": {
                                        "id": "str"
                                    }
                                },
                                "diagnosticsProfile": {
                                    "bootDiagnostics": {
                                        "enabled": bool,
                                        "storageUri": "str"
                                    }
                                },
                                "extensionProfile": {
                                    "extensions": [
                                        {
                                            "id": "str",
                                            "name": "str",
                                            "properties": {
                "autoUpgradeMinorVersion": bool,
                "enableAutomaticUpgrade": bool,
                                                "forceUpdateTag":
                                                  "str",
                                                "protectedSettings":
                                                  {
                                                    "str": {}
                                                },
                "protectedSettingsFromKeyVault": {
                                                    "secretUrl":
                                                      "str",
                "sourceVault": {
                                                        "id":
                                                          "str"
                                                    }
                                                },
                "provisionAfterExtensions": [
                                                    "str"
                                                ],
                                                "provisioningState":
                                                  "str",
                                                "publisher": "str",
                                                "settings": {
                                                    "str": {}
                                                },
                                                "suppressFailures":
                                                  bool,
                                                "type": "str",
                                                "typeHandlerVersion":
                                                  "str"
                                            },
                                            "type": "str"
                                        }
                                    ],
                                    "extensionsTimeBudget": "str"
                                },
                                "hardwareProfile": {
                                    "vmSizeProperties": {
                                        "vCPUsAvailable": 0,
                                        "vCPUsPerCore": 0
                                    }
                                },
                                "licenseType": "str",
                                "networkProfile": {
                                    "healthProbe": {
                                        "id": "str"
                                    },
                                    "networkApiVersion": "str",
                                    "networkInterfaceConfigurations": [
                                        {
                                            "name": "str",
                                            "properties": {
                                                "ipConfigurations": [
                                                    {
                "name": "str",
                "properties": {
                "applicationGatewayBackendAddressPools":
                                                              [
                {
                "id": "str"
                }
                ],
                "applicationSecurityGroups": [
                {
                "id": "str"
                }
                ],
                "loadBalancerBackendAddressPools": [
                {
                "id": "str"
                }
                ],
                "loadBalancerInboundNatPools": [
                {
                "id": "str"
                }
                ],
                "primary": bool,
                "privateIPAddressVersion": "str",
                "publicIPAddressConfiguration": {
                "name": "str",
                "properties": {
                "deleteOption": "str",
                "dnsSettings": {
                "domainNameLabel": "str",
                "domainNameLabelScope": "str"
                },
                "idleTimeoutInMinutes": 0,
                "ipTags": [
                {
                "ipTagType": "str",
                "tag": "str"
                }
                ],
                "publicIPAddressVersion": "str",
                "publicIPPrefix": {
                "id": "str"
                }
                },
                "sku": {
                "name": "str",
                "tier": "str"
                }
                },
                "subnet": {
                "id": "str"
                }
                                                        }
                                                    }
                                                ],
                                                "auxiliaryMode":
                                                  "str",
                                                "auxiliarySku":
                                                  "str",
                                                "deleteOption":
                                                  "str",
                "disableTcpStateTracking": bool,
                                                "dnsSettings": {
                                                    "dnsServers":
                                                      [
                                                        "str"
                                                    ]
                                                },
                "enableAcceleratedNetworking": bool,
                                                "enableFpga": bool,
                                                "enableIPForwarding":
                                                  bool,
                "networkSecurityGroup": {
                                                    "id": "str"
                                                },
                                                "primary": bool
                                            }
                                        }
                                    ]
                                },
                                "osProfile": {
                                    "adminPassword": "str",
                                    "adminUsername": "str",
                                    "allowExtensionOperations": bool,
                                    "computerNamePrefix": "str",
                                    "customData": "str",
                                    "linuxConfiguration": {
                                        "disablePasswordAuthentication":
                                          bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "ssh": {
                                            "publicKeys": [
                                                {
                                                    "keyData":
                                                      "str",
                                                    "path": "str"
                                                }
                                            ]
                                        }
                                    },
                                    "requireGuestProvisionSignal": bool,
                                    "secrets": [
                                        {
                                            "sourceVault": {
                                                "id": "str"
                                            },
                                            "vaultCertificates": [
                                                {
                "certificateStore": "str",
                "certificateUrl": "str"
                                                }
                                            ]
                                        }
                                    ],
                                    "windowsConfiguration": {
                                        "additionalUnattendContent": [
                                            {
                                                "componentName":
                                                  "Microsoft-Windows-Shell-Setup",
                                                "content": "str",
                                                "passName":
                                                  "OobeSystem",
                                                "settingName": "str"
                                            }
                                        ],
                                        "enableAutomaticUpdates": bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "enableHotpatching": bool,
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "timeZone": "str",
                                        "winRM": {
                                            "listeners": [
                                                {
                "certificateUrl": "str",
                                                    "protocol":
                                                      "str"
                                                }
                                            ]
                                        }
                                    }
                                },
                                "scheduledEventsProfile": {
                                    "osImageNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    },
                                    "terminateNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    }
                                },
                                "securityPostureReference": {
                                    "excludeExtensions": [
                                        "str"
                                    ],
                                    "id": "str",
                                    "isOverridable": bool
                                },
                                "securityProfile": {
                                    "encryptionAtHost": bool,
                                    "encryptionIdentity": {
                                        "userAssignedIdentityResourceId":
                                          "str"
                                    },
                                    "proxyAgentSettings": {
                                        "enabled": bool,
                                        "keyIncarnationId": 0,
                                        "mode": "str"
                                    },
                                    "securityType": "str",
                                    "uefiSettings": {
                                        "secureBootEnabled": bool,
                                        "vTpmEnabled": bool
                                    }
                                },
                                "serviceArtifactReference": {
                                    "id": "str"
                                },
                                "storageProfile": {
                                    "dataDisks": [
                                        {
                                            "createOption": "str",
                                            "lun": 0,
                                            "caching": "str",
                                            "deleteOption": "str",
                                            "diskIOPSReadWrite": 0,
                                            "diskMBpsReadWrite": 0,
                                            "diskSizeGB": 0,
                                            "managedDisk": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                                                "securityProfile": {
                "diskEncryptionSet": {
                                                        "id":
                                                          "str"
                                                    },
                "securityEncryptionType": "str"
                                                },
                                                "storageAccountType":
                                                  "str"
                                            },
                                            "name": "str",
                                            "writeAcceleratorEnabled":
                                              bool
                                        }
                                    ],
                                    "diskControllerType": "str",
                                    "imageReference": {
                                        "communityGalleryImageId": "str",
                                        "exactVersion": "str",
                                        "id": "str",
                                        "offer": "str",
                                        "publisher": "str",
                                        "sharedGalleryImageId": "str",
                                        "sku": "str",
                                        "version": "str"
                                    },
                                    "osDisk": {
                                        "createOption": "str",
                                        "caching": "str",
                                        "deleteOption": "str",
                                        "diffDiskSettings": {
                                            "option": "str",
                                            "placement": "str"
                                        },
                                        "diskSizeGB": 0,
                                        "image": {
                                            "uri": "str"
                                        },
                                        "managedDisk": {
                                            "diskEncryptionSet": {
                                                "id": "str"
                                            },
                                            "securityProfile": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                "securityEncryptionType": "str"
                                            },
                                            "storageAccountType": "str"
                                        },
                                        "name": "str",
                                        "osType": "str",
                                        "vhdContainers": [
                                            "str"
                                        ],
                                        "writeAcceleratorEnabled": bool
                                    }
                                },
                                "timeCreated": "2020-02-20 00:00:00",
                                "userData": "str"
                            },
                            "computeApiVersion": "str",
                            "platformFaultDomainCount": 0
                        },
                        "vmSizesProfile": [
                            {
                                "name": "str",
                                "rank": 0
                            }
                        ],
                        "provisioningState": "str",
                        "regularPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "minCapacity": 0
                        },
                        "spotPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "evictionPolicy": "str",
                            "maintain": bool,
                            "maxPricePerVM": 0.0,
                            "minCapacity": 0
                        },
                        "timeCreated": "2020-02-20 00:00:00",
                        "uniqueId": "str"
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str"
                    },
                    "tags": {
                        "str": "str"
                    },
                    "type": "str",
                    "zones": [
                        "str"
                    ]
                }
        """

    @overload
    async def begin_update(
        self,
        resource_group_name: str,
        fleet_name: str,
        properties: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Fleet]:
        """Update a Fleet.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param fleet_name: The name of the Compute Fleet. Required.
        :type fleet_name: str
        :param properties: The resource properties to be updated. Required.
        :type properties: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns Fleet. The Fleet is compatible with
         MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.computefleet.models.Fleet]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 202
                response == {
                    "location": "str",
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",
                                "principalId": "str"
                            }
                        }
                    },
                    "name": "str",
                    "plan": {
                        "name": "str",
                        "product": "str",
                        "publisher": "str",
                        "promotionCode": "str",
                        "version": "str"
                    },
                    "properties": {
                        "computeProfile": {
                            "baseVirtualMachineProfile": {
                                "applicationProfile": {
                                    "galleryApplications": [
                                        {
                                            "packageReferenceId": "str",
                                            "configurationReference":
                                              "str",
                                            "enableAutomaticUpgrade":
                                              bool,
                                            "order": 0,
                                            "tags": "str",
                "treatFailureAsDeploymentFailure": bool
                                        }
                                    ]
                                },
                                "capacityReservation": {
                                    "capacityReservationGroup": {
                                        "id": "str"
                                    }
                                },
                                "diagnosticsProfile": {
                                    "bootDiagnostics": {
                                        "enabled": bool,
                                        "storageUri": "str"
                                    }
                                },
                                "extensionProfile": {
                                    "extensions": [
                                        {
                                            "id": "str",
                                            "name": "str",
                                            "properties": {
                "autoUpgradeMinorVersion": bool,
                "enableAutomaticUpgrade": bool,
                                                "forceUpdateTag":
                                                  "str",
                                                "protectedSettings":
                                                  {
                                                    "str": {}
                                                },
                "protectedSettingsFromKeyVault": {
                                                    "secretUrl":
                                                      "str",
                "sourceVault": {
                                                        "id":
                                                          "str"
                                                    }
                                                },
                "provisionAfterExtensions": [
                                                    "str"
                                                ],
                                                "provisioningState":
                                                  "str",
                                                "publisher": "str",
                                                "settings": {
                                                    "str": {}
                                                },
                                                "suppressFailures":
                                                  bool,
                                                "type": "str",
                                                "typeHandlerVersion":
                                                  "str"
                                            },
                                            "type": "str"
                                        }
                                    ],
                                    "extensionsTimeBudget": "str"
                                },
                                "hardwareProfile": {
                                    "vmSizeProperties": {
                                        "vCPUsAvailable": 0,
                                        "vCPUsPerCore": 0
                                    }
                                },
                                "licenseType": "str",
                                "networkProfile": {
                                    "healthProbe": {
                                        "id": "str"
                                    },
                                    "networkApiVersion": "str",
                                    "networkInterfaceConfigurations": [
                                        {
                                            "name": "str",
                                            "properties": {
                                                "ipConfigurations": [
                                                    {
                "name": "str",
                "properties": {
                "applicationGatewayBackendAddressPools":
                                                              [
                {
                "id": "str"
                }
                ],
                "applicationSecurityGroups": [
                {
                "id": "str"
                }
                ],
                "loadBalancerBackendAddressPools": [
                {
                "id": "str"
                }
                ],
                "loadBalancerInboundNatPools": [
                {
                "id": "str"
                }
                ],
                "primary": bool,
                "privateIPAddressVersion": "str",
                "publicIPAddressConfiguration": {
                "name": "str",
                "properties": {
                "deleteOption": "str",
                "dnsSettings": {
                "domainNameLabel": "str",
                "domainNameLabelScope": "str"
                },
                "idleTimeoutInMinutes": 0,
                "ipTags": [
                {
                "ipTagType": "str",
                "tag": "str"
                }
                ],
                "publicIPAddressVersion": "str",
                "publicIPPrefix": {
                "id": "str"
                }
                },
                "sku": {
                "name": "str",
                "tier": "str"
                }
                },
                "subnet": {
                "id": "str"
                }
                                                        }
                                                    }
                                                ],
                                                "auxiliaryMode":
                                                  "str",
                                                "auxiliarySku":
                                                  "str",
                                                "deleteOption":
                                                  "str",
                "disableTcpStateTracking": bool,
                                                "dnsSettings": {
                                                    "dnsServers":
                                                      [
                                                        "str"
                                                    ]
                                                },
                "enableAcceleratedNetworking": bool,
                                                "enableFpga": bool,
                                                "enableIPForwarding":
                                                  bool,
                "networkSecurityGroup": {
                                                    "id": "str"
                                                },
                                                "primary": bool
                                            }
                                        }
                                    ]
                                },
                                "osProfile": {
                                    "adminPassword": "str",
                                    "adminUsername": "str",
                                    "allowExtensionOperations": bool,
                                    "computerNamePrefix": "str",
                                    "customData": "str",
                                    "linuxConfiguration": {
                                        "disablePasswordAuthentication":
                                          bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "ssh": {
                                            "publicKeys": [
                                                {
                                                    "keyData":
                                                      "str",
                                                    "path": "str"
                                                }
                                            ]
                                        }
                                    },
                                    "requireGuestProvisionSignal": bool,
                                    "secrets": [
                                        {
                                            "sourceVault": {
                                                "id": "str"
                                            },
                                            "vaultCertificates": [
                                                {
                "certificateStore": "str",
                "certificateUrl": "str"
                                                }
                                            ]
                                        }
                                    ],
                                    "windowsConfiguration": {
                                        "additionalUnattendContent": [
                                            {
                                                "componentName":
                                                  "Microsoft-Windows-Shell-Setup",
                                                "content": "str",
                                                "passName":
                                                  "OobeSystem",
                                                "settingName": "str"
                                            }
                                        ],
                                        "enableAutomaticUpdates": bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "enableHotpatching": bool,
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "timeZone": "str",
                                        "winRM": {
                                            "listeners": [
                                                {
                "certificateUrl": "str",
                                                    "protocol":
                                                      "str"
                                                }
                                            ]
                                        }
                                    }
                                },
                                "scheduledEventsProfile": {
                                    "osImageNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    },
                                    "terminateNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    }
                                },
                                "securityPostureReference": {
                                    "excludeExtensions": [
                                        "str"
                                    ],
                                    "id": "str",
                                    "isOverridable": bool
                                },
                                "securityProfile": {
                                    "encryptionAtHost": bool,
                                    "encryptionIdentity": {
                                        "userAssignedIdentityResourceId":
                                          "str"
                                    },
                                    "proxyAgentSettings": {
                                        "enabled": bool,
                                        "keyIncarnationId": 0,
                                        "mode": "str"
                                    },
                                    "securityType": "str",
                                    "uefiSettings": {
                                        "secureBootEnabled": bool,
                                        "vTpmEnabled": bool
                                    }
                                },
                                "serviceArtifactReference": {
                                    "id": "str"
                                },
                                "storageProfile": {
                                    "dataDisks": [
                                        {
                                            "createOption": "str",
                                            "lun": 0,
                                            "caching": "str",
                                            "deleteOption": "str",
                                            "diskIOPSReadWrite": 0,
                                            "diskMBpsReadWrite": 0,
                                            "diskSizeGB": 0,
                                            "managedDisk": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                                                "securityProfile": {
                "diskEncryptionSet": {
                                                        "id":
                                                          "str"
                                                    },
                "securityEncryptionType": "str"
                                                },
                                                "storageAccountType":
                                                  "str"
                                            },
                                            "name": "str",
                                            "writeAcceleratorEnabled":
                                              bool
                                        }
                                    ],
                                    "diskControllerType": "str",
                                    "imageReference": {
                                        "communityGalleryImageId": "str",
                                        "exactVersion": "str",
                                        "id": "str",
                                        "offer": "str",
                                        "publisher": "str",
                                        "sharedGalleryImageId": "str",
                                        "sku": "str",
                                        "version": "str"
                                    },
                                    "osDisk": {
                                        "createOption": "str",
                                        "caching": "str",
                                        "deleteOption": "str",
                                        "diffDiskSettings": {
                                            "option": "str",
                                            "placement": "str"
                                        },
                                        "diskSizeGB": 0,
                                        "image": {
                                            "uri": "str"
                                        },
                                        "managedDisk": {
                                            "diskEncryptionSet": {
                                                "id": "str"
                                            },
                                            "securityProfile": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                "securityEncryptionType": "str"
                                            },
                                            "storageAccountType": "str"
                                        },
                                        "name": "str",
                                        "osType": "str",
                                        "vhdContainers": [
                                            "str"
                                        ],
                                        "writeAcceleratorEnabled": bool
                                    }
                                },
                                "timeCreated": "2020-02-20 00:00:00",
                                "userData": "str"
                            },
                            "computeApiVersion": "str",
                            "platformFaultDomainCount": 0
                        },
                        "vmSizesProfile": [
                            {
                                "name": "str",
                                "rank": 0
                            }
                        ],
                        "provisioningState": "str",
                        "regularPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "minCapacity": 0
                        },
                        "spotPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "evictionPolicy": "str",
                            "maintain": bool,
                            "maxPricePerVM": 0.0,
                            "minCapacity": 0
                        },
                        "timeCreated": "2020-02-20 00:00:00",
                        "uniqueId": "str"
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str"
                    },
                    "tags": {
                        "str": "str"
                    },
                    "type": "str",
                    "zones": [
                        "str"
                    ]
                }
        """

    @overload
    async def begin_update(
        self,
        resource_group_name: str,
        fleet_name: str,
        properties: IO[bytes],
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Fleet]:
        """Update a Fleet.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param fleet_name: The name of the Compute Fleet. Required.
        :type fleet_name: str
        :param properties: The resource properties to be updated. Required.
        :type properties: IO[bytes]
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: An instance of AsyncLROPoller that returns Fleet. The Fleet is compatible with
         MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.computefleet.models.Fleet]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 202
                response == {
                    "location": "str",
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",
                                "principalId": "str"
                            }
                        }
                    },
                    "name": "str",
                    "plan": {
                        "name": "str",
                        "product": "str",
                        "publisher": "str",
                        "promotionCode": "str",
                        "version": "str"
                    },
                    "properties": {
                        "computeProfile": {
                            "baseVirtualMachineProfile": {
                                "applicationProfile": {
                                    "galleryApplications": [
                                        {
                                            "packageReferenceId": "str",
                                            "configurationReference":
                                              "str",
                                            "enableAutomaticUpgrade":
                                              bool,
                                            "order": 0,
                                            "tags": "str",
                "treatFailureAsDeploymentFailure": bool
                                        }
                                    ]
                                },
                                "capacityReservation": {
                                    "capacityReservationGroup": {
                                        "id": "str"
                                    }
                                },
                                "diagnosticsProfile": {
                                    "bootDiagnostics": {
                                        "enabled": bool,
                                        "storageUri": "str"
                                    }
                                },
                                "extensionProfile": {
                                    "extensions": [
                                        {
                                            "id": "str",
                                            "name": "str",
                                            "properties": {
                "autoUpgradeMinorVersion": bool,
                "enableAutomaticUpgrade": bool,
                                                "forceUpdateTag":
                                                  "str",
                                                "protectedSettings":
                                                  {
                                                    "str": {}
                                                },
                "protectedSettingsFromKeyVault": {
                                                    "secretUrl":
                                                      "str",
                "sourceVault": {
                                                        "id":
                                                          "str"
                                                    }
                                                },
                "provisionAfterExtensions": [
                                                    "str"
                                                ],
                                                "provisioningState":
                                                  "str",
                                                "publisher": "str",
                                                "settings": {
                                                    "str": {}
                                                },
                                                "suppressFailures":
                                                  bool,
                                                "type": "str",
                                                "typeHandlerVersion":
                                                  "str"
                                            },
                                            "type": "str"
                                        }
                                    ],
                                    "extensionsTimeBudget": "str"
                                },
                                "hardwareProfile": {
                                    "vmSizeProperties": {
                                        "vCPUsAvailable": 0,
                                        "vCPUsPerCore": 0
                                    }
                                },
                                "licenseType": "str",
                                "networkProfile": {
                                    "healthProbe": {
                                        "id": "str"
                                    },
                                    "networkApiVersion": "str",
                                    "networkInterfaceConfigurations": [
                                        {
                                            "name": "str",
                                            "properties": {
                                                "ipConfigurations": [
                                                    {
                "name": "str",
                "properties": {
                "applicationGatewayBackendAddressPools":
                                                              [
                {
                "id": "str"
                }
                ],
                "applicationSecurityGroups": [
                {
                "id": "str"
                }
                ],
                "loadBalancerBackendAddressPools": [
                {
                "id": "str"
                }
                ],
                "loadBalancerInboundNatPools": [
                {
                "id": "str"
                }
                ],
                "primary": bool,
                "privateIPAddressVersion": "str",
                "publicIPAddressConfiguration": {
                "name": "str",
                "properties": {
                "deleteOption": "str",
                "dnsSettings": {
                "domainNameLabel": "str",
                "domainNameLabelScope": "str"
                },
                "idleTimeoutInMinutes": 0,
                "ipTags": [
                {
                "ipTagType": "str",
                "tag": "str"
                }
                ],
                "publicIPAddressVersion": "str",
                "publicIPPrefix": {
                "id": "str"
                }
                },
                "sku": {
                "name": "str",
                "tier": "str"
                }
                },
                "subnet": {
                "id": "str"
                }
                                                        }
                                                    }
                                                ],
                                                "auxiliaryMode":
                                                  "str",
                                                "auxiliarySku":
                                                  "str",
                                                "deleteOption":
                                                  "str",
                "disableTcpStateTracking": bool,
                                                "dnsSettings": {
                                                    "dnsServers":
                                                      [
                                                        "str"
                                                    ]
                                                },
                "enableAcceleratedNetworking": bool,
                                                "enableFpga": bool,
                                                "enableIPForwarding":
                                                  bool,
                "networkSecurityGroup": {
                                                    "id": "str"
                                                },
                                                "primary": bool
                                            }
                                        }
                                    ]
                                },
                                "osProfile": {
                                    "adminPassword": "str",
                                    "adminUsername": "str",
                                    "allowExtensionOperations": bool,
                                    "computerNamePrefix": "str",
                                    "customData": "str",
                                    "linuxConfiguration": {
                                        "disablePasswordAuthentication":
                                          bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "ssh": {
                                            "publicKeys": [
                                                {
                                                    "keyData":
                                                      "str",
                                                    "path": "str"
                                                }
                                            ]
                                        }
                                    },
                                    "requireGuestProvisionSignal": bool,
                                    "secrets": [
                                        {
                                            "sourceVault": {
                                                "id": "str"
                                            },
                                            "vaultCertificates": [
                                                {
                "certificateStore": "str",
                "certificateUrl": "str"
                                                }
                                            ]
                                        }
                                    ],
                                    "windowsConfiguration": {
                                        "additionalUnattendContent": [
                                            {
                                                "componentName":
                                                  "Microsoft-Windows-Shell-Setup",
                                                "content": "str",
                                                "passName":
                                                  "OobeSystem",
                                                "settingName": "str"
                                            }
                                        ],
                                        "enableAutomaticUpdates": bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "enableHotpatching": bool,
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "timeZone": "str",
                                        "winRM": {
                                            "listeners": [
                                                {
                "certificateUrl": "str",
                                                    "protocol":
                                                      "str"
                                                }
                                            ]
                                        }
                                    }
                                },
                                "scheduledEventsProfile": {
                                    "osImageNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    },
                                    "terminateNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    }
                                },
                                "securityPostureReference": {
                                    "excludeExtensions": [
                                        "str"
                                    ],
                                    "id": "str",
                                    "isOverridable": bool
                                },
                                "securityProfile": {
                                    "encryptionAtHost": bool,
                                    "encryptionIdentity": {
                                        "userAssignedIdentityResourceId":
                                          "str"
                                    },
                                    "proxyAgentSettings": {
                                        "enabled": bool,
                                        "keyIncarnationId": 0,
                                        "mode": "str"
                                    },
                                    "securityType": "str",
                                    "uefiSettings": {
                                        "secureBootEnabled": bool,
                                        "vTpmEnabled": bool
                                    }
                                },
                                "serviceArtifactReference": {
                                    "id": "str"
                                },
                                "storageProfile": {
                                    "dataDisks": [
                                        {
                                            "createOption": "str",
                                            "lun": 0,
                                            "caching": "str",
                                            "deleteOption": "str",
                                            "diskIOPSReadWrite": 0,
                                            "diskMBpsReadWrite": 0,
                                            "diskSizeGB": 0,
                                            "managedDisk": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                                                "securityProfile": {
                "diskEncryptionSet": {
                                                        "id":
                                                          "str"
                                                    },
                "securityEncryptionType": "str"
                                                },
                                                "storageAccountType":
                                                  "str"
                                            },
                                            "name": "str",
                                            "writeAcceleratorEnabled":
                                              bool
                                        }
                                    ],
                                    "diskControllerType": "str",
                                    "imageReference": {
                                        "communityGalleryImageId": "str",
                                        "exactVersion": "str",
                                        "id": "str",
                                        "offer": "str",
                                        "publisher": "str",
                                        "sharedGalleryImageId": "str",
                                        "sku": "str",
                                        "version": "str"
                                    },
                                    "osDisk": {
                                        "createOption": "str",
                                        "caching": "str",
                                        "deleteOption": "str",
                                        "diffDiskSettings": {
                                            "option": "str",
                                            "placement": "str"
                                        },
                                        "diskSizeGB": 0,
                                        "image": {
                                            "uri": "str"
                                        },
                                        "managedDisk": {
                                            "diskEncryptionSet": {
                                                "id": "str"
                                            },
                                            "securityProfile": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                "securityEncryptionType": "str"
                                            },
                                            "storageAccountType": "str"
                                        },
                                        "name": "str",
                                        "osType": "str",
                                        "vhdContainers": [
                                            "str"
                                        ],
                                        "writeAcceleratorEnabled": bool
                                    }
                                },
                                "timeCreated": "2020-02-20 00:00:00",
                                "userData": "str"
                            },
                            "computeApiVersion": "str",
                            "platformFaultDomainCount": 0
                        },
                        "vmSizesProfile": [
                            {
                                "name": "str",
                                "rank": 0
                            }
                        ],
                        "provisioningState": "str",
                        "regularPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "minCapacity": 0
                        },
                        "spotPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "evictionPolicy": "str",
                            "maintain": bool,
                            "maxPricePerVM": 0.0,
                            "minCapacity": 0
                        },
                        "timeCreated": "2020-02-20 00:00:00",
                        "uniqueId": "str"
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str"
                    },
                    "tags": {
                        "str": "str"
                    },
                    "type": "str",
                    "zones": [
                        "str"
                    ]
                }
        """

    @distributed_trace_async
    async def begin_update(
        self,
        resource_group_name: str,
        fleet_name: str,
        properties: Union[_models.FleetUpdate, JSON, IO[bytes]],
        **kwargs: Any
    ) -> AsyncLROPoller[_models.Fleet]:
        """Update a Fleet.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param fleet_name: The name of the Compute Fleet. Required.
        :type fleet_name: str
        :param properties: The resource properties to be updated. Is one of the following types:
         FleetUpdate, JSON, IO[bytes] Required.
        :type properties: ~azure.mgmt.computefleet.models.FleetUpdate or JSON or IO[bytes]
        :return: An instance of AsyncLROPoller that returns Fleet. The Fleet is compatible with
         MutableMapping
        :rtype: ~azure.core.polling.AsyncLROPoller[~azure.mgmt.computefleet.models.Fleet]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                properties = {
                    "identity": {
                        "type": "str",
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",
                                "principalId": "str"
                            }
                        }
                    },
                    "plan": {
                        "name": "str",
                        "product": "str",
                        "promotionCode": "str",
                        "publisher": "str",
                        "version": "str"
                    },
                    "properties": {
                        "computeProfile": {
                            "baseVirtualMachineProfile": {
                                "applicationProfile": {
                                    "galleryApplications": [
                                        {
                                            "packageReferenceId": "str",
                                            "configurationReference":
                                              "str",
                                            "enableAutomaticUpgrade":
                                              bool,
                                            "order": 0,
                                            "tags": "str",
                "treatFailureAsDeploymentFailure": bool
                                        }
                                    ]
                                },
                                "capacityReservation": {
                                    "capacityReservationGroup": {
                                        "id": "str"
                                    }
                                },
                                "diagnosticsProfile": {
                                    "bootDiagnostics": {
                                        "enabled": bool,
                                        "storageUri": "str"
                                    }
                                },
                                "extensionProfile": {
                                    "extensions": [
                                        {
                                            "id": "str",
                                            "name": "str",
                                            "properties": {
                "autoUpgradeMinorVersion": bool,
                "enableAutomaticUpgrade": bool,
                                                "forceUpdateTag":
                                                  "str",
                                                "protectedSettings":
                                                  {
                                                    "str": {}
                                                },
                "protectedSettingsFromKeyVault": {
                                                    "secretUrl":
                                                      "str",
                "sourceVault": {
                                                        "id":
                                                          "str"
                                                    }
                                                },
                "provisionAfterExtensions": [
                                                    "str"
                                                ],
                                                "provisioningState":
                                                  "str",
                                                "publisher": "str",
                                                "settings": {
                                                    "str": {}
                                                },
                                                "suppressFailures":
                                                  bool,
                                                "type": "str",
                                                "typeHandlerVersion":
                                                  "str"
                                            },
                                            "type": "str"
                                        }
                                    ],
                                    "extensionsTimeBudget": "str"
                                },
                                "hardwareProfile": {
                                    "vmSizeProperties": {
                                        "vCPUsAvailable": 0,
                                        "vCPUsPerCore": 0
                                    }
                                },
                                "licenseType": "str",
                                "networkProfile": {
                                    "healthProbe": {
                                        "id": "str"
                                    },
                                    "networkApiVersion": "str",
                                    "networkInterfaceConfigurations": [
                                        {
                                            "name": "str",
                                            "properties": {
                                                "ipConfigurations": [
                                                    {
                "name": "str",
                "properties": {
                "applicationGatewayBackendAddressPools":
                                                              [
                {
                "id": "str"
                }
                ],
                "applicationSecurityGroups": [
                {
                "id": "str"
                }
                ],
                "loadBalancerBackendAddressPools": [
                {
                "id": "str"
                }
                ],
                "loadBalancerInboundNatPools": [
                {
                "id": "str"
                }
                ],
                "primary": bool,
                "privateIPAddressVersion": "str",
                "publicIPAddressConfiguration": {
                "name": "str",
                "properties": {
                "deleteOption": "str",
                "dnsSettings": {
                "domainNameLabel": "str",
                "domainNameLabelScope": "str"
                },
                "idleTimeoutInMinutes": 0,
                "ipTags": [
                {
                "ipTagType": "str",
                "tag": "str"
                }
                ],
                "publicIPAddressVersion": "str",
                "publicIPPrefix": {
                "id": "str"
                }
                },
                "sku": {
                "name": "str",
                "tier": "str"
                }
                },
                "subnet": {
                "id": "str"
                }
                                                        }
                                                    }
                                                ],
                                                "auxiliaryMode":
                                                  "str",
                                                "auxiliarySku":
                                                  "str",
                                                "deleteOption":
                                                  "str",
                "disableTcpStateTracking": bool,
                                                "dnsSettings": {
                                                    "dnsServers":
                                                      [
                                                        "str"
                                                    ]
                                                },
                "enableAcceleratedNetworking": bool,
                                                "enableFpga": bool,
                                                "enableIPForwarding":
                                                  bool,
                "networkSecurityGroup": {
                                                    "id": "str"
                                                },
                                                "primary": bool
                                            }
                                        }
                                    ]
                                },
                                "osProfile": {
                                    "adminPassword": "str",
                                    "adminUsername": "str",
                                    "allowExtensionOperations": bool,
                                    "computerNamePrefix": "str",
                                    "customData": "str",
                                    "linuxConfiguration": {
                                        "disablePasswordAuthentication":
                                          bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "ssh": {
                                            "publicKeys": [
                                                {
                                                    "keyData":
                                                      "str",
                                                    "path": "str"
                                                }
                                            ]
                                        }
                                    },
                                    "requireGuestProvisionSignal": bool,
                                    "secrets": [
                                        {
                                            "sourceVault": {
                                                "id": "str"
                                            },
                                            "vaultCertificates": [
                                                {
                "certificateStore": "str",
                "certificateUrl": "str"
                                                }
                                            ]
                                        }
                                    ],
                                    "windowsConfiguration": {
                                        "additionalUnattendContent": [
                                            {
                                                "componentName":
                                                  "Microsoft-Windows-Shell-Setup",
                                                "content": "str",
                                                "passName":
                                                  "OobeSystem",
                                                "settingName": "str"
                                            }
                                        ],
                                        "enableAutomaticUpdates": bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "enableHotpatching": bool,
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "timeZone": "str",
                                        "winRM": {
                                            "listeners": [
                                                {
                "certificateUrl": "str",
                                                    "protocol":
                                                      "str"
                                                }
                                            ]
                                        }
                                    }
                                },
                                "scheduledEventsProfile": {
                                    "osImageNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    },
                                    "terminateNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    }
                                },
                                "securityPostureReference": {
                                    "excludeExtensions": [
                                        "str"
                                    ],
                                    "id": "str",
                                    "isOverridable": bool
                                },
                                "securityProfile": {
                                    "encryptionAtHost": bool,
                                    "encryptionIdentity": {
                                        "userAssignedIdentityResourceId":
                                          "str"
                                    },
                                    "proxyAgentSettings": {
                                        "enabled": bool,
                                        "keyIncarnationId": 0,
                                        "mode": "str"
                                    },
                                    "securityType": "str",
                                    "uefiSettings": {
                                        "secureBootEnabled": bool,
                                        "vTpmEnabled": bool
                                    }
                                },
                                "serviceArtifactReference": {
                                    "id": "str"
                                },
                                "storageProfile": {
                                    "dataDisks": [
                                        {
                                            "createOption": "str",
                                            "lun": 0,
                                            "caching": "str",
                                            "deleteOption": "str",
                                            "diskIOPSReadWrite": 0,
                                            "diskMBpsReadWrite": 0,
                                            "diskSizeGB": 0,
                                            "managedDisk": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                                                "securityProfile": {
                "diskEncryptionSet": {
                                                        "id":
                                                          "str"
                                                    },
                "securityEncryptionType": "str"
                                                },
                                                "storageAccountType":
                                                  "str"
                                            },
                                            "name": "str",
                                            "writeAcceleratorEnabled":
                                              bool
                                        }
                                    ],
                                    "diskControllerType": "str",
                                    "imageReference": {
                                        "communityGalleryImageId": "str",
                                        "exactVersion": "str",
                                        "id": "str",
                                        "offer": "str",
                                        "publisher": "str",
                                        "sharedGalleryImageId": "str",
                                        "sku": "str",
                                        "version": "str"
                                    },
                                    "osDisk": {
                                        "createOption": "str",
                                        "caching": "str",
                                        "deleteOption": "str",
                                        "diffDiskSettings": {
                                            "option": "str",
                                            "placement": "str"
                                        },
                                        "diskSizeGB": 0,
                                        "image": {
                                            "uri": "str"
                                        },
                                        "managedDisk": {
                                            "diskEncryptionSet": {
                                                "id": "str"
                                            },
                                            "securityProfile": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                "securityEncryptionType": "str"
                                            },
                                            "storageAccountType": "str"
                                        },
                                        "name": "str",
                                        "osType": "str",
                                        "vhdContainers": [
                                            "str"
                                        ],
                                        "writeAcceleratorEnabled": bool
                                    }
                                },
                                "timeCreated": "2020-02-20 00:00:00",
                                "userData": "str"
                            },
                            "computeApiVersion": "str",
                            "platformFaultDomainCount": 0
                        },
                        "vmSizesProfile": [
                            {
                                "name": "str",
                                "rank": 0
                            }
                        ],
                        "provisioningState": "str",
                        "regularPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "minCapacity": 0
                        },
                        "spotPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "evictionPolicy": "str",
                            "maintain": bool,
                            "maxPricePerVM": 0.0,
                            "minCapacity": 0
                        },
                        "timeCreated": "2020-02-20 00:00:00",
                        "uniqueId": "str"
                    },
                    "tags": {
                        "str": "str"
                    }
                }

                # response body for status code(s): 200, 202
                response == {
                    "location": "str",
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",
                                "principalId": "str"
                            }
                        }
                    },
                    "name": "str",
                    "plan": {
                        "name": "str",
                        "product": "str",
                        "publisher": "str",
                        "promotionCode": "str",
                        "version": "str"
                    },
                    "properties": {
                        "computeProfile": {
                            "baseVirtualMachineProfile": {
                                "applicationProfile": {
                                    "galleryApplications": [
                                        {
                                            "packageReferenceId": "str",
                                            "configurationReference":
                                              "str",
                                            "enableAutomaticUpgrade":
                                              bool,
                                            "order": 0,
                                            "tags": "str",
                "treatFailureAsDeploymentFailure": bool
                                        }
                                    ]
                                },
                                "capacityReservation": {
                                    "capacityReservationGroup": {
                                        "id": "str"
                                    }
                                },
                                "diagnosticsProfile": {
                                    "bootDiagnostics": {
                                        "enabled": bool,
                                        "storageUri": "str"
                                    }
                                },
                                "extensionProfile": {
                                    "extensions": [
                                        {
                                            "id": "str",
                                            "name": "str",
                                            "properties": {
                "autoUpgradeMinorVersion": bool,
                "enableAutomaticUpgrade": bool,
                                                "forceUpdateTag":
                                                  "str",
                                                "protectedSettings":
                                                  {
                                                    "str": {}
                                                },
                "protectedSettingsFromKeyVault": {
                                                    "secretUrl":
                                                      "str",
                "sourceVault": {
                                                        "id":
                                                          "str"
                                                    }
                                                },
                "provisionAfterExtensions": [
                                                    "str"
                                                ],
                                                "provisioningState":
                                                  "str",
                                                "publisher": "str",
                                                "settings": {
                                                    "str": {}
                                                },
                                                "suppressFailures":
                                                  bool,
                                                "type": "str",
                                                "typeHandlerVersion":
                                                  "str"
                                            },
                                            "type": "str"
                                        }
                                    ],
                                    "extensionsTimeBudget": "str"
                                },
                                "hardwareProfile": {
                                    "vmSizeProperties": {
                                        "vCPUsAvailable": 0,
                                        "vCPUsPerCore": 0
                                    }
                                },
                                "licenseType": "str",
                                "networkProfile": {
                                    "healthProbe": {
                                        "id": "str"
                                    },
                                    "networkApiVersion": "str",
                                    "networkInterfaceConfigurations": [
                                        {
                                            "name": "str",
                                            "properties": {
                                                "ipConfigurations": [
                                                    {
                "name": "str",
                "properties": {
                "applicationGatewayBackendAddressPools":
                                                              [
                {
                "id": "str"
                }
                ],
                "applicationSecurityGroups": [
                {
                "id": "str"
                }
                ],
                "loadBalancerBackendAddressPools": [
                {
                "id": "str"
                }
                ],
                "loadBalancerInboundNatPools": [
                {
                "id": "str"
                }
                ],
                "primary": bool,
                "privateIPAddressVersion": "str",
                "publicIPAddressConfiguration": {
                "name": "str",
                "properties": {
                "deleteOption": "str",
                "dnsSettings": {
                "domainNameLabel": "str",
                "domainNameLabelScope": "str"
                },
                "idleTimeoutInMinutes": 0,
                "ipTags": [
                {
                "ipTagType": "str",
                "tag": "str"
                }
                ],
                "publicIPAddressVersion": "str",
                "publicIPPrefix": {
                "id": "str"
                }
                },
                "sku": {
                "name": "str",
                "tier": "str"
                }
                },
                "subnet": {
                "id": "str"
                }
                                                        }
                                                    }
                                                ],
                                                "auxiliaryMode":
                                                  "str",
                                                "auxiliarySku":
                                                  "str",
                                                "deleteOption":
                                                  "str",
                "disableTcpStateTracking": bool,
                                                "dnsSettings": {
                                                    "dnsServers":
                                                      [
                                                        "str"
                                                    ]
                                                },
                "enableAcceleratedNetworking": bool,
                                                "enableFpga": bool,
                                                "enableIPForwarding":
                                                  bool,
                "networkSecurityGroup": {
                                                    "id": "str"
                                                },
                                                "primary": bool
                                            }
                                        }
                                    ]
                                },
                                "osProfile": {
                                    "adminPassword": "str",
                                    "adminUsername": "str",
                                    "allowExtensionOperations": bool,
                                    "computerNamePrefix": "str",
                                    "customData": "str",
                                    "linuxConfiguration": {
                                        "disablePasswordAuthentication":
                                          bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "ssh": {
                                            "publicKeys": [
                                                {
                                                    "keyData":
                                                      "str",
                                                    "path": "str"
                                                }
                                            ]
                                        }
                                    },
                                    "requireGuestProvisionSignal": bool,
                                    "secrets": [
                                        {
                                            "sourceVault": {
                                                "id": "str"
                                            },
                                            "vaultCertificates": [
                                                {
                "certificateStore": "str",
                "certificateUrl": "str"
                                                }
                                            ]
                                        }
                                    ],
                                    "windowsConfiguration": {
                                        "additionalUnattendContent": [
                                            {
                                                "componentName":
                                                  "Microsoft-Windows-Shell-Setup",
                                                "content": "str",
                                                "passName":
                                                  "OobeSystem",
                                                "settingName": "str"
                                            }
                                        ],
                                        "enableAutomaticUpdates": bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "enableHotpatching": bool,
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "timeZone": "str",
                                        "winRM": {
                                            "listeners": [
                                                {
                "certificateUrl": "str",
                                                    "protocol":
                                                      "str"
                                                }
                                            ]
                                        }
                                    }
                                },
                                "scheduledEventsProfile": {
                                    "osImageNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    },
                                    "terminateNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    }
                                },
                                "securityPostureReference": {
                                    "excludeExtensions": [
                                        "str"
                                    ],
                                    "id": "str",
                                    "isOverridable": bool
                                },
                                "securityProfile": {
                                    "encryptionAtHost": bool,
                                    "encryptionIdentity": {
                                        "userAssignedIdentityResourceId":
                                          "str"
                                    },
                                    "proxyAgentSettings": {
                                        "enabled": bool,
                                        "keyIncarnationId": 0,
                                        "mode": "str"
                                    },
                                    "securityType": "str",
                                    "uefiSettings": {
                                        "secureBootEnabled": bool,
                                        "vTpmEnabled": bool
                                    }
                                },
                                "serviceArtifactReference": {
                                    "id": "str"
                                },
                                "storageProfile": {
                                    "dataDisks": [
                                        {
                                            "createOption": "str",
                                            "lun": 0,
                                            "caching": "str",
                                            "deleteOption": "str",
                                            "diskIOPSReadWrite": 0,
                                            "diskMBpsReadWrite": 0,
                                            "diskSizeGB": 0,
                                            "managedDisk": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                                                "securityProfile": {
                "diskEncryptionSet": {
                                                        "id":
                                                          "str"
                                                    },
                "securityEncryptionType": "str"
                                                },
                                                "storageAccountType":
                                                  "str"
                                            },
                                            "name": "str",
                                            "writeAcceleratorEnabled":
                                              bool
                                        }
                                    ],
                                    "diskControllerType": "str",
                                    "imageReference": {
                                        "communityGalleryImageId": "str",
                                        "exactVersion": "str",
                                        "id": "str",
                                        "offer": "str",
                                        "publisher": "str",
                                        "sharedGalleryImageId": "str",
                                        "sku": "str",
                                        "version": "str"
                                    },
                                    "osDisk": {
                                        "createOption": "str",
                                        "caching": "str",
                                        "deleteOption": "str",
                                        "diffDiskSettings": {
                                            "option": "str",
                                            "placement": "str"
                                        },
                                        "diskSizeGB": 0,
                                        "image": {
                                            "uri": "str"
                                        },
                                        "managedDisk": {
                                            "diskEncryptionSet": {
                                                "id": "str"
                                            },
                                            "securityProfile": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                "securityEncryptionType": "str"
                                            },
                                            "storageAccountType": "str"
                                        },
                                        "name": "str",
                                        "osType": "str",
                                        "vhdContainers": [
                                            "str"
                                        ],
                                        "writeAcceleratorEnabled": bool
                                    }
                                },
                                "timeCreated": "2020-02-20 00:00:00",
                                "userData": "str"
                            },
                            "computeApiVersion": "str",
                            "platformFaultDomainCount": 0
                        },
                        "vmSizesProfile": [
                            {
                                "name": "str",
                                "rank": 0
                            }
                        ],
                        "provisioningState": "str",
                        "regularPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "minCapacity": 0
                        },
                        "spotPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "evictionPolicy": "str",
                            "maintain": bool,
                            "maxPricePerVM": 0.0,
                            "minCapacity": 0
                        },
                        "timeCreated": "2020-02-20 00:00:00",
                        "uniqueId": "str"
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str"
                    },
                    "tags": {
                        "str": "str"
                    },
                    "type": "str",
                    "zones": [
                        "str"
                    ]
                }
        """
        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[_models.Fleet] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._update_initial(
                resource_group_name=resource_group_name,
                fleet_name=fleet_name,
                properties=properties,
                content_type=content_type,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            deserialized = _deserialize(_models.Fleet, response.json())
            if cls:
                return cls(pipeline_response, deserialized, {})  # type: ignore
            return deserialized

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[_models.Fleet].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[_models.Fleet](
            self._client, raw_result, get_long_running_output, polling_method  # type: ignore
        )

    async def _delete_initial(self, resource_group_name: str, fleet_name: str, **kwargs: Any) -> AsyncIterator[bytes]:
        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[AsyncIterator[bytes]] = kwargs.pop("cls", None)

        _request = build_fleets_delete_request(
            resource_group_name=resource_group_name,
            fleet_name=fleet_name,
            subscription_id=self._config.subscription_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        _request.url = self._client.format_url(_request.url)

        _stream = True
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            _request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [202, 204]:
            try:
                await response.read()  # Load the body in memory and close the socket
            except (StreamConsumedError, StreamClosedError):
                pass
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = _deserialize(_models.ErrorResponse, response.json())
            raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

        response_headers = {}
        if response.status_code == 202:
            response_headers["Location"] = self._deserialize("str", response.headers.get("Location"))
            response_headers["Retry-After"] = self._deserialize("int", response.headers.get("Retry-After"))

            deserialized = response.iter_bytes()

        if response.status_code == 204:
            deserialized = response.iter_bytes()

        if cls:
            return cls(pipeline_response, deserialized, response_headers)  # type: ignore

        return deserialized  # type: ignore

    @distributed_trace_async
    async def begin_delete(self, resource_group_name: str, fleet_name: str, **kwargs: Any) -> AsyncLROPoller[None]:
        """Delete a Fleet.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param fleet_name: The name of the Compute Fleet. Required.
        :type fleet_name: str
        :return: An instance of AsyncLROPoller that returns None
        :rtype: ~azure.core.polling.AsyncLROPoller[None]
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)
        polling: Union[bool, AsyncPollingMethod] = kwargs.pop("polling", True)
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token: Optional[str] = kwargs.pop("continuation_token", None)
        if cont_token is None:
            raw_result = await self._delete_initial(
                resource_group_name=resource_group_name,
                fleet_name=fleet_name,
                cls=lambda x, y, z: x,
                headers=_headers,
                params=_params,
                **kwargs
            )
            await raw_result.http_response.read()  # type: ignore
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):  # pylint: disable=inconsistent-return-statements
            if cls:
                return cls(pipeline_response, None, {})  # type: ignore

        if polling is True:
            polling_method: AsyncPollingMethod = cast(AsyncPollingMethod, AsyncARMPolling(lro_delay, **kwargs))
        elif polling is False:
            polling_method = cast(AsyncPollingMethod, AsyncNoPolling())
        else:
            polling_method = polling
        if cont_token:
            return AsyncLROPoller[None].from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return AsyncLROPoller[None](self._client, raw_result, get_long_running_output, polling_method)  # type: ignore

    @distributed_trace
    def list_by_resource_group(self, resource_group_name: str, **kwargs: Any) -> AsyncIterable["_models.Fleet"]:
        """List Fleet resources by resource group.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :return: An iterator like instance of Fleet
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.computefleet.models.Fleet]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "location": "str",
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",
                                "principalId": "str"
                            }
                        }
                    },
                    "name": "str",
                    "plan": {
                        "name": "str",
                        "product": "str",
                        "publisher": "str",
                        "promotionCode": "str",
                        "version": "str"
                    },
                    "properties": {
                        "computeProfile": {
                            "baseVirtualMachineProfile": {
                                "applicationProfile": {
                                    "galleryApplications": [
                                        {
                                            "packageReferenceId": "str",
                                            "configurationReference":
                                              "str",
                                            "enableAutomaticUpgrade":
                                              bool,
                                            "order": 0,
                                            "tags": "str",
                "treatFailureAsDeploymentFailure": bool
                                        }
                                    ]
                                },
                                "capacityReservation": {
                                    "capacityReservationGroup": {
                                        "id": "str"
                                    }
                                },
                                "diagnosticsProfile": {
                                    "bootDiagnostics": {
                                        "enabled": bool,
                                        "storageUri": "str"
                                    }
                                },
                                "extensionProfile": {
                                    "extensions": [
                                        {
                                            "id": "str",
                                            "name": "str",
                                            "properties": {
                "autoUpgradeMinorVersion": bool,
                "enableAutomaticUpgrade": bool,
                                                "forceUpdateTag":
                                                  "str",
                                                "protectedSettings":
                                                  {
                                                    "str": {}
                                                },
                "protectedSettingsFromKeyVault": {
                                                    "secretUrl":
                                                      "str",
                "sourceVault": {
                                                        "id":
                                                          "str"
                                                    }
                                                },
                "provisionAfterExtensions": [
                                                    "str"
                                                ],
                                                "provisioningState":
                                                  "str",
                                                "publisher": "str",
                                                "settings": {
                                                    "str": {}
                                                },
                                                "suppressFailures":
                                                  bool,
                                                "type": "str",
                                                "typeHandlerVersion":
                                                  "str"
                                            },
                                            "type": "str"
                                        }
                                    ],
                                    "extensionsTimeBudget": "str"
                                },
                                "hardwareProfile": {
                                    "vmSizeProperties": {
                                        "vCPUsAvailable": 0,
                                        "vCPUsPerCore": 0
                                    }
                                },
                                "licenseType": "str",
                                "networkProfile": {
                                    "healthProbe": {
                                        "id": "str"
                                    },
                                    "networkApiVersion": "str",
                                    "networkInterfaceConfigurations": [
                                        {
                                            "name": "str",
                                            "properties": {
                                                "ipConfigurations": [
                                                    {
                "name": "str",
                "properties": {
                "applicationGatewayBackendAddressPools":
                                                              [
                {
                "id": "str"
                }
                ],
                "applicationSecurityGroups": [
                {
                "id": "str"
                }
                ],
                "loadBalancerBackendAddressPools": [
                {
                "id": "str"
                }
                ],
                "loadBalancerInboundNatPools": [
                {
                "id": "str"
                }
                ],
                "primary": bool,
                "privateIPAddressVersion": "str",
                "publicIPAddressConfiguration": {
                "name": "str",
                "properties": {
                "deleteOption": "str",
                "dnsSettings": {
                "domainNameLabel": "str",
                "domainNameLabelScope": "str"
                },
                "idleTimeoutInMinutes": 0,
                "ipTags": [
                {
                "ipTagType": "str",
                "tag": "str"
                }
                ],
                "publicIPAddressVersion": "str",
                "publicIPPrefix": {
                "id": "str"
                }
                },
                "sku": {
                "name": "str",
                "tier": "str"
                }
                },
                "subnet": {
                "id": "str"
                }
                                                        }
                                                    }
                                                ],
                                                "auxiliaryMode":
                                                  "str",
                                                "auxiliarySku":
                                                  "str",
                                                "deleteOption":
                                                  "str",
                "disableTcpStateTracking": bool,
                                                "dnsSettings": {
                                                    "dnsServers":
                                                      [
                                                        "str"
                                                    ]
                                                },
                "enableAcceleratedNetworking": bool,
                                                "enableFpga": bool,
                                                "enableIPForwarding":
                                                  bool,
                "networkSecurityGroup": {
                                                    "id": "str"
                                                },
                                                "primary": bool
                                            }
                                        }
                                    ]
                                },
                                "osProfile": {
                                    "adminPassword": "str",
                                    "adminUsername": "str",
                                    "allowExtensionOperations": bool,
                                    "computerNamePrefix": "str",
                                    "customData": "str",
                                    "linuxConfiguration": {
                                        "disablePasswordAuthentication":
                                          bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "ssh": {
                                            "publicKeys": [
                                                {
                                                    "keyData":
                                                      "str",
                                                    "path": "str"
                                                }
                                            ]
                                        }
                                    },
                                    "requireGuestProvisionSignal": bool,
                                    "secrets": [
                                        {
                                            "sourceVault": {
                                                "id": "str"
                                            },
                                            "vaultCertificates": [
                                                {
                "certificateStore": "str",
                "certificateUrl": "str"
                                                }
                                            ]
                                        }
                                    ],
                                    "windowsConfiguration": {
                                        "additionalUnattendContent": [
                                            {
                                                "componentName":
                                                  "Microsoft-Windows-Shell-Setup",
                                                "content": "str",
                                                "passName":
                                                  "OobeSystem",
                                                "settingName": "str"
                                            }
                                        ],
                                        "enableAutomaticUpdates": bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "enableHotpatching": bool,
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "timeZone": "str",
                                        "winRM": {
                                            "listeners": [
                                                {
                "certificateUrl": "str",
                                                    "protocol":
                                                      "str"
                                                }
                                            ]
                                        }
                                    }
                                },
                                "scheduledEventsProfile": {
                                    "osImageNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    },
                                    "terminateNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    }
                                },
                                "securityPostureReference": {
                                    "excludeExtensions": [
                                        "str"
                                    ],
                                    "id": "str",
                                    "isOverridable": bool
                                },
                                "securityProfile": {
                                    "encryptionAtHost": bool,
                                    "encryptionIdentity": {
                                        "userAssignedIdentityResourceId":
                                          "str"
                                    },
                                    "proxyAgentSettings": {
                                        "enabled": bool,
                                        "keyIncarnationId": 0,
                                        "mode": "str"
                                    },
                                    "securityType": "str",
                                    "uefiSettings": {
                                        "secureBootEnabled": bool,
                                        "vTpmEnabled": bool
                                    }
                                },
                                "serviceArtifactReference": {
                                    "id": "str"
                                },
                                "storageProfile": {
                                    "dataDisks": [
                                        {
                                            "createOption": "str",
                                            "lun": 0,
                                            "caching": "str",
                                            "deleteOption": "str",
                                            "diskIOPSReadWrite": 0,
                                            "diskMBpsReadWrite": 0,
                                            "diskSizeGB": 0,
                                            "managedDisk": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                                                "securityProfile": {
                "diskEncryptionSet": {
                                                        "id":
                                                          "str"
                                                    },
                "securityEncryptionType": "str"
                                                },
                                                "storageAccountType":
                                                  "str"
                                            },
                                            "name": "str",
                                            "writeAcceleratorEnabled":
                                              bool
                                        }
                                    ],
                                    "diskControllerType": "str",
                                    "imageReference": {
                                        "communityGalleryImageId": "str",
                                        "exactVersion": "str",
                                        "id": "str",
                                        "offer": "str",
                                        "publisher": "str",
                                        "sharedGalleryImageId": "str",
                                        "sku": "str",
                                        "version": "str"
                                    },
                                    "osDisk": {
                                        "createOption": "str",
                                        "caching": "str",
                                        "deleteOption": "str",
                                        "diffDiskSettings": {
                                            "option": "str",
                                            "placement": "str"
                                        },
                                        "diskSizeGB": 0,
                                        "image": {
                                            "uri": "str"
                                        },
                                        "managedDisk": {
                                            "diskEncryptionSet": {
                                                "id": "str"
                                            },
                                            "securityProfile": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                "securityEncryptionType": "str"
                                            },
                                            "storageAccountType": "str"
                                        },
                                        "name": "str",
                                        "osType": "str",
                                        "vhdContainers": [
                                            "str"
                                        ],
                                        "writeAcceleratorEnabled": bool
                                    }
                                },
                                "timeCreated": "2020-02-20 00:00:00",
                                "userData": "str"
                            },
                            "computeApiVersion": "str",
                            "platformFaultDomainCount": 0
                        },
                        "vmSizesProfile": [
                            {
                                "name": "str",
                                "rank": 0
                            }
                        ],
                        "provisioningState": "str",
                        "regularPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "minCapacity": 0
                        },
                        "spotPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "evictionPolicy": "str",
                            "maintain": bool,
                            "maxPricePerVM": 0.0,
                            "minCapacity": 0
                        },
                        "timeCreated": "2020-02-20 00:00:00",
                        "uniqueId": "str"
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str"
                    },
                    "tags": {
                        "str": "str"
                    },
                    "type": "str",
                    "zones": [
                        "str"
                    ]
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.Fleet]] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_fleets_list_by_resource_group_request(
                    resource_group_name=resource_group_name,
                    subscription_id=self._config.subscription_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.Fleet], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.ErrorResponse, response.json())
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_by_subscription(self, **kwargs: Any) -> AsyncIterable["_models.Fleet"]:
        """List Fleet resources by subscription ID.

        :return: An iterator like instance of Fleet
        :rtype: ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.computefleet.models.Fleet]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "location": "str",
                    "id": "str",
                    "identity": {
                        "type": "str",
                        "principalId": "str",
                        "tenantId": "str",
                        "userAssignedIdentities": {
                            "str": {
                                "clientId": "str",
                                "principalId": "str"
                            }
                        }
                    },
                    "name": "str",
                    "plan": {
                        "name": "str",
                        "product": "str",
                        "publisher": "str",
                        "promotionCode": "str",
                        "version": "str"
                    },
                    "properties": {
                        "computeProfile": {
                            "baseVirtualMachineProfile": {
                                "applicationProfile": {
                                    "galleryApplications": [
                                        {
                                            "packageReferenceId": "str",
                                            "configurationReference":
                                              "str",
                                            "enableAutomaticUpgrade":
                                              bool,
                                            "order": 0,
                                            "tags": "str",
                "treatFailureAsDeploymentFailure": bool
                                        }
                                    ]
                                },
                                "capacityReservation": {
                                    "capacityReservationGroup": {
                                        "id": "str"
                                    }
                                },
                                "diagnosticsProfile": {
                                    "bootDiagnostics": {
                                        "enabled": bool,
                                        "storageUri": "str"
                                    }
                                },
                                "extensionProfile": {
                                    "extensions": [
                                        {
                                            "id": "str",
                                            "name": "str",
                                            "properties": {
                "autoUpgradeMinorVersion": bool,
                "enableAutomaticUpgrade": bool,
                                                "forceUpdateTag":
                                                  "str",
                                                "protectedSettings":
                                                  {
                                                    "str": {}
                                                },
                "protectedSettingsFromKeyVault": {
                                                    "secretUrl":
                                                      "str",
                "sourceVault": {
                                                        "id":
                                                          "str"
                                                    }
                                                },
                "provisionAfterExtensions": [
                                                    "str"
                                                ],
                                                "provisioningState":
                                                  "str",
                                                "publisher": "str",
                                                "settings": {
                                                    "str": {}
                                                },
                                                "suppressFailures":
                                                  bool,
                                                "type": "str",
                                                "typeHandlerVersion":
                                                  "str"
                                            },
                                            "type": "str"
                                        }
                                    ],
                                    "extensionsTimeBudget": "str"
                                },
                                "hardwareProfile": {
                                    "vmSizeProperties": {
                                        "vCPUsAvailable": 0,
                                        "vCPUsPerCore": 0
                                    }
                                },
                                "licenseType": "str",
                                "networkProfile": {
                                    "healthProbe": {
                                        "id": "str"
                                    },
                                    "networkApiVersion": "str",
                                    "networkInterfaceConfigurations": [
                                        {
                                            "name": "str",
                                            "properties": {
                                                "ipConfigurations": [
                                                    {
                "name": "str",
                "properties": {
                "applicationGatewayBackendAddressPools":
                                                              [
                {
                "id": "str"
                }
                ],
                "applicationSecurityGroups": [
                {
                "id": "str"
                }
                ],
                "loadBalancerBackendAddressPools": [
                {
                "id": "str"
                }
                ],
                "loadBalancerInboundNatPools": [
                {
                "id": "str"
                }
                ],
                "primary": bool,
                "privateIPAddressVersion": "str",
                "publicIPAddressConfiguration": {
                "name": "str",
                "properties": {
                "deleteOption": "str",
                "dnsSettings": {
                "domainNameLabel": "str",
                "domainNameLabelScope": "str"
                },
                "idleTimeoutInMinutes": 0,
                "ipTags": [
                {
                "ipTagType": "str",
                "tag": "str"
                }
                ],
                "publicIPAddressVersion": "str",
                "publicIPPrefix": {
                "id": "str"
                }
                },
                "sku": {
                "name": "str",
                "tier": "str"
                }
                },
                "subnet": {
                "id": "str"
                }
                                                        }
                                                    }
                                                ],
                                                "auxiliaryMode":
                                                  "str",
                                                "auxiliarySku":
                                                  "str",
                                                "deleteOption":
                                                  "str",
                "disableTcpStateTracking": bool,
                                                "dnsSettings": {
                                                    "dnsServers":
                                                      [
                                                        "str"
                                                    ]
                                                },
                "enableAcceleratedNetworking": bool,
                                                "enableFpga": bool,
                                                "enableIPForwarding":
                                                  bool,
                "networkSecurityGroup": {
                                                    "id": "str"
                                                },
                                                "primary": bool
                                            }
                                        }
                                    ]
                                },
                                "osProfile": {
                                    "adminPassword": "str",
                                    "adminUsername": "str",
                                    "allowExtensionOperations": bool,
                                    "computerNamePrefix": "str",
                                    "customData": "str",
                                    "linuxConfiguration": {
                                        "disablePasswordAuthentication":
                                          bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "ssh": {
                                            "publicKeys": [
                                                {
                                                    "keyData":
                                                      "str",
                                                    "path": "str"
                                                }
                                            ]
                                        }
                                    },
                                    "requireGuestProvisionSignal": bool,
                                    "secrets": [
                                        {
                                            "sourceVault": {
                                                "id": "str"
                                            },
                                            "vaultCertificates": [
                                                {
                "certificateStore": "str",
                "certificateUrl": "str"
                                                }
                                            ]
                                        }
                                    ],
                                    "windowsConfiguration": {
                                        "additionalUnattendContent": [
                                            {
                                                "componentName":
                                                  "Microsoft-Windows-Shell-Setup",
                                                "content": "str",
                                                "passName":
                                                  "OobeSystem",
                                                "settingName": "str"
                                            }
                                        ],
                                        "enableAutomaticUpdates": bool,
                                        "enableVMAgentPlatformUpdates": bool,
                                        "patchSettings": {
                                            "assessmentMode": "str",
                "automaticByPlatformSettings": {
                "bypassPlatformSafetyChecksOnUserSchedule": bool,
                                                "rebootSetting":
                                                  "str"
                                            },
                                            "enableHotpatching": bool,
                                            "patchMode": "str"
                                        },
                                        "provisionVMAgent": bool,
                                        "timeZone": "str",
                                        "winRM": {
                                            "listeners": [
                                                {
                "certificateUrl": "str",
                                                    "protocol":
                                                      "str"
                                                }
                                            ]
                                        }
                                    }
                                },
                                "scheduledEventsProfile": {
                                    "osImageNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    },
                                    "terminateNotificationProfile": {
                                        "enable": bool,
                                        "notBeforeTimeout": "str"
                                    }
                                },
                                "securityPostureReference": {
                                    "excludeExtensions": [
                                        "str"
                                    ],
                                    "id": "str",
                                    "isOverridable": bool
                                },
                                "securityProfile": {
                                    "encryptionAtHost": bool,
                                    "encryptionIdentity": {
                                        "userAssignedIdentityResourceId":
                                          "str"
                                    },
                                    "proxyAgentSettings": {
                                        "enabled": bool,
                                        "keyIncarnationId": 0,
                                        "mode": "str"
                                    },
                                    "securityType": "str",
                                    "uefiSettings": {
                                        "secureBootEnabled": bool,
                                        "vTpmEnabled": bool
                                    }
                                },
                                "serviceArtifactReference": {
                                    "id": "str"
                                },
                                "storageProfile": {
                                    "dataDisks": [
                                        {
                                            "createOption": "str",
                                            "lun": 0,
                                            "caching": "str",
                                            "deleteOption": "str",
                                            "diskIOPSReadWrite": 0,
                                            "diskMBpsReadWrite": 0,
                                            "diskSizeGB": 0,
                                            "managedDisk": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                                                "securityProfile": {
                "diskEncryptionSet": {
                                                        "id":
                                                          "str"
                                                    },
                "securityEncryptionType": "str"
                                                },
                                                "storageAccountType":
                                                  "str"
                                            },
                                            "name": "str",
                                            "writeAcceleratorEnabled":
                                              bool
                                        }
                                    ],
                                    "diskControllerType": "str",
                                    "imageReference": {
                                        "communityGalleryImageId": "str",
                                        "exactVersion": "str",
                                        "id": "str",
                                        "offer": "str",
                                        "publisher": "str",
                                        "sharedGalleryImageId": "str",
                                        "sku": "str",
                                        "version": "str"
                                    },
                                    "osDisk": {
                                        "createOption": "str",
                                        "caching": "str",
                                        "deleteOption": "str",
                                        "diffDiskSettings": {
                                            "option": "str",
                                            "placement": "str"
                                        },
                                        "diskSizeGB": 0,
                                        "image": {
                                            "uri": "str"
                                        },
                                        "managedDisk": {
                                            "diskEncryptionSet": {
                                                "id": "str"
                                            },
                                            "securityProfile": {
                                                "diskEncryptionSet":
                                                  {
                                                    "id": "str"
                                                },
                "securityEncryptionType": "str"
                                            },
                                            "storageAccountType": "str"
                                        },
                                        "name": "str",
                                        "osType": "str",
                                        "vhdContainers": [
                                            "str"
                                        ],
                                        "writeAcceleratorEnabled": bool
                                    }
                                },
                                "timeCreated": "2020-02-20 00:00:00",
                                "userData": "str"
                            },
                            "computeApiVersion": "str",
                            "platformFaultDomainCount": 0
                        },
                        "vmSizesProfile": [
                            {
                                "name": "str",
                                "rank": 0
                            }
                        ],
                        "provisioningState": "str",
                        "regularPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "minCapacity": 0
                        },
                        "spotPriorityProfile": {
                            "allocationStrategy": "str",
                            "capacity": 0,
                            "evictionPolicy": "str",
                            "maintain": bool,
                            "maxPricePerVM": 0.0,
                            "minCapacity": 0
                        },
                        "timeCreated": "2020-02-20 00:00:00",
                        "uniqueId": "str"
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str"
                    },
                    "tags": {
                        "str": "str"
                    },
                    "type": "str",
                    "zones": [
                        "str"
                    ]
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.Fleet]] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_fleets_list_by_subscription_request(
                    subscription_id=self._config.subscription_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.Fleet], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.ErrorResponse, response.json())
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace
    def list_virtual_machine_scale_sets(
        self, resource_group_name: str, name: str, **kwargs: Any
    ) -> AsyncIterable["_models.VirtualMachineScaleSet"]:
        """List VirtualMachineScaleSet resources by Fleet.

        :param resource_group_name: The name of the resource group. The name is case insensitive.
         Required.
        :type resource_group_name: str
        :param name: The name of the Fleet. Required.
        :type name: str
        :return: An iterator like instance of VirtualMachineScaleSet
        :rtype:
         ~azure.core.async_paging.AsyncItemPaged[~azure.mgmt.computefleet.models.VirtualMachineScaleSet]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "id": "str",
                    "operationStatus": "str",
                    "error": {
                        "code": "str",
                        "details": [
                            {
                                "code": "str",
                                "message": "str",
                                "target": "str"
                            }
                        ],
                        "innererror": {
                            "errorDetail": "str",
                            "exceptionType": "str"
                        },
                        "message": "str",
                        "target": "str"
                    },
                    "type": "str"
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[List[_models.VirtualMachineScaleSet]] = kwargs.pop("cls", None)

        error_map: MutableMapping[int, Type[HttpResponseError]] = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                _request = build_fleets_list_virtual_machine_scale_sets_request(
                    resource_group_name=resource_group_name,
                    name=name,
                    subscription_id=self._config.subscription_id,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                _request.url = self._client.format_url(_request.url)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                _request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                _request.url = self._client.format_url(_request.url)

            return _request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = _deserialize(List[_models.VirtualMachineScaleSet], deserialized["value"])
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            _request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                _request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                error = _deserialize(_models.ErrorResponse, response.json())
                raise HttpResponseError(response=response, model=error, error_format=ARMErrorFormat)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)
