# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.compute.aio import ComputeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestComputeManagementVirtualMachineScaleSetsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ComputeManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.virtual_machine_scale_sets.begin_create_or_update(
                resource_group_name=resource_group.name,
                name="str",
                parameters={
                    "location": "str",
                    "id": "str",
                    "name": "str",
                    "overProvision": bool,
                    "provisioningState": "str",
                    "sku": {"capacity": 0, "name": "str", "tier": "str"},
                    "tags": {"str": "str"},
                    "type": "str",
                    "upgradePolicy": {"mode": "str"},
                    "virtualMachineProfile": {
                        "extensionProfile": {
                            "extensions": [
                                {
                                    "autoUpgradeMinorVersion": bool,
                                    "id": "str",
                                    "name": "str",
                                    "protectedSettings": {},
                                    "provisioningState": "str",
                                    "publisher": "str",
                                    "settings": {},
                                    "type": "str",
                                    "typeHandlerVersion": "str",
                                }
                            ]
                        },
                        "networkProfile": {
                            "networkInterfaceConfigurations": [
                                {
                                    "name": "str",
                                    "id": "str",
                                    "ipConfigurations": [
                                        {
                                            "name": "str",
                                            "id": "str",
                                            "loadBalancerBackendAddressPools": [{"id": "str"}],
                                            "loadBalancerInboundNatPools": [{"id": "str"}],
                                            "subnet": {"id": "str"},
                                        }
                                    ],
                                    "primary": bool,
                                }
                            ]
                        },
                        "osProfile": {
                            "adminPassword": "str",
                            "adminUsername": "str",
                            "computerNamePrefix": "str",
                            "customData": "str",
                            "linuxConfiguration": {
                                "disablePasswordAuthentication": bool,
                                "ssh": {"publicKeys": [{"keyData": "str", "path": "str"}]},
                            },
                            "secrets": [
                                {
                                    "sourceVault": {"id": "str"},
                                    "vaultCertificates": [{"certificateStore": "str", "certificateUrl": "str"}],
                                }
                            ],
                            "windowsConfiguration": {
                                "additionalUnattendContent": [
                                    {
                                        "componentName": "Microsoft-Windows-Shell-Setup",
                                        "content": "str",
                                        "passName": "OobeSystem",
                                        "settingName": "str",
                                    }
                                ],
                                "enableAutomaticUpdates": bool,
                                "provisionVMAgent": bool,
                                "timeZone": "str",
                                "winRM": {"listeners": [{"certificateUrl": "str", "protocol": "str"}]},
                            },
                        },
                        "storageProfile": {
                            "imageReference": {"offer": "str", "publisher": "str", "sku": "str", "version": "str"},
                            "osDisk": {
                                "createOption": "str",
                                "name": "str",
                                "caching": "str",
                                "image": {"uri": "str"},
                                "osType": "str",
                                "vhdContainers": ["str"],
                            },
                        },
                    },
                },
                api_version="2015-06-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete(self, resource_group):
        response = await (
            await self.client.virtual_machine_scale_sets.begin_delete(
                resource_group_name=resource_group.name,
                vm_scale_set_name="str",
                api_version="2015-06-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get(self, resource_group):
        response = await self.client.virtual_machine_scale_sets.get(
            resource_group_name=resource_group.name,
            vm_scale_set_name="str",
            api_version="2015-06-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_deallocate(self, resource_group):
        response = await (
            await self.client.virtual_machine_scale_sets.begin_deallocate(
                resource_group_name=resource_group.name,
                vm_scale_set_name="str",
                api_version="2015-06-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_delete_instances(self, resource_group):
        response = await (
            await self.client.virtual_machine_scale_sets.begin_delete_instances(
                resource_group_name=resource_group.name,
                vm_scale_set_name="str",
                vm_instance_i_ds={"instanceIds": ["str"]},
                api_version="2015-06-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_get_instance_view(self, resource_group):
        response = await self.client.virtual_machine_scale_sets.get_instance_view(
            resource_group_name=resource_group.name,
            vm_scale_set_name="str",
            api_version="2015-06-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list(self, resource_group):
        response = self.client.virtual_machine_scale_sets.list(
            resource_group_name=resource_group.name,
            api_version="2015-06-15",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_all(self, resource_group):
        response = self.client.virtual_machine_scale_sets.list_all(
            api_version="2015-06-15",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_list_skus(self, resource_group):
        response = self.client.virtual_machine_scale_sets.list_skus(
            resource_group_name=resource_group.name,
            vm_scale_set_name="str",
            api_version="2015-06-15",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_power_off(self, resource_group):
        response = await (
            await self.client.virtual_machine_scale_sets.begin_power_off(
                resource_group_name=resource_group.name,
                vm_scale_set_name="str",
                api_version="2015-06-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_restart(self, resource_group):
        response = await (
            await self.client.virtual_machine_scale_sets.begin_restart(
                resource_group_name=resource_group.name,
                vm_scale_set_name="str",
                api_version="2015-06-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_start(self, resource_group):
        response = await (
            await self.client.virtual_machine_scale_sets.begin_start(
                resource_group_name=resource_group.name,
                vm_scale_set_name="str",
                api_version="2015-06-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_update_instances(self, resource_group):
        response = await (
            await self.client.virtual_machine_scale_sets.begin_update_instances(
                resource_group_name=resource_group.name,
                vm_scale_set_name="str",
                vm_instance_i_ds={"instanceIds": ["str"]},
                api_version="2015-06-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_begin_reimage(self, resource_group):
        response = await (
            await self.client.virtual_machine_scale_sets.begin_reimage(
                resource_group_name=resource_group.name,
                vm_scale_set_name="str",
                api_version="2015-06-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
