# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class QueryDTO(Model):
    """POST body schema to query the knowledgebase.

    :param qna_id: Exact qnaId to fetch from the knowledgebase, this field
     takes priority over question.
    :type qna_id: str
    :param question: User question to query against the knowledge base.
    :type question: str
    :param top: Max number of answers to be returned for the question.
    :type top: int
    :param user_id: Unique identifier for the user.
    :type user_id: str
    :param is_test: Query against the test index.
    :type is_test: bool
    :param score_threshold: Minimum threshold score for answers.
    :type score_threshold: float
    :param context: Context object with previous QnA's information.
    :type context:
     ~azure.cognitiveservices.knowledge.qnamaker.models.QueryDTOContext
    :param ranker_type: Optional field. Set to 'QuestionOnly' for using a
     question only Ranker.
    :type ranker_type: str
    :param strict_filters: Find QnAs that are associated with the given list
     of metadata.
    :type strict_filters:
     list[~azure.cognitiveservices.knowledge.qnamaker.models.MetadataDTO]
    :param strict_filters_compound_operation_type: Optional field. Set to 'OR'
     for using OR operation for strict filters. Possible values include: 'AND',
     'OR'
    :type strict_filters_compound_operation_type: str or
     ~azure.cognitiveservices.knowledge.qnamaker.models.StrictFiltersCompoundOperationType
    :param answer_span_request: To configure Answer span prediction feature.
    :type answer_span_request:
     ~azure.cognitiveservices.knowledge.qnamaker.models.QueryDTOAnswerSpanRequest
    """

    _attribute_map = {
        'qna_id': {'key': 'qnaId', 'type': 'str'},
        'question': {'key': 'question', 'type': 'str'},
        'top': {'key': 'top', 'type': 'int'},
        'user_id': {'key': 'userId', 'type': 'str'},
        'is_test': {'key': 'isTest', 'type': 'bool'},
        'score_threshold': {'key': 'scoreThreshold', 'type': 'float'},
        'context': {'key': 'context', 'type': 'QueryDTOContext'},
        'ranker_type': {'key': 'rankerType', 'type': 'str'},
        'strict_filters': {'key': 'strictFilters', 'type': '[MetadataDTO]'},
        'strict_filters_compound_operation_type': {'key': 'strictFiltersCompoundOperationType', 'type': 'str'},
        'answer_span_request': {'key': 'answerSpanRequest', 'type': 'QueryDTOAnswerSpanRequest'},
    }

    def __init__(self, *, qna_id: str=None, question: str=None, top: int=None, user_id: str=None, is_test: bool=None, score_threshold: float=None, context=None, ranker_type: str=None, strict_filters=None, strict_filters_compound_operation_type=None, answer_span_request=None, **kwargs) -> None:
        super(QueryDTO, self).__init__(**kwargs)
        self.qna_id = qna_id
        self.question = question
        self.top = top
        self.user_id = user_id
        self.is_test = is_test
        self.score_threshold = score_threshold
        self.context = context
        self.ranker_type = ranker_type
        self.strict_filters = strict_filters
        self.strict_filters_compound_operation_type = strict_filters_compound_operation_type
        self.answer_span_request = answer_span_request
