# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class ApplicationInsightsAgentVersions(_serialization.Model):
    """Application Insights agent versions properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar java: Indicates the version of application insight java agent.
    :vartype java: str
    """

    _validation = {
        "java": {"readonly": True},
    }

    _attribute_map = {
        "java": {"key": "java", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.java = None


class Resource(_serialization.Model):
    """The core properties of ARM resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have everything other than
    required location and tags.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    """


class AppResource(ProxyResource):
    """App resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar properties: Properties of the App resource.
    :vartype properties: ~azure.mgmt.appplatform.v2020_11_01_preview.models.AppResourceProperties
    :ivar identity: The Managed Identity type of the app resource.
    :vartype identity: ~azure.mgmt.appplatform.v2020_11_01_preview.models.ManagedIdentityProperties
    :ivar location: The GEO location of the application, always the same with its parent resource.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "AppResourceProperties"},
        "identity": {"key": "identity", "type": "ManagedIdentityProperties"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.AppResourceProperties"] = None,
        identity: Optional["_models.ManagedIdentityProperties"] = None,
        location: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: Properties of the App resource.
        :paramtype properties: ~azure.mgmt.appplatform.v2020_11_01_preview.models.AppResourceProperties
        :keyword identity: The Managed Identity type of the app resource.
        :paramtype identity:
         ~azure.mgmt.appplatform.v2020_11_01_preview.models.ManagedIdentityProperties
        :keyword location: The GEO location of the application, always the same with its parent
         resource.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.identity = identity
        self.location = location


class AppResourceCollection(_serialization.Model):
    """Object that includes an array of App resources and a possible link for next set.

    :ivar value: Collection of App resources.
    :vartype value: list[~azure.mgmt.appplatform.v2020_11_01_preview.models.AppResource]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AppResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.AppResource"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of App resources.
        :paramtype value: list[~azure.mgmt.appplatform.v2020_11_01_preview.models.AppResource]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AppResourceProperties(_serialization.Model):
    """App resource properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar public: Indicates whether the App exposes public endpoint.
    :vartype public: bool
    :ivar url: URL of the App.
    :vartype url: str
    :ivar provisioning_state: Provisioning state of the App. Known values are: "Succeeded",
     "Failed", "Creating", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2020_11_01_preview.models.AppResourceProvisioningState
    :ivar active_deployment_name: Name of the active deployment of the App.
    :vartype active_deployment_name: str
    :ivar fqdn: Fully qualified dns Name.
    :vartype fqdn: str
    :ivar https_only: Indicate if only https is allowed.
    :vartype https_only: bool
    :ivar created_time: Date time when the resource is created.
    :vartype created_time: ~datetime.datetime
    :ivar temporary_disk: Temporary disk settings.
    :vartype temporary_disk: ~azure.mgmt.appplatform.v2020_11_01_preview.models.TemporaryDisk
    :ivar persistent_disk: Persistent disk settings.
    :vartype persistent_disk: ~azure.mgmt.appplatform.v2020_11_01_preview.models.PersistentDisk
    :ivar enable_end_to_end_tls: Indicate if end to end TLS is enabled.
    :vartype enable_end_to_end_tls: bool
    """

    _validation = {
        "url": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "created_time": {"readonly": True},
    }

    _attribute_map = {
        "public": {"key": "public", "type": "bool"},
        "url": {"key": "url", "type": "str"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "active_deployment_name": {"key": "activeDeploymentName", "type": "str"},
        "fqdn": {"key": "fqdn", "type": "str"},
        "https_only": {"key": "httpsOnly", "type": "bool"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "temporary_disk": {"key": "temporaryDisk", "type": "TemporaryDisk"},
        "persistent_disk": {"key": "persistentDisk", "type": "PersistentDisk"},
        "enable_end_to_end_tls": {"key": "enableEndToEndTLS", "type": "bool"},
    }

    def __init__(
        self,
        *,
        public: Optional[bool] = None,
        active_deployment_name: Optional[str] = None,
        fqdn: Optional[str] = None,
        https_only: bool = False,
        temporary_disk: Optional["_models.TemporaryDisk"] = None,
        persistent_disk: Optional["_models.PersistentDisk"] = None,
        enable_end_to_end_tls: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword public: Indicates whether the App exposes public endpoint.
        :paramtype public: bool
        :keyword active_deployment_name: Name of the active deployment of the App.
        :paramtype active_deployment_name: str
        :keyword fqdn: Fully qualified dns Name.
        :paramtype fqdn: str
        :keyword https_only: Indicate if only https is allowed.
        :paramtype https_only: bool
        :keyword temporary_disk: Temporary disk settings.
        :paramtype temporary_disk: ~azure.mgmt.appplatform.v2020_11_01_preview.models.TemporaryDisk
        :keyword persistent_disk: Persistent disk settings.
        :paramtype persistent_disk: ~azure.mgmt.appplatform.v2020_11_01_preview.models.PersistentDisk
        :keyword enable_end_to_end_tls: Indicate if end to end TLS is enabled.
        :paramtype enable_end_to_end_tls: bool
        """
        super().__init__(**kwargs)
        self.public = public
        self.url = None
        self.provisioning_state = None
        self.active_deployment_name = active_deployment_name
        self.fqdn = fqdn
        self.https_only = https_only
        self.created_time = None
        self.temporary_disk = temporary_disk
        self.persistent_disk = persistent_disk
        self.enable_end_to_end_tls = enable_end_to_end_tls


class AvailableOperations(_serialization.Model):
    """Available operations of the service.

    :ivar value: Collection of available operation details.
    :vartype value: list[~azure.mgmt.appplatform.v2020_11_01_preview.models.OperationDetail]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[OperationDetail]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.OperationDetail"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of available operation details.
        :paramtype value: list[~azure.mgmt.appplatform.v2020_11_01_preview.models.OperationDetail]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AvailableRuntimeVersions(_serialization.Model):
    """AvailableRuntimeVersions.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of all supported runtime versions.
    :vartype value:
     list[~azure.mgmt.appplatform.v2020_11_01_preview.models.SupportedRuntimeVersion]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SupportedRuntimeVersion]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class BindingResource(ProxyResource):
    """Binding resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar properties: Properties of the Binding resource.
    :vartype properties:
     ~azure.mgmt.appplatform.v2020_11_01_preview.models.BindingResourceProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "BindingResourceProperties"},
    }

    def __init__(self, *, properties: Optional["_models.BindingResourceProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of the Binding resource.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2020_11_01_preview.models.BindingResourceProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class BindingResourceCollection(_serialization.Model):
    """Object that includes an array of Binding resources and a possible link for next set.

    :ivar value: Collection of Binding resources.
    :vartype value: list[~azure.mgmt.appplatform.v2020_11_01_preview.models.BindingResource]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BindingResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.BindingResource"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of Binding resources.
        :paramtype value: list[~azure.mgmt.appplatform.v2020_11_01_preview.models.BindingResource]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BindingResourceProperties(_serialization.Model):
    """Binding resource properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_name: The name of the bound resource.
    :vartype resource_name: str
    :ivar resource_type: The standard Azure resource type of the bound resource.
    :vartype resource_type: str
    :ivar resource_id: The Azure resource id of the bound resource.
    :vartype resource_id: str
    :ivar key: The key of the bound resource.
    :vartype key: str
    :ivar binding_parameters: Binding parameters of the Binding resource.
    :vartype binding_parameters: dict[str, JSON]
    :ivar generated_properties: The generated Spring Boot property file for this binding. The
     secret will be deducted.
    :vartype generated_properties: str
    :ivar created_at: Creation time of the Binding resource.
    :vartype created_at: str
    :ivar updated_at: Update time of the Binding resource.
    :vartype updated_at: str
    """

    _validation = {
        "resource_name": {"readonly": True},
        "resource_type": {"readonly": True},
        "generated_properties": {"readonly": True},
        "created_at": {"readonly": True},
        "updated_at": {"readonly": True},
    }

    _attribute_map = {
        "resource_name": {"key": "resourceName", "type": "str"},
        "resource_type": {"key": "resourceType", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "key": {"key": "key", "type": "str"},
        "binding_parameters": {"key": "bindingParameters", "type": "{object}"},
        "generated_properties": {"key": "generatedProperties", "type": "str"},
        "created_at": {"key": "createdAt", "type": "str"},
        "updated_at": {"key": "updatedAt", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        key: Optional[str] = None,
        binding_parameters: Optional[Dict[str, JSON]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The Azure resource id of the bound resource.
        :paramtype resource_id: str
        :keyword key: The key of the bound resource.
        :paramtype key: str
        :keyword binding_parameters: Binding parameters of the Binding resource.
        :paramtype binding_parameters: dict[str, JSON]
        """
        super().__init__(**kwargs)
        self.resource_name = None
        self.resource_type = None
        self.resource_id = resource_id
        self.key = key
        self.binding_parameters = binding_parameters
        self.generated_properties = None
        self.created_at = None
        self.updated_at = None


class CertificateProperties(_serialization.Model):
    """Certificate resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar thumbprint: The thumbprint of certificate.
    :vartype thumbprint: str
    :ivar vault_uri: The vault uri of user key vault. Required.
    :vartype vault_uri: str
    :ivar key_vault_cert_name: The certificate name of key vault. Required.
    :vartype key_vault_cert_name: str
    :ivar cert_version: The certificate version of key vault.
    :vartype cert_version: str
    :ivar issuer: The issuer of certificate.
    :vartype issuer: str
    :ivar issued_date: The issue date of certificate.
    :vartype issued_date: str
    :ivar expiration_date: The expiration date of certificate.
    :vartype expiration_date: str
    :ivar activate_date: The activate date of certificate.
    :vartype activate_date: str
    :ivar subject_name: The subject name of certificate.
    :vartype subject_name: str
    :ivar dns_names: The domain list of certificate.
    :vartype dns_names: list[str]
    """

    _validation = {
        "thumbprint": {"readonly": True},
        "vault_uri": {"required": True},
        "key_vault_cert_name": {"required": True},
        "issuer": {"readonly": True},
        "issued_date": {"readonly": True},
        "expiration_date": {"readonly": True},
        "activate_date": {"readonly": True},
        "subject_name": {"readonly": True},
        "dns_names": {"readonly": True},
    }

    _attribute_map = {
        "thumbprint": {"key": "thumbprint", "type": "str"},
        "vault_uri": {"key": "vaultUri", "type": "str"},
        "key_vault_cert_name": {"key": "keyVaultCertName", "type": "str"},
        "cert_version": {"key": "certVersion", "type": "str"},
        "issuer": {"key": "issuer", "type": "str"},
        "issued_date": {"key": "issuedDate", "type": "str"},
        "expiration_date": {"key": "expirationDate", "type": "str"},
        "activate_date": {"key": "activateDate", "type": "str"},
        "subject_name": {"key": "subjectName", "type": "str"},
        "dns_names": {"key": "dnsNames", "type": "[str]"},
    }

    def __init__(
        self, *, vault_uri: str, key_vault_cert_name: str, cert_version: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword vault_uri: The vault uri of user key vault. Required.
        :paramtype vault_uri: str
        :keyword key_vault_cert_name: The certificate name of key vault. Required.
        :paramtype key_vault_cert_name: str
        :keyword cert_version: The certificate version of key vault.
        :paramtype cert_version: str
        """
        super().__init__(**kwargs)
        self.thumbprint = None
        self.vault_uri = vault_uri
        self.key_vault_cert_name = key_vault_cert_name
        self.cert_version = cert_version
        self.issuer = None
        self.issued_date = None
        self.expiration_date = None
        self.activate_date = None
        self.subject_name = None
        self.dns_names = None


class CertificateResource(ProxyResource):
    """Certificate resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar properties: Properties of the certificate resource payload.
    :vartype properties: ~azure.mgmt.appplatform.v2020_11_01_preview.models.CertificateProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "CertificateProperties"},
    }

    def __init__(self, *, properties: Optional["_models.CertificateProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of the certificate resource payload.
        :paramtype properties: ~azure.mgmt.appplatform.v2020_11_01_preview.models.CertificateProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class CertificateResourceCollection(_serialization.Model):
    """Collection compose of certificate resources list and a possible link for next page.

    :ivar value: The certificate resources list.
    :vartype value: list[~azure.mgmt.appplatform.v2020_11_01_preview.models.CertificateResource]
    :ivar next_link: The link to next page of certificate list.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[CertificateResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.CertificateResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The certificate resources list.
        :paramtype value: list[~azure.mgmt.appplatform.v2020_11_01_preview.models.CertificateResource]
        :keyword next_link: The link to next page of certificate list.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CloudErrorBody(_serialization.Model):
    """An error response from the service.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    :ivar target: The target of the particular error. For example, the name of the property in
     error.
    :vartype target: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~azure.mgmt.appplatform.v2020_11_01_preview.models.CloudErrorBody]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.CloudErrorBody"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: An identifier for the error. Codes are invariant and are intended to be consumed
         programmatically.
        :paramtype code: str
        :keyword message: A message describing the error, intended to be suitable for display in a user
         interface.
        :paramtype message: str
        :keyword target: The target of the particular error. For example, the name of the property in
         error.
        :paramtype target: str
        :keyword details: A list of additional details about the error.
        :paramtype details: list[~azure.mgmt.appplatform.v2020_11_01_preview.models.CloudErrorBody]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class ClusterResourceProperties(_serialization.Model):
    """Service properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: Provisioning state of the Service. Known values are: "Creating",
     "Updating", "Deleting", "Deleted", "Succeeded", "Failed", "Moving", "Moved", and "MoveFailed".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2020_11_01_preview.models.ProvisioningState
    :ivar network_profile: Network profile of the Service.
    :vartype network_profile: ~azure.mgmt.appplatform.v2020_11_01_preview.models.NetworkProfile
    :ivar version: Version of the Service.
    :vartype version: int
    :ivar service_id: ServiceInstanceEntity Id which uniquely identifies a created resource.
    :vartype service_id: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "version": {"readonly": True},
        "service_id": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "network_profile": {"key": "networkProfile", "type": "NetworkProfile"},
        "version": {"key": "version", "type": "int"},
        "service_id": {"key": "serviceId", "type": "str"},
    }

    def __init__(self, *, network_profile: Optional["_models.NetworkProfile"] = None, **kwargs: Any) -> None:
        """
        :keyword network_profile: Network profile of the Service.
        :paramtype network_profile: ~azure.mgmt.appplatform.v2020_11_01_preview.models.NetworkProfile
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.network_profile = network_profile
        self.version = None
        self.service_id = None


class ConfigServerGitProperty(_serialization.Model):
    """Property of git.

    All required parameters must be populated in order to send to server.

    :ivar repositories: Repositories of git.
    :vartype repositories:
     list[~azure.mgmt.appplatform.v2020_11_01_preview.models.GitPatternRepository]
    :ivar uri: URI of the repository. Required.
    :vartype uri: str
    :ivar label: Label of the repository.
    :vartype label: str
    :ivar search_paths: Searching path of the repository.
    :vartype search_paths: list[str]
    :ivar username: Username of git repository basic auth.
    :vartype username: str
    :ivar password: Password of git repository basic auth.
    :vartype password: str
    :ivar host_key: Public sshKey of git repository.
    :vartype host_key: str
    :ivar host_key_algorithm: SshKey algorithm of git repository.
    :vartype host_key_algorithm: str
    :ivar private_key: Private sshKey algorithm of git repository.
    :vartype private_key: str
    :ivar strict_host_key_checking: Strict host key checking or not.
    :vartype strict_host_key_checking: bool
    """

    _validation = {
        "uri": {"required": True},
    }

    _attribute_map = {
        "repositories": {"key": "repositories", "type": "[GitPatternRepository]"},
        "uri": {"key": "uri", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "search_paths": {"key": "searchPaths", "type": "[str]"},
        "username": {"key": "username", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "host_key": {"key": "hostKey", "type": "str"},
        "host_key_algorithm": {"key": "hostKeyAlgorithm", "type": "str"},
        "private_key": {"key": "privateKey", "type": "str"},
        "strict_host_key_checking": {"key": "strictHostKeyChecking", "type": "bool"},
    }

    def __init__(
        self,
        *,
        uri: str,
        repositories: Optional[List["_models.GitPatternRepository"]] = None,
        label: Optional[str] = None,
        search_paths: Optional[List[str]] = None,
        username: Optional[str] = None,
        password: Optional[str] = None,
        host_key: Optional[str] = None,
        host_key_algorithm: Optional[str] = None,
        private_key: Optional[str] = None,
        strict_host_key_checking: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword repositories: Repositories of git.
        :paramtype repositories:
         list[~azure.mgmt.appplatform.v2020_11_01_preview.models.GitPatternRepository]
        :keyword uri: URI of the repository. Required.
        :paramtype uri: str
        :keyword label: Label of the repository.
        :paramtype label: str
        :keyword search_paths: Searching path of the repository.
        :paramtype search_paths: list[str]
        :keyword username: Username of git repository basic auth.
        :paramtype username: str
        :keyword password: Password of git repository basic auth.
        :paramtype password: str
        :keyword host_key: Public sshKey of git repository.
        :paramtype host_key: str
        :keyword host_key_algorithm: SshKey algorithm of git repository.
        :paramtype host_key_algorithm: str
        :keyword private_key: Private sshKey algorithm of git repository.
        :paramtype private_key: str
        :keyword strict_host_key_checking: Strict host key checking or not.
        :paramtype strict_host_key_checking: bool
        """
        super().__init__(**kwargs)
        self.repositories = repositories
        self.uri = uri
        self.label = label
        self.search_paths = search_paths
        self.username = username
        self.password = password
        self.host_key = host_key
        self.host_key_algorithm = host_key_algorithm
        self.private_key = private_key
        self.strict_host_key_checking = strict_host_key_checking


class ConfigServerProperties(_serialization.Model):
    """Config server git properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: State of the config server. Known values are: "NotAvailable",
     "Deleted", "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2020_11_01_preview.models.ConfigServerState
    :ivar error: Error when apply config server settings.
    :vartype error: ~azure.mgmt.appplatform.v2020_11_01_preview.models.Error
    :ivar config_server: Settings of config server.
    :vartype config_server: ~azure.mgmt.appplatform.v2020_11_01_preview.models.ConfigServerSettings
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "error": {"key": "error", "type": "Error"},
        "config_server": {"key": "configServer", "type": "ConfigServerSettings"},
    }

    def __init__(
        self,
        *,
        error: Optional["_models.Error"] = None,
        config_server: Optional["_models.ConfigServerSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error: Error when apply config server settings.
        :paramtype error: ~azure.mgmt.appplatform.v2020_11_01_preview.models.Error
        :keyword config_server: Settings of config server.
        :paramtype config_server:
         ~azure.mgmt.appplatform.v2020_11_01_preview.models.ConfigServerSettings
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.error = error
        self.config_server = config_server


class ConfigServerResource(ProxyResource):
    """Config Server resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar properties: Properties of the Config Server resource.
    :vartype properties: ~azure.mgmt.appplatform.v2020_11_01_preview.models.ConfigServerProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "ConfigServerProperties"},
    }

    def __init__(self, *, properties: Optional["_models.ConfigServerProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of the Config Server resource.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2020_11_01_preview.models.ConfigServerProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class ConfigServerSettings(_serialization.Model):
    """The settings of config server.

    :ivar git_property: Property of git environment.
    :vartype git_property:
     ~azure.mgmt.appplatform.v2020_11_01_preview.models.ConfigServerGitProperty
    """

    _attribute_map = {
        "git_property": {"key": "gitProperty", "type": "ConfigServerGitProperty"},
    }

    def __init__(self, *, git_property: Optional["_models.ConfigServerGitProperty"] = None, **kwargs: Any) -> None:
        """
        :keyword git_property: Property of git environment.
        :paramtype git_property:
         ~azure.mgmt.appplatform.v2020_11_01_preview.models.ConfigServerGitProperty
        """
        super().__init__(**kwargs)
        self.git_property = git_property


class ConfigServerSettingsErrorRecord(_serialization.Model):
    """Error record of the config server settings.

    :ivar name: The name of the config server settings error record.
    :vartype name: str
    :ivar uri: The uri of the config server settings error record.
    :vartype uri: str
    :ivar messages: The detail error messages of the record.
    :vartype messages: list[str]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "uri": {"key": "uri", "type": "str"},
        "messages": {"key": "messages", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        uri: Optional[str] = None,
        messages: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the config server settings error record.
        :paramtype name: str
        :keyword uri: The uri of the config server settings error record.
        :paramtype uri: str
        :keyword messages: The detail error messages of the record.
        :paramtype messages: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.uri = uri
        self.messages = messages


class ConfigServerSettingsValidateResult(_serialization.Model):
    """Validation result for config server settings.

    :ivar is_valid: Indicate if the config server settings are valid.
    :vartype is_valid: bool
    :ivar details: The detail validation results.
    :vartype details:
     list[~azure.mgmt.appplatform.v2020_11_01_preview.models.ConfigServerSettingsErrorRecord]
    """

    _attribute_map = {
        "is_valid": {"key": "isValid", "type": "bool"},
        "details": {"key": "details", "type": "[ConfigServerSettingsErrorRecord]"},
    }

    def __init__(
        self,
        *,
        is_valid: Optional[bool] = None,
        details: Optional[List["_models.ConfigServerSettingsErrorRecord"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_valid: Indicate if the config server settings are valid.
        :paramtype is_valid: bool
        :keyword details: The detail validation results.
        :paramtype details:
         list[~azure.mgmt.appplatform.v2020_11_01_preview.models.ConfigServerSettingsErrorRecord]
        """
        super().__init__(**kwargs)
        self.is_valid = is_valid
        self.details = details


class CustomDomainProperties(_serialization.Model):
    """Custom domain of app resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar thumbprint: The thumbprint of bound certificate.
    :vartype thumbprint: str
    :ivar app_name: The app name of domain.
    :vartype app_name: str
    :ivar cert_name: The bound certificate name of domain.
    :vartype cert_name: str
    """

    _validation = {
        "app_name": {"readonly": True},
    }

    _attribute_map = {
        "thumbprint": {"key": "thumbprint", "type": "str"},
        "app_name": {"key": "appName", "type": "str"},
        "cert_name": {"key": "certName", "type": "str"},
    }

    def __init__(self, *, thumbprint: Optional[str] = None, cert_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword thumbprint: The thumbprint of bound certificate.
        :paramtype thumbprint: str
        :keyword cert_name: The bound certificate name of domain.
        :paramtype cert_name: str
        """
        super().__init__(**kwargs)
        self.thumbprint = thumbprint
        self.app_name = None
        self.cert_name = cert_name


class CustomDomainResource(ProxyResource):
    """Custom domain resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar properties: Properties of the custom domain resource.
    :vartype properties: ~azure.mgmt.appplatform.v2020_11_01_preview.models.CustomDomainProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "CustomDomainProperties"},
    }

    def __init__(self, *, properties: Optional["_models.CustomDomainProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of the custom domain resource.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2020_11_01_preview.models.CustomDomainProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class CustomDomainResourceCollection(_serialization.Model):
    """Collection compose of a custom domain resources list and a possible link for next page.

    :ivar value: The custom domain resources list.
    :vartype value: list[~azure.mgmt.appplatform.v2020_11_01_preview.models.CustomDomainResource]
    :ivar next_link: The link to next page of custom domain list.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[CustomDomainResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.CustomDomainResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The custom domain resources list.
        :paramtype value: list[~azure.mgmt.appplatform.v2020_11_01_preview.models.CustomDomainResource]
        :keyword next_link: The link to next page of custom domain list.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CustomDomainValidatePayload(_serialization.Model):
    """Custom domain validate payload.

    All required parameters must be populated in order to send to server.

    :ivar name: Name to be validated. Required.
    :vartype name: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: Name to be validated. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class CustomDomainValidateResult(_serialization.Model):
    """Validation result for custom domain.

    :ivar is_valid: Indicates if domain name is valid.
    :vartype is_valid: bool
    :ivar message: Message of why domain name is invalid.
    :vartype message: str
    """

    _attribute_map = {
        "is_valid": {"key": "isValid", "type": "bool"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, is_valid: Optional[bool] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword is_valid: Indicates if domain name is valid.
        :paramtype is_valid: bool
        :keyword message: Message of why domain name is invalid.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.is_valid = is_valid
        self.message = message


class DeploymentInstance(_serialization.Model):
    """Deployment instance payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the deployment instance.
    :vartype name: str
    :ivar status: Status of the deployment instance.
    :vartype status: str
    :ivar reason: Failed reason of the deployment instance.
    :vartype reason: str
    :ivar discovery_status: Discovery status of the deployment instance.
    :vartype discovery_status: str
    :ivar start_time: Start time of the deployment instance.
    :vartype start_time: str
    """

    _validation = {
        "name": {"readonly": True},
        "status": {"readonly": True},
        "reason": {"readonly": True},
        "discovery_status": {"readonly": True},
        "start_time": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
        "discovery_status": {"key": "discoveryStatus", "type": "str"},
        "start_time": {"key": "startTime", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.status = None
        self.reason = None
        self.discovery_status = None
        self.start_time = None


class DeploymentResource(ProxyResource):
    """Deployment resource payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar properties: Properties of the Deployment resource.
    :vartype properties:
     ~azure.mgmt.appplatform.v2020_11_01_preview.models.DeploymentResourceProperties
    :ivar sku: Sku of the Deployment resource.
    :vartype sku: ~azure.mgmt.appplatform.v2020_11_01_preview.models.Sku
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "DeploymentResourceProperties"},
        "sku": {"key": "sku", "type": "Sku"},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.DeploymentResourceProperties"] = None,
        sku: Optional["_models.Sku"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword properties: Properties of the Deployment resource.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2020_11_01_preview.models.DeploymentResourceProperties
        :keyword sku: Sku of the Deployment resource.
        :paramtype sku: ~azure.mgmt.appplatform.v2020_11_01_preview.models.Sku
        """
        super().__init__(**kwargs)
        self.properties = properties
        self.sku = sku


class DeploymentResourceCollection(_serialization.Model):
    """Object that includes an array of App resources and a possible link for next set.

    :ivar value: Collection of Deployment resources.
    :vartype value: list[~azure.mgmt.appplatform.v2020_11_01_preview.models.DeploymentResource]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DeploymentResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.DeploymentResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of Deployment resources.
        :paramtype value: list[~azure.mgmt.appplatform.v2020_11_01_preview.models.DeploymentResource]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DeploymentResourceProperties(_serialization.Model):
    """Deployment resource properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar source: Uploaded source information of the deployment.
    :vartype source: ~azure.mgmt.appplatform.v2020_11_01_preview.models.UserSourceInfo
    :ivar app_name: App name of the deployment.
    :vartype app_name: str
    :ivar deployment_settings: Deployment settings of the Deployment.
    :vartype deployment_settings:
     ~azure.mgmt.appplatform.v2020_11_01_preview.models.DeploymentSettings
    :ivar provisioning_state: Provisioning state of the Deployment. Known values are: "Creating",
     "Updating", "Succeeded", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2020_11_01_preview.models.DeploymentResourceProvisioningState
    :ivar status: Status of the Deployment. Known values are: "Unknown", "Stopped", "Running",
     "Failed", "Allocating", "Upgrading", and "Compiling".
    :vartype status: str or
     ~azure.mgmt.appplatform.v2020_11_01_preview.models.DeploymentResourceStatus
    :ivar active: Indicates whether the Deployment is active.
    :vartype active: bool
    :ivar created_time: Date time when the resource is created.
    :vartype created_time: ~datetime.datetime
    :ivar instances: Collection of instances belong to the Deployment.
    :vartype instances: list[~azure.mgmt.appplatform.v2020_11_01_preview.models.DeploymentInstance]
    """

    _validation = {
        "app_name": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "active": {"readonly": True},
        "created_time": {"readonly": True},
        "instances": {"readonly": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "UserSourceInfo"},
        "app_name": {"key": "appName", "type": "str"},
        "deployment_settings": {"key": "deploymentSettings", "type": "DeploymentSettings"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "active": {"key": "active", "type": "bool"},
        "created_time": {"key": "createdTime", "type": "iso-8601"},
        "instances": {"key": "instances", "type": "[DeploymentInstance]"},
    }

    def __init__(
        self,
        *,
        source: Optional["_models.UserSourceInfo"] = None,
        deployment_settings: Optional["_models.DeploymentSettings"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword source: Uploaded source information of the deployment.
        :paramtype source: ~azure.mgmt.appplatform.v2020_11_01_preview.models.UserSourceInfo
        :keyword deployment_settings: Deployment settings of the Deployment.
        :paramtype deployment_settings:
         ~azure.mgmt.appplatform.v2020_11_01_preview.models.DeploymentSettings
        """
        super().__init__(**kwargs)
        self.source = source
        self.app_name = None
        self.deployment_settings = deployment_settings
        self.provisioning_state = None
        self.status = None
        self.active = None
        self.created_time = None
        self.instances = None


class DeploymentSettings(_serialization.Model):
    """Deployment settings payload.

    :ivar cpu: Required CPU, basic tier should be 1, standard tier should be in range (1, 4).
    :vartype cpu: int
    :ivar memory_in_gb: Required Memory size in GB, basic tier should be in range (1, 2), standard
     tier should be in range (1, 8).
    :vartype memory_in_gb: int
    :ivar jvm_options: JVM parameter.
    :vartype jvm_options: str
    :ivar net_core_main_entry_path: The path to the .NET executable relative to zip root.
    :vartype net_core_main_entry_path: str
    :ivar environment_variables: Collection of environment variables.
    :vartype environment_variables: dict[str, str]
    :ivar runtime_version: Runtime version. Known values are: "Java_8", "Java_11", and
     "NetCore_31".
    :vartype runtime_version: str or
     ~azure.mgmt.appplatform.v2020_11_01_preview.models.RuntimeVersion
    """

    _attribute_map = {
        "cpu": {"key": "cpu", "type": "int"},
        "memory_in_gb": {"key": "memoryInGB", "type": "int"},
        "jvm_options": {"key": "jvmOptions", "type": "str"},
        "net_core_main_entry_path": {"key": "netCoreMainEntryPath", "type": "str"},
        "environment_variables": {"key": "environmentVariables", "type": "{str}"},
        "runtime_version": {"key": "runtimeVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        cpu: int = 1,
        memory_in_gb: int = 1,
        jvm_options: Optional[str] = None,
        net_core_main_entry_path: Optional[str] = None,
        environment_variables: Optional[Dict[str, str]] = None,
        runtime_version: Union[str, "_models.RuntimeVersion"] = "Java_8",
        **kwargs: Any
    ) -> None:
        """
        :keyword cpu: Required CPU, basic tier should be 1, standard tier should be in range (1, 4).
        :paramtype cpu: int
        :keyword memory_in_gb: Required Memory size in GB, basic tier should be in range (1, 2),
         standard tier should be in range (1, 8).
        :paramtype memory_in_gb: int
        :keyword jvm_options: JVM parameter.
        :paramtype jvm_options: str
        :keyword net_core_main_entry_path: The path to the .NET executable relative to zip root.
        :paramtype net_core_main_entry_path: str
        :keyword environment_variables: Collection of environment variables.
        :paramtype environment_variables: dict[str, str]
        :keyword runtime_version: Runtime version. Known values are: "Java_8", "Java_11", and
         "NetCore_31".
        :paramtype runtime_version: str or
         ~azure.mgmt.appplatform.v2020_11_01_preview.models.RuntimeVersion
        """
        super().__init__(**kwargs)
        self.cpu = cpu
        self.memory_in_gb = memory_in_gb
        self.jvm_options = jvm_options
        self.net_core_main_entry_path = net_core_main_entry_path
        self.environment_variables = environment_variables
        self.runtime_version = runtime_version


class Error(_serialization.Model):
    """The error code compose of code and message.

    :ivar code: The code of error.
    :vartype code: str
    :ivar message: The message of error.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: The code of error.
        :paramtype code: str
        :keyword message: The message of error.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class GitPatternRepository(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Git repository property payload.

    All required parameters must be populated in order to send to server.

    :ivar name: Name of the repository. Required.
    :vartype name: str
    :ivar pattern: Collection of pattern of the repository.
    :vartype pattern: list[str]
    :ivar uri: URI of the repository. Required.
    :vartype uri: str
    :ivar label: Label of the repository.
    :vartype label: str
    :ivar search_paths: Searching path of the repository.
    :vartype search_paths: list[str]
    :ivar username: Username of git repository basic auth.
    :vartype username: str
    :ivar password: Password of git repository basic auth.
    :vartype password: str
    :ivar host_key: Public sshKey of git repository.
    :vartype host_key: str
    :ivar host_key_algorithm: SshKey algorithm of git repository.
    :vartype host_key_algorithm: str
    :ivar private_key: Private sshKey algorithm of git repository.
    :vartype private_key: str
    :ivar strict_host_key_checking: Strict host key checking or not.
    :vartype strict_host_key_checking: bool
    """

    _validation = {
        "name": {"required": True},
        "uri": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "pattern": {"key": "pattern", "type": "[str]"},
        "uri": {"key": "uri", "type": "str"},
        "label": {"key": "label", "type": "str"},
        "search_paths": {"key": "searchPaths", "type": "[str]"},
        "username": {"key": "username", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "host_key": {"key": "hostKey", "type": "str"},
        "host_key_algorithm": {"key": "hostKeyAlgorithm", "type": "str"},
        "private_key": {"key": "privateKey", "type": "str"},
        "strict_host_key_checking": {"key": "strictHostKeyChecking", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: str,
        uri: str,
        pattern: Optional[List[str]] = None,
        label: Optional[str] = None,
        search_paths: Optional[List[str]] = None,
        username: Optional[str] = None,
        password: Optional[str] = None,
        host_key: Optional[str] = None,
        host_key_algorithm: Optional[str] = None,
        private_key: Optional[str] = None,
        strict_host_key_checking: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the repository. Required.
        :paramtype name: str
        :keyword pattern: Collection of pattern of the repository.
        :paramtype pattern: list[str]
        :keyword uri: URI of the repository. Required.
        :paramtype uri: str
        :keyword label: Label of the repository.
        :paramtype label: str
        :keyword search_paths: Searching path of the repository.
        :paramtype search_paths: list[str]
        :keyword username: Username of git repository basic auth.
        :paramtype username: str
        :keyword password: Password of git repository basic auth.
        :paramtype password: str
        :keyword host_key: Public sshKey of git repository.
        :paramtype host_key: str
        :keyword host_key_algorithm: SshKey algorithm of git repository.
        :paramtype host_key_algorithm: str
        :keyword private_key: Private sshKey algorithm of git repository.
        :paramtype private_key: str
        :keyword strict_host_key_checking: Strict host key checking or not.
        :paramtype strict_host_key_checking: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.pattern = pattern
        self.uri = uri
        self.label = label
        self.search_paths = search_paths
        self.username = username
        self.password = password
        self.host_key = host_key
        self.host_key_algorithm = host_key_algorithm
        self.private_key = private_key
        self.strict_host_key_checking = strict_host_key_checking


class LogFileUrlResponse(_serialization.Model):
    """Log file URL payload.

    All required parameters must be populated in order to send to server.

    :ivar url: URL of the log file. Required.
    :vartype url: str
    """

    _validation = {
        "url": {"required": True},
    }

    _attribute_map = {
        "url": {"key": "url", "type": "str"},
    }

    def __init__(self, *, url: str, **kwargs: Any) -> None:
        """
        :keyword url: URL of the log file. Required.
        :paramtype url: str
        """
        super().__init__(**kwargs)
        self.url = url


class LogSpecification(_serialization.Model):
    """Specifications of the Log for Azure Monitoring.

    :ivar name: Name of the log.
    :vartype name: str
    :ivar display_name: Localized friendly display name of the log.
    :vartype display_name: str
    :ivar blob_duration: Blob duration of the log.
    :vartype blob_duration: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the log.
        :paramtype name: str
        :keyword display_name: Localized friendly display name of the log.
        :paramtype display_name: str
        :keyword blob_duration: Blob duration of the log.
        :paramtype blob_duration: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration


class ManagedIdentityProperties(_serialization.Model):
    """Managed identity properties retrieved from ARM request headers.

    :ivar type: Type of the managed identity. Known values are: "None", "SystemAssigned",
     "UserAssigned", and "SystemAssigned,UserAssigned".
    :vartype type: str or ~azure.mgmt.appplatform.v2020_11_01_preview.models.ManagedIdentityType
    :ivar principal_id: Principal Id.
    :vartype principal_id: str
    :ivar tenant_id: Tenant Id.
    :vartype tenant_id: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ManagedIdentityType"]] = None,
        principal_id: Optional[str] = None,
        tenant_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of the managed identity. Known values are: "None", "SystemAssigned",
         "UserAssigned", and "SystemAssigned,UserAssigned".
        :paramtype type: str or ~azure.mgmt.appplatform.v2020_11_01_preview.models.ManagedIdentityType
        :keyword principal_id: Principal Id.
        :paramtype principal_id: str
        :keyword tenant_id: Tenant Id.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.principal_id = principal_id
        self.tenant_id = tenant_id


class MetricDimension(_serialization.Model):
    """Specifications of the Dimension of metrics.

    :ivar name: Name of the dimension.
    :vartype name: str
    :ivar display_name: Localized friendly display name of the dimension.
    :vartype display_name: str
    :ivar to_be_exported_for_shoebox: Whether this dimension should be included for the Shoebox
     export scenario.
    :vartype to_be_exported_for_shoebox: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "to_be_exported_for_shoebox": {"key": "toBeExportedForShoebox", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        to_be_exported_for_shoebox: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the dimension.
        :paramtype name: str
        :keyword display_name: Localized friendly display name of the dimension.
        :paramtype display_name: str
        :keyword to_be_exported_for_shoebox: Whether this dimension should be included for the Shoebox
         export scenario.
        :paramtype to_be_exported_for_shoebox: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.to_be_exported_for_shoebox = to_be_exported_for_shoebox


class MetricSpecification(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Specifications of the Metrics for Azure Monitoring.

    :ivar name: Name of the metric.
    :vartype name: str
    :ivar display_name: Localized friendly display name of the metric.
    :vartype display_name: str
    :ivar display_description: Localized friendly description of the metric.
    :vartype display_description: str
    :ivar unit: Unit that makes sense for the metric.
    :vartype unit: str
    :ivar category: Name of the metric category that the metric belongs to. A metric can only
     belong to a single category.
    :vartype category: str
    :ivar aggregation_type: Only provide one value for this field. Valid values: Average, Minimum,
     Maximum, Total, Count.
    :vartype aggregation_type: str
    :ivar supported_aggregation_types: Supported aggregation types.
    :vartype supported_aggregation_types: list[str]
    :ivar supported_time_grain_types: Supported time grain types.
    :vartype supported_time_grain_types: list[str]
    :ivar fill_gap_with_zero: Optional. If set to true, then zero will be returned for time
     duration where no metric is emitted/published.
    :vartype fill_gap_with_zero: bool
    :ivar dimensions: Dimensions of the metric.
    :vartype dimensions: list[~azure.mgmt.appplatform.v2020_11_01_preview.models.MetricDimension]
    :ivar source_mdm_namespace: Name of the MDM namespace. Optional.
    :vartype source_mdm_namespace: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "category": {"key": "category", "type": "str"},
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "supported_aggregation_types": {"key": "supportedAggregationTypes", "type": "[str]"},
        "supported_time_grain_types": {"key": "supportedTimeGrainTypes", "type": "[str]"},
        "fill_gap_with_zero": {"key": "fillGapWithZero", "type": "bool"},
        "dimensions": {"key": "dimensions", "type": "[MetricDimension]"},
        "source_mdm_namespace": {"key": "sourceMdmNamespace", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        category: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        supported_aggregation_types: Optional[List[str]] = None,
        supported_time_grain_types: Optional[List[str]] = None,
        fill_gap_with_zero: Optional[bool] = None,
        dimensions: Optional[List["_models.MetricDimension"]] = None,
        source_mdm_namespace: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the metric.
        :paramtype name: str
        :keyword display_name: Localized friendly display name of the metric.
        :paramtype display_name: str
        :keyword display_description: Localized friendly description of the metric.
        :paramtype display_description: str
        :keyword unit: Unit that makes sense for the metric.
        :paramtype unit: str
        :keyword category: Name of the metric category that the metric belongs to. A metric can only
         belong to a single category.
        :paramtype category: str
        :keyword aggregation_type: Only provide one value for this field. Valid values: Average,
         Minimum, Maximum, Total, Count.
        :paramtype aggregation_type: str
        :keyword supported_aggregation_types: Supported aggregation types.
        :paramtype supported_aggregation_types: list[str]
        :keyword supported_time_grain_types: Supported time grain types.
        :paramtype supported_time_grain_types: list[str]
        :keyword fill_gap_with_zero: Optional. If set to true, then zero will be returned for time
         duration where no metric is emitted/published.
        :paramtype fill_gap_with_zero: bool
        :keyword dimensions: Dimensions of the metric.
        :paramtype dimensions: list[~azure.mgmt.appplatform.v2020_11_01_preview.models.MetricDimension]
        :keyword source_mdm_namespace: Name of the MDM namespace. Optional.
        :paramtype source_mdm_namespace: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.category = category
        self.aggregation_type = aggregation_type
        self.supported_aggregation_types = supported_aggregation_types
        self.supported_time_grain_types = supported_time_grain_types
        self.fill_gap_with_zero = fill_gap_with_zero
        self.dimensions = dimensions
        self.source_mdm_namespace = source_mdm_namespace


class MonitoringSettingProperties(_serialization.Model):
    """Monitoring Setting properties payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provisioning_state: State of the Monitoring Setting. Known values are: "NotAvailable",
     "Failed", "Succeeded", and "Updating".
    :vartype provisioning_state: str or
     ~azure.mgmt.appplatform.v2020_11_01_preview.models.MonitoringSettingState
    :ivar error: Error when apply Monitoring Setting changes.
    :vartype error: ~azure.mgmt.appplatform.v2020_11_01_preview.models.Error
    :ivar trace_enabled: Indicates whether enable the trace functionality, which will be deprecated
     since api version 2020-11-01-preview. Please leverage appInsightsInstrumentationKey to indicate
     if monitoringSettings enabled or not.
    :vartype trace_enabled: bool
    :ivar app_insights_instrumentation_key: Target application insight instrumentation key, null or
     whitespace include empty will disable monitoringSettings.
    :vartype app_insights_instrumentation_key: str
    :ivar app_insights_sampling_rate: Indicates the sampling rate of application insight agent,
     should be in range [0.0, 100.0].
    :vartype app_insights_sampling_rate: float
    :ivar app_insights_agent_versions: Indicates the versions of application insight agent.
    :vartype app_insights_agent_versions:
     ~azure.mgmt.appplatform.v2020_11_01_preview.models.ApplicationInsightsAgentVersions
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "app_insights_sampling_rate": {"maximum": 100, "minimum": 0},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "error": {"key": "error", "type": "Error"},
        "trace_enabled": {"key": "traceEnabled", "type": "bool"},
        "app_insights_instrumentation_key": {"key": "appInsightsInstrumentationKey", "type": "str"},
        "app_insights_sampling_rate": {"key": "appInsightsSamplingRate", "type": "float"},
        "app_insights_agent_versions": {"key": "appInsightsAgentVersions", "type": "ApplicationInsightsAgentVersions"},
    }

    def __init__(
        self,
        *,
        error: Optional["_models.Error"] = None,
        trace_enabled: Optional[bool] = None,
        app_insights_instrumentation_key: Optional[str] = None,
        app_insights_sampling_rate: Optional[float] = None,
        app_insights_agent_versions: Optional["_models.ApplicationInsightsAgentVersions"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword error: Error when apply Monitoring Setting changes.
        :paramtype error: ~azure.mgmt.appplatform.v2020_11_01_preview.models.Error
        :keyword trace_enabled: Indicates whether enable the trace functionality, which will be
         deprecated since api version 2020-11-01-preview. Please leverage appInsightsInstrumentationKey
         to indicate if monitoringSettings enabled or not.
        :paramtype trace_enabled: bool
        :keyword app_insights_instrumentation_key: Target application insight instrumentation key, null
         or whitespace include empty will disable monitoringSettings.
        :paramtype app_insights_instrumentation_key: str
        :keyword app_insights_sampling_rate: Indicates the sampling rate of application insight agent,
         should be in range [0.0, 100.0].
        :paramtype app_insights_sampling_rate: float
        :keyword app_insights_agent_versions: Indicates the versions of application insight agent.
        :paramtype app_insights_agent_versions:
         ~azure.mgmt.appplatform.v2020_11_01_preview.models.ApplicationInsightsAgentVersions
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.error = error
        self.trace_enabled = trace_enabled
        self.app_insights_instrumentation_key = app_insights_instrumentation_key
        self.app_insights_sampling_rate = app_insights_sampling_rate
        self.app_insights_agent_versions = app_insights_agent_versions


class MonitoringSettingResource(ProxyResource):
    """Monitoring Setting resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar properties: Properties of the Monitoring Setting resource.
    :vartype properties:
     ~azure.mgmt.appplatform.v2020_11_01_preview.models.MonitoringSettingProperties
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "MonitoringSettingProperties"},
    }

    def __init__(self, *, properties: Optional["_models.MonitoringSettingProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword properties: Properties of the Monitoring Setting resource.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2020_11_01_preview.models.MonitoringSettingProperties
        """
        super().__init__(**kwargs)
        self.properties = properties


class NameAvailability(_serialization.Model):
    """Name availability result payload.

    :ivar name_available: Indicates whether the name is available.
    :vartype name_available: bool
    :ivar reason: Reason why the name is not available.
    :vartype reason: str
    :ivar message: Message why the name is not available.
    :vartype message: str
    """

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "reason": {"key": "reason", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self,
        *,
        name_available: Optional[bool] = None,
        reason: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name_available: Indicates whether the name is available.
        :paramtype name_available: bool
        :keyword reason: Reason why the name is not available.
        :paramtype reason: str
        :keyword message: Message why the name is not available.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.name_available = name_available
        self.reason = reason
        self.message = message


class NameAvailabilityParameters(_serialization.Model):
    """Name availability parameters payload.

    All required parameters must be populated in order to send to server.

    :ivar type: Type of the resource to check name availability. Required.
    :vartype type: str
    :ivar name: Name to be checked. Required.
    :vartype name: str
    """

    _validation = {
        "type": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, type: str, name: str, **kwargs: Any) -> None:
        """
        :keyword type: Type of the resource to check name availability. Required.
        :paramtype type: str
        :keyword name: Name to be checked. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.name = name


class NetworkProfile(_serialization.Model):
    """Service network profile payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar service_runtime_subnet_id: Fully qualified resource Id of the subnet to host Azure Spring
     Cloud Service Runtime.
    :vartype service_runtime_subnet_id: str
    :ivar app_subnet_id: Fully qualified resource Id of the subnet to host Azure Spring Cloud Apps.
    :vartype app_subnet_id: str
    :ivar service_cidr: Azure Spring Cloud service reserved CIDR.
    :vartype service_cidr: str
    :ivar service_runtime_network_resource_group: Name of the resource group containing network
     resources of Azure Spring Cloud Service Runtime.
    :vartype service_runtime_network_resource_group: str
    :ivar app_network_resource_group: Name of the resource group containing network resources of
     Azure Spring Cloud Apps.
    :vartype app_network_resource_group: str
    :ivar outbound_i_ps: Desired outbound IP resources for Azure Spring Cloud instance.
    :vartype outbound_i_ps:
     ~azure.mgmt.appplatform.v2020_11_01_preview.models.NetworkProfileOutboundIPs
    :ivar required_traffics: Required inbound or outbound traffics for Azure Spring Cloud instance.
    :vartype required_traffics:
     list[~azure.mgmt.appplatform.v2020_11_01_preview.models.RequiredTraffic]
    """

    _validation = {
        "outbound_i_ps": {"readonly": True},
        "required_traffics": {"readonly": True},
    }

    _attribute_map = {
        "service_runtime_subnet_id": {"key": "serviceRuntimeSubnetId", "type": "str"},
        "app_subnet_id": {"key": "appSubnetId", "type": "str"},
        "service_cidr": {"key": "serviceCidr", "type": "str"},
        "service_runtime_network_resource_group": {"key": "serviceRuntimeNetworkResourceGroup", "type": "str"},
        "app_network_resource_group": {"key": "appNetworkResourceGroup", "type": "str"},
        "outbound_i_ps": {"key": "outboundIPs", "type": "NetworkProfileOutboundIPs"},
        "required_traffics": {"key": "requiredTraffics", "type": "[RequiredTraffic]"},
    }

    def __init__(
        self,
        *,
        service_runtime_subnet_id: Optional[str] = None,
        app_subnet_id: Optional[str] = None,
        service_cidr: Optional[str] = None,
        service_runtime_network_resource_group: Optional[str] = None,
        app_network_resource_group: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword service_runtime_subnet_id: Fully qualified resource Id of the subnet to host Azure
         Spring Cloud Service Runtime.
        :paramtype service_runtime_subnet_id: str
        :keyword app_subnet_id: Fully qualified resource Id of the subnet to host Azure Spring Cloud
         Apps.
        :paramtype app_subnet_id: str
        :keyword service_cidr: Azure Spring Cloud service reserved CIDR.
        :paramtype service_cidr: str
        :keyword service_runtime_network_resource_group: Name of the resource group containing network
         resources of Azure Spring Cloud Service Runtime.
        :paramtype service_runtime_network_resource_group: str
        :keyword app_network_resource_group: Name of the resource group containing network resources of
         Azure Spring Cloud Apps.
        :paramtype app_network_resource_group: str
        """
        super().__init__(**kwargs)
        self.service_runtime_subnet_id = service_runtime_subnet_id
        self.app_subnet_id = app_subnet_id
        self.service_cidr = service_cidr
        self.service_runtime_network_resource_group = service_runtime_network_resource_group
        self.app_network_resource_group = app_network_resource_group
        self.outbound_i_ps = None
        self.required_traffics = None


class NetworkProfileOutboundIPs(_serialization.Model):
    """Desired outbound IP resources for Azure Spring Cloud instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar public_i_ps: A list of public IP addresses.
    :vartype public_i_ps: list[str]
    """

    _validation = {
        "public_i_ps": {"readonly": True},
    }

    _attribute_map = {
        "public_i_ps": {"key": "publicIPs", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.public_i_ps = None


class OperationDetail(_serialization.Model):
    """Operation detail payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the operation.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar display: Display of the operation.
    :vartype display: ~azure.mgmt.appplatform.v2020_11_01_preview.models.OperationDisplay
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.appplatform.v2020_11_01_preview.models.ActionType
    :ivar origin: Origin of the operation.
    :vartype origin: str
    :ivar properties: Properties of the operation.
    :vartype properties: ~azure.mgmt.appplatform.v2020_11_01_preview.models.OperationProperties
    """

    _validation = {
        "action_type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "action_type": {"key": "actionType", "type": "str"},
        "origin": {"key": "origin", "type": "str"},
        "properties": {"key": "properties", "type": "OperationProperties"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["_models.OperationDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional["_models.OperationProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the operation.
        :paramtype name: str
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        :keyword display: Display of the operation.
        :paramtype display: ~azure.mgmt.appplatform.v2020_11_01_preview.models.OperationDisplay
        :keyword origin: Origin of the operation.
        :paramtype origin: str
        :keyword properties: Properties of the operation.
        :paramtype properties: ~azure.mgmt.appplatform.v2020_11_01_preview.models.OperationProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.display = display
        self.action_type = None
        self.origin = origin
        self.properties = properties


class OperationDisplay(_serialization.Model):
    """Operation display payload.

    :ivar provider: Resource provider of the operation.
    :vartype provider: str
    :ivar resource: Resource of the operation.
    :vartype resource: str
    :ivar operation: Localized friendly name for the operation.
    :vartype operation: str
    :ivar description: Localized friendly description for the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Resource provider of the operation.
        :paramtype provider: str
        :keyword resource: Resource of the operation.
        :paramtype resource: str
        :keyword operation: Localized friendly name for the operation.
        :paramtype operation: str
        :keyword description: Localized friendly description for the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationProperties(_serialization.Model):
    """Extra Operation properties.

    :ivar service_specification: Service specifications of the operation.
    :vartype service_specification:
     ~azure.mgmt.appplatform.v2020_11_01_preview.models.ServiceSpecification
    """

    _attribute_map = {
        "service_specification": {"key": "serviceSpecification", "type": "ServiceSpecification"},
    }

    def __init__(
        self, *, service_specification: Optional["_models.ServiceSpecification"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword service_specification: Service specifications of the operation.
        :paramtype service_specification:
         ~azure.mgmt.appplatform.v2020_11_01_preview.models.ServiceSpecification
        """
        super().__init__(**kwargs)
        self.service_specification = service_specification


class PersistentDisk(_serialization.Model):
    """Persistent disk payload.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar size_in_gb: Size of the persistent disk in GB.
    :vartype size_in_gb: int
    :ivar used_in_gb: Size of the used persistent disk in GB.
    :vartype used_in_gb: int
    :ivar mount_path: Mount path of the persistent disk.
    :vartype mount_path: str
    """

    _validation = {
        "size_in_gb": {"maximum": 50, "minimum": 0},
        "used_in_gb": {"readonly": True, "maximum": 50, "minimum": 0},
    }

    _attribute_map = {
        "size_in_gb": {"key": "sizeInGB", "type": "int"},
        "used_in_gb": {"key": "usedInGB", "type": "int"},
        "mount_path": {"key": "mountPath", "type": "str"},
    }

    def __init__(self, *, size_in_gb: Optional[int] = None, mount_path: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword size_in_gb: Size of the persistent disk in GB.
        :paramtype size_in_gb: int
        :keyword mount_path: Mount path of the persistent disk.
        :paramtype mount_path: str
        """
        super().__init__(**kwargs)
        self.size_in_gb = size_in_gb
        self.used_in_gb = None
        self.mount_path = mount_path


class RegenerateTestKeyRequestPayload(_serialization.Model):
    """Regenerate test key request payload.

    All required parameters must be populated in order to send to server.

    :ivar key_type: Type of the test key. Required. Known values are: "Primary" and "Secondary".
    :vartype key_type: str or ~azure.mgmt.appplatform.v2020_11_01_preview.models.TestKeyType
    """

    _validation = {
        "key_type": {"required": True},
    }

    _attribute_map = {
        "key_type": {"key": "keyType", "type": "str"},
    }

    def __init__(self, *, key_type: Union[str, "_models.TestKeyType"], **kwargs: Any) -> None:
        """
        :keyword key_type: Type of the test key. Required. Known values are: "Primary" and "Secondary".
        :paramtype key_type: str or ~azure.mgmt.appplatform.v2020_11_01_preview.models.TestKeyType
        """
        super().__init__(**kwargs)
        self.key_type = key_type


class RequiredTraffic(_serialization.Model):
    """Required inbound or outbound traffic for Azure Spring Cloud instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar protocol: The protocol of required traffic.
    :vartype protocol: str
    :ivar port: The port of required traffic.
    :vartype port: int
    :ivar ips: The ip list of required traffic.
    :vartype ips: list[str]
    :ivar fqdns: The FQDN list of required traffic.
    :vartype fqdns: list[str]
    :ivar direction: The direction of required traffic. Known values are: "Inbound" and "Outbound".
    :vartype direction: str or ~azure.mgmt.appplatform.v2020_11_01_preview.models.TrafficDirection
    """

    _validation = {
        "protocol": {"readonly": True},
        "port": {"readonly": True},
        "ips": {"readonly": True},
        "fqdns": {"readonly": True},
        "direction": {"readonly": True},
    }

    _attribute_map = {
        "protocol": {"key": "protocol", "type": "str"},
        "port": {"key": "port", "type": "int"},
        "ips": {"key": "ips", "type": "[str]"},
        "fqdns": {"key": "fqdns", "type": "[str]"},
        "direction": {"key": "direction", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.protocol = None
        self.port = None
        self.ips = None
        self.fqdns = None
        self.direction = None


class ResourceSku(_serialization.Model):
    """Describes an available Azure Spring Cloud SKU.

    :ivar resource_type: Gets the type of resource the SKU applies to.
    :vartype resource_type: str
    :ivar name: Gets the name of SKU.
    :vartype name: str
    :ivar tier: Gets the tier of SKU.
    :vartype tier: str
    :ivar capacity: Gets the capacity of SKU.
    :vartype capacity: ~azure.mgmt.appplatform.v2020_11_01_preview.models.SkuCapacity
    :ivar locations: Gets the set of locations that the SKU is available.
    :vartype locations: list[str]
    :ivar location_info: Gets a list of locations and availability zones in those locations where
     the SKU is available.
    :vartype location_info:
     list[~azure.mgmt.appplatform.v2020_11_01_preview.models.ResourceSkuLocationInfo]
    :ivar restrictions: Gets the restrictions because of which SKU cannot be used. This is
     empty if there are no restrictions.
    :vartype restrictions:
     list[~azure.mgmt.appplatform.v2020_11_01_preview.models.ResourceSkuRestrictions]
    """

    _attribute_map = {
        "resource_type": {"key": "resourceType", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capacity": {"key": "capacity", "type": "SkuCapacity"},
        "locations": {"key": "locations", "type": "[str]"},
        "location_info": {"key": "locationInfo", "type": "[ResourceSkuLocationInfo]"},
        "restrictions": {"key": "restrictions", "type": "[ResourceSkuRestrictions]"},
    }

    def __init__(
        self,
        *,
        resource_type: Optional[str] = None,
        name: Optional[str] = None,
        tier: Optional[str] = None,
        capacity: Optional["_models.SkuCapacity"] = None,
        locations: Optional[List[str]] = None,
        location_info: Optional[List["_models.ResourceSkuLocationInfo"]] = None,
        restrictions: Optional[List["_models.ResourceSkuRestrictions"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_type: Gets the type of resource the SKU applies to.
        :paramtype resource_type: str
        :keyword name: Gets the name of SKU.
        :paramtype name: str
        :keyword tier: Gets the tier of SKU.
        :paramtype tier: str
        :keyword capacity: Gets the capacity of SKU.
        :paramtype capacity: ~azure.mgmt.appplatform.v2020_11_01_preview.models.SkuCapacity
        :keyword locations: Gets the set of locations that the SKU is available.
        :paramtype locations: list[str]
        :keyword location_info: Gets a list of locations and availability zones in those locations
         where the SKU is available.
        :paramtype location_info:
         list[~azure.mgmt.appplatform.v2020_11_01_preview.models.ResourceSkuLocationInfo]
        :keyword restrictions: Gets the restrictions because of which SKU cannot be used. This is
         empty if there are no restrictions.
        :paramtype restrictions:
         list[~azure.mgmt.appplatform.v2020_11_01_preview.models.ResourceSkuRestrictions]
        """
        super().__init__(**kwargs)
        self.resource_type = resource_type
        self.name = name
        self.tier = tier
        self.capacity = capacity
        self.locations = locations
        self.location_info = location_info
        self.restrictions = restrictions


class ResourceSkuCapabilities(_serialization.Model):
    """ResourceSkuCapabilities.

    :ivar name: Gets an invariant to describe the feature.
    :vartype name: str
    :ivar value: Gets an invariant if the feature is measured by quantity.
    :vartype value: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, name: Optional[str] = None, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword name: Gets an invariant to describe the feature.
        :paramtype name: str
        :keyword value: Gets an invariant if the feature is measured by quantity.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.value = value


class ResourceSkuCollection(_serialization.Model):
    """Object that includes an array of Azure Spring Cloud SKU and a possible link for next set.

    :ivar value: Collection of resource SKU.
    :vartype value: list[~azure.mgmt.appplatform.v2020_11_01_preview.models.ResourceSku]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ResourceSku]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ResourceSku"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of resource SKU.
        :paramtype value: list[~azure.mgmt.appplatform.v2020_11_01_preview.models.ResourceSku]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ResourceSkuLocationInfo(_serialization.Model):
    """Locations and availability zones where the SKU is available.

    :ivar location: Gets location of the SKU.
    :vartype location: str
    :ivar zones: Gets list of availability zones where the SKU is supported.
    :vartype zones: list[str]
    :ivar zone_details: Gets details of capabilities available to a SKU in specific zones.
    :vartype zone_details:
     list[~azure.mgmt.appplatform.v2020_11_01_preview.models.ResourceSkuZoneDetails]
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "zones": {"key": "zones", "type": "[str]"},
        "zone_details": {"key": "zoneDetails", "type": "[ResourceSkuZoneDetails]"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        zones: Optional[List[str]] = None,
        zone_details: Optional[List["_models.ResourceSkuZoneDetails"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Gets location of the SKU.
        :paramtype location: str
        :keyword zones: Gets list of availability zones where the SKU is supported.
        :paramtype zones: list[str]
        :keyword zone_details: Gets details of capabilities available to a SKU in specific zones.
        :paramtype zone_details:
         list[~azure.mgmt.appplatform.v2020_11_01_preview.models.ResourceSkuZoneDetails]
        """
        super().__init__(**kwargs)
        self.location = location
        self.zones = zones
        self.zone_details = zone_details


class ResourceSkuRestrictionInfo(_serialization.Model):
    """Information about the restriction where the SKU cannot be used.

    :ivar locations: Gets locations where the SKU is restricted.
    :vartype locations: list[str]
    :ivar zones: Gets list of availability zones where the SKU is restricted.
    :vartype zones: list[str]
    """

    _attribute_map = {
        "locations": {"key": "locations", "type": "[str]"},
        "zones": {"key": "zones", "type": "[str]"},
    }

    def __init__(
        self, *, locations: Optional[List[str]] = None, zones: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword locations: Gets locations where the SKU is restricted.
        :paramtype locations: list[str]
        :keyword zones: Gets list of availability zones where the SKU is restricted.
        :paramtype zones: list[str]
        """
        super().__init__(**kwargs)
        self.locations = locations
        self.zones = zones


class ResourceSkuRestrictions(_serialization.Model):
    """Restrictions where the SKU cannot be used.

    :ivar type: Gets the type of restrictions. Possible values include: 'Location', 'Zone'. Known
     values are: "Location" and "Zone".
    :vartype type: str or
     ~azure.mgmt.appplatform.v2020_11_01_preview.models.ResourceSkuRestrictionsType
    :ivar values: Gets the value of restrictions. If the restriction type is set to
     location. This would be different locations where the SKU is restricted.
    :vartype values: list[str]
    :ivar restriction_info: Gets the information about the restriction where the SKU cannot be
     used.
    :vartype restriction_info:
     ~azure.mgmt.appplatform.v2020_11_01_preview.models.ResourceSkuRestrictionInfo
    :ivar reason_code: Gets the reason for restriction. Possible values include: 'QuotaId',
     'NotAvailableForSubscription'. Known values are: "QuotaId" and "NotAvailableForSubscription".
    :vartype reason_code: str or
     ~azure.mgmt.appplatform.v2020_11_01_preview.models.ResourceSkuRestrictionsReasonCode
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "values": {"key": "values", "type": "[str]"},
        "restriction_info": {"key": "restrictionInfo", "type": "ResourceSkuRestrictionInfo"},
        "reason_code": {"key": "reasonCode", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.ResourceSkuRestrictionsType"]] = None,
        values: Optional[List[str]] = None,
        restriction_info: Optional["_models.ResourceSkuRestrictionInfo"] = None,
        reason_code: Optional[Union[str, "_models.ResourceSkuRestrictionsReasonCode"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Gets the type of restrictions. Possible values include: 'Location', 'Zone'.
         Known values are: "Location" and "Zone".
        :paramtype type: str or
         ~azure.mgmt.appplatform.v2020_11_01_preview.models.ResourceSkuRestrictionsType
        :keyword values: Gets the value of restrictions. If the restriction type is set to
         location. This would be different locations where the SKU is restricted.
        :paramtype values: list[str]
        :keyword restriction_info: Gets the information about the restriction where the SKU cannot be
         used.
        :paramtype restriction_info:
         ~azure.mgmt.appplatform.v2020_11_01_preview.models.ResourceSkuRestrictionInfo
        :keyword reason_code: Gets the reason for restriction. Possible values include: 'QuotaId',
         'NotAvailableForSubscription'. Known values are: "QuotaId" and "NotAvailableForSubscription".
        :paramtype reason_code: str or
         ~azure.mgmt.appplatform.v2020_11_01_preview.models.ResourceSkuRestrictionsReasonCode
        """
        super().__init__(**kwargs)
        self.type = type
        self.values = values
        self.restriction_info = restriction_info
        self.reason_code = reason_code


class ResourceSkuZoneDetails(_serialization.Model):
    """Details of capabilities available to a SKU in specific zones.

    :ivar name: Gets the set of zones that the SKU is available in with the
     specified capabilities.
    :vartype name: list[str]
    :ivar capabilities: Gets a list of capabilities that are available for the SKU in the
     specified list of zones.
    :vartype capabilities:
     list[~azure.mgmt.appplatform.v2020_11_01_preview.models.ResourceSkuCapabilities]
    """

    _attribute_map = {
        "name": {"key": "name", "type": "[str]"},
        "capabilities": {"key": "capabilities", "type": "[ResourceSkuCapabilities]"},
    }

    def __init__(
        self,
        *,
        name: Optional[List[str]] = None,
        capabilities: Optional[List["_models.ResourceSkuCapabilities"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Gets the set of zones that the SKU is available in with the
         specified capabilities.
        :paramtype name: list[str]
        :keyword capabilities: Gets a list of capabilities that are available for the SKU in the
         specified list of zones.
        :paramtype capabilities:
         list[~azure.mgmt.appplatform.v2020_11_01_preview.models.ResourceSkuCapabilities]
        """
        super().__init__(**kwargs)
        self.name = name
        self.capabilities = capabilities


class ResourceUploadDefinition(_serialization.Model):
    """Resource upload definition payload.

    :ivar relative_path: Source relative path.
    :vartype relative_path: str
    :ivar upload_url: Upload URL.
    :vartype upload_url: str
    """

    _attribute_map = {
        "relative_path": {"key": "relativePath", "type": "str"},
        "upload_url": {"key": "uploadUrl", "type": "str"},
    }

    def __init__(self, *, relative_path: Optional[str] = None, upload_url: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword relative_path: Source relative path.
        :paramtype relative_path: str
        :keyword upload_url: Upload URL.
        :paramtype upload_url: str
        """
        super().__init__(**kwargs)
        self.relative_path = relative_path
        self.upload_url = upload_url


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The GEO location of the resource.
    :vartype location: str
    :ivar tags: Tags of the service which is a list of key value pairs that describe the resource.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: Optional[str] = None, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: The GEO location of the resource.
        :paramtype location: str
        :keyword tags: Tags of the service which is a list of key value pairs that describe the
         resource.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags


class ServiceResource(TrackedResource):
    """Service resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource Id for the resource.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar location: The GEO location of the resource.
    :vartype location: str
    :ivar tags: Tags of the service which is a list of key value pairs that describe the resource.
    :vartype tags: dict[str, str]
    :ivar properties: Properties of the Service resource.
    :vartype properties:
     ~azure.mgmt.appplatform.v2020_11_01_preview.models.ClusterResourceProperties
    :ivar sku: Sku of the Service resource.
    :vartype sku: ~azure.mgmt.appplatform.v2020_11_01_preview.models.Sku
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "properties": {"key": "properties", "type": "ClusterResourceProperties"},
        "sku": {"key": "sku", "type": "Sku"},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.ClusterResourceProperties"] = None,
        sku: Optional["_models.Sku"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The GEO location of the resource.
        :paramtype location: str
        :keyword tags: Tags of the service which is a list of key value pairs that describe the
         resource.
        :paramtype tags: dict[str, str]
        :keyword properties: Properties of the Service resource.
        :paramtype properties:
         ~azure.mgmt.appplatform.v2020_11_01_preview.models.ClusterResourceProperties
        :keyword sku: Sku of the Service resource.
        :paramtype sku: ~azure.mgmt.appplatform.v2020_11_01_preview.models.Sku
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.properties = properties
        self.sku = sku


class ServiceResourceList(_serialization.Model):
    """Object that includes an array of Service resources and a possible link for next set.

    :ivar value: Collection of Service resources.
    :vartype value: list[~azure.mgmt.appplatform.v2020_11_01_preview.models.ServiceResource]
    :ivar next_link: URL client should use to fetch the next page (per server side paging).
     It's null for now, added for future use.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ServiceResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ServiceResource"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Collection of Service resources.
        :paramtype value: list[~azure.mgmt.appplatform.v2020_11_01_preview.models.ServiceResource]
        :keyword next_link: URL client should use to fetch the next page (per server side paging).
         It's null for now, added for future use.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ServiceSpecification(_serialization.Model):
    """Service specification payload.

    :ivar log_specifications: Specifications of the Log for Azure Monitoring.
    :vartype log_specifications:
     list[~azure.mgmt.appplatform.v2020_11_01_preview.models.LogSpecification]
    :ivar metric_specifications: Specifications of the Metrics for Azure Monitoring.
    :vartype metric_specifications:
     list[~azure.mgmt.appplatform.v2020_11_01_preview.models.MetricSpecification]
    """

    _attribute_map = {
        "log_specifications": {"key": "logSpecifications", "type": "[LogSpecification]"},
        "metric_specifications": {"key": "metricSpecifications", "type": "[MetricSpecification]"},
    }

    def __init__(
        self,
        *,
        log_specifications: Optional[List["_models.LogSpecification"]] = None,
        metric_specifications: Optional[List["_models.MetricSpecification"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword log_specifications: Specifications of the Log for Azure Monitoring.
        :paramtype log_specifications:
         list[~azure.mgmt.appplatform.v2020_11_01_preview.models.LogSpecification]
        :keyword metric_specifications: Specifications of the Metrics for Azure Monitoring.
        :paramtype metric_specifications:
         list[~azure.mgmt.appplatform.v2020_11_01_preview.models.MetricSpecification]
        """
        super().__init__(**kwargs)
        self.log_specifications = log_specifications
        self.metric_specifications = metric_specifications


class Sku(_serialization.Model):
    """Sku of Azure Spring Cloud.

    :ivar name: Name of the Sku.
    :vartype name: str
    :ivar tier: Tier of the Sku.
    :vartype tier: str
    :ivar capacity: Current capacity of the target resource.
    :vartype capacity: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self, *, name: str = "S0", tier: str = "Standard", capacity: Optional[int] = None, **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the Sku.
        :paramtype name: str
        :keyword tier: Tier of the Sku.
        :paramtype tier: str
        :keyword capacity: Current capacity of the target resource.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class SkuCapacity(_serialization.Model):
    """The SKU capacity.

    All required parameters must be populated in order to send to server.

    :ivar minimum: Gets or sets the minimum. Required.
    :vartype minimum: int
    :ivar maximum: Gets or sets the maximum.
    :vartype maximum: int
    :ivar default: Gets or sets the default.
    :vartype default: int
    :ivar scale_type: Gets or sets the type of the scale. Known values are: "None", "Manual", and
     "Automatic".
    :vartype scale_type: str or ~azure.mgmt.appplatform.v2020_11_01_preview.models.SkuScaleType
    """

    _validation = {
        "minimum": {"required": True},
    }

    _attribute_map = {
        "minimum": {"key": "minimum", "type": "int"},
        "maximum": {"key": "maximum", "type": "int"},
        "default": {"key": "default", "type": "int"},
        "scale_type": {"key": "scaleType", "type": "str"},
    }

    def __init__(
        self,
        *,
        minimum: int,
        maximum: Optional[int] = None,
        default: Optional[int] = None,
        scale_type: Optional[Union[str, "_models.SkuScaleType"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword minimum: Gets or sets the minimum. Required.
        :paramtype minimum: int
        :keyword maximum: Gets or sets the maximum.
        :paramtype maximum: int
        :keyword default: Gets or sets the default.
        :paramtype default: int
        :keyword scale_type: Gets or sets the type of the scale. Known values are: "None", "Manual",
         and "Automatic".
        :paramtype scale_type: str or ~azure.mgmt.appplatform.v2020_11_01_preview.models.SkuScaleType
        """
        super().__init__(**kwargs)
        self.minimum = minimum
        self.maximum = maximum
        self.default = default
        self.scale_type = scale_type


class SupportedRuntimeVersion(_serialization.Model):
    """Supported deployment runtime version descriptor.

    :ivar value: The raw value which could be passed to deployment CRUD operations. Known values
     are: "Java_8", "Java_11", and "NetCore_31".
    :vartype value: str or ~azure.mgmt.appplatform.v2020_11_01_preview.models.SupportedRuntimeValue
    :ivar platform: The platform of this runtime version (possible values: "Java" or ".NET"). Known
     values are: "Java" and ".NET Core".
    :vartype platform: str or
     ~azure.mgmt.appplatform.v2020_11_01_preview.models.SupportedRuntimePlatform
    :ivar version: The detailed version (major.minor) of the platform.
    :vartype version: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "platform": {"key": "platform", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[Union[str, "_models.SupportedRuntimeValue"]] = None,
        platform: Optional[Union[str, "_models.SupportedRuntimePlatform"]] = None,
        version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The raw value which could be passed to deployment CRUD operations. Known values
         are: "Java_8", "Java_11", and "NetCore_31".
        :paramtype value: str or
         ~azure.mgmt.appplatform.v2020_11_01_preview.models.SupportedRuntimeValue
        :keyword platform: The platform of this runtime version (possible values: "Java" or ".NET").
         Known values are: "Java" and ".NET Core".
        :paramtype platform: str or
         ~azure.mgmt.appplatform.v2020_11_01_preview.models.SupportedRuntimePlatform
        :keyword version: The detailed version (major.minor) of the platform.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.platform = platform
        self.version = version


class TemporaryDisk(_serialization.Model):
    """Temporary disk payload.

    :ivar size_in_gb: Size of the temporary disk in GB.
    :vartype size_in_gb: int
    :ivar mount_path: Mount path of the temporary disk.
    :vartype mount_path: str
    """

    _validation = {
        "size_in_gb": {"maximum": 5, "minimum": 0},
    }

    _attribute_map = {
        "size_in_gb": {"key": "sizeInGB", "type": "int"},
        "mount_path": {"key": "mountPath", "type": "str"},
    }

    def __init__(self, *, size_in_gb: Optional[int] = None, mount_path: str = "/tmp", **kwargs: Any) -> None:
        """
        :keyword size_in_gb: Size of the temporary disk in GB.
        :paramtype size_in_gb: int
        :keyword mount_path: Mount path of the temporary disk.
        :paramtype mount_path: str
        """
        super().__init__(**kwargs)
        self.size_in_gb = size_in_gb
        self.mount_path = mount_path


class TestKeys(_serialization.Model):
    """Test keys payload.

    :ivar primary_key: Primary key.
    :vartype primary_key: str
    :ivar secondary_key: Secondary key.
    :vartype secondary_key: str
    :ivar primary_test_endpoint: Primary test endpoint.
    :vartype primary_test_endpoint: str
    :ivar secondary_test_endpoint: Secondary test endpoint.
    :vartype secondary_test_endpoint: str
    :ivar enabled: Indicates whether the test endpoint feature enabled or not.
    :vartype enabled: bool
    """

    _attribute_map = {
        "primary_key": {"key": "primaryKey", "type": "str"},
        "secondary_key": {"key": "secondaryKey", "type": "str"},
        "primary_test_endpoint": {"key": "primaryTestEndpoint", "type": "str"},
        "secondary_test_endpoint": {"key": "secondaryTestEndpoint", "type": "str"},
        "enabled": {"key": "enabled", "type": "bool"},
    }

    def __init__(
        self,
        *,
        primary_key: Optional[str] = None,
        secondary_key: Optional[str] = None,
        primary_test_endpoint: Optional[str] = None,
        secondary_test_endpoint: Optional[str] = None,
        enabled: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword primary_key: Primary key.
        :paramtype primary_key: str
        :keyword secondary_key: Secondary key.
        :paramtype secondary_key: str
        :keyword primary_test_endpoint: Primary test endpoint.
        :paramtype primary_test_endpoint: str
        :keyword secondary_test_endpoint: Secondary test endpoint.
        :paramtype secondary_test_endpoint: str
        :keyword enabled: Indicates whether the test endpoint feature enabled or not.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.primary_key = primary_key
        self.secondary_key = secondary_key
        self.primary_test_endpoint = primary_test_endpoint
        self.secondary_test_endpoint = secondary_test_endpoint
        self.enabled = enabled


class UserSourceInfo(_serialization.Model):
    """Source information for a deployment.

    :ivar type: Type of the source uploaded. Known values are: "Jar", "NetCoreZip", and "Source".
    :vartype type: str or ~azure.mgmt.appplatform.v2020_11_01_preview.models.UserSourceType
    :ivar relative_path: Relative path of the storage which stores the source.
    :vartype relative_path: str
    :ivar version: Version of the source.
    :vartype version: str
    :ivar artifact_selector: Selector for the artifact to be used for the deployment for
     multi-module projects. This should be
     the relative path to the target module/project.
    :vartype artifact_selector: str
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "relative_path": {"key": "relativePath", "type": "str"},
        "version": {"key": "version", "type": "str"},
        "artifact_selector": {"key": "artifactSelector", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.UserSourceType"]] = None,
        relative_path: Optional[str] = None,
        version: Optional[str] = None,
        artifact_selector: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of the source uploaded. Known values are: "Jar", "NetCoreZip", and
         "Source".
        :paramtype type: str or ~azure.mgmt.appplatform.v2020_11_01_preview.models.UserSourceType
        :keyword relative_path: Relative path of the storage which stores the source.
        :paramtype relative_path: str
        :keyword version: Version of the source.
        :paramtype version: str
        :keyword artifact_selector: Selector for the artifact to be used for the deployment for
         multi-module projects. This should be
         the relative path to the target module/project.
        :paramtype artifact_selector: str
        """
        super().__init__(**kwargs)
        self.type = type
        self.relative_path = relative_path
        self.version = version
        self.artifact_selector = artifact_selector
