# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class CompositionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The composition type describes how the key-values within the snapshot are composed. The 'key'
    composition type ensures there are no two key-values containing the same key. The 'key_label'
    composition type ensures there are no two key-values containing the same key and label.
    """

    KEY = "key"
    KEY_LABEL = "key_label"


class KeyValueFields(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """KeyValueFields."""

    KEY = "key"
    LABEL = "label"
    CONTENT_TYPE = "content_type"
    VALUE = "value"
    LAST_MODIFIED = "last_modified"
    TAGS = "tags"
    LOCKED = "locked"
    ETAG = "etag"


class LabelFields(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """LabelFields."""

    NAME = "name"


class SnapshotFields(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """SnapshotFields."""

    NAME = "name"
    STATUS = "status"
    FILTERS = "filters"
    COMPOSITION_TYPE = "composition_type"
    CREATED = "created"
    EXPIRES = "expires"
    RETENTION_PERIOD = "retention_period"
    SIZE = "size"
    ITEMS_COUNT = "items_count"
    TAGS = "tags"
    ETAG = "etag"


class SnapshotStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current status of the snapshot."""

    PROVISIONING = "provisioning"
    READY = "ready"
    ARCHIVED = "archived"
    FAILED = "failed"


class State(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The current status of the operation."""

    NOT_STARTED = "NotStarted"
    RUNNING = "Running"
    SUCCEEDED = "Succeeded"
    FAILED = "Failed"
    CANCELED = "Canceled"
