# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import TYPE_CHECKING

from msrest import Serializer

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    map_error,
)
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.polling import LROPoller, NoPolling, PollingMethod
from azure.core.polling.base_polling import LROBasePolling
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace

from .._vendor import _format_url_section

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Iterable, List, Optional, TypeVar, Union

    T = TypeVar("T")
    JSONType = Any
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False
# fmt: off

def build_list_projects_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
    top = kwargs.pop('top', None)  # type: Optional[int]
    skip = kwargs.pop('skip', None)  # type: Optional[int]
    maxpagesize = kwargs.pop('maxpagesize', None)  # type: Optional[int]

    accept = "application/json"
    # Construct URL
    _url = "/query-knowledgebases/projects"

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')
    if top is not None:
        _query_parameters['top'] = _SERIALIZER.query("top", top, 'int')
    if skip is not None:
        _query_parameters['skip'] = _SERIALIZER.query("skip", skip, 'int')
    if maxpagesize is not None:
        _query_parameters['maxpagesize'] = _SERIALIZER.query("maxpagesize", maxpagesize, 'int')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_get_project_details_request(
    project_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str

    accept = "application/json"
    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, 'str', max_length=100, min_length=0),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_create_project_request(
    project_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, 'str', max_length=100, min_length=0),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        _header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PATCH",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_delete_project_request_initial(
    project_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str

    accept = "application/json"
    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, 'str', max_length=100, min_length=0),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_export_request_initial(
    project_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
    format = kwargs.pop('format', "json")  # type: Optional[str]
    asset_kind = kwargs.pop('asset_kind', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}/:export"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, 'str', max_length=100, min_length=0),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')
    if format is not None:
        _query_parameters['format'] = _SERIALIZER.query("format", format, 'str')
    if asset_kind is not None:
        _query_parameters['assetKind'] = _SERIALIZER.query("asset_kind", asset_kind, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_import_assets_request_initial(
    project_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]
    format = kwargs.pop('format', "json")  # type: Optional[str]
    asset_kind = kwargs.pop('asset_kind', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}/:import"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, 'str', max_length=100, min_length=0),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')
    if format is not None:
        _query_parameters['format'] = _SERIALIZER.query("format", format, 'str')
    if asset_kind is not None:
        _query_parameters['assetKind'] = _SERIALIZER.query("asset_kind", asset_kind, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        _header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_deploy_project_request_initial(
    project_name,  # type: str
    deployment_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str

    accept = "application/json"
    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}/deployments/{deploymentName}"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, 'str', max_length=100, min_length=0),
        "deploymentName": _SERIALIZER.url("deployment_name", deployment_name, 'str'),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_list_deployments_request(
    project_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
    top = kwargs.pop('top', None)  # type: Optional[int]
    skip = kwargs.pop('skip', None)  # type: Optional[int]
    maxpagesize = kwargs.pop('maxpagesize', None)  # type: Optional[int]

    accept = "application/json"
    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}/deployments"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, 'str', max_length=100, min_length=0),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')
    if top is not None:
        _query_parameters['top'] = _SERIALIZER.query("top", top, 'int')
    if skip is not None:
        _query_parameters['skip'] = _SERIALIZER.query("skip", skip, 'int')
    if maxpagesize is not None:
        _query_parameters['maxpagesize'] = _SERIALIZER.query("maxpagesize", maxpagesize, 'int')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_list_synonyms_request(
    project_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
    top = kwargs.pop('top', None)  # type: Optional[int]
    skip = kwargs.pop('skip', None)  # type: Optional[int]
    maxpagesize = kwargs.pop('maxpagesize', None)  # type: Optional[int]

    accept = "application/json"
    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}/synonyms"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, 'str', max_length=100, min_length=0),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')
    if top is not None:
        _query_parameters['top'] = _SERIALIZER.query("top", top, 'int')
    if skip is not None:
        _query_parameters['skip'] = _SERIALIZER.query("skip", skip, 'int')
    if maxpagesize is not None:
        _query_parameters['maxpagesize'] = _SERIALIZER.query("maxpagesize", maxpagesize, 'int')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_update_synonyms_request(
    project_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}/synonyms"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, 'str', max_length=100, min_length=0),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        _header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_list_sources_request(
    project_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
    top = kwargs.pop('top', None)  # type: Optional[int]
    skip = kwargs.pop('skip', None)  # type: Optional[int]
    maxpagesize = kwargs.pop('maxpagesize', None)  # type: Optional[int]

    accept = "application/json"
    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}/sources"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, 'str', max_length=100, min_length=0),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')
    if top is not None:
        _query_parameters['top'] = _SERIALIZER.query("top", top, 'int')
    if skip is not None:
        _query_parameters['skip'] = _SERIALIZER.query("skip", skip, 'int')
    if maxpagesize is not None:
        _query_parameters['maxpagesize'] = _SERIALIZER.query("maxpagesize", maxpagesize, 'int')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_update_sources_request_initial(
    project_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}/sources"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, 'str', max_length=100, min_length=0),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        _header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PATCH",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_list_qnas_request(
    project_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
    source = kwargs.pop('source', None)  # type: Optional[str]
    top = kwargs.pop('top', None)  # type: Optional[int]
    skip = kwargs.pop('skip', None)  # type: Optional[int]
    maxpagesize = kwargs.pop('maxpagesize', None)  # type: Optional[int]

    accept = "application/json"
    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}/qnas"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, 'str', max_length=100, min_length=0),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')
    if source is not None:
        _query_parameters['source'] = _SERIALIZER.query("source", source, 'str')
    if top is not None:
        _query_parameters['top'] = _SERIALIZER.query("top", top, 'int')
    if skip is not None:
        _query_parameters['skip'] = _SERIALIZER.query("skip", skip, 'int')
    if maxpagesize is not None:
        _query_parameters['maxpagesize'] = _SERIALIZER.query("maxpagesize", maxpagesize, 'int')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="GET",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_update_qnas_request_initial(
    project_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}/qnas"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, 'str', max_length=100, min_length=0),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        _header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PATCH",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )


def build_add_feedback_request(
    project_name,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    _url = "/query-knowledgebases/projects/{projectName}/feedback"
    path_format_arguments = {
        "projectName": _SERIALIZER.url("project_name", project_name, 'str', max_length=100, min_length=0),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        _header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )

# fmt: on
class QuestionAnsweringProjectsClientOperationsMixin(object):  # pylint: disable=too-many-public-methods
    @distributed_trace
    def list_projects(
        self, **kwargs  # type: Any
    ):
        # type: (...) -> Iterable[JSONType]
        """Gets all projects for a user.

        Gets all projects for a user.

        :keyword top: The maximum number of resources to return from the collection.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned.
        :paramtype skip: int
        :keyword maxpagesize: The maximum number of resources to include in a single response.
        :paramtype maxpagesize: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSONType]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "nextLink": "str",  # Optional.
                    "value": [
                        {
                            "createdDateTime": "2020-02-20 00:00:00",  # Optional.
                              Project creation date-time.
                            "description": "str",  # Optional. Description of the
                              project.
                            "language": "str",  # Optional. Language of the text records.
                              This is BCP-47 representation of a language. For example, use "en" for
                              English; "es" for Spanish etc. If not set, use "en" for English as
                              default.
                            "lastDeployedDateTime": "2020-02-20 00:00:00",  # Optional.
                              Represents the project last deployment date-time.
                            "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional.
                              Represents the project last modified date-time.
                            "multilingualResource": bool,  # Optional. Resource enabled
                              for multiple languages across projects or not.
                            "projectName": "str",  # Optional. Name of the project.
                            "settings": {
                                "defaultAnswer": "str"  # Optional. Default Answer
                                  response when no good match is found in the knowledge base.
                            }
                        }
                    ]
                }
        """
        api_version = kwargs.pop("api_version", "2021-10-01")  # type: str
        top = kwargs.pop("top", None)  # type: Optional[int]
        skip = kwargs.pop("skip", None)  # type: Optional[int]
        maxpagesize = kwargs.pop("maxpagesize", None)  # type: Optional[int]

        cls = kwargs.pop("cls", None)  # type: ClsType[JSONType]
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}))

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_projects_request(
                    api_version=api_version,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:

                request = build_list_projects_request(
                    api_version=api_version,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(next_link, **path_format_arguments)

                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def get_project_details(
        self,
        project_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> JSONType
        """Get the requested project metadata.

        Get the requested project metadata.

        :param project_name: The name of the project to use.
        :type project_name: str
        :return: JSON object
        :rtype: JSONType
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Project creation
                      date-time.
                    "description": "str",  # Optional. Description of the project.
                    "language": "str",  # Optional. Language of the text records. This is BCP-47
                      representation of a language. For example, use "en" for English; "es" for Spanish
                      etc. If not set, use "en" for English as default.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last deployment date-time.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last modified date-time.
                    "multilingualResource": bool,  # Optional. Resource enabled for multiple
                      languages across projects or not.
                    "projectName": "str",  # Optional. Name of the project.
                    "settings": {
                        "defaultAnswer": "str"  # Optional. Default Answer response when no
                          good match is found in the knowledge base.
                    }
                }
        """
        cls = kwargs.pop("cls", None)  # type: ClsType[JSONType]
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}))

        api_version = kwargs.pop("api_version", "2021-10-01")  # type: str

        request = build_get_project_details_request(
            project_name=project_name,
            api_version=api_version,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    @distributed_trace
    def create_project(
        self,
        project_name,  # type: str
        options,  # type: JSONType
        **kwargs  # type: Any
    ):
        # type: (...) -> JSONType
        """Create or update a project.

        Create or update a project.

        :param project_name: The name of the project to use.
        :type project_name: str
        :param options: Parameters needed to create the project.
        :type options: JSONType
        :return: JSON object
        :rtype: JSONType
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                options = {
                    "description": "str",  # Optional. Description of the project.
                    "language": "str",  # Required. Language of the text records. This is BCP-47
                      representation of a language. For example, use "en" for English; "es" for Spanish
                      etc. If not set, use "en" for English as default.
                    "multilingualResource": bool,  # Optional. Set to true to enable creating
                      knowledgebases in different languages for the same resource.
                    "settings": {
                        "defaultAnswer": "str"  # Optional. Default Answer response when no
                          good match is found in the knowledge base.
                    }
                }

                # response body for status code(s): 200, 201
                response.json() == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Optional. Project creation
                      date-time.
                    "description": "str",  # Optional. Description of the project.
                    "language": "str",  # Optional. Language of the text records. This is BCP-47
                      representation of a language. For example, use "en" for English; "es" for Spanish
                      etc. If not set, use "en" for English as default.
                    "lastDeployedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last deployment date-time.
                    "lastModifiedDateTime": "2020-02-20 00:00:00",  # Optional. Represents the
                      project last modified date-time.
                    "multilingualResource": bool,  # Optional. Resource enabled for multiple
                      languages across projects or not.
                    "projectName": "str",  # Optional. Name of the project.
                    "settings": {
                        "defaultAnswer": "str"  # Optional. Default Answer response when no
                          good match is found in the knowledge base.
                    }
                }
        """
        cls = kwargs.pop("cls", None)  # type: ClsType[JSONType]
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}))

        api_version = kwargs.pop("api_version", "2021-10-01")  # type: str
        content_type = kwargs.pop("content_type", "application/json")  # type: Optional[str]

        _json = options

        request = build_create_project_request(
            project_name=project_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    def _delete_project_initial(  # pylint: disable=inconsistent-return-statements
        self,
        project_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        cls = kwargs.pop("cls", None)  # type: ClsType[None]
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}))

        api_version = kwargs.pop("api_version", "2021-10-01")  # type: str

        request = build_delete_project_request_initial(
            project_name=project_name,
            api_version=api_version,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    @distributed_trace
    def begin_delete_project(  # pylint: disable=inconsistent-return-statements
        self,
        project_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> LROPoller[None]
        """Delete the project.

        Delete the project.

        :param project_name: The name of the project to use.
        :type project_name: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns None
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop("api_version", "2021-10-01")  # type: str
        polling = kwargs.pop("polling", True)  # type: Union[bool, PollingMethod]
        cls = kwargs.pop("cls", None)  # type: ClsType[None]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._delete_project_initial(
                project_name=project_name, api_version=api_version, cls=lambda x, y, z: x, **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            if cls:
                return cls(pipeline_response, None, {})

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method = LROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
        elif polling is False:
            polling_method = NoPolling()
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    def _export_initial(
        self,
        project_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Optional[JSONType]
        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[JSONType]]
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}))

        api_version = kwargs.pop("api_version", "2021-10-01")  # type: str
        format = kwargs.pop("format", "json")  # type: Optional[str]
        asset_kind = kwargs.pop("asset_kind", None)  # type: Optional[str]

        request = build_export_request_initial(
            project_name=project_name,
            api_version=api_version,
            format=format,
            asset_kind=asset_kind,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            response_headers["Operation-Location"] = self._deserialize(
                "str", response.headers.get("Operation-Location")
            )

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized

    @distributed_trace
    def begin_export(
        self,
        project_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> LROPoller[JSONType]
        """Export project metadata and assets.

        Export project metadata and assets.

        :param project_name: The name of the project to use.
        :type project_name: str
        :keyword format: Knowledge base Import or Export format. Possible values are: "json", "tsv",
         and "excel".
        :paramtype format: str
        :keyword asset_kind: Kind of the asset of the project. Possible values are: "qnas" or
         "synonyms".
        :paramtype asset_kind: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns JSON object
        :rtype: ~azure.core.polling.LROPoller[JSONType]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "createdDateTime": "2020-02-20 00:00:00",  # Required.
                    "errors": [
                        {
                            "code": "str",  # Required. One of a server-defined set of
                              error codes. Possible values include: "InvalidRequest",
                              "InvalidArgument", "Unauthorized", "Forbidden", "NotFound",
                              "ProjectNotFound", "OperationNotFound", "AzureCognitiveSearchNotFound",
                              "AzureCognitiveSearchIndexNotFound", "TooManyRequests",
                              "AzureCognitiveSearchThrottling",
                              "AzureCognitiveSearchIndexLimitReached", "InternalServerError",
                              "ServiceUnavailable".
                            "details": [
                                ...
                            ],
                            "innererror": {
                                "code": "str",  # Required. One of a server-defined
                                  set of error codes. Possible values include: "InvalidRequest",
                                  "InvalidParameterValue", "KnowledgeBaseNotFound",
                                  "AzureCognitiveSearchNotFound", "AzureCognitiveSearchThrottling",
                                  "ExtractionFailure".
                                "details": {
                                    "str": "str"  # Optional. Error details.
                                },
                                "innererror": ...,
                                "message": "str",  # Required. Error message.
                                "target": "str"  # Optional. Error target.
                            },
                            "message": "str",  # Required. A human-readable
                              representation of the error.
                            "target": "str"  # Optional. The target of the error.
                        }
                    ],
                    "expirationDateTime": "2020-02-20 00:00:00",  # Optional.
                    "jobId": "str",  # Required.
                    "lastUpdatedDateTime": "2020-02-20 00:00:00",  # Required.
                    "resultUrl": "str",  # Required. URL to download the result of the Export
                      Job.
                    "status": "str"  # Required. Job Status. Possible values include:
                      "notStarted", "running", "succeeded", "failed", "cancelled", "cancelling",
                      "partiallyCompleted".
                }
        """
        api_version = kwargs.pop("api_version", "2021-10-01")  # type: str
        format = kwargs.pop("format", "json")  # type: Optional[str]
        asset_kind = kwargs.pop("asset_kind", None)  # type: Optional[str]
        polling = kwargs.pop("polling", True)  # type: Union[bool, PollingMethod]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSONType]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._export_initial(
                project_name=project_name,
                format=format,
                asset_kind=asset_kind,
                api_version=api_version,
                cls=lambda x, y, z: x,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            response = pipeline_response.http_response
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None
            if cls:
                return cls(pipeline_response, deserialized, {})
            return deserialized

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method = LROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
        elif polling is False:
            polling_method = NoPolling()
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    def _import_assets_initial(  # pylint: disable=inconsistent-return-statements
        self,
        project_name,  # type: str
        options=None,  # type: JSONType
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        cls = kwargs.pop("cls", None)  # type: ClsType[None]
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}))

        api_version = kwargs.pop("api_version", "2021-10-01")  # type: str
        content_type = kwargs.pop("content_type", "application/json")  # type: Optional[str]
        format = kwargs.pop("format", "json")  # type: Optional[str]
        asset_kind = kwargs.pop("asset_kind", None)  # type: Optional[str]

        if options is not None:
            _json = options
        else:
            _json = None

        request = build_import_assets_request_initial(
            project_name=project_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
            format=format,
            asset_kind=asset_kind,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    @distributed_trace
    def begin_import_assets(  # pylint: disable=inconsistent-return-statements
        self,
        project_name,  # type: str
        options=None,  # type: JSONType
        **kwargs  # type: Any
    ):
        # type: (...) -> LROPoller[None]
        """Import project assets.

        Import project assets.

        :param project_name: The name of the project to use.
        :type project_name: str
        :param options: Project assets the needs to be imported.
        :type options: JSONType
        :keyword format: Knowledge base Import or Export format. Possible values are: "json", "tsv",
         and "excel".
        :paramtype format: str
        :keyword asset_kind: Kind of the asset of the project. Possible values are: "qnas" or
         "synonyms".
        :paramtype asset_kind: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns None
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                options = {
                    "assets": {
                        "qnas": [
                            {
                                "activeLearningSuggestions": [
                                    {
                                        "clusterHead": "str",  # Optional.
                                          Question chosen as the head of suggested questions cluster by
                                          Active Learning clustering algorithm.
                                        "suggestedQuestions": [
                                            {
                                                "autoSuggestedCount":
                                                  0,  # Optional. The number of times the question was
                                                  suggested automatically by the Active Learning
                                                  algorithm.
                                                "question": "str",  #
                                                  Optional. Question suggested by the Active Learning
                                                  feature.
                                                "userSuggestedCount":
                                                  0  # Optional. The number of times the question was
                                                  suggested explicitly by the user.
                                            }
                                        ]
                                    }
                                ],
                                "answer": "str",  # Optional. Answer text.
                                "dialog": {
                                    "isContextOnly": bool,  # Optional. To mark
                                      if a prompt is relevant only with a previous question or not. If
                                      true, do not include this QnA as answer for queries without
                                      context; otherwise, ignores context and includes this QnA in
                                      answers.
                                    "prompts": [
                                        {
                                            "displayOrder": 0,  #
                                              Optional. Index of the prompt. It is used for ordering of
                                              the prompts.
                                            "displayText": "str",  #
                                              Optional. Text displayed to represent a follow up
                                              question prompt.
                                            "qna": {
                "activeLearningSuggestions": [
                                                    {
                "clusterHead": "str",  # Optional. Question
                                                          chosen as the head of suggested questions
                                                          cluster by Active Learning clustering
                                                          algorithm.
                "suggestedQuestions": [
                {
                "autoSuggestedCount": 0,  # Optional.
                                                                  The number of times the question was
                                                                  suggested automatically by the Active
                                                                  Learning algorithm.
                "question": "str",  # Optional.
                                                                  Question suggested by the Active
                                                                  Learning feature.
                "userSuggestedCount": 0  # Optional.
                                                                  The number of times the question was
                                                                  suggested explicitly by the user.
                }
                                                        ]
                                                    }
                                                ],
                                                "answer": "str",  #
                                                  Optional. Answer text.
                                                "dialog": ...,
                                                "id": 0,  # Optional.
                                                  Unique ID for the QnA.
                                                "metadata": {
                                                    "str": "str"
                                                      # Optional. Metadata associated with the answer,
                                                      useful to categorize or filter question answers.
                                                },
                                                "questions": [
                                                    "str"  #
                                                      Optional. List of questions associated with the
                                                      answer.
                                                ],
                                                "source": "str"  #
                                                  Optional. Source from which QnA was indexed e.g.
                                                  https://docs.microsoft.com/en-us/azure/cognitive-services/QnAMaker/FAQs
                                                  .
                                            },
                                            "qnaId": 0  # Optional. ID of
                                              the QnA corresponding to the prompt.
                                        }
                                    ]
                                },
                                "id": 0,  # Optional. Unique ID for the QnA.
                                "lastUpdatedDateTime": "2020-02-20 00:00:00",  #
                                  Optional. Date-time when the QnA was last updated.
                                "metadata": {
                                    "str": "str"  # Optional. Metadata associated
                                      with the answer, useful to categorize or filter question answers.
                                },
                                "questions": [
                                    "str"  # Optional. List of questions
                                      associated with the answer.
                                ],
                                "source": "str",  # Optional. Source from which QnA
                                  was indexed e.g.
                                  https://docs.microsoft.com/en-us/azure/cognitive-services/QnAMaker/FAQs
                                  .
                                "sourceDisplayName": "str"  # Optional. Friendly name
                                  of the Source.
                            }
                        ],
                        "synonyms": [
                            {
                                "alterations": [
                                    "str"  # Required. Collection of word
                                      alterations.
                                ]
                            }
                        ]
                    },
                    "fileUri": "str",  # Optional. Import data File URI.
                    "metadata": {
                        "description": "str",  # Optional. Description of the project.
                        "language": "str",  # Required. Language of the text records. This is
                          BCP-47 representation of a language. For example, use "en" for English; "es"
                          for Spanish etc. If not set, use "en" for English as default.
                        "multilingualResource": bool,  # Optional. Set to true to enable
                          creating knowledgebases in different languages for the same resource.
                        "settings": {
                            "defaultAnswer": "str"  # Optional. Default Answer response
                              when no good match is found in the knowledge base.
                        }
                    }
                }
        """
        api_version = kwargs.pop("api_version", "2021-10-01")  # type: str
        content_type = kwargs.pop("content_type", "application/json")  # type: Optional[str]
        format = kwargs.pop("format", "json")  # type: Optional[str]
        asset_kind = kwargs.pop("asset_kind", None)  # type: Optional[str]
        polling = kwargs.pop("polling", True)  # type: Union[bool, PollingMethod]
        cls = kwargs.pop("cls", None)  # type: ClsType[None]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._import_assets_initial(
                project_name=project_name,
                options=options,
                format=format,
                asset_kind=asset_kind,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            if cls:
                return cls(pipeline_response, None, {})

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method = LROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
        elif polling is False:
            polling_method = NoPolling()
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    def _deploy_project_initial(  # pylint: disable=inconsistent-return-statements
        self,
        project_name,  # type: str
        deployment_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        cls = kwargs.pop("cls", None)  # type: ClsType[None]
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}))

        api_version = kwargs.pop("api_version", "2021-10-01")  # type: str

        request = build_deploy_project_request_initial(
            project_name=project_name,
            deployment_name=deployment_name,
            api_version=api_version,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    @distributed_trace
    def begin_deploy_project(  # pylint: disable=inconsistent-return-statements
        self,
        project_name,  # type: str
        deployment_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> LROPoller[None]
        """Deploy project to production.

        Deploy project to production.

        :param project_name: The name of the project to use.
        :type project_name: str
        :param deployment_name: The name of the specific deployment of the project to use.
        :type deployment_name: str
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns None
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        api_version = kwargs.pop("api_version", "2021-10-01")  # type: str
        polling = kwargs.pop("polling", True)  # type: Union[bool, PollingMethod]
        cls = kwargs.pop("cls", None)  # type: ClsType[None]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._deploy_project_initial(
                project_name=project_name,
                deployment_name=deployment_name,
                api_version=api_version,
                cls=lambda x, y, z: x,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            if cls:
                return cls(pipeline_response, None, {})

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method = LROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
        elif polling is False:
            polling_method = NoPolling()
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    @distributed_trace
    def list_deployments(
        self,
        project_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable[JSONType]
        """List all deployments of a project.

        List all deployments of a project.

        :param project_name: The name of the project to use.
        :type project_name: str
        :keyword top: The maximum number of resources to return from the collection.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned.
        :paramtype skip: int
        :keyword maxpagesize: The maximum number of resources to include in a single response.
        :paramtype maxpagesize: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSONType]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "nextLink": "str",  # Optional.
                    "value": [
                        {
                            "deploymentName": "str",  # Optional. Name of the deployment.
                            "lastDeployedDateTime": "2020-02-20 00:00:00"  # Optional.
                              Represents the project last deployment date-time.
                        }
                    ]
                }
        """
        api_version = kwargs.pop("api_version", "2021-10-01")  # type: str
        top = kwargs.pop("top", None)  # type: Optional[int]
        skip = kwargs.pop("skip", None)  # type: Optional[int]
        maxpagesize = kwargs.pop("maxpagesize", None)  # type: Optional[int]

        cls = kwargs.pop("cls", None)  # type: ClsType[JSONType]
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}))

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_deployments_request(
                    project_name=project_name,
                    api_version=api_version,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:

                request = build_list_deployments_request(
                    project_name=project_name,
                    api_version=api_version,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(next_link, **path_format_arguments)

                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def list_synonyms(
        self,
        project_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable[JSONType]
        """Gets all the synonyms of a project.

        Gets all the synonyms of a project.

        :param project_name: The name of the project to use.
        :type project_name: str
        :keyword top: The maximum number of resources to return from the collection.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned.
        :paramtype skip: int
        :keyword maxpagesize: The maximum number of resources to include in a single response.
        :paramtype maxpagesize: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSONType]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "nextLink": "str",  # Optional.
                    "value": [
                        {
                            "alterations": [
                                "str"  # Required. Collection of word alterations.
                            ]
                        }
                    ]
                }
        """
        api_version = kwargs.pop("api_version", "2021-10-01")  # type: str
        top = kwargs.pop("top", None)  # type: Optional[int]
        skip = kwargs.pop("skip", None)  # type: Optional[int]
        maxpagesize = kwargs.pop("maxpagesize", None)  # type: Optional[int]

        cls = kwargs.pop("cls", None)  # type: ClsType[JSONType]
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}))

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_synonyms_request(
                    project_name=project_name,
                    api_version=api_version,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:

                request = build_list_synonyms_request(
                    project_name=project_name,
                    api_version=api_version,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(next_link, **path_format_arguments)

                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    @distributed_trace
    def update_synonyms(  # pylint: disable=inconsistent-return-statements
        self,
        project_name,  # type: str
        synonyms,  # type: JSONType
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Updates all the synonyms of a project.

        Updates all the synonyms of a project.

        :param project_name: The name of the project to use.
        :type project_name: str
        :param synonyms: All the synonyms of a project.
        :type synonyms: JSONType
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                synonyms = {
                    "nextLink": "str",  # Optional.
                    "value": [
                        {
                            "alterations": [
                                "str"  # Required. Collection of word alterations.
                            ]
                        }
                    ]
                }
        """
        cls = kwargs.pop("cls", None)  # type: ClsType[None]
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}))

        api_version = kwargs.pop("api_version", "2021-10-01")  # type: str
        content_type = kwargs.pop("content_type", "application/json")  # type: Optional[str]

        _json = synonyms

        request = build_update_synonyms_request(
            project_name=project_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def list_sources(
        self,
        project_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable[JSONType]
        """Gets all the sources of a project.

        Gets all the sources of a project.

        :param project_name: The name of the project to use.
        :type project_name: str
        :keyword top: The maximum number of resources to return from the collection.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned.
        :paramtype skip: int
        :keyword maxpagesize: The maximum number of resources to include in a single response.
        :paramtype maxpagesize: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSONType]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "nextLink": "str",  # Optional.
                    "value": [
                        {
                            "contentStructureKind": "unstructured",  # Optional. Default
                              value is "unstructured". Content structure type for sources. Possible
                              values include: "unstructured".
                            "displayName": "str",  # Optional. Friendly name of the
                              Source.
                            "lastUpdatedDateTime": "2020-02-20 00:00:00",  # Optional.
                              Date-time when the QnA was last updated.
                            "source": "str",  # Optional. Unique source identifier. Name
                              of the file if it's a 'file' source; otherwise, the complete URL if it's
                              a 'url' source.
                            "sourceKind": "str",  # Required. Supported source types.
                              Possible values include: "file", "url".
                            "sourceUri": "str"  # Required. URI location for the file or
                              url.
                        }
                    ]
                }
        """
        api_version = kwargs.pop("api_version", "2021-10-01")  # type: str
        top = kwargs.pop("top", None)  # type: Optional[int]
        skip = kwargs.pop("skip", None)  # type: Optional[int]
        maxpagesize = kwargs.pop("maxpagesize", None)  # type: Optional[int]

        cls = kwargs.pop("cls", None)  # type: ClsType[JSONType]
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}))

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_sources_request(
                    project_name=project_name,
                    api_version=api_version,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:

                request = build_list_sources_request(
                    project_name=project_name,
                    api_version=api_version,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(next_link, **path_format_arguments)

                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    def _update_sources_initial(  # pylint: disable=inconsistent-return-statements
        self,
        project_name,  # type: str
        sources,  # type: List[JSONType]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        cls = kwargs.pop("cls", None)  # type: ClsType[None]
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}))

        api_version = kwargs.pop("api_version", "2021-10-01")  # type: str
        content_type = kwargs.pop("content_type", "application/json")  # type: Optional[str]

        _json = sources

        request = build_update_sources_request_initial(
            project_name=project_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    @distributed_trace
    def begin_update_sources(  # pylint: disable=inconsistent-return-statements
        self,
        project_name,  # type: str
        sources,  # type: List[JSONType]
        **kwargs  # type: Any
    ):
        # type: (...) -> LROPoller[None]
        """Updates the sources of a project.

        Updates the sources of a project.

        :param project_name: The name of the project to use.
        :type project_name: str
        :param sources: Update sources parameters of a project.
        :type sources: list[JSONType]
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns None
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                sources = [
                    {
                        "op": "str",  # Required. Update operation type for assets. Possible
                          values include: "add", "delete", "replace".
                        "value": {
                            "contentStructureKind": "unstructured",  # Optional. Default
                              value is "unstructured". Content structure type for sources. Possible
                              values include: "unstructured".
                            "displayName": "str",  # Optional. Friendly name of the
                              Source.
                            "refresh": bool,  # Optional. Boolean flag used to refresh
                              data from the Source.
                            "source": "str",  # Optional. Unique source identifier. Name
                              of the file if it's a 'file' source; otherwise, the complete URL if it's
                              a 'url' source.
                            "sourceKind": "str",  # Required. Supported source types.
                              Possible values include: "file", "url".
                            "sourceUri": "str"  # Required. URI location for the file or
                              url.
                        }
                    }
                ]
        """
        api_version = kwargs.pop("api_version", "2021-10-01")  # type: str
        content_type = kwargs.pop("content_type", "application/json")  # type: Optional[str]
        polling = kwargs.pop("polling", True)  # type: Union[bool, PollingMethod]
        cls = kwargs.pop("cls", None)  # type: ClsType[None]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._update_sources_initial(
                project_name=project_name,
                sources=sources,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            if cls:
                return cls(pipeline_response, None, {})

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method = LROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
        elif polling is False:
            polling_method = NoPolling()
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    @distributed_trace
    def list_qnas(
        self,
        project_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable[JSONType]
        """Gets all the QnAs of a project.

        Gets all the QnAs of a project.

        :param project_name: The name of the project to use.
        :type project_name: str
        :keyword source: Source of the QnA.
        :paramtype source: str
        :keyword top: The maximum number of resources to return from the collection.
        :paramtype top: int
        :keyword skip: An offset into the collection of the first resource to be returned.
        :paramtype skip: int
        :keyword maxpagesize: The maximum number of resources to include in a single response.
        :paramtype maxpagesize: int
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.paging.ItemPaged[JSONType]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "nextLink": "str",  # Optional.
                    "value": [
                        {
                            "activeLearningSuggestions": [
                                {
                                    "clusterHead": "str",  # Optional. Question
                                      chosen as the head of suggested questions cluster by Active
                                      Learning clustering algorithm.
                                    "suggestedQuestions": [
                                        {
                                            "autoSuggestedCount": 0,  #
                                              Optional. The number of times the question was suggested
                                              automatically by the Active Learning algorithm.
                                            "question": "str",  #
                                              Optional. Question suggested by the Active Learning
                                              feature.
                                            "userSuggestedCount": 0  #
                                              Optional. The number of times the question was suggested
                                              explicitly by the user.
                                        }
                                    ]
                                }
                            ],
                            "answer": "str",  # Optional. Answer text.
                            "dialog": {
                                "isContextOnly": bool,  # Optional. To mark if a
                                  prompt is relevant only with a previous question or not. If true, do
                                  not include this QnA as answer for queries without context;
                                  otherwise, ignores context and includes this QnA in answers.
                                "prompts": [
                                    {
                                        "displayOrder": 0,  # Optional. Index
                                          of the prompt. It is used for ordering of the prompts.
                                        "displayText": "str",  # Optional.
                                          Text displayed to represent a follow up question prompt.
                                        "qna": {
                                            "activeLearningSuggestions":
                                              [
                                                {
                "clusterHead": "str",  # Optional. Question
                                                      chosen as the head of suggested questions cluster
                                                      by Active Learning clustering algorithm.
                "suggestedQuestions": [
                                                        {
                "autoSuggestedCount": 0,  # Optional. The
                                                              number of times the question was
                                                              suggested automatically by the Active
                                                              Learning algorithm.
                "question": "str",  # Optional. Question
                                                              suggested by the Active Learning feature.
                "userSuggestedCount": 0  # Optional. The
                                                              number of times the question was
                                                              suggested explicitly by the user.
                                                        }
                                                    ]
                                                }
                                            ],
                                            "answer": "str",  # Optional.
                                              Answer text.
                                            "dialog": ...,
                                            "id": 0,  # Optional. Unique
                                              ID for the QnA.
                                            "metadata": {
                                                "str": "str"  #
                                                  Optional. Metadata associated with the answer, useful
                                                  to categorize or filter question answers.
                                            },
                                            "questions": [
                                                "str"  # Optional.
                                                  List of questions associated with the answer.
                                            ],
                                            "source": "str"  # Optional.
                                              Source from which QnA was indexed e.g.
                                              https://docs.microsoft.com/en-us/azure/cognitive-services/QnAMaker/FAQs
                                              .
                                        },
                                        "qnaId": 0  # Optional. ID of the QnA
                                          corresponding to the prompt.
                                    }
                                ]
                            },
                            "id": 0,  # Optional. Unique ID for the QnA.
                            "lastUpdatedDateTime": "2020-02-20 00:00:00",  # Optional.
                              Date-time when the QnA was last updated.
                            "metadata": {
                                "str": "str"  # Optional. Metadata associated with
                                  the answer, useful to categorize or filter question answers.
                            },
                            "questions": [
                                "str"  # Optional. List of questions associated with
                                  the answer.
                            ],
                            "source": "str"  # Optional. Source from which QnA was
                              indexed e.g.
                              https://docs.microsoft.com/en-us/azure/cognitive-services/QnAMaker/FAQs .
                        }
                    ]
                }
        """
        api_version = kwargs.pop("api_version", "2021-10-01")  # type: str
        source = kwargs.pop("source", None)  # type: Optional[str]
        top = kwargs.pop("top", None)  # type: Optional[int]
        skip = kwargs.pop("skip", None)  # type: Optional[int]
        maxpagesize = kwargs.pop("maxpagesize", None)  # type: Optional[int]

        cls = kwargs.pop("cls", None)  # type: ClsType[JSONType]
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}))

        def prepare_request(next_link=None):
            if not next_link:

                request = build_list_qnas_request(
                    project_name=project_name,
                    api_version=api_version,
                    source=source,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:

                request = build_list_qnas_request(
                    project_name=project_name,
                    api_version=api_version,
                    source=source,
                    top=top,
                    skip=skip,
                    maxpagesize=maxpagesize,
                )
                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(next_link, **path_format_arguments)

                path_format_arguments = {
                    "Endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.method = "GET"
            return request

        def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=False, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return ItemPaged(get_next, extract_data)

    def _update_qnas_initial(  # pylint: disable=inconsistent-return-statements
        self,
        project_name,  # type: str
        qnas,  # type: List[JSONType]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        cls = kwargs.pop("cls", None)  # type: ClsType[None]
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}))

        api_version = kwargs.pop("api_version", "2021-10-01")  # type: str
        content_type = kwargs.pop("content_type", "application/json")  # type: Optional[str]

        _json = qnas

        request = build_update_qnas_request_initial(
            project_name=project_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        response_headers = {}
        response_headers["Operation-Location"] = self._deserialize("str", response.headers.get("Operation-Location"))

        if cls:
            return cls(pipeline_response, None, response_headers)

    @distributed_trace
    def begin_update_qnas(  # pylint: disable=inconsistent-return-statements
        self,
        project_name,  # type: str
        qnas,  # type: List[JSONType]
        **kwargs  # type: Any
    ):
        # type: (...) -> LROPoller[None]
        """Updates the QnAs of a project.

        Updates the QnAs of a project.

        :param project_name: The name of the project to use.
        :type project_name: str
        :param qnas: Update QnAs parameters of a project.
        :type qnas: list[JSONType]
        :keyword str continuation_token: A continuation token to restart a poller from a saved state.
        :keyword polling: By default, your polling method will be LROBasePolling. Pass in False for
         this operation to not poll, or pass in your own initialized polling object for a personal
         polling strategy.
        :paramtype polling: bool or ~azure.core.polling.PollingMethod
        :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
         Retry-After header is present.
        :return: An instance of LROPoller that returns None
        :rtype: ~azure.core.polling.LROPoller[None]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                qnas = [
                    {
                        "op": "str",  # Required. Update operation type for assets. Possible
                          values include: "add", "delete", "replace".
                        "value": {
                            "activeLearningSuggestions": [
                                {
                                    "clusterHead": "str",  # Optional. Question
                                      chosen as the head of suggested questions cluster by Active
                                      Learning clustering algorithm.
                                    "suggestedQuestions": [
                                        {
                                            "autoSuggestedCount": 0,  #
                                              Optional. The number of times the question was suggested
                                              automatically by the Active Learning algorithm.
                                            "question": "str",  #
                                              Optional. Question suggested by the Active Learning
                                              feature.
                                            "userSuggestedCount": 0  #
                                              Optional. The number of times the question was suggested
                                              explicitly by the user.
                                        }
                                    ]
                                }
                            ],
                            "answer": "str",  # Optional. Answer text.
                            "dialog": {
                                "isContextOnly": bool,  # Optional. To mark if a
                                  prompt is relevant only with a previous question or not. If true, do
                                  not include this QnA as answer for queries without context;
                                  otherwise, ignores context and includes this QnA in answers.
                                "prompts": [
                                    {
                                        "displayOrder": 0,  # Optional. Index
                                          of the prompt. It is used for ordering of the prompts.
                                        "displayText": "str",  # Optional.
                                          Text displayed to represent a follow up question prompt.
                                        "qna": ...,
                                        "qnaId": 0  # Optional. ID of the QnA
                                          corresponding to the prompt.
                                    }
                                ]
                            },
                            "id": 0,  # Optional. Unique ID for the QnA.
                            "metadata": {
                                "str": "str"  # Optional. Metadata associated with
                                  the answer, useful to categorize or filter question answers.
                            },
                            "questions": [
                                "str"  # Optional. List of questions associated with
                                  the answer.
                            ],
                            "source": "str"  # Optional. Source from which QnA was
                              indexed e.g.
                              https://docs.microsoft.com/en-us/azure/cognitive-services/QnAMaker/FAQs .
                        }
                    }
                ]
        """
        api_version = kwargs.pop("api_version", "2021-10-01")  # type: str
        content_type = kwargs.pop("content_type", "application/json")  # type: Optional[str]
        polling = kwargs.pop("polling", True)  # type: Union[bool, PollingMethod]
        cls = kwargs.pop("cls", None)  # type: ClsType[None]
        lro_delay = kwargs.pop("polling_interval", self._config.polling_interval)
        cont_token = kwargs.pop("continuation_token", None)  # type: Optional[str]
        if cont_token is None:
            raw_result = self._update_qnas_initial(
                project_name=project_name,
                qnas=qnas,
                api_version=api_version,
                content_type=content_type,
                cls=lambda x, y, z: x,
                **kwargs
            )
        kwargs.pop("error_map", None)

        def get_long_running_output(pipeline_response):
            if cls:
                return cls(pipeline_response, None, {})

        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }

        if polling is True:
            polling_method = LROBasePolling(lro_delay, path_format_arguments=path_format_arguments, **kwargs)
        elif polling is False:
            polling_method = NoPolling()
        else:
            polling_method = polling
        if cont_token:
            return LROPoller.from_continuation_token(
                polling_method=polling_method,
                continuation_token=cont_token,
                client=self._client,
                deserialization_callback=get_long_running_output,
            )
        return LROPoller(self._client, raw_result, get_long_running_output, polling_method)

    @distributed_trace
    def add_feedback(  # pylint: disable=inconsistent-return-statements
        self,
        project_name,  # type: str
        feedback,  # type: JSONType
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Update Active Learning feedback.

        Update Active Learning feedback.

        :param project_name: The name of the project to use.
        :type project_name: str
        :param feedback: Feedback for Active Learning.
        :type feedback: JSONType
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                feedback = {
                    "records": [
                        {
                            "qnaId": 0,  # Optional. Unique ID of the QnA.
                            "userId": "str",  # Optional. Unique identifier of the user.
                            "userQuestion": "str"  # Optional. User suggested question
                              for the QnA.
                        }
                    ]
                }
        """
        cls = kwargs.pop("cls", None)  # type: ClsType[None]
        error_map = {401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop("error_map", {}))

        api_version = kwargs.pop("api_version", "2021-10-01")  # type: str
        content_type = kwargs.pop("content_type", "application/json")  # type: Optional[str]

        _json = feedback

        request = build_add_feedback_request(
            project_name=project_name,
            api_version=api_version,
            content_type=content_type,
            json=_json,
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=False, **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})
