# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Serializer, Deserializer

from ._configuration import ApplicationInsightsManagementClientConfiguration
from .operations import EASubscriptionMigrateToNewPricingModelOperations
from .operations import EASubscriptionRollbackToLegacyPricingModelOperations
from .operations import EASubscriptionListMigrationDateOperations
from .operations import ComponentCurrentPricingPlanOperations
from . import models


class ApplicationInsightsManagementClient(SDKClient):
    """Composite Swagger for Application Insights Management Client

    :ivar config: Configuration for client.
    :vartype config: ApplicationInsightsManagementClientConfiguration

    :ivar ea_subscription_migrate_to_new_pricing_model: EASubscriptionMigrateToNewPricingModel operations
    :vartype ea_subscription_migrate_to_new_pricing_model: azure.mgmt.applicationinsights.v2017_10_01.operations.EASubscriptionMigrateToNewPricingModelOperations
    :ivar ea_subscription_rollback_to_legacy_pricing_model: EASubscriptionRollbackToLegacyPricingModel operations
    :vartype ea_subscription_rollback_to_legacy_pricing_model: azure.mgmt.applicationinsights.v2017_10_01.operations.EASubscriptionRollbackToLegacyPricingModelOperations
    :ivar ea_subscription_list_migration_date: EASubscriptionListMigrationDate operations
    :vartype ea_subscription_list_migration_date: azure.mgmt.applicationinsights.v2017_10_01.operations.EASubscriptionListMigrationDateOperations
    :ivar component_current_pricing_plan: ComponentCurrentPricingPlan operations
    :vartype component_current_pricing_plan: azure.mgmt.applicationinsights.v2017_10_01.operations.ComponentCurrentPricingPlanOperations

    :param credentials: Credentials needed for the client to connect to Azure.
    :type credentials: :mod:`A msrestazure Credentials
     object<msrestazure.azure_active_directory>`
    :param subscription_id: The ID of the target subscription.
    :type subscription_id: str
    :param str base_url: Service URL
    """

    def __init__(
            self, credentials, subscription_id, base_url=None):

        self.config = ApplicationInsightsManagementClientConfiguration(credentials, subscription_id, base_url)
        super(ApplicationInsightsManagementClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '2017-10-01'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.ea_subscription_migrate_to_new_pricing_model = EASubscriptionMigrateToNewPricingModelOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.ea_subscription_rollback_to_legacy_pricing_model = EASubscriptionRollbackToLegacyPricingModelOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.ea_subscription_list_migration_date = EASubscriptionListMigrationDateOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.component_current_pricing_plan = ComponentCurrentPricingPlanOperations(
            self._client, self.config, self._serialize, self._deserialize)
