# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ResourceCertificateDetails(Model):
    """Certificate details representing the Vault credentials.

    You probably want to use the sub-classes and not this class directly. Known
    sub-classes are: ResourceCertificateAndAadDetails,
    ResourceCertificateAndAcsDetails

    All required parameters must be populated in order to send to Azure.

    :param certificate: The base64 encoded certificate raw data string.
    :type certificate: bytearray
    :param friendly_name: Certificate friendlyname.
    :type friendly_name: str
    :param issuer: Certificate issuer.
    :type issuer: str
    :param resource_id: Resource ID of the vault.
    :type resource_id: long
    :param subject: Certificate Subject Name.
    :type subject: str
    :param thumbprint: Certificate thumbprint.
    :type thumbprint: str
    :param valid_from: Certificate Validity start Date time.
    :type valid_from: datetime
    :param valid_to: Certificate Validity End Date time.
    :type valid_to: datetime
    :param auth_type: Required. Constant filled by server.
    :type auth_type: str
    """

    _validation = {
        'auth_type': {'required': True},
    }

    _attribute_map = {
        'certificate': {'key': 'certificate', 'type': 'bytearray'},
        'friendly_name': {'key': 'friendlyName', 'type': 'str'},
        'issuer': {'key': 'issuer', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'long'},
        'subject': {'key': 'subject', 'type': 'str'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'valid_from': {'key': 'validFrom', 'type': 'iso-8601'},
        'valid_to': {'key': 'validTo', 'type': 'iso-8601'},
        'auth_type': {'key': 'authType', 'type': 'str'},
    }

    _subtype_map = {
        'auth_type': {'AzureActiveDirectory': 'ResourceCertificateAndAadDetails', 'AccessControlService': 'ResourceCertificateAndAcsDetails'}
    }

    def __init__(self, **kwargs):
        super(ResourceCertificateDetails, self).__init__(**kwargs)
        self.certificate = kwargs.get('certificate', None)
        self.friendly_name = kwargs.get('friendly_name', None)
        self.issuer = kwargs.get('issuer', None)
        self.resource_id = kwargs.get('resource_id', None)
        self.subject = kwargs.get('subject', None)
        self.thumbprint = kwargs.get('thumbprint', None)
        self.valid_from = kwargs.get('valid_from', None)
        self.valid_to = kwargs.get('valid_to', None)
        self.auth_type = None
