# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .content_key_policy_restriction_token_key import ContentKeyPolicyRestrictionTokenKey


class ContentKeyPolicySymmetricTokenKey(ContentKeyPolicyRestrictionTokenKey):
    """Specifies a symmetric key for token validation.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param key_value: Required. The key value of the key
    :type key_value: bytearray
    """

    _validation = {
        'odatatype': {'required': True},
        'key_value': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': '@odata\\.type', 'type': 'str'},
        'key_value': {'key': 'keyValue', 'type': 'bytearray'},
    }

    def __init__(self, **kwargs):
        super(ContentKeyPolicySymmetricTokenKey, self).__init__(**kwargs)
        self.key_value = kwargs.get('key_value', None)
        self.odatatype = '#Microsoft.Media.ContentKeyPolicySymmetricTokenKey'
