# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class EntitiesEntityPresentationInfo(Model):
    """Defines additional information about an entity such as type hints.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param entity_scenario: Required. The supported scenario. Possible values
     include: 'DominantEntity', 'DisambiguationItem', 'ListItem'. Default
     value: "DominantEntity" .
    :type entity_scenario: str or
     ~azure.cognitiveservices.search.entitysearch.models.EntityScenario
    :ivar entity_type_hints: A list of hints that indicate the entity's type.
     The list could contain a single hint such as Movie or a list of hints such
     as Place, LocalBusiness, Restaurant. Each successive hint in the array
     narrows the entity's type.
    :vartype entity_type_hints: list[str or
     ~azure.cognitiveservices.search.entitysearch.models.EntityType]
    :ivar entity_type_display_hint: A display version of the entity hint. For
     example, if entityTypeHints is Artist, this field may be set to American
     Singer.
    :vartype entity_type_display_hint: str
    """

    _validation = {
        'entity_scenario': {'required': True},
        'entity_type_hints': {'readonly': True},
        'entity_type_display_hint': {'readonly': True},
    }

    _attribute_map = {
        'entity_scenario': {'key': 'entityScenario', 'type': 'str'},
        'entity_type_hints': {'key': 'entityTypeHints', 'type': '[str]'},
        'entity_type_display_hint': {'key': 'entityTypeDisplayHint', 'type': 'str'},
    }

    def __init__(self, *, entity_scenario="DominantEntity", **kwargs) -> None:
        super(EntitiesEntityPresentationInfo, self).__init__(**kwargs)
        self.entity_scenario = entity_scenario
        self.entity_type_hints = None
        self.entity_type_display_hint = None
