import string, cStringIO, base64
from ftplib import *
from Ft.Server.Core import GetRepository
from Ft.Server.Protocols.Ftp.config import initial_msg

g_xmlText = """<?xml version = "1.0"?>
<ADDRBOOK>
    <ENTRY ID="pa">
        <NAME>Pieter Aaron</NAME>
        <ADDRESS>404 Error Way</ADDRESS>
        <PHONENUM DESC="Work">404-555-1234</PHONENUM>
        <PHONENUM DESC="Fax">404-555-4321</PHONENUM>
        <PHONENUM DESC="Pager">404-555-5555</PHONENUM>
        <EMAIL>pieter.aaron@inter.net</EMAIL>
    </ENTRY>
    <ENTRY ID="en">
        <NAME>Emeka Ndubuisi</NAME>
        <ADDRESS>42 Spam Blvd</ADDRESS>
        <PHONENUM DESC="Work">767-555-7676</PHONENUM>
        <PHONENUM DESC="Fax">767-555-7642</PHONENUM>
        <PHONENUM DESC="Pager">800-SKY-PAGEx767676</PHONENUM>
        <EMAIL>endubuisi@spamtron.com</EMAIL>
    </ENTRY>
    <ENTRY ID="vz">
        <NAME>Vasia Zhugenev</NAME>
        <ADDRESS>2000 Disaster Plaza</ADDRESS>
        <PHONENUM DESC="Work">000-987-6543</PHONENUM>
        <PHONENUM DESC="Cell">000-000-0000</PHONENUM>
        <EMAIL>vxz@magog.ru</EMAIL>
    </ENTRY>
</ADDRBOOK>
"""


def prime(tester):

    tester.startTest("Prime Repository")
    repo = tester.test_data['util'].getRepo()

    if repo.hasContainer('/test.com'):
        repo.deleteContainer('/test.com')

    container = repo.createContainer('/test.com',1)
    doc1 = container.createRawFile('testDoc1', 'text/xml', g_xmlText)

    repo.txCommit()
    tester.testDone()

def testCommands(tester):    
    tester.startTest("Testing connecting and (USER, PASS)")
    repo = tester.test_data['util'].getRepo()

    f=FTP()
    tester.compare("220 "+initial_msg,f.connect('localhost',int(raw_input("Please enter port of the running 4SSFTPServer:\t"))))
    response=f.login(tester.userName, raw_input("Please renter the password for 4SS user %s :\t"%tester.userName))
    tester.compare("230 You may proceed, "+tester.userName,response)
    
    tester.testDone()
    
    tester.startTest("Testing CWD, STOR, LIST, and DELE")
    tester.compare("250 Ok, current path is /test.com",f.sendcmd("CWD /test.com"))
    tester.compare("226 Phew, upload successfully completed",f.storlines("STOR /test.com/testDoc2",cStringIO.StringIO(g_xmlText)))
    tester.compare(['testDoc1', 'testDoc2'],f.nlst())
    tester.compare(1,repo.hasResource('/test.com/testDoc2'))
    tester.compare("250 File eliminated",f.delete('/test.com/testDoc2'))
    repo = GetRepository(tester.userName, tester.passwd)
    tester.compare(0,repo.hasResource('/test.com/testDoc2'))
    
    tester.testDone()
    
    tester.startTest("Testing MKD, RMD, CDUP, PWD")
    tester.compare('257 "/test.com/test1" Directory created',f.sendcmd("MKD /test.com/test1"))
    repo = GetRepository(tester.userName, tester.passwd)
    tester.compare(1,repo.hasResource('/test.com/test1'))    
    tester.compare("250 Directory removed",f.sendcmd("RMD /test.com/test1"))
    repo = GetRepository(tester.userName, tester.passwd)
    tester.compare(0,repo.hasResource('/test.com/test1'))    
    tester.compare("250 Ok, current path is /",f.sendcmd("CDUP"))
    tester.compare("/",f.pwd())
    
    tester.testDone()
    
    f.close()
    
def Test(tester):
    tester.startGroup("Testing 4SS FTP Daemon")
    tester.startTest("Not TEsted")
    tester.warning("Not finished")
    tester.testDone()
    tester.groupDone()
    return
    prime(tester)
    testCommands(tester)
    tester.groupDone()

