<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE xsl:stylesheet [
  <!ENTITY f  "http://xmlns.4suite.org/ext">
  <!ENTITY fres "http://xmlns.4suite.org/reserved">
]>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:cext="http://xmlns.4suite.org/demos/cards"
  xmlns:exslt="http://exslt.org/common"
  xmlns:exslt-str="http://exslt.org/strings"
  xmlns:f="&f;"
  xmlns:fcore="http://xmlns.4suite.org/4ss/score"
  xmlns:fhttp="http://xmlns.4suite.org/4ss/http"
  xmlns:fres="&fres;"
  xmlns:xupdate="http://www.xmldb.org/xupdate"
  extension-element-prefixes="cext exslt exslt-str f fcore fhttp fres"
  exclude-result-prefixes="xupdate"
>

  <!--

    4Suite repository demo application: Cribbage

    This stylesheet processes the user's play.

    Copyright 2004 Fourthought, Inc. (USA)
    http://4suite.org/

  -->

  <xsl:import href='error.xslt'/>
  <xsl:import href='changes.xsl'/>

  <xsl:output method='html'/>

  <xsl:param name='fres:uri-path'/>

  <xsl:param name='play1.x'/>
  <xsl:param name='play2.x'/>
  <xsl:param name='play3.x'/>
  <xsl:param name='play4.x'/>
  <xsl:param name='GO'/>


  <xsl:template match='/'>
    <!-- Validate the human move -->
    <xsl:choose>
      <xsl:when test='$GO and key("players",2)/playing-cards/Card[number(@point) + sum(/cribbage/game-info/cur-count/score) &lt; 32]'>
        <xsl:call-template name="display-error">
          <xsl:with-param name='message' select='"You cannot go when you have cards to play that keep the current count less than 31"'/>
          <xsl:with-param name='uri' select='concat($fres:uri-path,"?xslt=../play-human.xsl")'/>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test='$GO'>
        <xsl:variable name='changes'>
          <Changes>
            <xsl:call-template name='make-go'>
              <xsl:with-param name='player' select='2'/>
            </xsl:call-template>
          </Changes>
        </xsl:variable>
        <xsl:call-template name='process-next-step'>
          <xsl:with-param name='current-changes' select='$changes'/>
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name='move-human'/>
      </xsl:otherwise>

    </xsl:choose>
  </xsl:template>

  <xsl:template name='move-human'>

    <!-- determine the card and see if it is a valid move -->
    <xsl:variable name='sorted-cards'>
      <xsl:for-each select='key("players",2)/playing-cards/Card'>
        <xsl:sort select='@value-int' data-type='number'/>
        <xsl:copy-of select='.'/>
      </xsl:for-each>
    </xsl:variable>
    <xsl:choose>
      <xsl:when test='$play1.x'>
        <xsl:call-template name='make-move'>
          <xsl:with-param name='card' select='exslt:node-set($sorted-cards)/Card[1]'/>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test='$play2.x'>
        <xsl:call-template name='make-move'>
          <xsl:with-param name='card' select='exslt:node-set($sorted-cards)/Card[2]'/>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test='$play3.x'>
        <xsl:call-template name='make-move'>
          <xsl:with-param name='card' select='exslt:node-set($sorted-cards)/Card[3]'/>
        </xsl:call-template>
      </xsl:when>
      <xsl:when test='$play4.x'>
        <xsl:call-template name='make-move'>
          <xsl:with-param name='card' select='exslt:node-set($sorted-cards)/Card[4]'/>
        </xsl:call-template>
      </xsl:when>
    </xsl:choose>

  </xsl:template>

  <xsl:template name='make-move'>
    <xsl:param name='card'/>

    <!-- Verify that it can be played on the current stack -->
    <xsl:choose>
      <xsl:when test='sum(/cribbage/game-info/cur-count/score) + number($card/@point) &gt; 31'>
        <xsl:call-template name="display-error">
          <xsl:with-param name='message' select='"You cannot play this card because it puts you over 31"'/>
          <xsl:with-param name='uri' select='concat($fres:uri-path,"?xslt=../play-human.xsl")'/>
        </xsl:call-template>
      </xsl:when>

      <xsl:otherwise>
        <!-- That is all to check to see if it can be played.  Now play it -->
        <xsl:variable name='changes'>
          <Changes>
            <xsl:call-template name='play-card'>
              <xsl:with-param name='player' select='2'/>
              <xsl:with-param name='card' select='$card'/>
              <xsl:with-param name='played' select='/cribbage/game-info/cur-played/Card'/>
              <xsl:with-param name='cur-count' select='$initial-count'/>

            </xsl:call-template>
          </Changes>
        </xsl:variable>
        <xsl:call-template name='process-next-step'>
          <xsl:with-param name='current-changes' select='$changes'/>
        </xsl:call-template>

      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


</xsl:stylesheet>
