########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Common/ResourceTypes.py,v 1.5 2005/10/28 06:52:27 mbrown Exp $
"""
Constants for referring to repository resource types; related functions

Copyright 2005 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

class ResourceType:
    RESOURCE = 0
    CONTAINER = 1
    ALIAS = 2
    RAW_FILE = 3
    XML_DOCUMENT = 4
    XSLT_DOCUMENT = 5
    SCHEMATRON_DOCUMENT = 6
    USER = 7
    GROUP = 8
    XPATH_DOCUMENT_DEFINITION = 9
    XSLT_DOCUMENT_DEFINITION = 11
    RDF_DOCUMENT = 12
    DOCUMENT_DEFINITION = 13
    COMMAND = 14
    SERVER = 15
    META_DATA = 16
    URI_REFERENCE_FILE = 17

RAW_FILES = [ResourceType.CONTAINER,
             ResourceType.ALIAS,
             ResourceType.RAW_FILE,
             ResourceType.XML_DOCUMENT,
             ResourceType.XSLT_DOCUMENT,
             ResourceType.SCHEMATRON_DOCUMENT,
             ResourceType.USER,
             ResourceType.GROUP,
             ResourceType.XPATH_DOCUMENT_DEFINITION,
             ResourceType.XSLT_DOCUMENT_DEFINITION,
             ResourceType.RDF_DOCUMENT,
             ResourceType.COMMAND,
             ResourceType.SERVER,
             ResourceType.URI_REFERENCE_FILE,
             ]

XML_DOCUMENTS = [ResourceType.CONTAINER,
                 ResourceType.ALIAS,
                 ResourceType.XML_DOCUMENT,
                 ResourceType.XSLT_DOCUMENT,
                 ResourceType.SCHEMATRON_DOCUMENT,
                 ResourceType.USER,
                 ResourceType.GROUP,
                 ResourceType.XPATH_DOCUMENT_DEFINITION,
                 ResourceType.XSLT_DOCUMENT_DEFINITION,
                 ResourceType.RDF_DOCUMENT,
                 ResourceType.COMMAND,
                 ResourceType.SERVER,
                 ]

DOCUMENT_DEFINITIONS = [ResourceType.XPATH_DOCUMENT_DEFINITION,
                        ResourceType.XSLT_DOCUMENT_DEFINITION]

CONTAINERS = [ResourceType.CONTAINER,
              ]

g_resourceTypeMap = {ResourceType.RESOURCE: "Unknown Resource",
                     ResourceType.CONTAINER: "Container",
                     ResourceType.ALIAS: "Alias",
                     ResourceType.RAW_FILE: "Raw File",
                     ResourceType.XML_DOCUMENT: "XML Document",
                     ResourceType.XSLT_DOCUMENT: "XSLT Document",
                     ResourceType.SCHEMATRON_DOCUMENT: "Schematron Document",
                     ResourceType.USER: "User",
                     ResourceType.GROUP: "Group",
                     ResourceType.DOCUMENT_DEFINITION: "Document Definition",
                     ResourceType.XPATH_DOCUMENT_DEFINITION: "XPath Document Definition",
                     ResourceType.XSLT_DOCUMENT_DEFINITION: "XSLT Document Definition",
                     ResourceType.RDF_DOCUMENT: "RDF Document",
                     ResourceType.COMMAND: "Command",
                     ResourceType.SERVER: "Server",
                     ResourceType.URI_REFERENCE_FILE: "URI Reference",
                     ResourceType.META_DATA: "Resource MetaData",
                     }


def _IsResourceType(resourceType,testType):
    if testType == ResourceType.RAW_FILE:
        return resourceType != ResourceType.RESOURCE
    if testType == ResourceType.XML_DOCUMENT:
        return resourceType in XML_DOCUMENTS
    if testType == ResourceType.DOCUMENT_DEFINITION:
        return resourceType in DOCUMENT_DEFINITIONS
    if testType == ResourceType.CONTAINER:
        return resourceType in CONTAINERS
    return testType == resourceType


# resource meta-type (repo driver level):
# stored, along with a resource path, in the repository as a key
# for accessing a resource's metadata, its content, etc.
RESOURCE_METADATA= 1
RESOURCE_CONTENT= 2
RESOURCE_CACHE = 3
SESSION_DATA = 4
