from Ft.Rdf.Drivers import Memory
from Ft.Rdf import Model
def CreateInfEng():
    from Ft.Rdf.Inference import InferenceEngine
    db = Memory.DbAdapter('kb')
    db.begin()
    kb = Model.Model( db)
    return InferenceEngine.InferenceEngine(kb)

def Test(test):
    test.startGroup('Inference Action')
    
    test.startTest('Syntax')
    from Ft.Rdf.Inference import InferenceEngine
    from Ft.Rdf.Parsers.Ril import RilParserImp
    test.testDone()


    exp = """<?xml version = "1.0"?>
<ril:expression xmlns:ril = "http://namespaces.rdfinference.org/ril" xmlns:ft = "http://namespaces.fourthought.com/test">
  <ril:assert>
    <ft:wet>
        <ril:string-list>
          <ril:string>Mike</ril:string>
          <ril:string>Uche</ril:string>
        </ril:string-list>
    </ft:wet>
  </ril:assert>
  <ril:subject>
    <ril:query>
      <ft:wet>
        <ril:variable name="X"/>
      </ft:wet>
    </ril:query>
  </ril:subject>
  <ril:predicate>
    <ril:query>
      <ft:wet>
        <ril:variable name="X"/>
      </ft:wet>
    </ril:query>
  </ril:predicate>
  <ril:object>
    <ril:query>
      <ft:wet>
        <ril:variable name="X"/>
      </ft:wet>
    </ril:query>
  </ril:object>
<!-- Test the path function -->
  <ril:assert>
    <ft:s1>
      <ril:string>A</ril:string>
      <ril:string>B</ril:string>
    </ft:s1>
    <ft:s2>
      <ril:string>B</ril:string>
      <ril:string>C</ril:string>
    </ft:s2>
    <ft:s3>
      <ril:string>C</ril:string>
      <ril:string>D</ril:string>
    </ft:s3>
    <ft:s4>
      <ril:string>D</ril:string>
      <ril:string>E</ril:string>
    </ft:s4>
    <ft:s5>
      <ril:string>A</ril:string>
      <ril:string>D</ril:string>
    </ft:s5>
    <ft:s6>
      <ril:string>A</ril:string>
      <ril:string>F</ril:string>
    </ft:s6>
    <ft:s7>
      <ril:string>F</ril:string>
      <ril:string>E</ril:string>
    </ft:s7>
  </ril:assert>
  <ril:paths>
    <ril:start><ril:string>A</ril:string></ril:start>
    <ril:end><ril:string>E</ril:string></ril:end>
    <ril:predicate-list>
       <ft:s1/>
       <ft:s2/>
       <ft:s3/>
       <ft:s4/>
       <ft:s5/>
       <ft:s6/>
    </ril:predicate-list>
  </ril:paths>
  <ril:reverse-paths>
    <ril:start><ril:string>E</ril:string></ril:start>
    <ril:end><ril:string>A</ril:string></ril:end>
    <ril:predicate-list>
       <ft:s1/>
       <ft:s2/>
       <ft:s3/>
       <ft:s4/>
       <ft:s5/>
       <ft:s6/>
    </ril:predicate-list>
  </ril:reverse-paths>
  
<!--Index Action-->
  <ril:index index="1">
    <ril:string-list>
      <ril:string>0</ril:string>
      <ril:string>1</ril:string>
      <ril:string>2</ril:string>
      <ril:string>3</ril:string>
    </ril:string-list>
  </ril:index>
  <ril:reverse>
    <ril:string-list>
      <ril:string>0</ril:string>
      <ril:string>1</ril:string>
      <ril:string>2</ril:string>
      <ril:string>3</ril:string>
    </ril:string-list>
  </ril:reverse>
  
  <ril:slice start="1" end="3">
    <ril:string-list>
      <ril:string>0</ril:string>
      <ril:string>1</ril:string>
      <ril:string>2</ril:string>
      <ril:string>3</ril:string>
    </ril:string-list>
  </ril:slice>
  
<!--Unique Action-->
  <ril:unique>
    <ril:string-list>
      <ril:string>2</ril:string>
      <ril:string>1</ril:string>
      <ril:string>2</ril:string>
      <ril:string>2</ril:string>
    </ril:string-list>
  </ril:unique>


<!--Intersection Action-->
  <ril:intersection>
    <ril:string-list>
      <ril:string>0</ril:string>
      <ril:string>1</ril:string>
      <ril:string>2</ril:string>
      <ril:string>3</ril:string>
    </ril:string-list>
    <ril:string-list>
      <ril:string>2</ril:string>
      <ril:string>3</ril:string>
      <ril:string>4</ril:string>
      <ril:string>5</ril:string>
    </ril:string-list>
  </ril:intersection>

<!--Union Action-->
  <ril:union>
    <ril:string-list>
      <ril:string>0</ril:string>
      <ril:string>1</ril:string>
      <ril:string>2</ril:string>
      <ril:string>3</ril:string>
    </ril:string-list>
    <ril:string-list>
      <ril:string>2</ril:string>
      <ril:string>3</ril:string>
      <ril:string>4</ril:string>
      <ril:string>5</ril:string>
    </ril:string-list>
  </ril:union>

<!--Count Action -->
  <ril:count>
    <ril:string-list>
      <ril:string>1</ril:string>
      <ril:string>2</ril:string>
      <ril:string>3</ril:string>
    </ril:string-list>
  </ril:count>

<!--Sum Action -->
  <ril:sum>
    <ril:string-list>
      <ril:string>1</ril:string>
      <ril:string>2</ril:string>
      <ril:string>3</ril:string>
    </ril:string-list>
  </ril:sum>

<!--Average Action -->
  <ril:average>
    <ril:string-list>
      <ril:string>1</ril:string>
      <ril:string>2</ril:string>
      <ril:string>3</ril:string>
    </ril:string-list>
  </ril:average>

<!--Sort Action -->
  <ril:sort mode="TEXT" key="subject">
    <ril:query>
      <ft:wet>
        <ril:variable name="X"/>
      </ft:wet>
    </ril:query>
  </ril:sort>

<!-- Variable Set -->
  <ril:variable-set name="Foo">
    <ril:string-list>
      <ril:string>1</ril:string>
      <ril:string>2</ril:string>
      <ril:string>3</ril:string>
    </ril:string-list>
  </ril:variable-set>
  <ril:variable-ref name="Foo"/>

<!-- Ext Param -->
  <ril:param name="ext1">
    <ril:string-list>
      <ril:string>1</ril:string>
      <ril:string>2</ril:string>
      <ril:string>3</ril:string>
    </ril:string-list>
  </ril:param>
  <ril:variable-ref name="ext1"/>
  <ril:param name="ext2">
    <ril:string-list>
      <ril:string>1</ril:string>
      <ril:string>2</ril:string>
      <ril:string>3</ril:string>
    </ril:string-list>
  </ril:param>
  <ril:variable-ref name="ext2"/>



</ril:expression>
"""


    test.startTest('Parsed Action')
    infeng = CreateInfEng()

    p = RilParserImp.RilParserImp()

    defs = p.parse(exp)

    params = {'ext1':'Test Param'}

    results = infeng.execute(defs,extParams=params)

    test.compare([['Mike', 'Uche'],
                  ['http://namespaces.fourthought.com/test#wet', 'http://namespaces.fourthought.com/test#wet'],
                  ['1', '1'],
                  [[[('A', 'http://namespaces.fourthought.com/test#s1', 'B'),
                     ('B', 'http://namespaces.fourthought.com/test#s2', 'C'),
                     ('C', 'http://namespaces.fourthought.com/test#s3', 'D'),
                     ('D', 'http://namespaces.fourthought.com/test#s4', 'E')],
                    [('A', 'http://namespaces.fourthought.com/test#s5', 'D'),
                     ('D', 'http://namespaces.fourthought.com/test#s4', 'E')]]],
                  [[[('D', 'http://namespaces.fourthought.com/test#s4', 'E'),
                     ('C', 'http://namespaces.fourthought.com/test#s3', 'D'),
                     ('B', 'http://namespaces.fourthought.com/test#s2', 'C'),
                     ('A', 'http://namespaces.fourthought.com/test#s1', 'B')],
                    [('D', 'http://namespaces.fourthought.com/test#s4', 'E'),
                     ('A', 'http://namespaces.fourthought.com/test#s5', 'D')]]],
                  ['1'],
                  ['3', '2', '1', '0'],
                  ['1', '2'],
                  ['2', '1'],
                  ['2', '3'],
                  ['0', '1', '2', '3', '4', '5'],
                  ['3'],
                  ['6.0'],
                  ['2.0'],
                  [('Mike', 'http://namespaces.fourthought.com/test#wet', '1'),
                   ('Uche', 'http://namespaces.fourthought.com/test#wet', '1')],
                  ['1', '2', '3'],
                  ['Test Param'],
                  ['1', '2', '3']],
                 results)

    test.testDone()
    test.groupDone()
    

if __name__ == '__main__':
    from Ft.Lib.TestSuite import Tester
    tester = Tester.Tester()
    Test(tester)

