from Ft.Rdf.Drivers import Memory
from Ft.Rdf import Model
from Ft.Rdf.Statement import Statement
def CreateInfEng():
    from Ft.Rdf.Inference import InferenceEngine
    db = Memory.DbAdapter('kb')
    db.begin()
    kb = Model.Model(db)
    return InferenceEngine.InferenceEngine(kb)

def Test(test):
    test.startGroup('Inference Assert')
    
    test.startTest('Syntax')
    from Ft.Rdf.Inference import InferenceEngine
    from Ft.Rdf.Inference import Common
    from Ft.Rdf.Inference import Assert
    test.testDone()

    test.startTest('Single Assert')
    sl = Common.StringListLiteralArgument("arg1",['http://ogbuji.net#uche'])
    a1 = Assert.SingleAssert("http://spam.com#wet",0,(sl,))

    infeng = CreateInfEng()

    context = Common.Context()
    a1.execute(infeng,context)
    a1.execute(infeng,context)

    wet = Statement("http://ogbuji.net#uche","http://spam.com#wet","1")
    test.compare(1, infeng.contains(wet))
    test.testDone()

    test.startTest('Dual Assert')
    sl = Common.StringListLiteralArgument("arg1",['http://ogbuji.net#uche'])
    sl1 = Common.StringListLiteralArgument("arg2",['A Book'])
    a1 = Assert.DualAssert("http://spam.com#creator",0,(sl,sl1))

    infeng = CreateInfEng()

    context = Common.Context()
    a1.execute(infeng,context)
    a1.execute(infeng,context)

    book = Statement("http://ogbuji.net#uche","http://spam.com#creator","A Book")
    test.compare(1, infeng.contains(book))
    test.testDone()

    test.groupDone()

if __name__ == '__main__':
    from Ft.Lib.TestSuite import Tester
    tester = Tester.Tester()
    Test(tester)

