# http://lists.fourthought.com/pipermail/4suite/2001-December/002966.html
import os

from Ft.Lib.Uri import OsPathToUri
from Ft.Rdf import Util, RDF_MS_BASE
from Ft.Rdf.Serializers.Dom import RDF_TYPE_PREDICATE, RDF_VALUE_PREDICATE

from Rdf import RdfHelper

DATABASE_NAME = os.environ.get('RDF_TEST_DB', 'test')

RDF1 = """\
<?xml version='1.0' encoding='UTF-8'?>
<rdf:RDF xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#' xmlns:dc='http://purl.org/dc/elements/1.1/' xmlns:dcq='http://purl.org/dc/terms/' xmlns:gemq='http://gemstar.ischool.washington.edu/schema/2001/04/11/gemq#'>
  <rdf:Description rdf:about='http://magma.nationalgeographic.com/pulseplanet/'>
    <dc:subject>
      <rdf:Seq>
        <rdf:li>
          <gemq:GEM-S>
            <rdf:value>Social studies</rdf:value>
          </gemq:GEM-S>
        </rdf:li>
        <rdf:li>
          <gemq:GEM-S>
            <rdf:value>Geography</rdf:value>
          </gemq:GEM-S>
        </rdf:li>
      </rdf:Seq>
    </dc:subject>
  </rdf:Description>
</rdf:RDF>
"""

EXPECTED1 = [
    (u'http://magma.nationalgeographic.com/pulseplanet/', u'http://purl.org/dc/elements/1.1/subject', u'ANONYMOUS0'),
    (u'ANONYMOUS0', RDF_TYPE_PREDICATE, RDF_MS_BASE + 'Seq'),
    (u'ANONYMOUS0', RDF_MS_BASE + '_1', u'ANONYMOUS1'),
    (u'ANONYMOUS0', RDF_MS_BASE + '_2', u'ANONYMOUS2'),
    (u'ANONYMOUS1', RDF_TYPE_PREDICATE, 'http://gemstar.ischool.washington.edu/schema/2001/04/11/gemq#GEM-S'),
    (u'ANONYMOUS1', RDF_VALUE_PREDICATE, u'Social studies'),
    (u'ANONYMOUS2', RDF_TYPE_PREDICATE, 'http://gemstar.ischool.washington.edu/schema/2001/04/11/gemq#GEM-S'),
    (u'ANONYMOUS2', RDF_VALUE_PREDICATE, u'Geography'),
]

def Test(tester):
    driver = tester.test_data['driver']
    if driver.ExistsDb(DATABASE_NAME):
        driver.DestroyDb(DATABASE_NAME)

    tester.startTest('deserialization with anonymous nodes')
    scope = OsPathToUri(__file__, attemptAbsolute=True) + u'-INTERNAL-XML-STRING'
    model, db = Util.DeserializeFromString(RDF1, driver=driver, dbName=DATABASE_NAME, create=True, scope=scope)
    actual = RdfHelper.make_tuple(model.statements(), scope)
    expected = []
    for tup in EXPECTED1:
        expected.append(tup + (u'', scope))

    expected.sort()
    tester.compare(expected, actual, func=RdfHelper.compare_tuple)
    db.rollback()
    tester.testDone()

