# -*- mode: python -*-
# -*- coding: iso-8859-1 -*-

import os, _winreg

HKEYS = (_winreg.HKEY_CURRENT_USER, _winreg.HKEY_LOCAL_MACHINE)

def get_value(key, name):
    for hkey in HKEYS:
        try:
            handle = _winreg.OpenKeyEx(hkey, key)
        except _winreg.error:
            continue
        i = 0
        name = name.lower()
        while True:
            try:
                reg_name, reg_value, reg_type = _winreg.EnumValue(handle, i)
            except _winreg.error:
                # end of values
                break
            if reg_name.lower() == name:
                return reg_value
            i += 1
    return None


framework = get_value(r"Software\Microsoft\.NETFramework", r"InstallRoot")
if framework is None:
    raise SystemExit(".NET Framework needs to be installed.")

framework_sdk = get_value(r"Software\Microsoft\.NETFramework",
                          r"sdkInstallRootv1.1")
if framework_sdk is None:
    raise SystemExit(".NET Framework 1.1 SDK needs to be installed.")

vc7_dir = get_value(r"Software\Microsoft\VisualStudio\SxS\VC7", r"7.1")
if vc7_dir is None:
    raise SystemExit("ERROR: missing required registry key")

psdk_guid = r"8F9E5EF3-A9A5-491B-A889-C58EFFECE8B3"
platform_sdk = get_value(
    r"Software\Microsoft\MicrosoftSDK\InstalledSDKs\%s" % psdk_guid,
    r"Install Dir")
if platform_sdk is None:
    print "WARNING: Platform SDK needs to be installed or updated"

# Hunt out the installer information for the Visual C++ Toolkit 2003
uninstall_root = r"SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall"
handle = _winreg.OpenKeyEx(_winreg.HKEY_LOCAL_MACHINE, uninstall_root)
keys = []
while True:
    try:
        key = _winreg.EnumKey(handle, len(keys))
    except _winreg.error:
        # end of keys
        break
    else:
        keys.append(key)

installed = {}
for subkey in keys:
    key = r"%s\%s" % (uninstall_root, subkey)
    handle = _winreg.OpenKeyEx(_winreg.HKEY_LOCAL_MACHINE, key)
    display_name = None
    install_dir = None
    i = 0
    while display_name is None or install_dir is None:
        try:
            name, value, type = _winreg.EnumValue(handle, i)
        except _winreg.error:
            # end of values
            break
        name = name.lower()
        if name == "displayname":
            display_name = value
        elif name == "installlocation":
            install_dir = value
        i += 1
    else:
        if install_dir:
            installed[display_name] = install_dir

try:
    toolkit_dir = installed['Microsoft Visual C++ Toolkit 2003']
except KeyError:
    raise SystemExit("Visual C++ Toolkit 2003 needs to be installed")


# Find the VisualStudio key
for hkey in HKEYS:
    try:
        key = _winreg.OpenKeyEx(hkey, r"Software\Microsoft\VisualStudio\7.1")
    except _winreg.error:
        continue
    key = _winreg.CreateKey(key, r"VC")
    key = _winreg.CreateKey(key, r"VC_OBJECTS_PLATFORM_INFO")
    key = _winreg.CreateKey(key, r"Win32")
    key = _winreg.CreateKey(key, r"Directories")

    dirs = (platform_sdk, toolkit_dir)
    _winreg.SetValueEx(key, r"Include Dirs", None, _winreg.REG_SZ,
                       ';'.join([ os.path.join(d, "include") for d in dirs if d ]))

    dirs = (platform_sdk, toolkit_dir, vc7_dir)
    _winreg.SetValueEx(key, r"Library Dirs", None, _winreg.REG_SZ,
                       ';'.join([ os.path.join(d, "lib") for d in dirs if d ]))

    dirs = (platform_sdk, toolkit_dir)
    _winreg.SetValueEx(key, r"Path Dirs", None, _winreg.REG_SZ,
                       ';'.join([ os.path.join(d, "bin") for d in dirs if d ]))


print "Visual C++ Toolkit 2003 successfully registered!"
