from Xslt import test_harness
from xml.xslt import XsltException, Error

sheet_1 = """<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:n="http://spam.com"
  version="1.0"
>

  <xsl:template match="/">
    <HTML>
    <HEAD><TITLE>Address Book</TITLE>
    </HEAD>
    <BODY>
    <TABLE><xsl:apply-templates/></TABLE>
    </BODY>
    </HTML>
  </xsl:template>

  <xsl:variable name='a'>1</xsl:variable>

  <xsl:variable name='width' select='100'></xsl:variable>

  <xsl:variable name='c'></xsl:variable>

  <xsl:template match="ENTRY">
        <!-- Make sure shadowing check isn't overzealous -->
        <xsl:param name='n:a' select='ok'/>
        <!-- Tests legal shadowing -->
        <xsl:variable name='a'>boo</xsl:variable>
        <xsl:element name='TR'>
        <xsl:apply-templates select='NAME'/>
        </xsl:element>
  </xsl:template>

  <xsl:template match="NAME">
    <xsl:variable name='d' select='.'></xsl:variable>
    <TD WIDTH='{$d}'>
      <B><xsl:apply-templates/></B>
    </TD>
  </xsl:template>

</xsl:stylesheet>
"""


sheet_2 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">

  <xsl:param name='override' select='abc'/>
  <xsl:param name='list' select='foo'/>

  <xsl:template match="/">
    <doc>
      <overridden><xsl:value-of select='$override'/></overridden>
      <list><xsl:apply-templates select="$list"/></list>
    </doc>
  </xsl:template>

  <xsl:template match="text()">
    <item><xsl:value-of select="."/></item>
  </xsl:template>

</xsl:stylesheet>
"""


sheet_3 = """<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
version="1.0">

  <xsl:param name='a' select='"foo"'/>
  <xsl:variable name='b' select='concat($a, "bar")'/>

  <xsl:template match="/">
    <doc>
      <a><xsl:value-of select='$a'/></a>
      <b><xsl:value-of select='$b'/></b>
    </doc>
  </xsl:template>

</xsl:stylesheet>
"""


invalid_sheet_1 = """\
<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:variable name='x' select='a'/>

  <xsl:template match="/">
    <xsl:variable name='x' select='b'/>
    <xsl:value-of select='$x'/>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="ENTRY">
    <xsl:variable name='x' select='c'/>
    <doc>
      <xsl:variable name='x' select='d'/>
      <xsl:value-of select='$x'/>
    </doc>
  </xsl:template>

</xsl:stylesheet>
"""


invalid_sheet_2 = """\
<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:variable name='x' select='a'/>

  <xsl:template match="/">
    <xsl:variable name='x' select='b'/>
    <xsl:value-of select='$x'/>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="ENTRY">
    <xsl:variable name='x' select='c'/>
    <xsl:variable name='x' select='d'/>
    <doc>
      <xsl:value-of select='$x'/>
    </doc>
  </xsl:template>

</xsl:stylesheet>
"""


invalid_sheet_3 = """\
<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:variable name='image-name' select='a'/>

  <xsl:template name="dummy">
    <xsl:param name="p1"/>
    <xsl:param name="p2" select="1"/>
    <xsl:variable name="image-name" select="''"/>
    <a href='{$image-name}'>
      <img height="24" width="32" border="0" src="{$image-name}.gif" name="{$image-name}"/>
    </a>
    <img height="24" width="32" border="0" src="{$image-name}.gif" name="{$image-name}"/>
    <xsl:variable name="image-name" select="'a'"/>
    <xsl:variable name="image-name" select="'b'"/>
    <img height="24" width="32" border="0" src="{$image-name}.gif" name="{$image-name}"/>
  </xsl:template>

</xsl:stylesheet>
"""

invalid_sheet_4 = """\
<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:variable name='x' select='a'/>
  <xsl:variable name='x' select='b'/>

  <xsl:template match="/">
    <xsl:variable name='y' select='b'/>
    <xsl:value-of select='$x'/>
  </xsl:template>

</xsl:stylesheet>
"""


invalid_sheet_5 = """\
<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:variable name='x' select='a'/>
  <xsl:param name='x' select='b'/>

  <xsl:template match="/">
    <xsl:variable name='y' select='b'/>
    <xsl:value-of select='$x'/>
  </xsl:template>

</xsl:stylesheet>
"""


invalid_sheet_6 = """\
<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                version="1.0">

  <xsl:param name='x' select='a'/>
  <xsl:param name='x' select='b'/>

  <xsl:template match="/">
    <xsl:variable name='y' select='b'/>
    <xsl:value-of select='$x'/>
  </xsl:template>

</xsl:stylesheet>
"""


source_2 = """
<dummy/>
"""


expected_1 = """<HTML>
  <HEAD>
    <META HTTP-EQUIV='Content-Type' CONTENT='text/html; charset=iso-8859-1'>
    <TITLE>Address Book</TITLE>
  </HEAD>
  <BODY>
    <TABLE>
      <TR>
        <TD WIDTH='Pieter Aaron'>
          <B>Pieter Aaron</B>
        </TD>
      </TR>
      <TR>
        <TD WIDTH='Emeka Ndubuisi'>
          <B>Emeka Ndubuisi</B>
        </TD>
      </TR>
      <TR>
        <TD WIDTH='Vasia Zhugenev'>
          <B>Vasia Zhugenev</B>
        </TD>
      </TR>
    </TABLE>
  </BODY>
</HTML>"""


expected_2 = """<?xml version='1.0' encoding='UTF-8'?>
<doc><overridden>xyz</overridden><list><item>a</item><item>b</item><item>c</item></list></doc>"""


expected_3 = """<?xml version='1.0' encoding='UTF-8'?>
<doc><a>foo</a><b>foobar</b></doc>"""


def Test(tester):

    tester.startGroup("Usage")
    source = test_harness.FileInfo(uri="Xslt/Core/addr_book1.xml", nsAware=0)
    sty = test_harness.FileInfo(string=sheet_1)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_1,
                                    )
    xtest.test(tester)
    tester.groupDone()

    tester.startGroup("Top-level param override")
    source = test_harness.FileInfo(string=source_2)
    sty = test_harness.FileInfo(string=sheet_2)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_2,
                                    topLevelParams={'override': 'xyz',
                                                    'list': ['a', 'b', 'c']},
                                    )
    xtest.test(tester)
    tester.groupDone()

    tester.startGroup("Top-level variable depends on top-level param")
    source = test_harness.FileInfo(string=source_2)
    sty = test_harness.FileInfo(string=sheet_3)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_3,
                                    )
    xtest.test(tester)
    tester.groupDone()

    tester.startGroup("Illegal shadowing 1")
    source = test_harness.FileInfo(uri="Xslt/Core/addr_book1.xml", nsAware=0)
    sty = test_harness.FileInfo(string=invalid_sheet_1)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_1,
                                    expectedException = XsltException,
                                    exceptionValues = {'errorCode':Error.ILLEGAL_SHADOWING},
                                    )
    xtest.test(tester)
    tester.groupDone()

    tester.startGroup("Illegal shadowing 2")
    source = test_harness.FileInfo(uri="Xslt/Core/addr_book1.xml", nsAware=0)
    sty = test_harness.FileInfo(string=invalid_sheet_2)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_1,
                                    expectedException = XsltException,
                                    exceptionValues = {'errorCode':Error.ILLEGAL_SHADOWING},
                                    )
    xtest.test(tester)
    tester.groupDone()

    tester.startGroup("Illegal shadowing 3")
    source = test_harness.FileInfo(uri="Xslt/Core/addr_book1.xml", nsAware=0)
    sty = test_harness.FileInfo(string=invalid_sheet_3)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_1,
                                    expectedException = XsltException,
                                    exceptionValues = {'errorCode':Error.ILLEGAL_SHADOWING},
                                    )
    xtest.test(tester)
    tester.groupDone()

    tester.startGroup("Illegal shadowing 4")
    source = test_harness.FileInfo(uri="Xslt/Core/addr_book1.xml", nsAware=0)
    sty = test_harness.FileInfo(string=invalid_sheet_4)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_1,
                                    expectedException = XsltException,
                                    exceptionValues = {'errorCode':Error.DUPLICATE_TOP_LEVEL_VAR},
                                    )
    xtest.test(tester)
    tester.groupDone()

    tester.startGroup("Illegal shadowing 5")
    source = test_harness.FileInfo(uri="Xslt/Core/addr_book1.xml", nsAware=0)
    sty = test_harness.FileInfo(string=invalid_sheet_5)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_1,
                                    expectedException = XsltException,
                                    exceptionValues = {'errorCode':Error.DUPLICATE_TOP_LEVEL_VAR},
                                    )
    xtest.test(tester)
    tester.groupDone()
    
    tester.startGroup("Illegal shadowing 6")
    source = test_harness.FileInfo(uri="Xslt/Core/addr_book1.xml", nsAware=0)
    sty = test_harness.FileInfo(string=invalid_sheet_6)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_1,
                                    expectedException = XsltException,
                                    exceptionValues = {'errorCode':Error.DUPLICATE_TOP_LEVEL_VAR},
                                    )
    xtest.test(tester)
    tester.groupDone()
    return
