import os, sys
from xml.xslt import RegisterExtensionModules
from xml.xslt import XsltElement, AttributeValueTemplate

from Xslt import test_harness

class SystemElement(XsltElement):
    def __init__(self, doc, uri='http://foo.org/namespaces/ext-xslt', localName='system', prefix='xsl', baseUri=''):
        XsltElement.__init__(self, doc, uri, localName, prefix, baseUri)

    def setup(self):
	from xml.dom.ext import GetAllNs
        self.__dict__['_nss'] = GetAllNs(self)
        self.__dict__['_command'] = AttributeValueTemplate.AttributeValueTemplate(self.getAttributeNS('', 'command'))
        return

    def instantiate(self, context, processor):
        origState = context.copy()
        context.setNamespaces(self._nss)
        command = self._command.evaluate(context)
        os.system(command)
        context.set(origState)
        return (context,)


    def __getinitargs__(self):
        return (None, self.namespaceURI, self.localName, self.prefix,
                self.baseUri)

    def __getstate__(self):
         base_state = XsltElement.__getstate__(self)
         new_state = (base_state, self._nss, self._command)
         return new_state

    def __setstate__(self, state):
        XsltElement.__setstate__(self, state[0])
        self._nss = state[1]
        self._command = state[2]
        return


ExtElements = {
    ('http://foo.org/namespaces/ext-xslt', 'system'): SystemElement
    }


sheet_str_1 = """<?xml version="1.0"?>
<xsl:stylesheet
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:ext="http://foo.org/namespaces/ext-xslt"
  extension-element-prefixes="ext"
  version="1.0">

  <xsl:template match="execute-command">
    <docelem>
    <ext:system command="{@cmd}"/>
    </docelem>
  </xsl:template>

</xsl:stylesheet>
"""

if sys.platform[:3] != 'win':
    xml_source_1 = """<execute-command cmd="touch 'foo'"/>"""
    xml_source_2 = """<execute-command cmd="rm -f 'foo'"/>"""
else:
    xml_source_1 = """<execute-command cmd="echo '1' > foo"/>"""
    xml_source_2 = """<execute-command cmd="del foo"/>"""
    
expected_result_1 = """<?xml version='1.0' encoding='UTF-8'?>
<docelem/>
"""
expected_result_2 = expected_result_1


def Test(tester):

    tester.startGroup("Test 1")

    RegisterExtensionModules(['Xslt.Core.test_extensions_1'])

    if os.path.exists("foo"):
        os.unlink("foo")

    source = test_harness.FileInfo(string=xml_source_1)
    sty = test_harness.FileInfo(string=sheet_str_1)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_result_1,
                                    )
    xtest.test(tester)
    tester.startTest("Test extension element result")
    tester.compare(1, os.path.exists("foo"))
    tester.testDone()
    tester.groupDone()


    tester.startGroup("Test 2")
    source = test_harness.FileInfo(string=xml_source_2)
    sty = test_harness.FileInfo(string=sheet_str_1)
    xtest = test_harness.XsltTester(source,
                                    [sty],
                                    expected_result_2,
                                    )

    xtest.test(tester)
    tester.startTest("Test extension element result")
    tester.compare(0, os.path.exists("foo"))
    tester.testDone()
    tester.groupDone()

    if os.path.exists("foo"):
        os.unlink("foo")

    return
