########################################################################
#
# File Name:            ProcessingInstructionElement.py
#
# Documentation:        http://docs.4suite.org/4XSLT/ProcessingInstructionElement.py.html
#
"""
Implementation of the XSLT Spec processing-instruction stylesheet element.
WWW: http://4suite.org/4XSLT        e-mail: support@4suite.org

Copyright (c) 1999-2001 Fourthought Inc, USA.   All Rights Reserved.
See  http://4suite.org/COPYRIGHT  for license and copyright information
"""

import xml.dom.ext
from xml.xslt import XsltElement, XsltException, Error
from xml.xpath import Conversions


class ProcessingInstructionElement(XsltElement):
    legalAttrs = ('name',)

    def __init__(self, doc, uri=xml.xslt.XSL_NAMESPACE, localName='processing-instructions', prefix='xsl', baseUri=''):
        XsltElement.__init__(self, doc, uri, localName, prefix, baseUri)

    def setup(self):
        self._target = self.parseAVT(self.getAttributeNS('', 'name'))
        self._nss = xml.dom.ext.GetAllNs(self)
        return

    def instantiate(self, context, processor):
        origState = context.copy()
        context.setNamespaces(self._nss)
        context.currentInstruction = self

        target = self._target.evaluate(context)

        #FIXME: Add error checking of child nodes
        processor.pushResult()
        try:
            for child in self.childNodes:
                context = child.instantiate(context, processor)[0]
        finally:
            result = processor.popResult()
        
        processor.writers[-1].processingInstruction(target, Conversions.StringValue(result))
        processor.releaseRtf(result)

        context.set(origState)
        
        return (context,)

    def __getinitargs__(self):
        return (None, self.namespaceURI, self.localName, self.prefix,
                self.baseUri)

    def __getstate__(self):
         base_state = XsltElement.__getstate__(self)
         new_state = (base_state, self._nss, self._target)
         return new_state

    def __setstate__(self, state):
        XsltElement.__setstate__(self, state[0])
        self._nss = state[1]
        self._target = state[2]
        return

