import os
import sipconfig

# The name of the SIP build file generated by SIP and used by the build
# system.
build_file = "tango.sbf"

# Get the SIP configuration information.
config = sipconfig.Configuration()

# Run SIP to generate the code.
os.system(" ".join([config.sip_bin, "-c", ".", "-b", build_file, "tango.sip"]))

# Create the Makefile.
makefile = sipconfig.SIPModuleMakefile(config, build_file)

# Add the library we are wrapping.  The name doesn't include any platform
# specific prefixes or extensions (e.g. the "lib" prefix on UNIX, or the
# ".dll" extension on Windows).
makefile.extra_libs = ["tango", "zmq"]
makefile.extra_lib_dirs = ["/home/tcoutinho/.local/lib"]
makefile.extra_include_dirs = ["/home/tcoutinho/.local/include", "/home/tcoutinho/.local/include/tango"]
makefile.extra_cxxflags = ["-std=c++0x"]

# Generate the Makefile itself.
makefile.generate()
