
/****************************************************************************
 * NCSA HDF                                                                 *
 * Scientific Data Technologies                                             *
 * National Center for Supercomputing Applications                          *
 * University of Illinois at Urbana-Champaign                               *
 * 605 E. Springfield, Champaign IL 61820                                   *
 *                                                                          *
 * For conditions of distribution and use, see the accompanying             *
 * hdf/COPYING file.                                                        *
 *                                                                          *
 ****************************************************************************/


#ifndef _H5TB_H
#define _H5TB_H

#include "H5LT.h"

#if 0
#define H5_TB_DEBUG
#endif

#define HLTB_MAX_FIELD_LEN 255

#ifdef __cplusplus
extern "C" {
#endif


/*-------------------------------------------------------------------------
 *
 * Create functions
 *
 *-------------------------------------------------------------------------
 */

herr_t H5TBmake_table( const char *table_title,
                       hid_t loc_id,
                       const char *dset_name,
		       char *version,
                       const char *class_,
		       hid_t mem_type_id,
                       hsize_t nrecords,
                       hsize_t chunk_size,
                       int compress,
		       char *complib,
		       int shuffle,
		       int fletcher32,
                       const void *data );


/*-------------------------------------------------------------------------
 *
 * Write functions
 *
 *-------------------------------------------------------------------------
 */

herr_t H5TBappend_records( hid_t loc_id,
                           const char *dset_name,
                           hsize_t nrecords,
                           size_t type_size,
                           const size_t *field_offset,
                           const void *data );


/*-------------------------------------------------------------------------
 *
 * Inquiry functions
 *
 *-------------------------------------------------------------------------
 */


herr_t H5TBget_table_info ( hid_t loc_id,
                            const char *dset_name,
                            hsize_t *nfields,
                            hsize_t *nrecords );


/*-------------------------------------------------------------------------
 *
 * Manipulation functions
 *
 *-------------------------------------------------------------------------
 */


herr_t H5TBdelete_record( hid_t loc_id,
                          const char *dset_name,
			  hid_t   mem_type_id,
                          hsize_t start,
                          hsize_t nrecords,
			  hsize_t maxtuples);


#ifdef __cplusplus
}
#endif


#endif

