#!/bin/sh
# Determine the translation options and translate

set -e -u

usage() {
	name=$(basename $0)
	echo <<EOF
Usage: $name [options...]"
Options:
  --sandbox       Translate a sandboxed PyPy
  --python=PYTHON Use PYTHON to tranlate PyPy

EOF
}

SANDBOX=0
PYTHON=python

while [ $# -ge 1 ]; do
	case "$1" in
	--sandbox)
		SANDBOX=1
		;;
	--python)
		PYTHON="$2"
		shift
		;;
	--help|-h)
		usage
		exit 0
		;;
	*)
		echo "Unkown option: $1" >&2
		usage
		exit 1
		;;
	esac
	shift
done

OPTIONS="--batch --source"

OPT=3
ROOTFINDER=shadowstack
if echo "$DEB_BUILD_OPTIONS" | egrep -q '\bnoopt\b'; then
	OPT=0
elif [ $SANDBOX -gt 0 ]; then
	OPT=2
elif dpkg-architecture -iany-i386; then
	OPT=jit
	ROOTFINDER=asmgcc
	#OPTIONS="$OPTIONS --jit-backend=x86-without-sse2"
elif dpkg-architecture -iany-armel \
     || dpkg-architecture -iany-armhf; then
	# Still in alpha
	#OPT=jit
	ROOTFINDER=shadowstack
elif dpkg-architecture -iany-amd64; then
	OPT=jit
	ROOTFINDER=asmgcc
fi
OPTIONS="$OPTIONS --opt=$OPT"

if [ $SANDBOX -gt 0 ]; then
	OPTIONS="$OPTIONS --sandbox --gc=generation"
	ROOTFINDER=shadowstack
fi
if [ $OPT = "mem" -o $OPT = "jit" -o $OPT = 2 -o $OPT = 3 ]; then
	OPTIONS="$OPTIONS --gcrootfinder=$ROOTFINDER"
fi

set -x
cd pypy/goal
exec "$PYTHON" -u ../../rpython/bin/rpython $OPTIONS targetpypystandalone 2>&1
