#
# sample.py
#
# Duane Maxwell
# (c) Copyright Linspire. Inc, 2005
#
# This is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
from pynjb import *

def transferFeedback(sent,total,data):
	print ".", #sent,total,data

print "Discovering"
njbs = NJBDevice.Discover()
if njbs and len(njbs)>0:
	print "Found %d devices" % len(njbs)
	njb = njbs[0]
	print "Opening"
	if njb.Open()>=0:
		print "Model '%s'" % njb.GetProductName()
		print "Owner '%s'" % njb.GetOwnerString()
		print "Capturing"
		njb.Capture()
		njb.ResetGetTrackTag()
		song = njb.GetTrackTag()
		firstSong = song
		while song:
			print "Song ID=%d" % song.GetTrackID()
			song.ResetGetFrame()
			frame = song.GetFrame()
			while frame:
				print "  '%s' : '%s'" % (frame.GetLabel(),str(frame.GetValue()))
				frame = song.GetFrame();
			song = njb.GetTrackTag()
		if firstSong:
			trackID = firstSong.GetTrackID()
			size = firstSong.FindFrame("FILE SIZE").GetValue()
			print "Transferring song %d of size %d" % (trackID,size)
			njb.GetTrack(trackID,size,"/tmp/blah.mp3",transferFeedback,None)
		print "Releasing"
		njb.Release()
		print "Closing"
		njb.Close()
	else:
		print "Cannot Open"
print "Done"