/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.msg;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.wimpi.modbus.ModbusCoupler;
import net.wimpi.modbus.msg.ModbusRequest;
import net.wimpi.modbus.msg.ModbusResponse;
import net.wimpi.modbus.msg.ReadInputDiscretesResponse;
import net.wimpi.modbus.procimg.DigitalIn;
import net.wimpi.modbus.procimg.IllegalAddressException;
import net.wimpi.modbus.procimg.ProcessImage;

public final class ReadInputDiscretesRequest
extends ModbusRequest {
    private int m_Reference;
    private int m_BitCount;

    public ReadInputDiscretesRequest() {
        this.setFunctionCode(2);
        this.setDataLength(4);
    }

    public ReadInputDiscretesRequest(int ref, int count) {
        this.setFunctionCode(2);
        this.setDataLength(4);
        this.setReference(ref);
        this.setBitCount(count);
    }

    public ModbusResponse createResponse() {
        ReadInputDiscretesResponse response = null;
        DigitalIn[] dins = null;
        ProcessImage procimg = ModbusCoupler.getReference().getProcessImage();
        try {
            dins = procimg.getDigitalInRange(this.getReference(), this.getBitCount());
        }
        catch (IllegalAddressException iaex) {
            return this.createExceptionResponse(2);
        }
        response = new ReadInputDiscretesResponse(dins.length);
        if (!this.isHeadless()) {
            response.setTransactionID(this.getTransactionID());
            response.setProtocolID(this.getProtocolID());
        } else {
            response.setHeadless();
        }
        response.setUnitID(this.getUnitID());
        response.setFunctionCode(this.getFunctionCode());
        for (int i = 0; i < dins.length; ++i) {
            response.setDiscreteStatus(i, dins[i].isSet());
        }
        return response;
    }

    public void setReference(int ref) {
        this.m_Reference = ref;
    }

    public int getReference() {
        return this.m_Reference;
    }

    public void setBitCount(int count) {
        this.m_BitCount = count;
    }

    public int getBitCount() {
        return this.m_BitCount;
    }

    public void writeData(DataOutput dout) throws IOException {
        dout.writeShort(this.m_Reference);
        dout.writeShort(this.m_BitCount);
    }

    public void readData(DataInput din) throws IOException {
        this.m_Reference = din.readUnsignedShort();
        this.m_BitCount = din.readUnsignedShort();
    }
}

