/* ====================================================================
 * Copyright (c) 2004-2008 Open Source Applications Foundation.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions: 
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 * ====================================================================
 */

package org.osafoundation.lucene.search;

import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.SimilarityDelegator;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.index.Term;


public class PythonSimilarityDelegator extends SimilarityDelegator {

    private long pythonObject;

    public PythonSimilarityDelegator(Similarity delegee)
    {
        super(delegee);
    }

    public void pythonExtension(long pythonObject)
    {
        this.pythonObject = pythonObject;
    }
    public long pythonExtension()
    {
        return this.pythonObject;
    }

    public void finalize()
        throws Throwable
    {
        pythonDecRef();
    }

    public native void pythonDecRef();
    public native float lengthNorm(String fieldName, int numTokens);
    public native float queryNorm(float sumOfSquaredWeights);
    public native float tf(float freq);
    public native float sloppyFreq(int distance);
    public native float idf(int docFreq, int numDocs);
    public native float coord(int overlap, int maxOverlap);
    public native float scorePayload(String fieldName, byte[] payload,
                                     int offset, int length);
}
