import py

#
# main entry point
#

def main():
    warn_about_missing_assertion()
    config, args = py.test.Config.parse(py.std.sys.argv[1:])
    sessionclass = config.getsessionclass() 
    session = sessionclass(config)
    try: 
        failures = session.main(args)
        if failures: 
            raise SystemExit, 1 
    except KeyboardInterrupt: 
        if not config.option.verbose: 
            print
            print "KeyboardInterrupt (-v to see traceback)"
            raise SystemExit, 2
        else: 
            raise 

def warn_about_missing_assertion():
    try:
        assert False
    except AssertionError:
        pass
    else:
        py.std.warnings.warn("Assertions are turned off!"
                             " (are you using python -O?)")
