#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-
#
# TestProcINotify.py - inotify's path tests cases
# Copyright (C) 2006  Sbastien Martini <sebastien.martini@gmail.com>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.

import unittest
import os
import colorize
import coverage

# coverage init
# early initialization, before the import of inotify
# (avoid to miss something)
coverage.erase()
coverage.start()

try:
    import autopath
    import src.pyinotify.inotify
    from src.pyinotify.inotify import max_queued_events, \
         max_user_instances, max_user_watches
    module_ = src.pyinotify.inotify
except ImportError:
    import inotify
    from inotify import max_queued_events, \
         max_user_instances, max_user_watches
    module_ = inotify


class TestProcINotify(unittest.TestCase):
    def test_write(self):
        """
        write proc fs
        """
        max_queued_events.value = 16384
        max_user_instances.value = 128
        max_user_watches.value = 8192

    def test_read(self):
        """
        read proc fs
        """
        self.assertEqual(max_queued_events.value, 16384)
        self.assertEqual(max_user_instances.value, 128)
        self.assertEqual(max_user_watches.value, 8192)


def testsuite():
    suite = unittest.TestSuite()
    suite.addTests([TestProcINotify('test_write'),
                    TestProcINotify('test_read')])
    return suite


def test_it():
    runner = unittest.TextTestRunner(verbosity=2)
    runner.run(testsuite())

    # coverage analysis
    coverage.stop()
    # colorization
    f, s, m, mf = coverage.analysis(module_)
    fo = file(os.path.basename(f)+'.html', 'wb')
    colorize.colorize_file(f, outstream=fo, not_covered=mf)

    coverage.report(module_)
    coverage.erase()


if __name__ == '__main__':
    test_it()
