#  Author:     Roberto Cavada
#
#  Copyright:  
#  This file is part of of gNuSMV version 2.
#  Copyright (C) 2000-2001 by ITC-irst. 
#
#  NuSMV version 2 is free software; you can redistribute it and/or
#  modify it under the terms of the GNU Lesser General Public
#  License as published by the Free Software Foundation; either
#  version 2 of the License, or (at your option) any later version.
#
#  NuSMV version 2 is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  Lesser General Public License for more details.
#
#  You should have received a copy of the GNU Lesser General Public
#  License along with this library; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.
#
#  For more information of NuSMV see <http://nusmv.irst.itc.it>
#  or email to <nusmv-users@irst.itc.it>.
#  Please report bugs to <nusmv-users@irst.itc.it>.
#
#  To contact the NuSMV development board, email to <nusmv@irst.itc.it>.


from support.metaclasses import ObservablePropertyMeta

class Model (object):
    """This class is the application model base class.
    It handles a set of observable properties which you are interested
    in showing by one ore more view - via one or more controllers of course.
    The mechanism is the following:
    1. You are interested in showing a set of model property, that you can
    declare in the __properties__ member map. 
    2. You define one or more observers that observe one or more properties
    you registered. When someone changes a property value the model notifies
    the changing to each listening controller. The property-observer[s]
    association is given by the implicit rule in observers method names: if
    you want the model notified the changing event of the property 'p'
    you must define the method called 'property_p_change_notification' in
    each listening observer class.
    Notice that tipically 'controllers' implement the observer pattern. 
    The notification method gets the
    emitting model, the old value for the property and the new one.
    Properties functionalities are automatically provided by the
    ObservablePropertyMeta meta-class."""

    __metaclass__  = ObservablePropertyMeta 
    __properties__ = {} # override this
    
    def __init__(self):
        object.__init__(self)
        self.m_observers = []
        # keys are properties names, values are methods inside the controllers:
        self.m_notifications = {}
        for property in (self.__properties__.keys() + self.__derived_properties__.keys()):
            # Not duplicated properties:
            assert(not self.m_notifications.has_key(property))
            self.m_notifications[property] = []
            pass                   
        return

    def registerObserver(self, observer):
        if observer in self.m_observers: return # not already registered
        
        self.m_observers.append(observer)
        
        # Search in the observer for any possible listener:
        for property in (self.__properties__.keys() + self.__derived_properties__.keys()):
            method_name = "property_%s_change_notification" % property
            if hasattr(observer, method_name):
                method = getattr(observer, method_name)
                if method not in self.m_notifications[property]:
                    list.append(self.m_notifications[property], method)
                    pass
                pass
            else: print "Model warning: observable property '%s' has no observers (%s)" \
                  % (property, method_name)
            pass        
        return


    def notify_property_change(self, prop_name, old, new):
        assert(self.m_notifications.has_key(prop_name))
        if len(self.m_notifications[prop_name]) == 0:
            print "Model warning: observable property '%s' changed, but there are no registered observers." \
                  % prop_name
        else:
            for method in self.m_notifications[prop_name] :
                method(self, old, new) # notifies the change
                pass
            pass
        return                

    pass # end of class Model
# ----------------------------------------------------------------------
