#!/usr/bin/env python

from distutils.core import setup, Extension

setup(name='pygpiv',
      version='1.0.0',
      description='Particle Image Velocimetry module',
      long_description='Python module, wrapped from Libgpiv, \
for Particle Image Velocimetry. The module is intended for developers on \
the PIV technique itself and for fluid dynamics researchers and engineers \
who feel limited by the Gpiv GUI program and the command line \
programs from the Gpivtools package. So, those may write their own \'quick hacks\' easely \
by using the Python scripting language for rapid development.',
      author='Gerber van der Graaf',
      author_email='gerber_graaf@users.sourceforge.net',
      license='GNU General Public License (GPL)',
      keywords='science engineering fluid mechanics experiment piv particle image velocimetry',
      url='http://gpiv.sourceforge.net/',
      classifiers=['Development Status :: 4 - Beta',
                   'Environment :: Console',
                   'Intended Audience :: End Users/Desktop',
                   'Intended Audience :: Science/Research',
                   'Intended Audience :: Education',
                   'License :: OSI Approved :: GNU General Public License (GPL)',
                   'Operating System :: POSIX :: Linux',
                   'Programming Language :: C',
                   'Programming Language :: Python',
                   'Topic :: Scientific/Engineering',
                   'Topic :: Software Development :: Libraries',
                   'Natural Language :: Dutch'
                   ],
      ext_modules=[Extension('_pygpiv', ['pygpiv.i'],
                             include_dirs=['/usr/local/include',
                                           '/usr/include/glib-2.0',
                                           '/usr/lib/glib-2.0/include'],
                             swig_opts=['-modern',
                                        '-cpperraswarn',
                                        '-I/usr/include',
                                        '-I/usr/local/include'],
                             libraries=['gsl', 'gslcblas', 'm', 'hdf5',
                                        'fftw3', 'png', 'glib-2.0', 'gpiv'],
                             )],
      )
