/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4 c-style: "K&R" -*- */

/*-----------------------------------------------------------------------------
   libgpiv - library for Particle Image Velocimetry

   Copyright (C) 2002, 2003, 2004 Gerber van der Graaf

   This file is part of libgpiv.

   Libgpiv is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  



-------------------------------------------------------------------------------
FILENAME:                pygpiv.i

LAST MODIFICATION DATE: $Id: $
 --------------------------------------------------------------------------- */

%module pygpiv
%include "typemaps.i"
%pragma make_default

%{
#include <gpiv.h>
#include <glib-2.0/glib.h>
%}

%rename(GpivImage) __GpivImage;
%rename(GpivPivData) __GpivPivData;
%rename(GpivScalarData) __GpivScalarData;
%rename(GpivBinData) __GpivBinData;
%rename(GpivCovariance) __GpivCovariance;
%rename(GpivLinRegData) __GpivLinRegData;
%rename(GpivRoi) __GpivRoi;

%rename(GpivImagePar) __GpivImagePar;
%rename(GpivImageProcPar) __GpivImageProcPar;
%rename(GpivPivPar) __GpivPivPar;
%rename(GpivValidPar) __GpivValidPar;
%rename(GpivPostPar) __GpivPostPar;



%inline %{
%}

%include <gpiv.h>
%include <gpiv/gpiv-img.h>
%include <gpiv/gpiv-img_utils.h>

%include <gpiv/gpiv-imgproc.h>

%include <gpiv/gpiv-piv.h>
%include <gpiv/gpiv-piv_par.h>
%include <gpiv/gpiv-piv_utils.h>

%include <gpiv/gpiv-valid.h>
%include <gpiv/gpiv-valid_par.h>

%include <gpiv/gpiv-post.h>
%include <gpiv/gpiv-post_par.h>

%include <gpiv/gpiv-io.h>
%include <gpiv/gpiv-utils.h>
%include <gpiv/gpiv-utils_alloc.h>

#define G_BEGIN_DECLS
#define G_END_DECLS
%include <glib-2.0/glib.h>
%include <glib-2.0/glib/gtypes.h>
%include <glib-2.0/glib/gmacros.h>
#define G_END_DECLS
