/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.util.ArrayList;
import java.util.Iterator;
import visad.bom.Tile;

class Mosaic {
    Tile[][] tiles;
    ArrayList<Tile> tileList = new ArrayList();
    int n_x_sub = 1;
    int n_y_sub = 1;

    Mosaic(int lenY, int limitY, int lenX, int limitX) {
        int k;
        int y_sub_len = limitY;
        this.n_y_sub = lenY / y_sub_len;
        if (this.n_y_sub == 0) {
            ++this.n_y_sub;
        }
        if (lenY - this.n_y_sub * y_sub_len > 4) {
            ++this.n_y_sub;
        }
        int[][] y_start_stop = new int[this.n_y_sub][2];
        for (k = 0; k < this.n_y_sub - 1; ++k) {
            y_start_stop[k][0] = k * y_sub_len - k;
            y_start_stop[k][1] = (k + 1) * y_sub_len - 1 - k;
            if (y_start_stop[k][1] - y_start_stop[k][0] + 1 <= limitY) continue;
            int[] nArray = y_start_stop[k];
            nArray[1] = nArray[1] - 1;
        }
        k = this.n_y_sub - 1;
        y_start_stop[k][0] = k * y_sub_len - k;
        y_start_stop[k][1] = lenY - 1 - k;
        int x_sub_len = limitX;
        this.n_x_sub = lenX / x_sub_len;
        if (this.n_x_sub == 0) {
            ++this.n_x_sub;
        }
        if (lenX - this.n_x_sub * x_sub_len > 4) {
            ++this.n_x_sub;
        }
        int[][] x_start_stop = new int[this.n_x_sub][2];
        for (k = 0; k < this.n_x_sub - 1; ++k) {
            x_start_stop[k][0] = k * x_sub_len - k;
            x_start_stop[k][1] = (k + 1) * x_sub_len - 1 - k;
            if (x_start_stop[k][1] - x_start_stop[k][0] + 1 <= limitX) continue;
            int[] nArray = x_start_stop[k];
            nArray[1] = nArray[1] - 1;
        }
        k = this.n_x_sub - 1;
        x_start_stop[k][0] = k * x_sub_len - k;
        x_start_stop[k][1] = lenX - 1 - k;
        this.tiles = new Tile[this.n_y_sub][this.n_x_sub];
        for (int j = 0; j < this.n_y_sub; ++j) {
            for (int i = 0; i < this.n_x_sub; ++i) {
                this.tiles[j][i] = new Tile(y_start_stop[j][0], y_start_stop[j][1], x_start_stop[i][0], x_start_stop[i][1]);
                this.tileList.add(this.tiles[j][i]);
            }
        }
    }

    Iterator iterator() {
        return this.tileList.iterator();
    }
}

